/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.BatteryState;
import android.hardware.SensorManager;
import android.hardware.input.HostUsiVersion;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputManagerGlobal;
import android.hardware.lights.LightsManager;
import android.icu.util.ULocale;
import android.os.NullVibrator;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Vibrator;
import android.os.VibratorManager;
import android.text.TextUtils;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class InputDevice
implements Parcelable {
    private final int mId;
    private final int mGeneration;
    private final int mControllerNumber;
    private final String mName;
    private final int mVendorId;
    private final int mProductId;
    private final int mDeviceBus;
    private final String mDescriptor;
    private final InputDeviceIdentifier mIdentifier;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private final boolean mIsExternal;
    private final int mSources;
    private final int mKeyboardType;
    private final KeyCharacterMap mKeyCharacterMap;
    @Nullable
    private final String mKeyboardLanguageTag;
    @Nullable
    private final String mKeyboardLayoutType;
    private final boolean mHasVibrator;
    private final boolean mHasMicrophone;
    private final boolean mHasButtonUnderPad;
    private final boolean mHasSensor;
    private final boolean mHasBattery;
    private final HostUsiVersion mHostUsiVersion;
    private final int mAssociatedDisplayId;
    private final boolean mEnabled;
    private final ArrayList<MotionRange> mMotionRanges = new ArrayList();
    private final ViewBehavior mViewBehavior = new ViewBehavior(this);
    @GuardedBy(value={"mMotionRanges"})
    private Vibrator mVibrator;
    @GuardedBy(value={"mMotionRanges"})
    private VibratorManager mVibratorManager;
    @GuardedBy(value={"mMotionRanges"})
    private SensorManager mSensorManager;
    @GuardedBy(value={"mMotionRanges"})
    private LightsManager mLightsManager;
    public static final int SOURCE_CLASS_MASK = 255;
    public static final int SOURCE_CLASS_NONE = 0;
    public static final int SOURCE_CLASS_BUTTON = 1;
    public static final int SOURCE_CLASS_POINTER = 2;
    public static final int SOURCE_CLASS_TRACKBALL = 4;
    public static final int SOURCE_CLASS_POSITION = 8;
    public static final int SOURCE_CLASS_JOYSTICK = 16;
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_KEYBOARD = 257;
    public static final int SOURCE_DPAD = 513;
    public static final int SOURCE_GAMEPAD = 1025;
    public static final int SOURCE_TOUCHSCREEN = 4098;
    public static final int SOURCE_MOUSE = 8194;
    public static final int SOURCE_STYLUS = 16386;
    public static final int SOURCE_BLUETOOTH_STYLUS = 49154;
    public static final int SOURCE_TRACKBALL = 65540;
    public static final int SOURCE_MOUSE_RELATIVE = 131076;
    public static final int SOURCE_TOUCHPAD = 0x100008;
    public static final int SOURCE_TOUCH_NAVIGATION = 0x200000;
    public static final int SOURCE_ROTARY_ENCODER = 0x400000;
    public static final int SOURCE_JOYSTICK = 0x1000010;
    public static final int SOURCE_HDMI = 0x2000001;
    public static final int SOURCE_SENSOR = 0x4000000;
    public static final int SOURCE_ANY = -256;
    @Deprecated
    public static final int MOTION_RANGE_X = 0;
    @Deprecated
    public static final int MOTION_RANGE_Y = 1;
    @Deprecated
    public static final int MOTION_RANGE_PRESSURE = 2;
    @Deprecated
    public static final int MOTION_RANGE_SIZE = 3;
    @Deprecated
    public static final int MOTION_RANGE_TOUCH_MAJOR = 4;
    @Deprecated
    public static final int MOTION_RANGE_TOUCH_MINOR = 5;
    @Deprecated
    public static final int MOTION_RANGE_TOOL_MAJOR = 6;
    @Deprecated
    public static final int MOTION_RANGE_TOOL_MINOR = 7;
    @Deprecated
    public static final int MOTION_RANGE_ORIENTATION = 8;
    public static final int KEYBOARD_TYPE_NONE = 0;
    public static final int KEYBOARD_TYPE_NON_ALPHABETIC = 1;
    public static final int KEYBOARD_TYPE_ALPHABETIC = 2;
    private static final int MAX_RANGES = 1000;
    private static final int VIBRATOR_ID_ALL = -1;
    @NonNull
    public static final Parcelable.Creator<InputDevice> CREATOR = new Parcelable.Creator<InputDevice>(){

        @Override
        public InputDevice createFromParcel(Parcel in) {
            return new InputDevice(in);
        }

        public InputDevice[] newArray(int size) {
            return new InputDevice[size];
        }
    };

    private InputDevice(int id2, int generation, int controllerNumber, String name, int vendorId, int productId, int deviceBus, String descriptor, boolean isExternal, int sources, int keyboardType, KeyCharacterMap keyCharacterMap, @Nullable String keyboardLanguageTag, @Nullable String keyboardLayoutType, boolean hasVibrator, boolean hasMicrophone, boolean hasButtonUnderPad, boolean hasSensor, boolean hasBattery, int usiVersionMajor, int usiVersionMinor, int associatedDisplayId, boolean enabled) {
        String langTag;
        this.mId = id2;
        this.mGeneration = generation;
        this.mControllerNumber = controllerNumber;
        this.mName = name;
        this.mVendorId = vendorId;
        this.mProductId = productId;
        this.mDeviceBus = deviceBus;
        this.mDescriptor = descriptor;
        this.mIsExternal = isExternal;
        this.mSources = sources;
        this.mKeyboardType = keyboardType;
        this.mKeyCharacterMap = keyCharacterMap;
        this.mKeyboardLanguageTag = !TextUtils.isEmpty(keyboardLanguageTag) ? (TextUtils.equals(langTag = ULocale.createCanonical(ULocale.forLanguageTag(keyboardLanguageTag)).toLanguageTag(), "und") ? null : langTag) : null;
        this.mKeyboardLayoutType = keyboardLayoutType;
        this.mHasVibrator = hasVibrator;
        this.mHasMicrophone = hasMicrophone;
        this.mHasButtonUnderPad = hasButtonUnderPad;
        this.mHasSensor = hasSensor;
        this.mHasBattery = hasBattery;
        this.mIdentifier = new InputDeviceIdentifier(descriptor, vendorId, productId);
        this.mHostUsiVersion = new HostUsiVersion(usiVersionMajor, usiVersionMinor);
        this.mAssociatedDisplayId = associatedDisplayId;
        this.mEnabled = enabled;
    }

    private InputDevice(Parcel in) {
        this.mKeyCharacterMap = KeyCharacterMap.CREATOR.createFromParcel(in);
        this.mId = in.readInt();
        this.mGeneration = in.readInt();
        this.mControllerNumber = in.readInt();
        this.mName = in.readString();
        this.mVendorId = in.readInt();
        this.mProductId = in.readInt();
        this.mDeviceBus = in.readInt();
        this.mDescriptor = in.readString();
        this.mIsExternal = in.readInt() != 0;
        this.mSources = in.readInt();
        this.mKeyboardType = in.readInt();
        this.mKeyboardLanguageTag = in.readString8();
        this.mKeyboardLayoutType = in.readString8();
        this.mHasVibrator = in.readInt() != 0;
        this.mHasMicrophone = in.readInt() != 0;
        this.mHasButtonUnderPad = in.readInt() != 0;
        this.mHasSensor = in.readInt() != 0;
        this.mHasBattery = in.readInt() != 0;
        this.mHostUsiVersion = HostUsiVersion.CREATOR.createFromParcel(in);
        this.mAssociatedDisplayId = in.readInt();
        this.mEnabled = in.readInt() != 0;
        this.mIdentifier = new InputDeviceIdentifier(this.mDescriptor, this.mVendorId, this.mProductId);
        int numRanges = in.readInt();
        if (numRanges > 1000) {
            numRanges = 1000;
        }
        for (int i = 0; i < numRanges; ++i) {
            this.addMotionRange(in.readInt(), in.readInt(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
        }
        this.mViewBehavior.mShouldSmoothScroll = in.readBoolean();
    }

    @Nullable
    public static InputDevice getDevice(int id2) {
        return InputManagerGlobal.getInstance().getInputDevice(id2);
    }

    public static int[] getDeviceIds() {
        return InputManagerGlobal.getInstance().getInputDeviceIds();
    }

    public int getId() {
        return this.mId;
    }

    public int getControllerNumber() {
        return this.mControllerNumber;
    }

    @NonNull
    public InputDeviceIdentifier getIdentifier() {
        return this.mIdentifier;
    }

    public int getGeneration() {
        return this.mGeneration;
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public int getDeviceBus() {
        return this.mDeviceBus;
    }

    public String getDescriptor() {
        return this.mDescriptor;
    }

    public boolean isVirtual() {
        return this.mId < 0;
    }

    public boolean isExternal() {
        return this.mIsExternal;
    }

    public boolean isFullKeyboard() {
        return (this.mSources & 0x101) == 257 && this.mKeyboardType == 2;
    }

    public String getName() {
        return this.mName;
    }

    public int getSources() {
        return this.mSources;
    }

    public boolean supportsSource(int source) {
        return (this.mSources & source) == source;
    }

    public int getKeyboardType() {
        return this.mKeyboardType;
    }

    public KeyCharacterMap getKeyCharacterMap() {
        return this.mKeyCharacterMap;
    }

    @Nullable
    public String getKeyboardLanguageTag() {
        return this.mKeyboardLanguageTag;
    }

    @Nullable
    public String getKeyboardLayoutType() {
        return this.mKeyboardLayoutType;
    }

    public boolean[] hasKeys(int ... keys) {
        return InputManagerGlobal.getInstance().deviceHasKeys(this.mId, keys);
    }

    public int getKeyCodeForKeyLocation(int locationKeyCode) {
        return InputManagerGlobal.getInstance().getKeyCodeForKeyLocation(this.mId, locationKeyCode);
    }

    public MotionRange getMotionRange(int axis) {
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            if (range.mAxis != axis) continue;
            return range;
        }
        return null;
    }

    public MotionRange getMotionRange(int axis, int source) {
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            if (range.mAxis != axis || range.mSource != source) continue;
            return range;
        }
        return null;
    }

    public List<MotionRange> getMotionRanges() {
        return this.mMotionRanges;
    }

    @NonNull
    public ViewBehavior getViewBehavior() {
        return this.mViewBehavior;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void addMotionRange(int axis, int source, float min, float max, float flat, float fuzz, float resolution) {
        this.mMotionRanges.add(new MotionRange(axis, source, min, max, flat, fuzz, resolution));
    }

    private void setShouldSmoothScroll(boolean shouldSmoothScroll) {
        this.mViewBehavior.mShouldSmoothScroll = shouldSmoothScroll;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    @Nullable
    public String getBluetoothAddress() {
        return InputManagerGlobal.getInstance().getInputDeviceBluetoothAddress(this.mId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Vibrator getVibrator() {
        ArrayList<MotionRange> arrayList = this.mMotionRanges;
        synchronized (arrayList) {
            if (this.mVibrator == null) {
                this.mVibrator = this.mHasVibrator ? InputManagerGlobal.getInstance().getInputDeviceVibrator(this.mId, -1) : NullVibrator.getInstance();
            }
            return this.mVibrator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public VibratorManager getVibratorManager() {
        ArrayList<MotionRange> arrayList = this.mMotionRanges;
        synchronized (arrayList) {
            if (this.mVibratorManager == null) {
                this.mVibratorManager = InputManagerGlobal.getInstance().getInputDeviceVibratorManager(this.mId);
            }
        }
        return this.mVibratorManager;
    }

    @NonNull
    public BatteryState getBatteryState() {
        return InputManagerGlobal.getInstance().getInputDeviceBatteryState(this.mId, this.mHasBattery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LightsManager getLightsManager() {
        ArrayList<MotionRange> arrayList = this.mMotionRanges;
        synchronized (arrayList) {
            if (this.mLightsManager == null) {
                this.mLightsManager = InputManagerGlobal.getInstance().getInputDeviceLightsManager(this.mId);
            }
        }
        return this.mLightsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public SensorManager getSensorManager() {
        ArrayList<MotionRange> arrayList = this.mMotionRanges;
        synchronized (arrayList) {
            if (this.mSensorManager == null) {
                this.mSensorManager = InputManagerGlobal.getInstance().getInputDeviceSensorManager(this.mId);
            }
        }
        return this.mSensorManager;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    @RequiresPermission(value="android.permission.DISABLE_INPUT_DEVICE")
    public void enable() {
        InputManagerGlobal.getInstance().enableInputDevice(this.mId);
    }

    @RequiresPermission(value="android.permission.DISABLE_INPUT_DEVICE")
    public void disable() {
        InputManagerGlobal.getInstance().disableInputDevice(this.mId);
    }

    public boolean hasMicrophone() {
        return this.mHasMicrophone;
    }

    public boolean hasButtonUnderPad() {
        return this.mHasButtonUnderPad;
    }

    public boolean hasSensor() {
        return this.mHasSensor;
    }

    public boolean hasBattery() {
        return this.mHasBattery;
    }

    @Nullable
    public HostUsiVersion getHostUsiVersion() {
        return this.mHostUsiVersion.isValid() ? this.mHostUsiVersion : null;
    }

    public int getAssociatedDisplayId() {
        return this.mAssociatedDisplayId;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mKeyCharacterMap.writeToParcel(out, flags);
        out.writeInt(this.mId);
        out.writeInt(this.mGeneration);
        out.writeInt(this.mControllerNumber);
        out.writeString(this.mName);
        out.writeInt(this.mVendorId);
        out.writeInt(this.mProductId);
        out.writeInt(this.mDeviceBus);
        out.writeString(this.mDescriptor);
        out.writeInt(this.mIsExternal ? 1 : 0);
        out.writeInt(this.mSources);
        out.writeInt(this.mKeyboardType);
        out.writeString8(this.mKeyboardLanguageTag);
        out.writeString8(this.mKeyboardLayoutType);
        out.writeInt(this.mHasVibrator ? 1 : 0);
        out.writeInt(this.mHasMicrophone ? 1 : 0);
        out.writeInt(this.mHasButtonUnderPad ? 1 : 0);
        out.writeInt(this.mHasSensor ? 1 : 0);
        out.writeInt(this.mHasBattery ? 1 : 0);
        this.mHostUsiVersion.writeToParcel(out, flags);
        out.writeInt(this.mAssociatedDisplayId);
        out.writeInt(this.mEnabled ? 1 : 0);
        int numRanges = this.mMotionRanges.size();
        numRanges = numRanges > 1000 ? 1000 : numRanges;
        out.writeInt(numRanges);
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            out.writeInt(range.mAxis);
            out.writeInt(range.mSource);
            out.writeFloat(range.mMin);
            out.writeFloat(range.mMax);
            out.writeFloat(range.mFlat);
            out.writeFloat(range.mFuzz);
            out.writeFloat(range.mResolution);
        }
        out.writeBoolean(this.mViewBehavior.mShouldSmoothScroll);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder description = new StringBuilder();
        description.append("Input Device ").append(this.mId).append(": ").append(this.mName).append("\n");
        description.append("  Descriptor: ").append(this.mDescriptor).append("\n");
        description.append("  Generation: ").append(this.mGeneration).append("\n");
        description.append("  Location: ").append(this.mIsExternal ? "external" : "built-in").append("\n");
        description.append("  Enabled: ").append(this.isEnabled()).append("\n");
        description.append("  Keyboard Type: ");
        switch (this.mKeyboardType) {
            case 0: {
                description.append("none");
                break;
            }
            case 1: {
                description.append("non-alphabetic");
                break;
            }
            case 2: {
                description.append("alphabetic");
            }
        }
        description.append("\n");
        description.append("  Has Vibrator: ").append(this.mHasVibrator).append("\n");
        description.append("  Has Sensor: ").append(this.mHasSensor).append("\n");
        description.append("  Has battery: ").append(this.mHasBattery).append("\n");
        description.append("  Has mic: ").append(this.mHasMicrophone).append("\n");
        description.append("  USI Version: ").append(this.getHostUsiVersion()).append("\n");
        if (this.mKeyboardLanguageTag != null) {
            description.append(" Keyboard language tag: ").append(this.mKeyboardLanguageTag).append("\n");
        }
        if (this.mKeyboardLayoutType != null) {
            description.append(" Keyboard layout type: ").append(this.mKeyboardLayoutType).append("\n");
        }
        description.append("  Sources: 0x").append(Integer.toHexString(this.mSources)).append(" (");
        this.appendSourceDescriptionIfApplicable(description, 257, "keyboard");
        this.appendSourceDescriptionIfApplicable(description, 513, "dpad");
        this.appendSourceDescriptionIfApplicable(description, 4098, "touchscreen");
        this.appendSourceDescriptionIfApplicable(description, 8194, "mouse");
        this.appendSourceDescriptionIfApplicable(description, 16386, "stylus");
        this.appendSourceDescriptionIfApplicable(description, 65540, "trackball");
        this.appendSourceDescriptionIfApplicable(description, 131076, "mouse_relative");
        this.appendSourceDescriptionIfApplicable(description, 0x100008, "touchpad");
        this.appendSourceDescriptionIfApplicable(description, 0x1000010, "joystick");
        this.appendSourceDescriptionIfApplicable(description, 1025, "gamepad");
        description.append(" )\n");
        int numAxes = this.mMotionRanges.size();
        for (int i = 0; i < numAxes; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            description.append("    ").append(MotionEvent.axisToString(range.mAxis));
            description.append(": source=0x").append(Integer.toHexString(range.mSource));
            description.append(" min=").append(range.mMin);
            description.append(" max=").append(range.mMax);
            description.append(" flat=").append(range.mFlat);
            description.append(" fuzz=").append(range.mFuzz);
            description.append(" resolution=").append(range.mResolution);
            description.append("\n");
        }
        return description.toString();
    }

    private void appendSourceDescriptionIfApplicable(StringBuilder description, int source, String sourceName) {
        if ((this.mSources & source) == source) {
            description.append(" ");
            description.append(sourceName);
        }
    }

    @FlaggedApi(value="com.android.input.flags.input_device_view_behavior_api")
    public static class ViewBehavior {
        private static final boolean DEFAULT_SHOULD_SMOOTH_SCROLL = false;
        private final InputDevice mInputDevice;
        private boolean mShouldSmoothScroll = false;

        public ViewBehavior(@NonNull InputDevice inputDevice) {
            this.mInputDevice = inputDevice;
        }

        @FlaggedApi(value="com.android.input.flags.input_device_view_behavior_api")
        public boolean shouldSmoothScroll(int axis, int source) {
            if (this.mInputDevice.getMotionRange(axis, source) == null) {
                return false;
            }
            return this.mShouldSmoothScroll;
        }
    }

    public static class MotionRange {
        private int mAxis;
        private int mSource;
        private float mMin;
        private float mMax;
        private float mFlat;
        private float mFuzz;
        private float mResolution;

        private MotionRange(int axis, int source, float min, float max, float flat, float fuzz, float resolution) {
            this.mAxis = axis;
            this.mSource = source;
            this.mMin = min;
            this.mMax = max;
            this.mFlat = flat;
            this.mFuzz = fuzz;
            this.mResolution = resolution;
        }

        public int getAxis() {
            return this.mAxis;
        }

        public int getSource() {
            return this.mSource;
        }

        public boolean isFromSource(int source) {
            return (this.getSource() & source) == source;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getRange() {
            return this.mMax - this.mMin;
        }

        public float getFlat() {
            return this.mFlat;
        }

        public float getFuzz() {
            return this.mFuzz;
        }

        public float getResolution() {
            return this.mResolution;
        }
    }

    @VisibleForTesting
    public static class Builder {
        private int mId = 0;
        private int mGeneration = 0;
        private int mControllerNumber = 0;
        private String mName = "";
        private int mVendorId = 0;
        private int mProductId = 0;
        private int mDeviceBus = 0;
        private String mDescriptor = "";
        private boolean mIsExternal = false;
        private int mSources = 0;
        private int mKeyboardType = 0;
        private KeyCharacterMap mKeyCharacterMap = null;
        private boolean mHasVibrator = false;
        private boolean mHasMicrophone = false;
        private boolean mHasButtonUnderPad = false;
        private boolean mHasSensor = false;
        private boolean mHasBattery = false;
        private String mKeyboardLanguageTag = null;
        private String mKeyboardLayoutType = null;
        private int mUsiVersionMajor = -1;
        private int mUsiVersionMinor = -1;
        private int mAssociatedDisplayId = -1;
        private boolean mEnabled = true;
        private List<MotionRange> mMotionRanges = new ArrayList<MotionRange>();
        private boolean mShouldSmoothScroll;

        public Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setGeneration(int generation) {
            this.mGeneration = generation;
            return this;
        }

        public Builder setControllerNumber(int controllerNumber) {
            this.mControllerNumber = controllerNumber;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setVendorId(int vendorId) {
            this.mVendorId = vendorId;
            return this;
        }

        public Builder setProductId(int productId) {
            this.mProductId = productId;
            return this;
        }

        public Builder setDeviceBus(int deviceBus) {
            this.mDeviceBus = deviceBus;
            return this;
        }

        public Builder setDescriptor(String descriptor) {
            this.mDescriptor = descriptor;
            return this;
        }

        public Builder setExternal(boolean external) {
            this.mIsExternal = external;
            return this;
        }

        public Builder setSources(int sources) {
            this.mSources = sources;
            return this;
        }

        public Builder setKeyboardType(int keyboardType) {
            this.mKeyboardType = keyboardType;
            return this;
        }

        public Builder setKeyCharacterMap(KeyCharacterMap keyCharacterMap) {
            this.mKeyCharacterMap = keyCharacterMap;
            return this;
        }

        public Builder setHasVibrator(boolean hasVibrator) {
            this.mHasVibrator = hasVibrator;
            return this;
        }

        public Builder setHasMicrophone(boolean hasMicrophone) {
            this.mHasMicrophone = hasMicrophone;
            return this;
        }

        public Builder setHasButtonUnderPad(boolean hasButtonUnderPad) {
            this.mHasButtonUnderPad = hasButtonUnderPad;
            return this;
        }

        public Builder setHasSensor(boolean hasSensor) {
            this.mHasSensor = hasSensor;
            return this;
        }

        public Builder setHasBattery(boolean hasBattery) {
            this.mHasBattery = hasBattery;
            return this;
        }

        public Builder setKeyboardLanguageTag(String keyboardLanguageTag) {
            this.mKeyboardLanguageTag = keyboardLanguageTag;
            return this;
        }

        public Builder setKeyboardLayoutType(String keyboardLayoutType) {
            this.mKeyboardLayoutType = keyboardLayoutType;
            return this;
        }

        public Builder setUsiVersion(@Nullable HostUsiVersion usiVersion) {
            this.mUsiVersionMajor = usiVersion != null ? usiVersion.getMajorVersion() : -1;
            this.mUsiVersionMinor = usiVersion != null ? usiVersion.getMinorVersion() : -1;
            return this;
        }

        public Builder setAssociatedDisplayId(int displayId) {
            this.mAssociatedDisplayId = displayId;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            return this;
        }

        public Builder addMotionRange(int axis, int source, float min, float max, float flat, float fuzz, float resolution) {
            this.mMotionRanges.add(new MotionRange(axis, source, min, max, flat, fuzz, resolution));
            return this;
        }

        public Builder setShouldSmoothScroll(boolean shouldSmoothScroll) {
            this.mShouldSmoothScroll = shouldSmoothScroll;
            return this;
        }

        public InputDevice build() {
            InputDevice device = new InputDevice(this.mId, this.mGeneration, this.mControllerNumber, this.mName, this.mVendorId, this.mProductId, this.mDeviceBus, this.mDescriptor, this.mIsExternal, this.mSources, this.mKeyboardType, this.mKeyCharacterMap, this.mKeyboardLanguageTag, this.mKeyboardLayoutType, this.mHasVibrator, this.mHasMicrophone, this.mHasButtonUnderPad, this.mHasSensor, this.mHasBattery, this.mUsiVersionMajor, this.mUsiVersionMinor, this.mAssociatedDisplayId, this.mEnabled);
            int numRanges = this.mMotionRanges.size();
            for (int i = 0; i < numRanges; ++i) {
                MotionRange range = this.mMotionRanges.get(i);
                device.addMotionRange(range.getAxis(), range.getSource(), range.getMin(), range.getMax(), range.getFlat(), range.getFuzz(), range.getResolution());
            }
            device.setShouldSmoothScroll(this.mShouldSmoothScroll);
            return device;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Source {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface InputSourceClass {
    }
}

