/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.Handler;
import android.view.InputEvent;
import android.view.LetterboxScrollProcessor;
import android.view.MotionEvent;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.ArrayList;
import java.util.List;

public class InputEventCompatProcessor {
    protected Context mContext;
    protected int mTargetSdkVersion;
    private final LetterboxScrollProcessor mLetterboxScrollProcessor;
    private final List<InputEvent> mProcessedEvents;

    public InputEventCompatProcessor(Context context) {
        this(context, null);
    }

    public InputEventCompatProcessor(Context context, Handler handler) {
        this.mContext = context;
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.mLetterboxScrollProcessor = Flags.scrollingFromLetterbox() ? new LetterboxScrollProcessor(this.mContext, handler) : null;
        this.mProcessedEvents = new ArrayList<InputEvent>();
    }

    public List<InputEvent> processInputEventForCompatibility(InputEvent inputEvent) {
        this.mProcessedEvents.clear();
        InputEvent stylusCompatEvent = this.processStylusButtonCompatibility(inputEvent);
        List<MotionEvent> letterboxScrollCompatEvents = this.processLetterboxScrollCompatibility(stylusCompatEvent != null ? stylusCompatEvent : inputEvent);
        if (letterboxScrollCompatEvents == null) {
            if (stylusCompatEvent != null) {
                this.mProcessedEvents.add(stylusCompatEvent);
                return this.mProcessedEvents;
            }
            return null;
        }
        this.mProcessedEvents.addAll(letterboxScrollCompatEvents);
        return this.mProcessedEvents;
    }

    public InputEvent processInputEventBeforeFinish(InputEvent inputEvent) {
        if (this.mLetterboxScrollProcessor != null && inputEvent instanceof MotionEvent) {
            MotionEvent motionEvent = (MotionEvent)inputEvent;
            return this.mLetterboxScrollProcessor.processMotionEventBeforeFinish(motionEvent);
        }
        return inputEvent;
    }

    private List<MotionEvent> processLetterboxScrollCompatibility(InputEvent inputEvent) {
        MotionEvent motionEvent;
        if (this.mLetterboxScrollProcessor != null && inputEvent instanceof MotionEvent && (motionEvent = (MotionEvent)inputEvent).getAction() != 4) {
            return this.mLetterboxScrollProcessor.processMotionEvent(motionEvent);
        }
        return null;
    }

    private InputEvent processStylusButtonCompatibility(InputEvent inputEvent) {
        if (this.mTargetSdkVersion < 23 && inputEvent instanceof MotionEvent) {
            MotionEvent motion = (MotionEvent)inputEvent;
            int mask = 96;
            int buttonState = motion.getButtonState();
            int compatButtonState = (buttonState & 0x60) >> 4;
            if (compatButtonState != 0) {
                motion.setButtonState(buttonState | compatButtonState);
            }
            return motion;
        }
        return null;
    }
}

