/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Trace;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public abstract class InputEventReceiver {
    private static final String TAG = "InputEventReceiver";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mReceiverPtr;
    private InputChannel mInputChannel;
    private MessageQueue mMessageQueue;
    private final SparseIntArray mSeqMap = new SparseIntArray();

    private static long nativeInit(WeakReference<InputEventReceiver> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return OverrideMethod.invokeL("android.view.InputEventReceiver#nativeInit(Ljava/lang/ref/WeakReference;Landroid/view/InputChannel;Landroid/os/MessageQueue;)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.InputEventReceiver#nativeDispose(J)V", true, null);
    }

    private static void nativeFinishInputEvent(long l, int n, boolean bl) {
        OverrideMethod.invokeV("android.view.InputEventReceiver#nativeFinishInputEvent(JIZ)V", true, null);
    }

    private static boolean nativeProbablyHasInput(long l) {
        return OverrideMethod.invokeI("android.view.InputEventReceiver#nativeProbablyHasInput(J)Z", true, null) != 0;
    }

    private static void nativeReportTimeline(long l, int n, long l2, long l3) {
        OverrideMethod.invokeV("android.view.InputEventReceiver#nativeReportTimeline(JIJJ)V", true, null);
    }

    private static boolean nativeConsumeBatchedInputEvents(long l, long l2) {
        return OverrideMethod.invokeI("android.view.InputEventReceiver#nativeConsumeBatchedInputEvents(JJ)Z", true, null) != 0;
    }

    private static String nativeDump(long l, String string2) {
        return (String)OverrideMethod.invokeA("android.view.InputEventReceiver#nativeDump(JLjava/lang/String;)Ljava/lang/String;", true, null);
    }

    public InputEventReceiver(InputChannel inputChannel, Looper looper) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = InputEventReceiver.nativeInit(new WeakReference<InputEventReceiver>(this), this.mInputChannel, this.mMessageQueue);
        this.mCloseGuard.open("InputEventReceiver.dispose");
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public boolean probablyHasInput() {
        if (this.mReceiverPtr == 0L) {
            return false;
        }
        return InputEventReceiver.nativeProbablyHasInput(this.mReceiverPtr);
    }

    public void dispose() {
        this.dispose(false);
    }

    private void dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0L) {
            InputEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        if (this.mInputChannel != null) {
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
        this.mMessageQueue = null;
        Reference.reachabilityFence(this);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void onInputEvent(InputEvent event) {
        this.finishInputEvent(event, false);
    }

    public void onFocusEvent(boolean hasFocus) {
    }

    public void onPointerCaptureEvent(boolean pointerCaptureEnabled) {
    }

    public void onDragEvent(boolean isExiting, float x, float y, int displayId) {
    }

    public void onTouchModeChanged(boolean inTouchMode) {
    }

    public void onBatchedInputEventPending(int source) {
        this.consumeBatchedInputEvents(-1L);
    }

    public void finishInputEvent(InputEvent event, boolean handled) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to finish an input event but the input event receiver has already been disposed.");
        } else {
            int index = this.mSeqMap.indexOfKey(event.getSequenceNumber());
            if (index < 0) {
                Log.w(TAG, "Attempted to finish an input event that is not in progress.");
            } else {
                int seq = this.mSeqMap.valueAt(index);
                this.mSeqMap.removeAt(index);
                InputEventReceiver.nativeFinishInputEvent(this.mReceiverPtr, seq, handled);
            }
        }
        event.recycleIfNeededAfterDispatch();
    }

    public void reportTimeline(int inputEventId, long gpuCompletedTime, long presentTime) {
        Trace.traceBegin(4L, "reportTimeline");
        InputEventReceiver.nativeReportTimeline(this.mReceiverPtr, inputEventId, gpuCompletedTime, presentTime);
        Trace.traceEnd(4L);
    }

    public boolean consumeBatchedInputEvents(long frameTimeNanos) {
        if (this.mReceiverPtr != 0L) {
            return InputEventReceiver.nativeConsumeBatchedInputEvents(this.mReceiverPtr, frameTimeNanos);
        }
        Log.w(TAG, "Attempted to consume batched input events but the input event receiver has already been disposed.");
        return false;
    }

    public IBinder getToken() {
        if (this.mInputChannel == null) {
            return null;
        }
        return this.mInputChannel.getToken();
    }

    private String getShortDescription(InputEvent event) {
        if (event instanceof MotionEvent) {
            MotionEvent motion = (MotionEvent)event;
            return "MotionEvent " + MotionEvent.actionToString(motion.getAction()) + " deviceId=" + motion.getDeviceId() + " source=0x" + Integer.toHexString(motion.getSource()) + " historySize=" + motion.getHistorySize();
        }
        if (event instanceof KeyEvent) {
            KeyEvent key = (KeyEvent)event;
            return "KeyEvent " + KeyEvent.actionToString(key.getAction()) + " deviceId=" + key.getDeviceId();
        }
        Log.wtf(TAG, "Illegal InputEvent type: " + event);
        return "InputEvent";
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void dispatchInputEvent(int seq, InputEvent event) {
        if (Trace.isTagEnabled(4L)) {
            Trace.traceBegin(4L, "dispatchInputEvent " + this.getShortDescription(event));
        }
        this.mSeqMap.put(event.getSequenceNumber(), seq);
        this.onInputEvent(event);
        Trace.traceEnd(4L);
    }

    public void dump(String prefix, PrintWriter writer) {
        writer.println(prefix + this.getClass().getName());
        writer.println(prefix + " mInputChannel: " + this.mInputChannel);
        writer.println(prefix + " mSeqMap: " + this.mSeqMap);
        writer.println(prefix + " mReceiverPtr:\n" + InputEventReceiver.nativeDump(this.mReceiverPtr, prefix + "  "));
    }
}

