/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.view.MotionEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import libcore.util.NativeAllocationRegistry;

public class MotionPredictor {
    private final long mPtr;
    private final boolean mIsPredictionEnabled;

    public MotionPredictor(@NonNull Context context) {
        this(context.getResources().getBoolean(17891711), context.getResources().getInteger(17694939));
    }

    @VisibleForTesting
    public MotionPredictor(boolean isPredictionEnabled, int motionPredictionOffsetNanos) {
        this.mIsPredictionEnabled = isPredictionEnabled;
        this.mPtr = MotionPredictor.nativeInitialize(motionPredictionOffsetNanos);
        RegistryHolder.REGISTRY.registerNativeAllocation(this, this.mPtr);
    }

    public void record(@NonNull MotionEvent event) {
        if (!this.mIsPredictionEnabled) {
            return;
        }
        MotionPredictor.nativeRecord(this.mPtr, event);
    }

    @Nullable
    public MotionEvent predict(long predictionTimeNanos) {
        if (!this.mIsPredictionEnabled) {
            return null;
        }
        return MotionPredictor.nativePredict(this.mPtr, predictionTimeNanos);
    }

    public boolean isPredictionAvailable(int deviceId, int source) {
        return this.mIsPredictionEnabled && MotionPredictor.nativeIsPredictionAvailable(this.mPtr, deviceId, source);
    }

    private static long nativeInitialize(int n) {
        return OverrideMethod.invokeL("android.view.MotionPredictor#nativeInitialize(I)J", true, null);
    }

    private static void nativeRecord(long l, MotionEvent motionEvent) {
        OverrideMethod.invokeV("android.view.MotionPredictor#nativeRecord(JLandroid/view/MotionEvent;)V", true, null);
    }

    private static MotionEvent nativePredict(long l, long l2) {
        return (MotionEvent)OverrideMethod.invokeA("android.view.MotionPredictor#nativePredict(JJ)Landroid/view/MotionEvent;", true, null);
    }

    private static boolean nativeIsPredictionAvailable(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.view.MotionPredictor#nativeIsPredictionAvailable(JII)Z", true, null) != 0;
    }

    private static long nativeGetNativeMotionPredictorFinalizer() {
        return OverrideMethod.invokeL("android.view.MotionPredictor#nativeGetNativeMotionPredictorFinalizer()J", true, null);
    }

    private static class RegistryHolder {
        public static final NativeAllocationRegistry REGISTRY = NativeAllocationRegistry.createMalloced(MotionPredictor.class.getClassLoader(), MotionPredictor.nativeGetNativeMotionPredictorFinalizer());

        private RegistryHolder() {
        }
    }
}

