/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.view.PointerIcon_Delegate;
import android.view.flags.Flags;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PointerIcon
implements Parcelable {
    private static final String TAG = "PointerIcon";
    public static final int TYPE_CUSTOM = -1;
    public static final int TYPE_NULL = 0;
    public static final int TYPE_NOT_SPECIFIED = 1;
    public static final int TYPE_ARROW = 1000;
    public static final int TYPE_SPOT_HOVER = 2000;
    public static final int TYPE_SPOT_TOUCH = 2001;
    public static final int TYPE_SPOT_ANCHOR = 2002;
    public static final int TYPE_CONTEXT_MENU = 1001;
    public static final int TYPE_HAND = 1002;
    public static final int TYPE_HELP = 1003;
    public static final int TYPE_WAIT = 1004;
    public static final int TYPE_CELL = 1006;
    public static final int TYPE_CROSSHAIR = 1007;
    public static final int TYPE_TEXT = 1008;
    public static final int TYPE_VERTICAL_TEXT = 1009;
    public static final int TYPE_ALIAS = 1010;
    public static final int TYPE_COPY = 1011;
    public static final int TYPE_NO_DROP = 1012;
    public static final int TYPE_ALL_SCROLL = 1013;
    public static final int TYPE_HORIZONTAL_DOUBLE_ARROW = 1014;
    public static final int TYPE_VERTICAL_DOUBLE_ARROW = 1015;
    public static final int TYPE_TOP_RIGHT_DIAGONAL_DOUBLE_ARROW = 1016;
    public static final int TYPE_TOP_LEFT_DIAGONAL_DOUBLE_ARROW = 1017;
    public static final int TYPE_ZOOM_IN = 1018;
    public static final int TYPE_ZOOM_OUT = 1019;
    public static final int TYPE_GRAB = 1020;
    public static final int TYPE_GRABBING = 1021;
    public static final int TYPE_HANDWRITING = 1022;
    private static final int TYPE_OEM_FIRST = 10000;
    public static final int TYPE_DEFAULT = 1000;
    private static final SparseArray<PointerIcon> SYSTEM_ICONS = new SparseArray();
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_BLACK = 0;
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_GREEN = 1;
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_RED = 2;
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_PINK = 3;
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_BLUE = 4;
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_PURPLE = 5;
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_BEGIN = 0;
    public static final int POINTER_ICON_VECTOR_STYLE_FILL_END = 5;
    public static final int POINTER_ICON_VECTOR_STYLE_STROKE_WHITE = 0;
    public static final int POINTER_ICON_VECTOR_STYLE_STROKE_BLACK = 1;
    public static final int POINTER_ICON_VECTOR_STYLE_STROKE_NONE = 2;
    public static final int POINTER_ICON_VECTOR_STYLE_STROKE_BEGIN = 0;
    public static final int POINTER_ICON_VECTOR_STYLE_STROKE_END = 2;
    public static final float DEFAULT_POINTER_SCALE = 1.0f;
    public static final float LARGE_POINTER_SCALE = 2.5f;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int mType;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Bitmap mBitmap;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mHotSpotX;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mHotSpotY;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Bitmap[] mBitmapFrames;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mDurationPerFrame;
    private boolean mDrawNativeDropShadow;
    @NonNull
    public static final Parcelable.Creator<PointerIcon> CREATOR = new Parcelable.Creator<PointerIcon>(){

        @Override
        public PointerIcon createFromParcel(Parcel in) {
            int type = in.readInt();
            if (type != -1) {
                return PointerIcon.getSystemIcon(type);
            }
            PointerIcon icon = PointerIcon.create(Bitmap.CREATOR.createFromParcel(in), in.readFloat(), in.readFloat());
            icon.mDrawNativeDropShadow = in.readBoolean();
            return icon;
        }

        public PointerIcon[] newArray(int size) {
            return new PointerIcon[size];
        }
    };

    private PointerIcon(int type) {
        this.mType = type;
    }

    @NonNull
    public static PointerIcon getSystemIcon(@NonNull Context context, int type) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        return PointerIcon.getSystemIcon(type);
    }

    @NonNull
    private static PointerIcon getSystemIcon(int type) {
        if (type == -1) {
            throw new IllegalArgumentException("cannot get system icon for TYPE_CUSTOM");
        }
        PointerIcon icon = SYSTEM_ICONS.get(type);
        if (icon == null) {
            icon = new PointerIcon(type);
            SYSTEM_ICONS.put(type, icon);
        }
        return icon;
    }

    @NonNull
    public static PointerIcon getLoadedSystemIcon(@NonNull Context context, int type, boolean useLargeIcons, float pointerScale) {
        if (type == 1) {
            throw new IllegalStateException("Cannot load icon for type TYPE_NOT_SPECIFIED");
        }
        if (type == -1) {
            throw new IllegalArgumentException("Custom icons must be loaded when they're created");
        }
        int typeIndex = PointerIcon.getSystemIconTypeIndex(type);
        if (typeIndex < 0) {
            typeIndex = PointerIcon.getSystemIconTypeIndex(1000);
        }
        int defStyle = Flags.enableVectorCursorA11ySettings() ? 16974960 : (useLargeIcons ? 16974653 : (Flags.enableVectorCursors() ? 16974960 : 16974660));
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Pointer, 0, defStyle);
        int resourceId = a.getResourceId(typeIndex, -1);
        a.recycle();
        if (resourceId == -1) {
            Log.w(TAG, "Missing theme resources for pointer icon type " + type);
            return type == 1000 ? PointerIcon.getSystemIcon(0) : PointerIcon.getLoadedSystemIcon(context, 1000, useLargeIcons, pointerScale);
        }
        PointerIcon icon = new PointerIcon(type);
        icon.loadResource(context.getResources(), resourceId, context.getTheme(), pointerScale);
        return icon;
    }

    private boolean isLoaded() {
        return this.mBitmap != null && this.mHotSpotX >= 0.0f && this.mHotSpotX < (float)this.mBitmap.getWidth() && this.mHotSpotY >= 0.0f && this.mHotSpotY < (float)this.mBitmap.getHeight();
    }

    @NonNull
    public static PointerIcon create(@NonNull Bitmap bitmap, float hotSpotX, float hotSpotY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        PointerIcon.validateHotSpot(bitmap, hotSpotX, hotSpotY, false);
        PointerIcon icon = new PointerIcon(-1);
        icon.mBitmap = bitmap;
        icon.mHotSpotX = hotSpotX;
        icon.mHotSpotY = hotSpotY;
        return icon;
    }

    @NonNull
    public static PointerIcon load(@NonNull Resources resources, int resourceId) {
        if (resources == null) {
            throw new IllegalArgumentException("resources must not be null");
        }
        PointerIcon icon = new PointerIcon(-1);
        icon.loadResource(resources, resourceId, null, 1.0f);
        return icon;
    }

    public int getType() {
        return this.mType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mType);
        if (this.mType != -1) {
            return;
        }
        if (!this.isLoaded()) {
            throw new IllegalStateException("Custom icon should be loaded upon creation");
        }
        this.mBitmap.writeToParcel(out, flags);
        out.writeFloat(this.mHotSpotX);
        out.writeFloat(this.mHotSpotY);
        out.writeBoolean(this.mDrawNativeDropShadow);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof PointerIcon)) {
            return false;
        }
        PointerIcon otherIcon = (PointerIcon)other;
        if (this.mType != otherIcon.mType) {
            return false;
        }
        return this.mBitmap == otherIcon.mBitmap && this.mHotSpotX == otherIcon.mHotSpotX && this.mHotSpotY == otherIcon.mHotSpotY;
    }

    private Bitmap getBitmapFromDrawable(BitmapDrawable bitmapDrawable) {
        Bitmap bitmap = bitmapDrawable.getBitmap();
        int scaledWidth = bitmapDrawable.getIntrinsicWidth();
        int scaledHeight = bitmapDrawable.getIntrinsicHeight();
        if (scaledWidth == bitmap.getWidth() && scaledHeight == bitmap.getHeight()) {
            return bitmap;
        }
        Rect src = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF dst = new RectF(0.0f, 0.0f, scaledWidth, scaledHeight);
        Bitmap scaled = Bitmap.createBitmap(scaledWidth, scaledHeight, bitmap.getConfig());
        Canvas canvas = new Canvas(scaled);
        Paint paint = new Paint();
        paint.setFilterBitmap(true);
        canvas.drawBitmap(bitmap, src, dst, paint);
        return scaled;
    }

    private BitmapDrawable getBitmapDrawableFromVectorDrawable(Resources resources, VectorDrawable vectorDrawable, float pointerScale) {
        Bitmap bitmap = Bitmap.createBitmap(resources.getDisplayMetrics(), (int)((float)vectorDrawable.getIntrinsicWidth() * pointerScale), (int)((float)vectorDrawable.getIntrinsicHeight() * pointerScale), Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return new BitmapDrawable(resources, bitmap);
    }

    void loadResource_Original(@NonNull Resources resources, int resourceId, @Nullable Resources.Theme theme, float pointerScale) {
        float hotSpotY;
        float hotSpotX;
        int bitmapRes;
        try (XmlResourceParser parser = resources.getXml(resourceId);){
            XmlUtils.beginDocument(parser, "pointer-icon");
            TypedArray a = resources.obtainAttributes(parser, R.styleable.PointerIcon);
            bitmapRes = a.getResourceId(0, 0);
            int unscaledHotSpotX = (int)a.getDimension(1, 0.0f);
            int unscaledHotSpotY = (int)a.getDimension(2, 0.0f);
            hotSpotX = (float)unscaledHotSpotX * pointerScale;
            hotSpotY = (float)unscaledHotSpotY * pointerScale;
            a.recycle();
        }
        if (bitmapRes == 0) {
            throw new IllegalArgumentException("<pointer-icon> is missing bitmap attribute.");
        }
        Drawable drawable2 = resources.getDrawable(bitmapRes, theme);
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable)drawable2;
            int frames = animationDrawable.getNumberOfFrames();
            drawable2 = animationDrawable.getFrame(0);
            if (frames == 1) {
                Log.w(TAG, "Animation icon with single frame -- simply treating the first frame as a normal bitmap icon.");
            } else {
                boolean isVectorAnimation;
                this.mDurationPerFrame = animationDrawable.getDuration(0);
                this.mBitmapFrames = new Bitmap[frames - 1];
                this.mDrawNativeDropShadow = isVectorAnimation = drawable2 instanceof VectorDrawable;
                for (int i = 1; i < frames; ++i) {
                    Drawable drawableFrame = animationDrawable.getFrame(i);
                    if (!(drawableFrame instanceof BitmapDrawable) && !(drawableFrame instanceof VectorDrawable)) {
                        throw new IllegalArgumentException("Frame of an animated pointer icon must refer to a bitmap drawable or vector drawable.");
                    }
                    if (isVectorAnimation != drawableFrame instanceof VectorDrawable) {
                        throw new IllegalArgumentException("The drawable of the " + i + "-th frame is a different type from the others. All frames should be the same type.");
                    }
                    if (isVectorAnimation) {
                        drawableFrame = this.getBitmapDrawableFromVectorDrawable(resources, (VectorDrawable)drawableFrame, pointerScale);
                    }
                    this.mBitmapFrames[i - 1] = this.getBitmapFromDrawable((BitmapDrawable)drawableFrame);
                }
            }
        }
        if (drawable2 instanceof VectorDrawable) {
            this.mDrawNativeDropShadow = true;
            drawable2 = this.getBitmapDrawableFromVectorDrawable(resources, (VectorDrawable)drawable2, pointerScale);
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("<pointer-icon> bitmap attribute must refer to a bitmap drawable.");
        }
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        Bitmap bitmap = this.getBitmapFromDrawable(bitmapDrawable);
        PointerIcon.validateHotSpot(bitmap, hotSpotX, hotSpotY, true);
        this.mBitmap = bitmap;
        this.mHotSpotX = hotSpotX;
        this.mHotSpotY = hotSpotY;
        assert (this.isLoaded());
    }

    @LayoutlibDelegate
    private void loadResource(Resources resources, int n, Resources.Theme theme, float f) {
        PointerIcon_Delegate.loadResource(this, resources, n, theme, f);
    }

    public String toString() {
        return "PointerIcon{type=" + PointerIcon.typeToString(this.mType) + ", hotspotX=" + this.mHotSpotX + ", hotspotY=" + this.mHotSpotY + "}";
    }

    private static void validateHotSpot(Bitmap bitmap, float hotSpotX, float hotSpotY, boolean isScaled) {
        if (hotSpotX < 0.0f || (isScaled ? (int)hotSpotX > bitmap.getWidth() : hotSpotX >= (float)bitmap.getWidth())) {
            throw new IllegalArgumentException("x hotspot lies outside of the bitmap area");
        }
        if (hotSpotY < 0.0f || (isScaled ? (int)hotSpotY > bitmap.getHeight() : hotSpotY >= (float)bitmap.getHeight())) {
            throw new IllegalArgumentException("y hotspot lies outside of the bitmap area");
        }
    }

    private static int getSystemIconTypeIndex(int type) {
        switch (type) {
            case 1000: {
                return 2;
            }
            case 2000: {
                return 15;
            }
            case 2001: {
                return 16;
            }
            case 2002: {
                return 14;
            }
            case 1002: {
                return 9;
            }
            case 1001: {
                return 4;
            }
            case 1003: {
                return 11;
            }
            case 1004: {
                return 22;
            }
            case 1006: {
                return 3;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 17;
            }
            case 1009: {
                return 21;
            }
            case 1010: {
                return 0;
            }
            case 1011: {
                return 5;
            }
            case 1013: {
                return 1;
            }
            case 1012: {
                return 13;
            }
            case 1014: {
                return 12;
            }
            case 1015: {
                return 20;
            }
            case 1016: {
                return 19;
            }
            case 1017: {
                return 18;
            }
            case 1018: {
                return 23;
            }
            case 1019: {
                return 24;
            }
            case 1020: {
                return 7;
            }
            case 1021: {
                return 8;
            }
            case 1022: {
                return 10;
            }
        }
        return -1;
    }

    public static String typeToString(int type) {
        switch (type) {
            case -1: {
                return "CUSTOM";
            }
            case 0: {
                return "NULL";
            }
            case 1: {
                return "NOT_SPECIFIED";
            }
            case 1000: {
                return "ARROW";
            }
            case 2000: {
                return "SPOT_HOVER";
            }
            case 2001: {
                return "SPOT_TOUCH";
            }
            case 2002: {
                return "SPOT_ANCHOR";
            }
            case 1001: {
                return "CONTEXT_MENU";
            }
            case 1002: {
                return "HAND";
            }
            case 1003: {
                return "HELP";
            }
            case 1004: {
                return "WAIT";
            }
            case 1006: {
                return "CELL";
            }
            case 1007: {
                return "CROSSHAIR";
            }
            case 1008: {
                return "TEXT";
            }
            case 1009: {
                return "VERTICAL_TEXT";
            }
            case 1010: {
                return "ALIAS";
            }
            case 1011: {
                return "COPY";
            }
            case 1012: {
                return "NO_DROP";
            }
            case 1013: {
                return "ALL_SCROLL";
            }
            case 1014: {
                return "HORIZONTAL_DOUBLE_ARROW";
            }
            case 1015: {
                return "VERTICAL_DOUBLE_ARROW";
            }
            case 1016: {
                return "TOP_RIGHT_DIAGONAL_DOUBLE_ARROW";
            }
            case 1017: {
                return "TOP_LEFT_DIAGONAL_DOUBLE_ARROW";
            }
            case 1018: {
                return "ZOOM_IN";
            }
            case 1019: {
                return "ZOOM_OUT";
            }
            case 1020: {
                return "GRAB";
            }
            case 1021: {
                return "GRABBING";
            }
            case 1022: {
                return "HANDWRITING";
            }
        }
        return Integer.toString(type);
    }

    public static int vectorFillStyleToResource(int fillStyle) {
        int n;
        switch (fillStyle) {
            case 0: {
                n = 16974661;
                break;
            }
            case 1: {
                n = 16974663;
                break;
            }
            case 2: {
                n = 16974666;
                break;
            }
            case 3: {
                n = 16974664;
                break;
            }
            case 4: {
                n = 16974662;
                break;
            }
            case 5: {
                n = 16974665;
                break;
            }
            default: {
                n = 16974661;
            }
        }
        return n;
    }

    public static int vectorStrokeStyleToResource(int strokeStyle) {
        int n;
        switch (strokeStyle) {
            case 1: {
                n = 16974667;
                break;
            }
            case 0: {
                n = 16974669;
                break;
            }
            case 2: {
                n = 16974668;
                break;
            }
            default: {
                n = 16974669;
            }
        }
        return n;
    }

    @FlaggedApi(value="android.view.flags.enable_vector_cursors")
    public void setDrawNativeDropShadow(boolean drawNativeDropShadow) {
        this.mDrawNativeDropShadow = drawNativeDropShadow;
    }

    @VisibleForTesting
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PointerIconVectorStyleStroke {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PointerIconVectorStyleFill {
    }
}

