/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemProperties;
import android.util.MathUtils;
import android.view.View;
import android.view.flags.Flags;

public class RoundScrollbarRenderer {
    public static final String BLUECHIP_ENABLED_SYSPROP = "persist.cw_build.bluechip.enabled";
    private static final float SCROLLBAR_ANGLE_RANGE = 28.8f;
    private static final float MAX_SCROLLBAR_ANGLE_SWIPE = 20.16f;
    private static final float MIN_SCROLLBAR_ANGLE_SWIPE = 8.64f;
    private static final float GAP_BETWEEN_TRACK_AND_THUMB_DP = 3.0f;
    private static final float OUTER_PADDING_DP = 2.0f;
    private static final int DEFAULT_THUMB_COLOR = -3750201;
    private static final int DEFAULT_TRACK_COLOR = -13684431;
    private static final float RESIZING_RATE = 0.8f;
    private static final int RESIZING_THRESHOLD_PX = 20;
    private final Paint mThumbPaint = new Paint();
    private final Paint mTrackPaint = new Paint();
    private final RectF mRect = new RectF();
    private final View mParent;
    private final float mInset;
    private final float mGapBetweenThumbAndTrackPx;
    private final boolean mUseRefactoredRoundScrollbar;
    private float mPreviousMaxScroll = 0.0f;
    private float mMaxScrollDiff = 0.0f;
    private float mPreviousCurrentScroll = 0.0f;
    private float mCurrentScrollDiff = 0.0f;
    private float mThumbStrokeWidthAsDegrees = 0.0f;
    private float mGapBetweenTrackAndThumbAsDegrees = 0.0f;
    private boolean mDrawToLeft;

    public RoundScrollbarRenderer(View parent) {
        this.mThumbPaint.setAntiAlias(true);
        this.mThumbPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mThumbPaint.setStyle(Paint.Style.STROKE);
        this.mTrackPaint.setAntiAlias(true);
        this.mTrackPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mTrackPaint.setStyle(Paint.Style.STROKE);
        this.mParent = parent;
        Resources resources = parent.getContext().getResources();
        int maskThickness = resources.getDimensionPixelSize(17105109);
        float thumbWidth = resources.getDimensionPixelSize(17105720);
        this.mGapBetweenThumbAndTrackPx = this.dpToPx(3.0f);
        this.mThumbPaint.setStrokeWidth(thumbWidth);
        this.mTrackPaint.setStrokeWidth(thumbWidth);
        this.mInset = thumbWidth / 2.0f + (float)maskThickness;
        this.mUseRefactoredRoundScrollbar = Flags.useRefactoredRoundScrollbar() && SystemProperties.getBoolean(BLUECHIP_ENABLED_SYSPROP, false);
    }

    private float computeScrollExtent(float scrollExtent, float maxScroll) {
        if (scrollExtent <= 0.0f) {
            if (!this.mParent.canScrollVertically(1) && !this.mParent.canScrollVertically(-1)) {
                return -1.0f;
            }
            return 0.0f;
        }
        if (maxScroll <= scrollExtent) {
            return -1.0f;
        }
        return scrollExtent;
    }

    private void resizeGradually(float maxScroll, float newScroll) {
        if (Math.abs(maxScroll - this.mPreviousMaxScroll) > 20.0f && this.mPreviousMaxScroll != 0.0f) {
            this.mMaxScrollDiff += maxScroll - this.mPreviousMaxScroll;
            this.mCurrentScrollDiff += newScroll - this.mPreviousCurrentScroll;
        }
        this.mPreviousMaxScroll = maxScroll;
        this.mPreviousCurrentScroll = newScroll;
        if (Math.abs(this.mMaxScrollDiff) > 20.0f || Math.abs(this.mCurrentScrollDiff) > 20.0f) {
            this.mMaxScrollDiff *= 0.8f;
            this.mCurrentScrollDiff *= 0.8f;
        } else {
            this.mMaxScrollDiff = 0.0f;
            this.mCurrentScrollDiff = 0.0f;
        }
    }

    public void drawRoundScrollbars(Canvas canvas, float alpha, Rect bounds, boolean drawToLeft) {
        if (alpha == 0.0f) {
            return;
        }
        float maxScroll = this.mParent.computeVerticalScrollRange();
        float scrollExtent = this.mParent.computeVerticalScrollExtent();
        float newScroll = this.mParent.computeVerticalScrollOffset();
        if ((scrollExtent = this.computeScrollExtent(scrollExtent, maxScroll)) < 0.0f) {
            return;
        }
        this.resizeGradually(maxScroll, newScroll);
        this.applyThumbColor(alpha);
        float sweepAngle = this.computeSweepAngle(scrollExtent, maxScroll -= this.mMaxScrollDiff);
        float startAngle = this.computeStartAngle(Math.max(0.0f, newScroll -= this.mCurrentScrollDiff), sweepAngle, maxScroll, scrollExtent);
        this.updateBounds(bounds);
        this.mDrawToLeft = drawToLeft;
        this.drawRoundScrollbars(canvas, startAngle, sweepAngle, alpha);
    }

    private void drawRoundScrollbars(Canvas canvas, float startAngle, float sweepAngle, float alpha) {
        if (this.mUseRefactoredRoundScrollbar) {
            this.draw(canvas, startAngle, sweepAngle, alpha);
        } else {
            this.applyTrackColor(alpha);
            this.drawArc(canvas, -14.4f, 28.8f, this.mTrackPaint);
            this.drawArc(canvas, startAngle, sweepAngle, this.mThumbPaint);
        }
    }

    private void updateBounds(Rect bounds) {
        this.mRect.set((float)bounds.left + this.mInset, (float)bounds.top + this.mInset, (float)bounds.right - this.mInset, (float)bounds.bottom - this.mInset);
        this.mThumbStrokeWidthAsDegrees = RoundScrollbarRenderer.getVertexAngle((this.mRect.right - this.mRect.left) / 2.0f, this.mThumbPaint.getStrokeWidth() / 2.0f);
        this.mGapBetweenTrackAndThumbAsDegrees = RoundScrollbarRenderer.getVertexAngle((this.mRect.right - this.mRect.left) / 2.0f, this.mGapBetweenThumbAndTrackPx);
    }

    private float computeSweepAngle(float scrollExtent, float maxScroll) {
        float sweepAngle = scrollExtent / maxScroll * 28.8f;
        return RoundScrollbarRenderer.clamp(sweepAngle, 8.64f, 20.16f);
    }

    private float computeStartAngle(float currentScroll, float sweepAngle, float maxScroll, float scrollExtent) {
        float startAngle = currentScroll * (28.8f - sweepAngle) / (maxScroll - scrollExtent) - 14.4f;
        return RoundScrollbarRenderer.clamp(startAngle, -14.4f, 14.4f - sweepAngle);
    }

    void getRoundVerticalScrollBarBounds(Rect bounds) {
        float padding = this.dpToPx(2.0f);
        int width = this.mParent.mRight - this.mParent.mLeft;
        int height = this.mParent.mBottom - this.mParent.mTop;
        bounds.left = this.mParent.mScrollX + (int)padding;
        bounds.top = this.mParent.mScrollY + (int)padding;
        bounds.right = this.mParent.mScrollX + width - (int)padding;
        bounds.bottom = this.mParent.mScrollY + height - (int)padding;
    }

    private static float clamp(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        return Math.min(val, max);
    }

    private static int applyAlpha(int color2, float alpha) {
        int alphaByte = (int)((float)Color.alpha(color2) * alpha);
        return Color.argb(alphaByte, Color.red(color2), Color.green(color2), Color.blue(color2));
    }

    private void applyThumbColor(float alpha) {
        int color2 = RoundScrollbarRenderer.applyAlpha(-3750201, alpha);
        if (this.mThumbPaint.getColor() != color2) {
            this.mThumbPaint.setColor(color2);
        }
    }

    private void applyTrackColor(float alpha) {
        int color2 = RoundScrollbarRenderer.applyAlpha(-13684431, alpha);
        if (this.mTrackPaint.getColor() != color2) {
            this.mTrackPaint.setColor(color2);
        }
    }

    private float dpToPx(float dp) {
        return dp * (float)this.mParent.getContext().getResources().getDisplayMetrics().densityDpi / 160.0f;
    }

    private static float getVertexAngle(float edge, float base) {
        float edgeSquare = edge * edge * 2.0f;
        float baseSquare = base * base;
        float gapInRadians = MathUtils.acos((edgeSquare - baseSquare) / edgeSquare);
        return (float)Math.toDegrees(gapInRadians);
    }

    private static float getKiteEdge(float knownEdge, float angleBetweenKnownEdgesInDegrees) {
        return (float)((double)(2.0f * knownEdge) * Math.sin(Math.toRadians(angleBetweenKnownEdgesInDegrees / 2.0f)));
    }

    private void draw(Canvas canvas, float thumbStartAngle, float thumbSweepAngle, float alpha) {
        this.drawTrack(canvas, -14.4f - this.mThumbStrokeWidthAsDegrees, thumbStartAngle - this.mThumbStrokeWidthAsDegrees - this.mGapBetweenTrackAndThumbAsDegrees, alpha);
        this.drawArc(canvas, thumbStartAngle, thumbSweepAngle, this.mThumbPaint);
        this.drawTrack(canvas, thumbStartAngle + thumbSweepAngle + this.mThumbStrokeWidthAsDegrees + this.mGapBetweenTrackAndThumbAsDegrees, 14.4f + this.mThumbStrokeWidthAsDegrees, alpha);
    }

    private void drawTrack(Canvas canvas, float beginAngle, float endAngle, float alpha) {
        float angleBetweenEndAndBegin = endAngle - beginAngle;
        float sweepAngle = angleBetweenEndAndBegin - 2.0f * this.mThumbStrokeWidthAsDegrees;
        float startAngle = -1.0f;
        float strokeWidth = -1.0f;
        if (sweepAngle > 0.0f) {
            startAngle = beginAngle + this.mThumbStrokeWidthAsDegrees;
            strokeWidth = this.mThumbPaint.getStrokeWidth();
        } else if (Math.abs(sweepAngle) < 2.0f * this.mThumbStrokeWidthAsDegrees) {
            startAngle = beginAngle + angleBetweenEndAndBegin / 2.0f;
            strokeWidth = RoundScrollbarRenderer.getKiteEdge((this.mRect.right - this.mRect.left) / 2.0f, angleBetweenEndAndBegin);
            alpha *= Math.min(1.0f, 2.0f * strokeWidth / this.mThumbPaint.getStrokeWidth());
            sweepAngle = Float.MIN_NORMAL;
        } else {
            return;
        }
        this.applyTrackColor(alpha);
        this.mTrackPaint.setStrokeWidth(strokeWidth);
        this.drawArc(canvas, startAngle, sweepAngle, this.mTrackPaint);
    }

    private void drawArc(Canvas canvas, float startAngle, float sweepAngle, Paint paint) {
        if (this.mDrawToLeft) {
            canvas.drawArc(this.mRect, 180.0f - startAngle, -sweepAngle, false, paint);
        } else {
            canvas.drawArc(this.mRect, startAngle, sweepAngle, false, paint);
        }
    }
}

