/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.SparseArray;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureSession;
import android.view.contentcapture.ViewNode;
import java.util.ArrayList;

class ChildContentCaptureSession
extends ContentCaptureSession {
    @NonNull
    private final ContentCaptureSession mParent;

    protected ChildContentCaptureSession(@NonNull ContentCaptureSession parent, @NonNull ContentCaptureContext clientContext) {
        super(clientContext);
        this.mParent = parent;
    }

    @Override
    ContentCaptureSession getMainCaptureSession() {
        return this.mParent.getMainCaptureSession();
    }

    @Override
    void start(@NonNull IBinder token, @NonNull IBinder shareableActivityToken, @NonNull ComponentName component, int flags) {
        this.getMainCaptureSession().start(token, shareableActivityToken, component, flags);
    }

    @Override
    boolean isDisabled() {
        return this.getMainCaptureSession().isDisabled();
    }

    @Override
    boolean setDisabled(boolean disabled) {
        return this.getMainCaptureSession().setDisabled(disabled);
    }

    @Override
    ContentCaptureSession newChild(@NonNull ContentCaptureContext clientContext) {
        ChildContentCaptureSession child = new ChildContentCaptureSession(this, clientContext);
        this.internalNotifyChildSessionStarted(this.mId, child.mId, clientContext);
        return child;
    }

    @Override
    void flush(int reason) {
        this.mParent.flush(reason);
    }

    @Override
    public void updateContentCaptureContext(@Nullable ContentCaptureContext context) {
        this.internalNotifyContextUpdated(this.mId, context);
    }

    @Override
    void onDestroy() {
        this.internalNotifyChildSessionFinished(this.mParent.mId, this.mId);
    }

    @Override
    void internalNotifyChildSessionStarted(int parentSessionId, int childSessionId, @NonNull ContentCaptureContext clientContext) {
        this.getMainCaptureSession().internalNotifyChildSessionStarted(parentSessionId, childSessionId, clientContext);
    }

    @Override
    void internalNotifyChildSessionFinished(int parentSessionId, int childSessionId) {
        this.getMainCaptureSession().internalNotifyChildSessionFinished(parentSessionId, childSessionId);
    }

    @Override
    void internalNotifyContextUpdated(int sessionId, @Nullable ContentCaptureContext context) {
        this.getMainCaptureSession().internalNotifyContextUpdated(sessionId, context);
    }

    @Override
    void internalNotifyViewAppeared(int sessionId, @NonNull ViewNode.ViewStructureImpl node) {
        this.getMainCaptureSession().internalNotifyViewAppeared(sessionId, node);
    }

    @Override
    void internalNotifyViewDisappeared(int sessionId, @NonNull AutofillId id2) {
        this.getMainCaptureSession().internalNotifyViewDisappeared(sessionId, id2);
    }

    @Override
    void internalNotifyViewTextChanged(int sessionId, @NonNull AutofillId id2, @Nullable CharSequence text) {
        this.getMainCaptureSession().internalNotifyViewTextChanged(sessionId, id2, text);
    }

    @Override
    void internalNotifyViewInsetsChanged(int sessionId, @NonNull Insets viewInsets) {
        this.getMainCaptureSession().internalNotifyViewInsetsChanged(this.mId, viewInsets);
    }

    @Override
    public void internalNotifyViewTreeEvent(int sessionId, boolean started) {
        this.getMainCaptureSession().internalNotifyViewTreeEvent(sessionId, started);
    }

    @Override
    void internalNotifySessionResumed() {
        this.getMainCaptureSession().internalNotifySessionResumed();
    }

    @Override
    void internalNotifySessionPaused() {
        this.getMainCaptureSession().internalNotifySessionPaused();
    }

    @Override
    void internalNotifySessionFlushEvent(int sessionId) {
        this.getMainCaptureSession().internalNotifySessionFlushEvent(sessionId);
    }

    @Override
    boolean isContentCaptureEnabled() {
        return this.getMainCaptureSession().isContentCaptureEnabled();
    }

    @Override
    public void notifyWindowBoundsChanged(int sessionId, @NonNull Rect bounds) {
        this.getMainCaptureSession().notifyWindowBoundsChanged(sessionId, bounds);
    }

    @Override
    public void notifyContentCaptureEvents(@NonNull SparseArray<ArrayList<Object>> contentCaptureEvents) {
        this.getMainCaptureSession().notifyContentCaptureEvents(contentCaptureEvents);
    }
}

