/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.ParcelableHandwritingGesture;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class HandwritingGesture {
    static final int GRANULARITY_UNDEFINED = 0;
    public static final int GRANULARITY_WORD = 1;
    public static final int GRANULARITY_CHARACTER = 2;
    public static final int GESTURE_TYPE_NONE = 0;
    public static final int GESTURE_TYPE_SELECT = 1;
    public static final int GESTURE_TYPE_INSERT = 2;
    public static final int GESTURE_TYPE_DELETE = 4;
    public static final int GESTURE_TYPE_REMOVE_SPACE = 8;
    public static final int GESTURE_TYPE_JOIN_OR_SPLIT = 16;
    public static final int GESTURE_TYPE_SELECT_RANGE = 32;
    public static final int GESTURE_TYPE_DELETE_RANGE = 64;
    public static final int GESTURE_TYPE_INSERT_MODE = 128;
    int mType = 0;
    @Nullable
    String mFallbackText;

    HandwritingGesture() {
    }

    public int getGestureType() {
        return this.mType;
    }

    @Nullable
    public String getFallbackText() {
        return this.mFallbackText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public byte[] toByteArray() {
        if (!(this instanceof Parcelable)) {
            throw new UnsupportedOperationException(this.getClass() + " is not Parcelable");
        }
        Parcelable self = (Parcelable)((Object)this);
        if ((self.describeContents() & 1) != 0) {
            throw new UnsupportedOperationException("Gesture that contains FD is not supported");
        }
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            ParcelableHandwritingGesture.of(this).writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
    }

    @NonNull
    public static HandwritingGesture fromByteArray(@NonNull byte[] buffer) {
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.unmarshall(buffer, 0, buffer.length);
            parcel.setDataPosition(0);
            HandwritingGesture handwritingGesture = ParcelableHandwritingGesture.CREATOR.createFromParcel(parcel).get();
            return handwritingGesture;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GestureTypeFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface GestureType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Granularity {
    }
}

