/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.InputChannel;
import android.view.MotionEvent;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodSession;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.inputmethod.IConnectionlessHandwritingCallback;
import com.android.internal.inputmethod.IInlineSuggestionsRequestCallback;
import com.android.internal.inputmethod.IInputMethod;
import com.android.internal.inputmethod.InlineSuggestionsRequestInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface InputMethod {
    public static final String TAG = "InputMethod";
    public static final String SERVICE_INTERFACE = "android.view.InputMethod";
    public static final String SERVICE_META_DATA = "android.view.im";
    public static final int SHOW_EXPLICIT = 1;
    @Deprecated
    public static final int SHOW_FORCED = 2;

    default public void initializeInternal(@NonNull IInputMethod.InitParams params) {
        this.attachToken(params.token);
    }

    default public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) {
        try {
            cb.onInlineSuggestionsUnsupported();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to call onInlineSuggestionsUnsupported.", e);
        }
    }

    public void attachToken(IBinder var1);

    public void bindInput(InputBinding var1);

    public void unbindInput();

    public void startInput(InputConnection var1, EditorInfo var2);

    public void restartInput(InputConnection var1, EditorInfo var2);

    default public void dispatchStartInput(@Nullable InputConnection inputConnection, @NonNull IInputMethod.StartInputParams params) {
        if (params.restarting) {
            this.restartInput(inputConnection, params.editorInfo);
        } else {
            this.startInput(inputConnection, params.editorInfo);
        }
    }

    default public void onNavButtonFlagsChanged(int navButtonFlags) {
    }

    public void createSession(SessionCallback var1);

    public void setSessionEnabled(InputMethodSession var1, boolean var2);

    public void revokeSession(InputMethodSession var1);

    default public void showSoftInputWithToken(int flags, ResultReceiver resultReceiver, IBinder showInputToken, @NonNull ImeTracker.Token statsToken) {
        this.showSoftInput(flags, resultReceiver);
    }

    public void showSoftInput(int var1, ResultReceiver var2);

    default public void hideSoftInputWithToken(int flags, ResultReceiver resultReceiver, IBinder hideInputToken, @NonNull ImeTracker.Token statsToken) {
        this.hideSoftInput(flags, resultReceiver);
    }

    public void hideSoftInput(int var1, ResultReceiver var2);

    public void changeInputMethodSubtype(InputMethodSubtype var1);

    default public void canStartStylusHandwriting(int requestId, @Nullable IConnectionlessHandwritingCallback connectionlessCallback, @Nullable CursorAnchorInfo cursorAnchorInfo, boolean isConnectionlessForDelegation) {
    }

    default public void updateEditorToolType(int toolType) {
    }

    default public void startStylusHandwriting(int requestId, @NonNull InputChannel channel, @Nullable List<MotionEvent> events) {
    }

    default public void commitHandwritingDelegationTextIfAvailable() {
    }

    default public void discardHandwritingDelegationText() {
    }

    default public void initInkWindow() {
    }

    default public void finishStylusHandwriting() {
    }

    default public void removeStylusHandwritingWindow() {
    }

    default public void setStylusWindowIdleTimeoutForTest(long timeout) {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowFlags {
    }

    public static interface SessionCallback {
        public void sessionCreated(InputMethodSession var1);
    }
}

