/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class EntityConfidence
implements Parcelable {
    private final ArrayMap<String, Float> mEntityConfidence = new ArrayMap();
    private final ArrayList<String> mSortedEntities = new ArrayList();
    @NonNull
    public static final Parcelable.Creator<EntityConfidence> CREATOR = new Parcelable.Creator<EntityConfidence>(){

        @Override
        public EntityConfidence createFromParcel(Parcel in) {
            return new EntityConfidence(in);
        }

        public EntityConfidence[] newArray(int size) {
            return new EntityConfidence[size];
        }
    };

    EntityConfidence() {
    }

    EntityConfidence(@NonNull EntityConfidence source) {
        Objects.requireNonNull(source);
        this.mEntityConfidence.putAll(source.mEntityConfidence);
        this.mSortedEntities.addAll(source.mSortedEntities);
    }

    EntityConfidence(@NonNull Map<String, Float> source) {
        Objects.requireNonNull(source);
        this.mEntityConfidence.ensureCapacity(source.size());
        for (Map.Entry<String, Float> it : source.entrySet()) {
            if (it.getValue().floatValue() <= 0.0f) continue;
            this.mEntityConfidence.put(it.getKey(), Float.valueOf(Math.min(1.0f, it.getValue().floatValue())));
        }
        this.resetSortedEntitiesFromMap();
    }

    @NonNull
    public List<String> getEntities() {
        return Collections.unmodifiableList(this.mSortedEntities);
    }

    public float getConfidenceScore(String entity) {
        if (this.mEntityConfidence.containsKey(entity)) {
            return this.mEntityConfidence.get(entity).floatValue();
        }
        return 0.0f;
    }

    public Map<String, Float> toMap() {
        return new ArrayMap<String, Float>(this.mEntityConfidence);
    }

    public String toString() {
        return this.mEntityConfidence.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mEntityConfidence.size());
        for (Map.Entry<String, Float> entry : this.mEntityConfidence.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeFloat(entry.getValue().floatValue());
        }
    }

    private EntityConfidence(Parcel in) {
        int numEntities = in.readInt();
        this.mEntityConfidence.ensureCapacity(numEntities);
        for (int i = 0; i < numEntities; ++i) {
            this.mEntityConfidence.put(in.readString(), Float.valueOf(in.readFloat()));
        }
        this.resetSortedEntitiesFromMap();
    }

    private void resetSortedEntitiesFromMap() {
        this.mSortedEntities.clear();
        this.mSortedEntities.ensureCapacity(this.mEntityConfidence.size());
        this.mSortedEntities.addAll(this.mEntityConfidence.keySet());
        this.mSortedEntities.sort((e1, e2) -> {
            float score1 = this.mEntityConfidence.get(e1).floatValue();
            float score2 = this.mEntityConfidence.get(e2).floatValue();
            return Float.compare(score2, score1);
        });
    }
}

