/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.SystemTextClassifierMetadata;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinksParams;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TextLinks
implements Parcelable {
    public static final int STATUS_LINKS_APPLIED = 0;
    public static final int STATUS_NO_LINKS_FOUND = 1;
    public static final int STATUS_NO_LINKS_APPLIED = 2;
    public static final int STATUS_DIFFERENT_TEXT = 3;
    public static final int STATUS_UNSUPPORTED_CHARACTER = 4;
    public static final int APPLY_STRATEGY_IGNORE = 0;
    public static final int APPLY_STRATEGY_REPLACE = 1;
    private final String mFullText;
    private final List<TextLink> mLinks;
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<TextLinks> CREATOR = new Parcelable.Creator<TextLinks>(){

        @Override
        public TextLinks createFromParcel(Parcel in) {
            return new TextLinks(in);
        }

        public TextLinks[] newArray(int size) {
            return new TextLinks[size];
        }
    };

    private TextLinks(String fullText, ArrayList<TextLink> links, Bundle extras) {
        this.mFullText = fullText;
        this.mLinks = Collections.unmodifiableList(links);
        this.mExtras = extras;
    }

    @NonNull
    public CharSequence getText() {
        return this.mFullText;
    }

    @NonNull
    public Collection<TextLink> getLinks() {
        return this.mLinks;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public int apply(@NonNull Spannable text, int applyStrategy, @Nullable Function<TextLink, TextLinkSpan> spanFactory) {
        Objects.requireNonNull(text);
        return new TextLinksParams.Builder().setApplyStrategy(applyStrategy).setSpanFactory(spanFactory).build().apply(text, this);
    }

    public String toString() {
        return String.format(Locale.US, "TextLinks{fullText=%s, links=%s}", this.mFullText, this.mLinks);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mFullText);
        dest.writeTypedList(this.mLinks);
        dest.writeBundle(this.mExtras);
    }

    private TextLinks(Parcel in) {
        this.mFullText = in.readString();
        this.mLinks = in.createTypedArrayList(TextLink.CREATOR);
        this.mExtras = in.readBundle();
    }

    public static class TextLink
    implements Parcelable {
        private final EntityConfidence mEntityScores;
        private final int mStart;
        private final int mEnd;
        private final Bundle mExtras;
        @Nullable
        private final URLSpan mUrlSpan;
        @NonNull
        public static final Parcelable.Creator<TextLink> CREATOR = new Parcelable.Creator<TextLink>(){

            @Override
            public TextLink createFromParcel(Parcel in) {
                return TextLink.readFromParcel(in);
            }

            public TextLink[] newArray(int size) {
                return new TextLink[size];
            }
        };

        private TextLink(int start, int end, @NonNull EntityConfidence entityConfidence, @NonNull Bundle extras, @Nullable URLSpan urlSpan) {
            Objects.requireNonNull(entityConfidence);
            Preconditions.checkArgument(!entityConfidence.getEntities().isEmpty());
            Preconditions.checkArgument(start <= end);
            Objects.requireNonNull(extras);
            this.mStart = start;
            this.mEnd = end;
            this.mEntityScores = entityConfidence;
            this.mUrlSpan = urlSpan;
            this.mExtras = extras;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getEntityCount() {
            return this.mEntityScores.getEntities().size();
        }

        @NonNull
        public String getEntity(int index) {
            return this.mEntityScores.getEntities().get(index);
        }

        public float getConfidenceScore(String entityType) {
            return this.mEntityScores.getConfidenceScore(entityType);
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        public String toString() {
            return String.format(Locale.US, "TextLink{start=%s, end=%s, entityScores=%s, urlSpan=%s}", this.mStart, this.mEnd, this.mEntityScores, this.mUrlSpan);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mEntityScores.writeToParcel(dest, flags);
            dest.writeInt(this.mStart);
            dest.writeInt(this.mEnd);
            dest.writeBundle(this.mExtras);
        }

        private static TextLink readFromParcel(Parcel in) {
            EntityConfidence entityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
            int start = in.readInt();
            int end = in.readInt();
            Bundle extras = in.readBundle();
            return new TextLink(start, end, entityConfidence, extras, null);
        }
    }

    public static class Builder {
        private final String mFullText;
        private final ArrayList<TextLink> mLinks;
        private Bundle mExtras;

        public Builder(@NonNull String fullText) {
            this.mFullText = Objects.requireNonNull(fullText);
            this.mLinks = new ArrayList();
        }

        @NonNull
        public Builder addLink(int start, int end, @NonNull Map<String, Float> entityScores) {
            return this.addLink(start, end, entityScores, Bundle.EMPTY, null);
        }

        @NonNull
        public Builder addLink(int start, int end, @NonNull Map<String, Float> entityScores, @NonNull Bundle extras) {
            return this.addLink(start, end, entityScores, extras, null);
        }

        @NonNull
        Builder addLink(int start, int end, @NonNull Map<String, Float> entityScores, @Nullable URLSpan urlSpan) {
            return this.addLink(start, end, entityScores, Bundle.EMPTY, urlSpan);
        }

        private Builder addLink(int start, int end, @NonNull Map<String, Float> entityScores, @NonNull Bundle extras, @Nullable URLSpan urlSpan) {
            this.mLinks.add(new TextLink(start, end, new EntityConfidence(entityScores), extras, urlSpan));
            return this;
        }

        @NonNull
        public Builder clearTextLinks() {
            this.mLinks.clear();
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public TextLinks build() {
            return new TextLinks(this.mFullText, this.mLinks, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
        }
    }

    public static class TextLinkSpan
    extends ClickableSpan {
        public static final int INVOCATION_METHOD_UNSPECIFIED = -1;
        public static final int INVOCATION_METHOD_TOUCH = 0;
        public static final int INVOCATION_METHOD_KEYBOARD = 1;
        private final TextLink mTextLink;

        public TextLinkSpan(@NonNull TextLink textLink) {
            this.mTextLink = textLink;
        }

        @Override
        public void onClick(View widget) {
            this.onClick(widget, -1);
        }

        public void onClick(View widget, int invocationMethod) {
            if (widget instanceof TextView) {
                TextView textView = (TextView)widget;
                Context context = textView.getContext();
                if (TextClassificationManager.getSettings(context).isSmartLinkifyEnabled()) {
                    switch (invocationMethod) {
                        case 0: {
                            textView.requestActionMode(this);
                            break;
                        }
                        default: {
                            textView.handleClick(this);
                            break;
                        }
                    }
                } else if (this.mTextLink.mUrlSpan != null) {
                    this.mTextLink.mUrlSpan.onClick(textView);
                } else {
                    textView.handleClick(this);
                }
            }
        }

        public TextLink getTextLink() {
            return this.mTextLink;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
        @Nullable
        public String getUrl() {
            if (this.mTextLink.mUrlSpan != null) {
                return this.mTextLink.mUrlSpan.getURL();
            }
            return null;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InvocationMethod {
        }
    }

    public static class Request
    implements Parcelable {
        private final CharSequence mText;
        @Nullable
        private final LocaleList mDefaultLocales;
        @Nullable
        private final TextClassifier.EntityConfig mEntityConfig;
        private final boolean mLegacyFallback;
        private final Bundle mExtras;
        @Nullable
        private final ZonedDateTime mReferenceTime;
        @Nullable
        private SystemTextClassifierMetadata mSystemTcMetadata;
        @NonNull
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return Request.readFromParcel(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(CharSequence text, LocaleList defaultLocales, TextClassifier.EntityConfig entityConfig, boolean legacyFallback, ZonedDateTime referenceTime, Bundle extras) {
            this.mText = text;
            this.mDefaultLocales = defaultLocales;
            this.mEntityConfig = entityConfig;
            this.mLegacyFallback = legacyFallback;
            this.mReferenceTime = referenceTime;
            this.mExtras = extras;
        }

        @NonNull
        public CharSequence getText() {
            return this.mText;
        }

        @Nullable
        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        @Nullable
        public TextClassifier.EntityConfig getEntityConfig() {
            return this.mEntityConfig;
        }

        public boolean isLegacyFallback() {
            return this.mLegacyFallback;
        }

        @Nullable
        public ZonedDateTime getReferenceTime() {
            return this.mReferenceTime;
        }

        @Nullable
        public String getCallingPackageName() {
            return this.mSystemTcMetadata != null ? this.mSystemTcMetadata.getCallingPackageName() : null;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void setSystemTextClassifierMetadata(@Nullable SystemTextClassifierMetadata systemTcMetadata) {
            this.mSystemTcMetadata = systemTcMetadata;
        }

        @Nullable
        public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
            return this.mSystemTcMetadata;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mText.toString());
            dest.writeParcelable(this.mDefaultLocales, flags);
            dest.writeParcelable(this.mEntityConfig, flags);
            dest.writeBundle(this.mExtras);
            dest.writeString(this.mReferenceTime == null ? null : this.mReferenceTime.toString());
            dest.writeParcelable(this.mSystemTcMetadata, flags);
        }

        private static Request readFromParcel(Parcel in) {
            String text = in.readString();
            LocaleList defaultLocales = in.readParcelable(null, LocaleList.class);
            TextClassifier.EntityConfig entityConfig = in.readParcelable(null, TextClassifier.EntityConfig.class);
            Bundle extras = in.readBundle();
            String referenceTimeString = in.readString();
            ZonedDateTime referenceTime = referenceTimeString == null ? null : ZonedDateTime.parse(referenceTimeString);
            SystemTextClassifierMetadata systemTcMetadata = in.readParcelable(null, SystemTextClassifierMetadata.class);
            Request request = new Request(text, defaultLocales, entityConfig, true, referenceTime, extras);
            request.setSystemTextClassifierMetadata(systemTcMetadata);
            return request;
        }

        public static class Builder {
            private final CharSequence mText;
            @Nullable
            private LocaleList mDefaultLocales;
            @Nullable
            private TextClassifier.EntityConfig mEntityConfig;
            private boolean mLegacyFallback = true;
            @Nullable
            private Bundle mExtras;
            @Nullable
            private ZonedDateTime mReferenceTime;

            public Builder(@NonNull CharSequence text) {
                this.mText = Objects.requireNonNull(text);
            }

            @NonNull
            public Builder setDefaultLocales(@Nullable LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            @NonNull
            public Builder setEntityConfig(@Nullable TextClassifier.EntityConfig entityConfig) {
                this.mEntityConfig = entityConfig;
                return this;
            }

            @NonNull
            public Builder setLegacyFallback(boolean legacyFallback) {
                this.mLegacyFallback = legacyFallback;
                return this;
            }

            public Builder setExtras(@Nullable Bundle extras) {
                this.mExtras = extras;
                return this;
            }

            @NonNull
            public Builder setReferenceTime(@Nullable ZonedDateTime referenceTime) {
                this.mReferenceTime = referenceTime;
                return this;
            }

            @NonNull
            public Request build() {
                return new Request(this.mText, this.mDefaultLocales, this.mEntityConfig, this.mLegacyFallback, this.mReferenceTime, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplyStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

