/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.webkit.WebViewFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public abstract class WebSettings {
    @SystemApi
    public static final long ENABLE_SIMPLIFIED_DARK_MODE = 214741472L;
    @SystemApi
    @FlaggedApi(value="android.webkit.user_agent_reduction")
    public static final long ENABLE_USER_AGENT_REDUCTION = 371034303L;
    public static final int LOAD_DEFAULT = -1;
    @Deprecated
    public static final int LOAD_NORMAL = 0;
    public static final int LOAD_CACHE_ELSE_NETWORK = 1;
    public static final int LOAD_NO_CACHE = 2;
    public static final int LOAD_CACHE_ONLY = 3;
    public static final int MIXED_CONTENT_ALWAYS_ALLOW = 0;
    public static final int MIXED_CONTENT_NEVER_ALLOW = 1;
    public static final int MIXED_CONTENT_COMPATIBILITY_MODE = 2;
    public static final int FORCE_DARK_OFF = 0;
    public static final int FORCE_DARK_AUTO = 1;
    public static final int FORCE_DARK_ON = 2;
    public static final int MENU_ITEM_NONE = 0;
    public static final int MENU_ITEM_SHARE = 1;
    public static final int MENU_ITEM_WEB_SEARCH = 2;
    public static final int MENU_ITEM_PROCESS_TEXT = 4;

    @SystemApi
    @Deprecated
    public abstract void setNavDump(boolean var1);

    @SystemApi
    @Deprecated
    public abstract boolean getNavDump();

    public abstract void setSupportZoom(boolean var1);

    public abstract boolean supportZoom();

    public abstract void setMediaPlaybackRequiresUserGesture(boolean var1);

    public abstract boolean getMediaPlaybackRequiresUserGesture();

    public abstract void setBuiltInZoomControls(boolean var1);

    public abstract boolean getBuiltInZoomControls();

    public abstract void setDisplayZoomControls(boolean var1);

    public abstract boolean getDisplayZoomControls();

    public abstract void setAllowFileAccess(boolean var1);

    public abstract boolean getAllowFileAccess();

    public abstract void setAllowContentAccess(boolean var1);

    public abstract boolean getAllowContentAccess();

    public abstract void setLoadWithOverviewMode(boolean var1);

    public abstract boolean getLoadWithOverviewMode();

    @Deprecated
    public abstract void setEnableSmoothTransition(boolean var1);

    @Deprecated
    public abstract boolean enableSmoothTransition();

    @SystemApi
    @Deprecated
    public abstract void setUseWebViewBackgroundForOverscrollBackground(boolean var1);

    @SystemApi
    @Deprecated
    public abstract boolean getUseWebViewBackgroundForOverscrollBackground();

    @Deprecated
    public abstract void setSaveFormData(boolean var1);

    @Deprecated
    public abstract boolean getSaveFormData();

    @Deprecated
    public abstract void setSavePassword(boolean var1);

    @Deprecated
    public abstract boolean getSavePassword();

    public abstract void setTextZoom(int var1);

    public abstract int getTextZoom();

    @SystemApi
    public abstract void setAcceptThirdPartyCookies(boolean var1);

    @SystemApi
    public abstract boolean getAcceptThirdPartyCookies();

    @Deprecated
    public synchronized void setTextSize(TextSize t) {
        this.setTextZoom(t.value);
    }

    @Deprecated
    public synchronized TextSize getTextSize() {
        TextSize closestSize = null;
        int smallestDelta = Integer.MAX_VALUE;
        int textSize = this.getTextZoom();
        for (TextSize size : TextSize.values()) {
            int delta = Math.abs(textSize - size.value);
            if (delta == 0) {
                return size;
            }
            if (delta >= smallestDelta) continue;
            smallestDelta = delta;
            closestSize = size;
        }
        return closestSize != null ? closestSize : TextSize.NORMAL;
    }

    @Deprecated
    public abstract void setDefaultZoom(ZoomDensity var1);

    @Deprecated
    public abstract ZoomDensity getDefaultZoom();

    @Deprecated
    public abstract void setLightTouchEnabled(boolean var1);

    @Deprecated
    public abstract boolean getLightTouchEnabled();

    @Deprecated
    @UnsupportedAppUsage
    public void setUseDoubleTree(boolean use) {
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean getUseDoubleTree() {
        return false;
    }

    @SystemApi
    @Deprecated
    public abstract void setUserAgent(int var1);

    @SystemApi
    @Deprecated
    public abstract int getUserAgent();

    public abstract void setUseWideViewPort(boolean var1);

    public abstract boolean getUseWideViewPort();

    public abstract void setSupportMultipleWindows(boolean var1);

    public abstract boolean supportMultipleWindows();

    public abstract void setLayoutAlgorithm(LayoutAlgorithm var1);

    public abstract LayoutAlgorithm getLayoutAlgorithm();

    public abstract void setStandardFontFamily(String var1);

    public abstract String getStandardFontFamily();

    public abstract void setFixedFontFamily(String var1);

    public abstract String getFixedFontFamily();

    public abstract void setSansSerifFontFamily(String var1);

    public abstract String getSansSerifFontFamily();

    public abstract void setSerifFontFamily(String var1);

    public abstract String getSerifFontFamily();

    public abstract void setCursiveFontFamily(String var1);

    public abstract String getCursiveFontFamily();

    public abstract void setFantasyFontFamily(String var1);

    public abstract String getFantasyFontFamily();

    public abstract void setMinimumFontSize(int var1);

    public abstract int getMinimumFontSize();

    public abstract void setMinimumLogicalFontSize(int var1);

    public abstract int getMinimumLogicalFontSize();

    public abstract void setDefaultFontSize(int var1);

    public abstract int getDefaultFontSize();

    public abstract void setDefaultFixedFontSize(int var1);

    public abstract int getDefaultFixedFontSize();

    public abstract void setLoadsImagesAutomatically(boolean var1);

    public abstract boolean getLoadsImagesAutomatically();

    public abstract void setBlockNetworkImage(boolean var1);

    public abstract boolean getBlockNetworkImage();

    public abstract void setBlockNetworkLoads(boolean var1);

    public abstract boolean getBlockNetworkLoads();

    public abstract void setJavaScriptEnabled(boolean var1);

    @Deprecated
    public abstract void setAllowUniversalAccessFromFileURLs(boolean var1);

    @Deprecated
    public abstract void setAllowFileAccessFromFileURLs(boolean var1);

    @SystemApi
    @Deprecated
    public abstract void setPluginsEnabled(boolean var1);

    @Deprecated
    public abstract void setPluginState(PluginState var1);

    @Deprecated
    @UnsupportedAppUsage
    public void setPluginsPath(String pluginsPath) {
    }

    @Deprecated
    public abstract void setDatabasePath(String var1);

    @Deprecated
    public abstract void setGeolocationDatabasePath(String var1);

    @Deprecated
    public void setAppCacheEnabled(boolean flag) {
    }

    @Deprecated
    public void setAppCachePath(String appCachePath) {
    }

    @Deprecated
    public void setAppCacheMaxSize(long appCacheMaxSize) {
    }

    @Deprecated
    public abstract void setDatabaseEnabled(boolean var1);

    public abstract void setDomStorageEnabled(boolean var1);

    public abstract boolean getDomStorageEnabled();

    @Deprecated
    public abstract String getDatabasePath();

    @Deprecated
    public abstract boolean getDatabaseEnabled();

    public abstract void setGeolocationEnabled(boolean var1);

    public abstract boolean getJavaScriptEnabled();

    public abstract boolean getAllowUniversalAccessFromFileURLs();

    public abstract boolean getAllowFileAccessFromFileURLs();

    @SystemApi
    @Deprecated
    public abstract boolean getPluginsEnabled();

    @Deprecated
    public abstract PluginState getPluginState();

    @Deprecated
    @UnsupportedAppUsage
    public String getPluginsPath() {
        return "";
    }

    public abstract void setJavaScriptCanOpenWindowsAutomatically(boolean var1);

    public abstract boolean getJavaScriptCanOpenWindowsAutomatically();

    public abstract void setDefaultTextEncodingName(String var1);

    public abstract String getDefaultTextEncodingName();

    public abstract void setUserAgentString(@Nullable String var1);

    public abstract String getUserAgentString();

    public static String getDefaultUserAgent(Context context) {
        return WebViewFactory.getProvider().getStatics().getDefaultUserAgent(context);
    }

    public abstract void setNeedInitialFocus(boolean var1);

    @Deprecated
    public abstract void setRenderPriority(RenderPriority var1);

    public abstract void setCacheMode(int var1);

    public abstract int getCacheMode();

    public abstract void setMixedContentMode(int var1);

    public abstract int getMixedContentMode();

    @SystemApi
    public abstract void setVideoOverlayForEmbeddedEncryptedVideoEnabled(boolean var1);

    @SystemApi
    public abstract boolean getVideoOverlayForEmbeddedEncryptedVideoEnabled();

    public abstract void setOffscreenPreRaster(boolean var1);

    public abstract boolean getOffscreenPreRaster();

    public abstract void setSafeBrowsingEnabled(boolean var1);

    public abstract boolean getSafeBrowsingEnabled();

    public void setForceDark(int forceDark) {
    }

    public int getForceDark() {
        return 1;
    }

    public void setAlgorithmicDarkeningAllowed(boolean allow) {
    }

    public boolean isAlgorithmicDarkeningAllowed() {
        return false;
    }

    public abstract void setDisabledActionModeMenuItems(int var1);

    public abstract int getDisabledActionModeMenuItems();

    @Deprecated
    public static enum TextSize {
        SMALLEST(50),
        SMALLER(75),
        NORMAL(100),
        LARGER(150),
        LARGEST(200);

        @UnsupportedAppUsage
        int value;

        private TextSize(int size) {
            this.value = size;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    private static @interface MenuItemFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ForceDark {
    }

    public static enum PluginState {
        ON,
        ON_DEMAND,
        OFF;

    }

    public static enum RenderPriority {
        NORMAL,
        HIGH,
        LOW;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CacheMode {
    }

    public static enum ZoomDensity {
        FAR(150),
        MEDIUM(100),
        CLOSE(75);

        int value;

        private ZoomDensity(int size) {
            this.value = size;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LayoutAlgorithm {
        NORMAL,
        SINGLE_COLUMN,
        NARROW_COLUMNS,
        TEXT_AUTOSIZING;

    }
}

