/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.FlaggedApi;
import android.app.compat.CompatChanges;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.widget.RemoteViews;
import android.widget.TextView;
import android.widget.flags.Flags;

@RemoteViews.RemoteView
public class Button
extends TextView {
    private static final long WEAR_MATERIAL3_BUTTON = 376561342L;
    private static Boolean sUseWearMaterial3Style;

    public Button(Context context) {
        this(context, null);
    }

    public Button(Context context, AttributeSet attrs) {
        this(context, attrs, Button.getButtonDefaultStyleAttr(context), Button.getButtonDefaultStyleRes());
    }

    public Button(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public Button(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return Button.class.getName();
    }

    @Override
    @FlaggedApi(value="android.view.flags.enable_arrow_icon_on_hover_when_clickable")
    public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        if (!android.view.flags.Flags.enableArrowIconOnHoverWhenClickable() && this.getPointerIcon() == null && this.isClickable() && this.isEnabled() && event.isFromSource(8194)) {
            return PointerIcon.getSystemIcon(this.getContext(), 1002);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private static int getButtonDefaultStyleAttr(Context context) {
        sUseWearMaterial3Style = Button.useWearMaterial3Style(context);
        if (sUseWearMaterial3Style.booleanValue()) {
            return 0;
        }
        return 16842824;
    }

    private static int getButtonDefaultStyleRes() {
        if (sUseWearMaterial3Style != null && sUseWearMaterial3Style.booleanValue()) {
            return 16975156;
        }
        return 0;
    }

    private static boolean useWearMaterial3Style(Context context) {
        return Flags.useWearMaterial3Ui() && CompatChanges.isChangeEnabled(376561342L) && context.getPackageManager().hasSystemFeature("android.hardware.type.watch") && context.getThemeResId() == 16974120;
    }
}

