/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.Flags;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.widget.Button;
import android.widget.Checkable;
import com.android.internal.R;

public abstract class CompoundButton
extends Button
implements Checkable {
    private static final String LOG_TAG = CompoundButton.class.getSimpleName();
    private boolean mChecked;
    @UnsupportedAppUsage
    private boolean mBroadcasting;
    @UnsupportedAppUsage
    private Drawable mButtonDrawable;
    private ColorStateList mButtonTintList = null;
    private BlendMode mButtonBlendMode = null;
    private boolean mHasButtonTint = false;
    private boolean mHasButtonBlendMode = false;
    @UnsupportedAppUsage
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeWidgetListener;
    private boolean mCheckedFromResource = false;
    private CharSequence mCustomStateDescription = null;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public CompoundButton(Context context) {
        this(context, null);
    }

    public CompoundButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CompoundButton(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CompoundButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CompoundButton, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.CompoundButton, attrs, a, defStyleAttr, defStyleRes);
        Drawable d = a.getDrawable(1);
        if (d != null) {
            this.setButtonDrawable(d);
        }
        if (a.hasValue(3)) {
            this.mButtonBlendMode = Drawable.parseBlendMode(a.getInt(3, -1), this.mButtonBlendMode);
            this.mHasButtonBlendMode = true;
        }
        if (a.hasValue(2)) {
            this.mButtonTintList = a.getColorStateList(2);
            this.mHasButtonTint = true;
        }
        boolean checked = a.getBoolean(0, false);
        this.setChecked(checked);
        this.mCheckedFromResource = true;
        a.recycle();
        this.applyButtonTint();
    }

    @Override
    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    @Override
    public boolean performClick() {
        this.toggle();
        boolean handled = super.performClick();
        if (!handled) {
            this.playSoundEffect(0);
        }
        return handled;
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return this.mChecked;
    }

    @NonNull
    protected CharSequence getButtonStateDescription() {
        if (this.isChecked()) {
            return this.getResources().getString(17039846);
        }
        return this.getResources().getString(17041072);
    }

    @Override
    public void setStateDescription(@Nullable CharSequence stateDescription) {
        this.mCustomStateDescription = stateDescription;
        if (stateDescription == null) {
            this.setDefaultStateDescription();
        } else {
            super.setStateDescription(stateDescription);
        }
    }

    protected void setDefaultStateDescription() {
        if (this.mCustomStateDescription == null) {
            super.setStateDescription(this.getButtonStateDescription());
        }
    }

    @Override
    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            AutofillManager afm;
            this.mCheckedFromResource = false;
            this.mChecked = checked;
            this.refreshDrawableState();
            if (Flags.triStateChecked()) {
                this.notifyViewAccessibilityStateChangedIfNeeded(8192);
            }
            if (this.mBroadcasting) {
                this.setDefaultStateDescription();
                return;
            }
            this.mBroadcasting = true;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
            if (this.mOnCheckedChangeWidgetListener != null) {
                this.mOnCheckedChangeWidgetListener.onCheckedChanged(this, this.mChecked);
            }
            if ((afm = this.mContext.getSystemService(AutofillManager.class)) != null) {
                afm.notifyValueChanged(this);
            }
            this.mBroadcasting = false;
        }
        this.setDefaultStateDescription();
    }

    public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    void setOnCheckedChangeWidgetListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeWidgetListener = listener;
    }

    @RemotableViewMethod(asyncImpl="setButtonDrawableAsync")
    public void setButtonDrawable(int resId) {
        Drawable d = resId != 0 ? this.getContext().getDrawable(resId) : null;
        this.setButtonDrawable(d);
    }

    public Runnable setButtonDrawableAsync(int resId) {
        Drawable drawable2 = resId == 0 ? null : this.getContext().getDrawable(resId);
        return () -> this.setButtonDrawable(drawable2);
    }

    public void setButtonDrawable(@Nullable Drawable drawable2) {
        if (this.mButtonDrawable != drawable2) {
            if (this.mButtonDrawable != null) {
                this.mButtonDrawable.setCallback(null);
                this.unscheduleDrawable(this.mButtonDrawable);
            }
            this.mButtonDrawable = drawable2;
            if (drawable2 != null) {
                drawable2.setCallback(this);
                drawable2.setLayoutDirection(this.getLayoutDirection());
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                drawable2.setVisible(this.getVisibility() == 0, false);
                this.setMinHeight(drawable2.getIntrinsicHeight());
                this.applyButtonTint();
            }
        }
    }

    @Override
    public void onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.setLayoutDirection(layoutDirection);
        }
    }

    @Nullable
    public Drawable getButtonDrawable() {
        return this.mButtonDrawable;
    }

    @RemotableViewMethod(asyncImpl="setButtonIconAsync")
    public void setButtonIcon(@Nullable Icon icon) {
        this.setButtonDrawable(icon == null ? null : icon.loadDrawable(this.getContext()));
    }

    public Runnable setButtonIconAsync(@Nullable Icon icon) {
        Drawable button = icon == null ? null : icon.loadDrawable(this.getContext());
        return () -> this.setButtonDrawable(button);
    }

    @RemotableViewMethod
    public void setButtonTintList(@Nullable ColorStateList tint) {
        this.mButtonTintList = tint;
        this.mHasButtonTint = true;
        this.applyButtonTint();
    }

    @Nullable
    public ColorStateList getButtonTintList() {
        return this.mButtonTintList;
    }

    public void setButtonTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.setButtonTintBlendMode(tintMode != null ? BlendMode.fromValue(tintMode.nativeInt) : null);
    }

    @RemotableViewMethod
    public void setButtonTintBlendMode(@Nullable BlendMode tintMode) {
        this.mButtonBlendMode = tintMode;
        this.mHasButtonBlendMode = true;
        this.applyButtonTint();
    }

    @Nullable
    public PorterDuff.Mode getButtonTintMode() {
        return this.mButtonBlendMode != null ? BlendMode.blendModeToPorterDuffMode(this.mButtonBlendMode) : null;
    }

    @Nullable
    public BlendMode getButtonTintBlendMode() {
        return this.mButtonBlendMode;
    }

    private void applyButtonTint() {
        if (this.mButtonDrawable != null && (this.mHasButtonTint || this.mHasButtonBlendMode)) {
            this.mButtonDrawable = this.mButtonDrawable.mutate();
            if (this.mHasButtonTint) {
                this.mButtonDrawable.setTintList(this.mButtonTintList);
            }
            if (this.mHasButtonBlendMode) {
                this.mButtonDrawable.setTintBlendMode(this.mButtonBlendMode);
            }
            if (this.mButtonDrawable.isStateful()) {
                this.mButtonDrawable.setState(this.getDrawableState());
            }
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return CompoundButton.class.getName();
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setChecked(this.mChecked);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setCheckable(true);
        if (Flags.triStateChecked()) {
            info.setChecked(this.mChecked ? 1 : 0);
        } else {
            info.setChecked(this.mChecked);
        }
    }

    @Override
    public int getCompoundPaddingLeft() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingLeft();
        if (!this.isLayoutRtl() && (buttonDrawable = this.mButtonDrawable) != null) {
            padding += buttonDrawable.getIntrinsicWidth();
        }
        return padding;
    }

    @Override
    public int getCompoundPaddingRight() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingRight();
        if (this.isLayoutRtl() && (buttonDrawable = this.mButtonDrawable) != null) {
            padding += buttonDrawable.getIntrinsicWidth();
        }
        return padding;
    }

    @Override
    public int getHorizontalOffsetForDrawables() {
        Drawable buttonDrawable = this.mButtonDrawable;
        return buttonDrawable != null ? buttonDrawable.getIntrinsicWidth() : 0;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        Drawable buttonDrawable = this.mButtonDrawable;
        if (buttonDrawable != null) {
            int top;
            int verticalGravity = this.getGravity() & 0x70;
            int drawableHeight = buttonDrawable.getIntrinsicHeight();
            int drawableWidth = buttonDrawable.getIntrinsicWidth();
            switch (verticalGravity) {
                case 80: {
                    top = this.getHeight() - drawableHeight;
                    break;
                }
                case 16: {
                    top = (this.getHeight() - drawableHeight) / 2;
                    break;
                }
                default: {
                    top = 0;
                }
            }
            int bottom = top + drawableHeight;
            int left = this.isLayoutRtl() ? this.getWidth() - drawableWidth : 0;
            int right = this.isLayoutRtl() ? this.getWidth() : drawableWidth;
            buttonDrawable.setBounds(left, top, right, bottom);
            Drawable background = this.getBackground();
            if (background != null) {
                background.setHotspotBounds(left, top, right, bottom);
            }
        }
        super.onDraw(canvas);
        if (buttonDrawable != null) {
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            if (scrollX == 0 && scrollY == 0) {
                buttonDrawable.draw(canvas);
            } else {
                canvas.translate(scrollX, scrollY);
                buttonDrawable.draw(canvas);
                canvas.translate(-scrollX, -scrollY);
            }
        }
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CompoundButton.mergeDrawableStates(drawableState, CHECKED_STATE_SET);
        }
        return drawableState;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable buttonDrawable = this.mButtonDrawable;
        if (buttonDrawable != null && buttonDrawable.isStateful() && buttonDrawable.setState(this.getDrawableState())) {
            this.invalidateDrawable(buttonDrawable);
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.setHotspot(x, y);
        }
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.mButtonDrawable;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.jumpToCurrentState();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checked = this.isChecked();
        return ss;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
        this.requestLayout();
    }

    @Override
    protected void encodeProperties(@NonNull ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        stream.addProperty("checked", this.isChecked());
    }

    @Override
    protected void onProvideStructure(@NonNull ViewStructure structure, int viewFor, int flags) {
        super.onProvideStructure(structure, viewFor, flags);
        if (viewFor == 1) {
            structure.setDataIsSensitive(!this.mCheckedFromResource);
        }
    }

    @Override
    public void autofill(AutofillValue value) {
        if (!this.isEnabled()) {
            return;
        }
        if (!value.isToggle()) {
            Log.w(LOG_TAG, value + " could not be autofilled into " + this);
            return;
        }
        this.setChecked(value.getToggleValue());
    }

    @Override
    public int getAutofillType() {
        return this.isEnabled() ? 2 : 0;
    }

    @Override
    public AutofillValue getAutofillValue() {
        return this.isEnabled() ? AutofillValue.forToggle(this.isChecked()) : null;
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(@NonNull CompoundButton var1, boolean var2);
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean checked;
        @NonNull
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checked = (Boolean)in.readValue(null);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue(this.checked);
        }

        public String toString() {
            return "CompoundButton.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " checked=" + this.checked + "}";
        }
    }
}

