/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.FlaggedApi;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlendMode;
import android.graphics.drawable.Icon;
import android.graphics.text.LineBreakConfig;
import android.os.LocaleList;
import android.os.PersistableBundle;
import android.text.Annotation;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AccessibilityClickableSpan;
import android.text.style.AccessibilityReplacementSpan;
import android.text.style.AccessibilityURLSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.EasyEditSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.LineBreakConfigSpan;
import android.text.style.LineHeightSpan;
import android.text.style.LocaleSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.SpellCheckSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TtsSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoUtils;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.text.flags.Flags;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;

public class RemoteViewsSerializers {
    private static final String TAG = "RemoteViews";

    public static void writeIconToProto(@NonNull ProtoOutputStream out, @NonNull Resources appResources, @NonNull Icon icon) {
        if (icon.getTintList() != null) {
            long token = out.start(1146756268034L);
            icon.getTintList().writeToProto(out);
            out.end(token);
        }
        out.write(0x10500000001L, BlendMode.toValue(icon.getTintBlendMode()));
        switch (icon.getType()) {
            case 1: {
                ByteArrayOutputStream bitmapBytes = new ByteArrayOutputStream();
                icon.getBitmap().compress(Bitmap.CompressFormat.WEBP_LOSSLESS, 100, bitmapBytes);
                out.write(1151051235331L, bitmapBytes.toByteArray());
                break;
            }
            case 5: {
                ByteArrayOutputStream adaptiveBitmapBytes = new ByteArrayOutputStream();
                icon.getBitmap().compress(Bitmap.CompressFormat.WEBP_LOSSLESS, 100, adaptiveBitmapBytes);
                out.write(1151051235336L, adaptiveBitmapBytes.toByteArray());
                break;
            }
            case 2: {
                out.write(1138166333444L, appResources.getResourceName(icon.getResId()));
                break;
            }
            case 3: {
                out.write(1151051235333L, icon.getDataBytes());
                break;
            }
            case 4: {
                out.write(1138166333446L, icon.getUriString());
                break;
            }
            case 6: {
                out.write(1138166333447L, icon.getUriString());
                break;
            }
            default: {
                Log.e(TAG, "Tried to serialize unknown Icon type " + icon.getType());
            }
        }
    }

    @NonNull
    public static Function<Resources, Icon> createIconFromProto(@NonNull ProtoInputStream in) throws Exception {
        LongSparseArray<Object> values = new LongSparseArray<Object>();
        block10: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    values.put(0x10500000001L, in.readInt(0x10500000001L));
                    continue block10;
                }
                case 2: {
                    long tintListToken = in.start(1146756268034L);
                    values.put(1146756268034L, ColorStateList.createFromProto(in));
                    in.end(tintListToken);
                    continue block10;
                }
                case 3: {
                    byte[] bitmapData = in.readBytes(1151051235331L);
                    values.put(1151051235331L, BitmapFactory.decodeByteArray(bitmapData, 0, bitmapData.length));
                    continue block10;
                }
                case 8: {
                    byte[] bitmapAdaptiveData = in.readBytes(1151051235336L);
                    values.put(1151051235336L, BitmapFactory.decodeByteArray(bitmapAdaptiveData, 0, bitmapAdaptiveData.length));
                    continue block10;
                }
                case 4: {
                    values.put(1138166333444L, in.readString(1138166333444L));
                    continue block10;
                }
                case 5: {
                    values.put(1151051235333L, in.readBytes(1151051235333L));
                    continue block10;
                }
                case 6: {
                    values.put(1138166333446L, in.readString(1138166333446L));
                    continue block10;
                }
                case 7: {
                    values.put(1138166333447L, in.readString(1138166333447L));
                    continue block10;
                }
            }
            Log.w(TAG, "Unhandled field while reading Icon proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return resources -> {
            Icon icon;
            int blendMode = values.get(0x10500000001L, -1);
            ColorStateList tintList = (ColorStateList)values.get(1146756268034L);
            Bitmap bitmap = (Bitmap)values.get(1151051235331L);
            Bitmap bitmapAdaptive = (Bitmap)values.get(1151051235336L);
            String resName = (String)values.get(1138166333444L);
            int resource = resName != null ? resources.getIdentifier(resName, null, null) : -1;
            byte[] data = (byte[])values.get(1151051235333L);
            String uri = (String)values.get(1138166333446L);
            String uriAdaptive = (String)values.get(1138166333447L);
            if (bitmap != null) {
                icon = Icon.createWithBitmap(bitmap);
            } else if (bitmapAdaptive != null) {
                icon = Icon.createWithAdaptiveBitmap(bitmapAdaptive);
            } else if (resource != -1) {
                icon = Icon.createWithResource(resources, resource);
            } else if (data != null) {
                icon = Icon.createWithData(data, 0, data.length);
            } else if (uri != null) {
                icon = Icon.createWithContentUri(uri);
            } else if (uriAdaptive != null) {
                icon = Icon.createWithAdaptiveBitmapContentUri(uriAdaptive);
            } else {
                return null;
            }
            if (tintList != null) {
                icon.setTintList(tintList);
            }
            if (blendMode != -1) {
                icon.setTintBlendMode(BlendMode.fromValue(blendMode));
            }
            return icon;
        };
    }

    public static void writeCharSequenceToProto(@NonNull ProtoOutputStream out, @NonNull CharSequence cs) {
        Object[] os;
        out.write(0x10900000001L, cs.toString());
        if (!(cs instanceof Spanned)) {
            return;
        }
        Spanned sp = (Spanned)cs;
        for (Object original : os = sp.getSpans(0, cs.length(), Object.class)) {
            long spanToken;
            Object prop = original;
            if (prop instanceof CharacterStyle) {
                prop = ((CharacterStyle)prop).getUnderlying();
            }
            long spansToken = out.start(0x20B00000002L);
            out.write(0x10500000001L, sp.getSpanStart(original));
            out.write(1120986464258L, sp.getSpanEnd(original));
            out.write(1120986464259L, sp.getSpanFlags(original));
            if (prop instanceof AbsoluteSizeSpan) {
                AbsoluteSizeSpan span = (AbsoluteSizeSpan)prop;
                spanToken = out.start(2246267895812L);
                RemoteViewsSerializers.writeAbsoluteSizeSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof AccessibilityClickableSpan) {
                AccessibilityClickableSpan span = (AccessibilityClickableSpan)prop;
                spanToken = out.start(2246267895813L);
                RemoteViewsSerializers.writeAccessibilityClickableSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof AccessibilityReplacementSpan) {
                AccessibilityReplacementSpan span = (AccessibilityReplacementSpan)prop;
                spanToken = out.start(2246267895814L);
                RemoteViewsSerializers.writeAccessibilityReplacementSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof AccessibilityURLSpan) {
                AccessibilityURLSpan span = (AccessibilityURLSpan)prop;
                spanToken = out.start(2246267895815L);
                RemoteViewsSerializers.writeAccessibilityURLSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof Annotation) {
                Annotation span = (Annotation)prop;
                spanToken = out.start(2246267895817L);
                RemoteViewsSerializers.writeAnnotationToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof BackgroundColorSpan) {
                BackgroundColorSpan span = (BackgroundColorSpan)prop;
                spanToken = out.start(2246267895818L);
                RemoteViewsSerializers.writeBackgroundColorSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof BulletSpan) {
                BulletSpan span = (BulletSpan)prop;
                spanToken = out.start(0x20B0000000BL);
                RemoteViewsSerializers.writeBulletSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof EasyEditSpan) {
                EasyEditSpan span = (EasyEditSpan)prop;
                spanToken = out.start(2246267895820L);
                RemoteViewsSerializers.writeEasyEditSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof ForegroundColorSpan) {
                ForegroundColorSpan span = (ForegroundColorSpan)prop;
                spanToken = out.start(2246267895821L);
                RemoteViewsSerializers.writeForegroundColorSpanToProto(out, span);
                out.end(spanToken);
            } else if (Flags.noBreakNoHyphenationSpan() && prop instanceof LineBreakConfigSpan) {
                LineBreakConfigSpan span = (LineBreakConfigSpan)prop;
                spanToken = out.start(2246267895824L);
                RemoteViewsSerializers.writeLineBreakConfigSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof LocaleSpan) {
                LocaleSpan span = (LocaleSpan)prop;
                spanToken = out.start(2246267895826L);
                RemoteViewsSerializers.writeLocaleSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof QuoteSpan) {
                QuoteSpan span = (QuoteSpan)prop;
                spanToken = out.start(2246267895827L);
                RemoteViewsSerializers.writeQuoteSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof RelativeSizeSpan) {
                RelativeSizeSpan span = (RelativeSizeSpan)prop;
                spanToken = out.start(2246267895828L);
                RemoteViewsSerializers.writeRelativeSizeSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof ScaleXSpan) {
                ScaleXSpan span = (ScaleXSpan)prop;
                spanToken = out.start(2246267895829L);
                RemoteViewsSerializers.writeScaleXSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof SpellCheckSpan) {
                SpellCheckSpan span = (SpellCheckSpan)prop;
                spanToken = out.start(2246267895830L);
                RemoteViewsSerializers.writeSpellCheckSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof LineBackgroundSpan.Standard) {
                LineBackgroundSpan.Standard span = (LineBackgroundSpan.Standard)prop;
                spanToken = out.start(2246267895823L);
                RemoteViewsSerializers.writeLineBackgroundSpanStandardToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof LineHeightSpan.Standard) {
                LineHeightSpan.Standard span = (LineHeightSpan.Standard)prop;
                spanToken = out.start(2246267895825L);
                RemoteViewsSerializers.writeLineHeightSpanStandardToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof LeadingMarginSpan.Standard) {
                LeadingMarginSpan.Standard span = (LeadingMarginSpan.Standard)prop;
                spanToken = out.start(2246267895822L);
                RemoteViewsSerializers.writeLeadingMarginSpanStandardToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof AlignmentSpan.Standard) {
                AlignmentSpan.Standard span = (AlignmentSpan.Standard)prop;
                spanToken = out.start(2246267895816L);
                RemoteViewsSerializers.writeAlignmentSpanStandardToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof StrikethroughSpan) {
                StrikethroughSpan span = (StrikethroughSpan)prop;
                spanToken = out.start(2246267895831L);
                RemoteViewsSerializers.writeStrikethroughSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof StyleSpan) {
                StyleSpan span = (StyleSpan)prop;
                spanToken = out.start(2246267895832L);
                RemoteViewsSerializers.writeStyleSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof SubscriptSpan) {
                SubscriptSpan span = (SubscriptSpan)prop;
                spanToken = out.start(2246267895833L);
                RemoteViewsSerializers.writeSubscriptSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof SuggestionRangeSpan) {
                SuggestionRangeSpan span = (SuggestionRangeSpan)prop;
                spanToken = out.start(2246267895835L);
                RemoteViewsSerializers.writeSuggestionRangeSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof SuggestionSpan) {
                SuggestionSpan span = (SuggestionSpan)prop;
                spanToken = out.start(2246267895834L);
                RemoteViewsSerializers.writeSuggestionSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof SuperscriptSpan) {
                SuperscriptSpan span = (SuperscriptSpan)prop;
                spanToken = out.start(2246267895836L);
                RemoteViewsSerializers.writeSuperscriptSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof TextAppearanceSpan) {
                TextAppearanceSpan span = (TextAppearanceSpan)prop;
                spanToken = out.start(2246267895837L);
                RemoteViewsSerializers.writeTextAppearanceSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof TtsSpan) {
                TtsSpan span = (TtsSpan)prop;
                spanToken = out.start(2246267895838L);
                RemoteViewsSerializers.writeTtsSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof TypefaceSpan) {
                TypefaceSpan span = (TypefaceSpan)prop;
                spanToken = out.start(2246267895839L);
                RemoteViewsSerializers.writeTypefaceSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof URLSpan) {
                URLSpan span = (URLSpan)prop;
                spanToken = out.start(2246267895841L);
                RemoteViewsSerializers.writeURLSpanToProto(out, span);
                out.end(spanToken);
            } else if (prop instanceof UnderlineSpan) {
                UnderlineSpan span = (UnderlineSpan)prop;
                spanToken = out.start(0x20B00000020L);
                RemoteViewsSerializers.writeUnderlineSpanToProto(out, span);
                out.end(spanToken);
            }
            out.end(spansToken);
        }
    }

    public static CharSequence createCharSequenceFromProto(ProtoInputStream in) throws Exception {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        boolean hasSpans = false;
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    String text = in.readString(0x10900000001L);
                    builder.append(text);
                    continue block4;
                }
                case 2: {
                    hasSpans = true;
                    long spansToken = in.start(0x20B00000002L);
                    RemoteViewsSerializers.createSpanFromProto(in, builder);
                    in.end(spansToken);
                    continue block4;
                }
            }
            Log.w(TAG, "Unhandled field while reading CharSequence proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return hasSpans ? builder : builder.toString();
    }

    private static void createSpanFromProto(ProtoInputStream in, SpannableStringBuilder builder) throws Exception {
        int start = 0;
        int end = 0;
        int flags = 0;
        ParcelableSpan what = null;
        block35: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    start = in.readInt(0x10500000001L);
                    continue block35;
                }
                case 2: {
                    end = in.readInt(1120986464258L);
                    continue block35;
                }
                case 3: {
                    flags = in.readInt(1120986464259L);
                    continue block35;
                }
                case 4: {
                    long asToken = in.start(2246267895812L);
                    what = RemoteViewsSerializers.createAbsoluteSizeSpanFromProto(in);
                    in.end(asToken);
                    continue block35;
                }
                case 5: {
                    long acToken = in.start(2246267895813L);
                    what = RemoteViewsSerializers.createAccessibilityClickableSpanFromProto(in);
                    in.end(acToken);
                    continue block35;
                }
                case 6: {
                    long arToken = in.start(2246267895814L);
                    what = RemoteViewsSerializers.createAccessibilityReplacementSpanFromProto(in);
                    in.end(arToken);
                    continue block35;
                }
                case 7: {
                    long auToken = in.start(2246267895815L);
                    what = RemoteViewsSerializers.createAccessibilityURLSpanFromProto(in);
                    in.end(auToken);
                    continue block35;
                }
                case 8: {
                    long aToken = in.start(2246267895816L);
                    what = RemoteViewsSerializers.createAlignmentSpanStandardFromProto(in);
                    in.end(aToken);
                    continue block35;
                }
                case 9: {
                    long annToken = in.start(2246267895817L);
                    what = RemoteViewsSerializers.createAnnotationFromProto(in);
                    in.end(annToken);
                    continue block35;
                }
                case 10: {
                    long bcToken = in.start(2246267895818L);
                    what = RemoteViewsSerializers.createBackgroundColorSpanFromProto(in);
                    in.end(bcToken);
                    continue block35;
                }
                case 11: {
                    long bToken = in.start(0x20B0000000BL);
                    what = RemoteViewsSerializers.createBulletSpanFromProto(in);
                    in.end(bToken);
                    continue block35;
                }
                case 12: {
                    long eeToken = in.start(2246267895820L);
                    what = RemoteViewsSerializers.createEasyEditSpanFromProto(in);
                    in.end(eeToken);
                    continue block35;
                }
                case 13: {
                    long fcToken = in.start(2246267895821L);
                    what = RemoteViewsSerializers.createForegroundColorSpanFromProto(in);
                    in.end(fcToken);
                    continue block35;
                }
                case 14: {
                    long lmToken = in.start(2246267895822L);
                    what = RemoteViewsSerializers.createLeadingMarginSpanStandardFromProto(in);
                    in.end(lmToken);
                    continue block35;
                }
                case 15: {
                    long lbToken = in.start(2246267895823L);
                    what = RemoteViewsSerializers.createLineBackgroundSpanStandardFromProto(in);
                    in.end(lbToken);
                    continue block35;
                }
                case 16: {
                    if (!Flags.noBreakNoHyphenationSpan()) continue block35;
                    long lbrToken = in.start(2246267895824L);
                    what = RemoteViewsSerializers.createLineBreakConfigSpanFromProto(in);
                    in.end(lbrToken);
                    continue block35;
                }
                case 17: {
                    long lhToken = in.start(2246267895825L);
                    what = RemoteViewsSerializers.createLineHeightSpanStandardFromProto(in);
                    in.end(lhToken);
                    continue block35;
                }
                case 18: {
                    long lToken = in.start(2246267895826L);
                    what = RemoteViewsSerializers.createLocaleSpanFromProto(in);
                    in.end(lToken);
                    continue block35;
                }
                case 19: {
                    long qToken = in.start(2246267895827L);
                    what = RemoteViewsSerializers.createQuoteSpanFromProto(in);
                    in.end(qToken);
                    continue block35;
                }
                case 20: {
                    long rsToken = in.start(2246267895828L);
                    what = RemoteViewsSerializers.createRelativeSizeSpanFromProto(in);
                    in.end(rsToken);
                    continue block35;
                }
                case 21: {
                    long sxToken = in.start(2246267895829L);
                    what = RemoteViewsSerializers.createScaleXSpanFromProto(in);
                    in.end(sxToken);
                    continue block35;
                }
                case 22: {
                    long scToken = in.start(2246267895830L);
                    what = RemoteViewsSerializers.createSpellCheckSpanFromProto(in);
                    in.end(scToken);
                    continue block35;
                }
                case 23: {
                    long stToken = in.start(2246267895831L);
                    what = RemoteViewsSerializers.createStrikethroughSpanFromProto(in);
                    in.end(stToken);
                    continue block35;
                }
                case 24: {
                    long sToken = in.start(2246267895832L);
                    what = RemoteViewsSerializers.createStyleSpanFromProto(in);
                    in.end(sToken);
                    continue block35;
                }
                case 25: {
                    long suToken = in.start(2246267895833L);
                    what = RemoteViewsSerializers.createSubscriptSpanFromProto(in);
                    in.end(suToken);
                    continue block35;
                }
                case 27: {
                    long srToken = in.start(2246267895835L);
                    what = RemoteViewsSerializers.createSuggestionRangeSpanFromProto(in);
                    in.end(srToken);
                    continue block35;
                }
                case 26: {
                    long sugToken = in.start(2246267895834L);
                    what = RemoteViewsSerializers.createSuggestionSpanFromProto(in);
                    in.end(sugToken);
                    continue block35;
                }
                case 28: {
                    long supToken = in.start(2246267895836L);
                    what = RemoteViewsSerializers.createSuperscriptSpanFromProto(in);
                    in.end(supToken);
                    continue block35;
                }
                case 29: {
                    long taToken = in.start(2246267895837L);
                    what = RemoteViewsSerializers.createTextAppearanceSpanFromProto(in);
                    in.end(taToken);
                    continue block35;
                }
                case 30: {
                    long ttsToken = in.start(2246267895838L);
                    what = RemoteViewsSerializers.createTtsSpanFromProto(in);
                    in.end(ttsToken);
                    continue block35;
                }
                case 31: {
                    long tfToken = in.start(2246267895839L);
                    what = RemoteViewsSerializers.createTypefaceSpanFromProto(in);
                    in.end(tfToken);
                    continue block35;
                }
                case 32: {
                    long unToken = in.start(0x20B00000020L);
                    what = RemoteViewsSerializers.createUnderlineSpanFromProto(in);
                    in.end(unToken);
                    continue block35;
                }
                case 33: {
                    long urlToken = in.start(2246267895841L);
                    what = RemoteViewsSerializers.createURLSpanFromProto(in);
                    in.end(urlToken);
                    continue block35;
                }
            }
            Log.w(TAG, "Unhandled field while reading CharSequence proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        if (what == null) {
            return;
        }
        builder.setSpan(what, start, end, flags);
    }

    public static AbsoluteSizeSpan createAbsoluteSizeSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int size = 0;
        boolean dip = false;
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    size = in.readInt(0x10500000001L);
                    continue block4;
                }
                case 2: {
                    dip = in.readBoolean(1133871366146L);
                    continue block4;
                }
            }
            Log.w("AbsoluteSizeSpan", "Unhandled field while reading AbsoluteSizeSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new AbsoluteSizeSpan(size, dip);
    }

    public static void writeAbsoluteSizeSpanToProto(@NonNull ProtoOutputStream out, AbsoluteSizeSpan span) {
        out.write(0x10500000001L, span.getSize());
        out.write(1133871366146L, span.getDip());
    }

    public static AccessibilityClickableSpan createAccessibilityClickableSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int originalClickableSpanId = 0;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    originalClickableSpanId = in.readInt(0x10500000001L);
                    continue block3;
                }
            }
            Log.w("AccessibilityClickable", "Unhandled field while reading AccessibilityClickableSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new AccessibilityClickableSpan(originalClickableSpanId);
    }

    public static void writeAccessibilityClickableSpanToProto(@NonNull ProtoOutputStream out, AccessibilityClickableSpan span) {
        out.write(0x10500000001L, span.getOriginalClickableSpanId());
    }

    public static AccessibilityReplacementSpan createAccessibilityReplacementSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        CharSequence contentDescription = null;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    long token = in.start(0x10B00000001L);
                    contentDescription = RemoteViewsSerializers.createCharSequenceFromProto(in);
                    in.end(token);
                    continue block3;
                }
            }
            Log.w("AccessibilityReplacemen", "Unhandled field while reading AccessibilityReplacementSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new AccessibilityReplacementSpan(contentDescription);
    }

    public static void writeAccessibilityReplacementSpanToProto(@NonNull ProtoOutputStream out, AccessibilityReplacementSpan span) {
        long token = out.start(0x10B00000001L);
        CharSequence description = span.getContentDescription();
        if (description != null) {
            RemoteViewsSerializers.writeCharSequenceToProto(out, description);
        }
        out.end(token);
    }

    public static AccessibilityURLSpan createAccessibilityURLSpanFromProto(ProtoInputStream in) throws Exception {
        String url = null;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    url = in.readString(0x10900000001L);
                    continue block3;
                }
            }
            Log.w("AccessibilityURLSpan", "Unhandled field while reading AccessibilityURLSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new AccessibilityURLSpan(new URLSpan(url));
    }

    public static void writeAccessibilityURLSpanToProto(@NonNull ProtoOutputStream out, AccessibilityURLSpan span) {
        out.write(0x10900000001L, span.getURL());
    }

    public static AlignmentSpan.Standard createAlignmentSpanStandardFromProto(@NonNull ProtoInputStream in) throws Exception {
        String alignment = null;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    alignment = in.readString(0x10900000001L);
                    continue block3;
                }
            }
            Log.w("AlignmentSpan", "Unhandled field while reading AlignmentSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new AlignmentSpan.Standard(Layout.Alignment.valueOf(alignment));
    }

    public static void writeAlignmentSpanStandardToProto(@NonNull ProtoOutputStream out, AlignmentSpan.Standard span) {
        out.write(0x10900000001L, span.getAlignment().name());
    }

    public static Annotation createAnnotationFromProto(@NonNull ProtoInputStream in) throws Exception {
        String key = null;
        String value = null;
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    key = in.readString(0x10900000001L);
                    continue block4;
                }
                case 2: {
                    value = in.readString(1138166333442L);
                    continue block4;
                }
            }
            Log.w("Annotation", "Unhandled field while reading Annotation proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new Annotation(key, value);
    }

    public static void writeAnnotationToProto(@NonNull ProtoOutputStream out, Annotation span) {
        out.write(0x10900000001L, span.getKey());
        out.write(1138166333442L, span.getValue());
    }

    public static BackgroundColorSpan createBackgroundColorSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int color2 = 0;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    color2 = in.readInt(0x10500000001L);
                    continue block3;
                }
            }
            Log.w("BackgroundColorSpan", "Unhandled field while reading BackgroundColorSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new BackgroundColorSpan(color2);
    }

    public static void writeBackgroundColorSpanToProto(@NonNull ProtoOutputStream out, BackgroundColorSpan span) {
        out.write(0x10500000001L, span.getBackgroundColor());
    }

    public static BulletSpan createBulletSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int bulletRadius = 0;
        int color2 = 0;
        int gapWidth = 0;
        boolean wantColor = false;
        block6: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 3: {
                    bulletRadius = in.readInt(1120986464259L);
                    continue block6;
                }
                case 2: {
                    color2 = in.readInt(1120986464258L);
                    continue block6;
                }
                case 1: {
                    gapWidth = in.readInt(0x10500000001L);
                    continue block6;
                }
                case 4: {
                    wantColor = in.readBoolean(1133871366148L);
                    continue block6;
                }
            }
            Log.w("BulletSpan", "Unhandled field while reading BulletSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new BulletSpan(gapWidth, color2, wantColor, bulletRadius);
    }

    public static void writeBulletSpanToProto(@NonNull ProtoOutputStream out, BulletSpan span) {
        out.write(1120986464259L, span.getBulletRadius());
        out.write(1120986464258L, span.getColor());
        out.write(0x10500000001L, span.getGapWidth());
        out.write(1133871366148L, span.getWantColor());
    }

    public static EasyEditSpan createEasyEditSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        return new EasyEditSpan();
    }

    public static void writeEasyEditSpanToProto(@NonNull ProtoOutputStream out, EasyEditSpan span) {
    }

    public static ForegroundColorSpan createForegroundColorSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int color2 = 0;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    color2 = in.readInt(0x10500000001L);
                    continue block3;
                }
            }
            Log.w("ForegroundColorSpan", "Unhandled field while reading ForegroundColorSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new ForegroundColorSpan(color2);
    }

    public static LeadingMarginSpan.Standard createLeadingMarginSpanStandardFromProto(@NonNull ProtoInputStream in) throws Exception {
        int first = 0;
        int rest = 0;
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    first = in.readInt(0x10500000001L);
                    continue block4;
                }
                case 2: {
                    rest = in.readInt(1120986464258L);
                    continue block4;
                }
            }
            Log.w("LeadingMarginSpan", "Unhandled field while reading LeadingMarginSpanproto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new LeadingMarginSpan.Standard(first, rest);
    }

    public static void writeLeadingMarginSpanStandardToProto(@NonNull ProtoOutputStream out, LeadingMarginSpan.Standard span) {
        out.write(0x10500000001L, span.getLeadingMargin(true));
        out.write(1120986464258L, span.getLeadingMargin(false));
    }

    public static void writeForegroundColorSpanToProto(@NonNull ProtoOutputStream out, ForegroundColorSpan span) {
        out.write(0x10500000001L, span.getForegroundColor());
    }

    public static LineBackgroundSpan.Standard createLineBackgroundSpanStandardFromProto(@NonNull ProtoInputStream in) throws Exception {
        int color2 = 0;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    color2 = in.readInt(0x10500000001L);
                    continue block3;
                }
            }
            Log.w("LineBackgroundSpan", "Unhandled field while reading LineBackgroundSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new LineBackgroundSpan.Standard(color2);
    }

    public static void writeLineBackgroundSpanStandardToProto(@NonNull ProtoOutputStream out, LineBackgroundSpan.Standard span) {
        out.write(0x10500000001L, span.getColor());
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static LineBreakConfigSpan createLineBreakConfigSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int lineBreakStyle = 0;
        int lineBreakWordStyle = 0;
        int hyphenation = 0;
        block5: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    lineBreakStyle = in.readInt(0x10500000001L);
                    continue block5;
                }
                case 2: {
                    lineBreakWordStyle = in.readInt(1120986464258L);
                    continue block5;
                }
                case 3: {
                    hyphenation = in.readInt(1120986464259L);
                    continue block5;
                }
            }
            Log.w("LineBreakConfigSpan", "Unhandled field while reading LineBreakConfigSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        LineBreakConfig lbc = new LineBreakConfig.Builder().setLineBreakStyle(lineBreakStyle).setLineBreakWordStyle(lineBreakWordStyle).setHyphenation(hyphenation).build();
        return new LineBreakConfigSpan(lbc);
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static void writeLineBreakConfigSpanToProto(@NonNull ProtoOutputStream out, LineBreakConfigSpan span) {
        out.write(0x10500000001L, span.getLineBreakConfig().getLineBreakStyle());
        out.write(1120986464258L, span.getLineBreakConfig().getLineBreakWordStyle());
        out.write(1120986464259L, span.getLineBreakConfig().getHyphenation());
    }

    public static LineHeightSpan.Standard createLineHeightSpanStandardFromProto(@NonNull ProtoInputStream in) throws Exception {
        int height = 0;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    height = in.readInt(0x10500000001L);
                    continue block3;
                }
            }
            Log.w("LineHeightSpan.Standard", "Unhandled field while reading LineHeightSpan.Standard proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new LineHeightSpan.Standard(height);
    }

    public static void writeLineHeightSpanStandardToProto(@NonNull ProtoOutputStream out, LineHeightSpan.Standard span) {
        out.write(0x10500000001L, span.getHeight());
    }

    public static LocaleSpan createLocaleSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        String languageTags = null;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    languageTags = in.readString(0x10900000001L);
                    continue block3;
                }
            }
            Log.w("LocaleSpan", "Unhandled field while reading LocaleSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new LocaleSpan(LocaleList.forLanguageTags(languageTags));
    }

    public static void writeLocaleSpanToProto(@NonNull ProtoOutputStream out, LocaleSpan span) {
        out.write(0x10900000001L, span.getLocales().toLanguageTags());
    }

    public static QuoteSpan createQuoteSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int color2 = 0;
        int stripeWidth = 0;
        int gapWidth = 0;
        block5: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    color2 = in.readInt(0x10500000001L);
                    continue block5;
                }
                case 2: {
                    stripeWidth = in.readInt(1120986464258L);
                    continue block5;
                }
                case 3: {
                    gapWidth = in.readInt(1120986464259L);
                    continue block5;
                }
            }
            Log.w("QuoteSpan", "Unhandled field while reading QuoteSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new QuoteSpan(color2, stripeWidth, gapWidth);
    }

    public static void writeQuoteSpanToProto(@NonNull ProtoOutputStream out, QuoteSpan span) {
        out.write(0x10500000001L, span.getColor());
        out.write(1120986464258L, span.getStripeWidth());
        out.write(1120986464259L, span.getGapWidth());
    }

    public static RelativeSizeSpan createRelativeSizeSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        float proportion = 0.0f;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    proportion = in.readFloat(0x10200000001L);
                    continue block3;
                }
            }
            Log.w("RelativeSizeSpan", "Unhandled field while reading RelativeSizeSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new RelativeSizeSpan(proportion);
    }

    public static void writeRelativeSizeSpanToProto(@NonNull ProtoOutputStream out, RelativeSizeSpan span) {
        out.write(0x10200000001L, span.getSizeChange());
    }

    public static ScaleXSpan createScaleXSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        float proportion = 0.0f;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    proportion = in.readFloat(0x10200000001L);
                    continue block3;
                }
            }
            Log.w("ScaleXSpan", "Unhandled field while reading ScaleXSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new ScaleXSpan(proportion);
    }

    public static void writeScaleXSpanToProto(@NonNull ProtoOutputStream out, ScaleXSpan span) {
        out.write(0x10200000001L, span.getScaleX());
    }

    public static SpellCheckSpan createSpellCheckSpanFromProto(@NonNull ProtoInputStream in) {
        return new SpellCheckSpan();
    }

    public static void writeSpellCheckSpanToProto(@NonNull ProtoOutputStream out, SpellCheckSpan span) {
    }

    public static StrikethroughSpan createStrikethroughSpanFromProto(@NonNull ProtoInputStream in) {
        return new StrikethroughSpan();
    }

    public static void writeStrikethroughSpanToProto(@NonNull ProtoOutputStream out, StrikethroughSpan span) {
    }

    public static StyleSpan createStyleSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int style2 = 0;
        int fontWeightAdjustment = 0;
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    style2 = in.readInt(0x10500000001L);
                    continue block4;
                }
                case 2: {
                    fontWeightAdjustment = in.readInt(1120986464258L);
                    continue block4;
                }
            }
            Log.w("StyleSpan", "Unhandled field while reading StyleSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new StyleSpan(style2, fontWeightAdjustment);
    }

    public static void writeStyleSpanToProto(@NonNull ProtoOutputStream out, StyleSpan span) {
        out.write(0x10500000001L, span.getStyle());
        out.write(1120986464258L, span.getFontWeightAdjustment());
    }

    public static SubscriptSpan createSubscriptSpanFromProto(@NonNull ProtoInputStream in) {
        return new SubscriptSpan();
    }

    public static void writeSubscriptSpanToProto(@NonNull ProtoOutputStream out, SubscriptSpan span) {
    }

    public static SuggestionRangeSpan createSuggestionRangeSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        int backgroundColor = 0;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    backgroundColor = in.readInt(0x10500000001L);
                    continue block3;
                }
            }
            Log.w("SuggestionRangeSpan", "Unhandled field while reading SuggestionRangeSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        SuggestionRangeSpan span = new SuggestionRangeSpan();
        span.setBackgroundColor(backgroundColor);
        return span;
    }

    public static void writeSuggestionRangeSpanToProto(@NonNull ProtoOutputStream out, SuggestionRangeSpan span) {
        out.write(0x10500000001L, span.getBackgroundColor());
    }

    public static SuggestionSpan createSuggestionSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        ArrayList<String> suggestions = new ArrayList<String>();
        int flags = 0;
        String localeStringForCompatibility = null;
        String languageTag = null;
        int hashCode = 0;
        int easyCorrectUnderlineColor = 0;
        float easyCorrectUnderlineThickness = 0.0f;
        int misspelledUnderlineColor = 0;
        float misspelledUnderlineThickness = 0.0f;
        int autoCorrectionUnderlineColor = 0;
        float autoCorrectionUnderlineThickness = 0.0f;
        int grammarErrorUnderlineColor = 0;
        float grammarErrorUnderlineThickness = 0.0f;
        block15: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    suggestions.add(in.readString(2237677961217L));
                    continue block15;
                }
                case 2: {
                    flags = in.readInt(1120986464258L);
                    continue block15;
                }
                case 3: {
                    localeStringForCompatibility = in.readString(1138166333443L);
                    continue block15;
                }
                case 4: {
                    languageTag = in.readString(1138166333444L);
                    continue block15;
                }
                case 5: {
                    hashCode = in.readInt(0x10500000005L);
                    continue block15;
                }
                case 6: {
                    easyCorrectUnderlineColor = in.readInt(1120986464262L);
                    continue block15;
                }
                case 7: {
                    easyCorrectUnderlineThickness = in.readFloat(1108101562375L);
                    continue block15;
                }
                case 8: {
                    misspelledUnderlineColor = in.readInt(1120986464264L);
                    continue block15;
                }
                case 9: {
                    misspelledUnderlineThickness = in.readFloat(1108101562377L);
                    continue block15;
                }
                case 10: {
                    autoCorrectionUnderlineColor = in.readInt(1120986464266L);
                    continue block15;
                }
                case 11: {
                    autoCorrectionUnderlineThickness = in.readFloat(1108101562379L);
                    continue block15;
                }
                case 12: {
                    grammarErrorUnderlineColor = in.readInt(1120986464268L);
                    continue block15;
                }
                case 13: {
                    grammarErrorUnderlineThickness = in.readFloat(1108101562381L);
                    continue block15;
                }
            }
            Log.w("SuggestionSpan", "Unhandled field while reading SuggestionSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        String[] suggestionsArray = new String[suggestions.size()];
        suggestions.toArray(suggestionsArray);
        return new SuggestionSpan(suggestionsArray, flags, localeStringForCompatibility, languageTag, hashCode, easyCorrectUnderlineColor, easyCorrectUnderlineThickness, misspelledUnderlineColor, misspelledUnderlineThickness, autoCorrectionUnderlineColor, autoCorrectionUnderlineThickness, grammarErrorUnderlineColor, grammarErrorUnderlineThickness);
    }

    public static void writeSuggestionSpanToProto(@NonNull ProtoOutputStream out, SuggestionSpan span) {
        for (String suggestion : span.getSuggestions()) {
            out.write(2237677961217L, suggestion);
        }
        out.write(1120986464258L, span.getFlags());
        out.write(1138166333443L, span.getLocale());
        if (span.getLocaleObject() != null) {
            out.write(1138166333444L, span.getLocaleObject().toLanguageTag());
        }
        out.write(0x10500000005L, span.hashCode());
        out.write(1120986464262L, span.getEasyCorrectUnderlineColor());
        out.write(1108101562375L, span.getEasyCorrectUnderlineThickness());
        out.write(1120986464264L, span.getMisspelledUnderlineColor());
        out.write(1108101562377L, span.getMisspelledUnderlineThickness());
        out.write(1120986464266L, span.getAutoCorrectionUnderlineColor());
        out.write(1108101562379L, span.getAutoCorrectionUnderlineThickness());
        out.write(1120986464268L, span.getGrammarErrorUnderlineColor());
        out.write(1108101562381L, span.getGrammarErrorUnderlineThickness());
    }

    public static SuperscriptSpan createSuperscriptSpanFromProto(@NonNull ProtoInputStream in) {
        return new SuperscriptSpan();
    }

    public static void writeSuperscriptSpanToProto(@NonNull ProtoOutputStream out, SuperscriptSpan span) {
    }

    public static TextAppearanceSpan createTextAppearanceSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        String familyName = null;
        int style2 = 0;
        int textSize = 0;
        ColorStateList textColor = null;
        ColorStateList textColorLink = null;
        int textFontWeight = 0;
        LocaleList textLocales = null;
        float shadowRadius = 0.0f;
        float shadowDx = 0.0f;
        float shadowDy = 0.0f;
        int shadowColor = 0;
        boolean hasElegantTextHeight = false;
        boolean elegantTextHeight = false;
        boolean hasLetterSpacing = false;
        float letterSpacing = 0.0f;
        String fontFeatureSettings = null;
        String fontVariationSettings = null;
        block19: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    familyName = in.readString(0x10900000001L);
                    continue block19;
                }
                case 2: {
                    style2 = in.readInt(1120986464258L);
                    continue block19;
                }
                case 3: {
                    textSize = in.readInt(1120986464259L);
                    continue block19;
                }
                case 4: {
                    long textColorToken = in.start(1146756268036L);
                    textColor = ColorStateList.createFromProto(in);
                    in.end(textColorToken);
                    continue block19;
                }
                case 5: {
                    long textColorLinkToken = in.start(1146756268037L);
                    textColorLink = ColorStateList.createFromProto(in);
                    in.end(textColorLinkToken);
                    continue block19;
                }
                case 7: {
                    textFontWeight = in.readInt(1120986464263L);
                    continue block19;
                }
                case 8: {
                    textLocales = LocaleList.forLanguageTags(in.readString(1138166333448L));
                    continue block19;
                }
                case 9: {
                    shadowRadius = in.readFloat(1108101562377L);
                    continue block19;
                }
                case 10: {
                    shadowDx = in.readFloat(1108101562378L);
                    continue block19;
                }
                case 11: {
                    shadowDy = in.readFloat(1108101562379L);
                    continue block19;
                }
                case 12: {
                    shadowColor = in.readInt(1120986464268L);
                    continue block19;
                }
                case 13: {
                    hasElegantTextHeight = in.readBoolean(1133871366157L);
                    continue block19;
                }
                case 14: {
                    elegantTextHeight = in.readBoolean(1133871366158L);
                    continue block19;
                }
                case 15: {
                    hasLetterSpacing = in.readBoolean(1133871366159L);
                    continue block19;
                }
                case 16: {
                    letterSpacing = in.readFloat(0x10200000010L);
                    continue block19;
                }
                case 17: {
                    fontFeatureSettings = in.readString(0x10900000011L);
                    continue block19;
                }
                case 18: {
                    fontVariationSettings = in.readString(1138166333458L);
                    continue block19;
                }
            }
            Log.w("TextAppearanceSpan", "Unhandled field while reading TextAppearanceSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new TextAppearanceSpan(familyName, style2, textSize, textColor, textColorLink, null, textFontWeight, textLocales, shadowRadius, shadowDx, shadowDy, shadowColor, hasElegantTextHeight, elegantTextHeight, hasLetterSpacing, letterSpacing, fontFeatureSettings, fontVariationSettings);
    }

    public static void writeTextAppearanceSpanToProto(@NonNull ProtoOutputStream out, TextAppearanceSpan span) {
        out.write(0x10900000001L, span.getFamily());
        out.write(1120986464258L, span.getTextStyle());
        out.write(1120986464259L, span.getTextSize());
        out.write(1120986464263L, span.getTextFontWeight());
        if (span.getTextLocales() != null) {
            out.write(1138166333448L, span.getTextLocales().toLanguageTags());
        }
        out.write(1108101562377L, span.getShadowRadius());
        out.write(1108101562378L, span.getShadowDx());
        out.write(1108101562379L, span.getShadowDy());
        out.write(1120986464268L, span.getShadowColor());
        out.write(1133871366157L, span.hasElegantTextHeight());
        out.write(1133871366158L, span.isElegantTextHeight());
        out.write(1133871366159L, span.hasLetterSpacing());
        out.write(0x10200000010L, span.getLetterSpacing());
        out.write(0x10900000011L, span.getFontFeatureSettings());
        out.write(1138166333458L, span.getFontVariationSettings());
        if (span.getTextColor() != null) {
            long textColorToken = out.start(1146756268036L);
            span.getTextColor().writeToProto(out);
            out.end(textColorToken);
        }
        if (span.getLinkTextColor() != null) {
            long textColorLinkToken = out.start(1146756268037L);
            span.getLinkTextColor().writeToProto(out);
            out.end(textColorLinkToken);
        }
    }

    public static TtsSpan createTtsSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        String type = null;
        PersistableBundle args = null;
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    type = in.readString(0x10900000001L);
                    continue block4;
                }
                case 2: {
                    byte[] data = in.readString(1138166333442L).getBytes();
                    args = PersistableBundle.readFromStream(new ByteArrayInputStream(data));
                    continue block4;
                }
            }
            Log.w("TtsSpan", "Unhandled field while reading TtsSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new TtsSpan(type, args);
    }

    public static void writeTtsSpanToProto(@NonNull ProtoOutputStream out, TtsSpan span) {
        out.write(0x10900000001L, span.getType());
        if (span.getArgs() != null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            try {
                span.getArgs().writeToStream(buf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            out.write(1138166333442L, buf.toString(StandardCharsets.UTF_8));
        }
    }

    public static TypefaceSpan createTypefaceSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        String family = null;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    family = in.readString(0x10900000001L);
                    continue block3;
                }
            }
            Log.w("TypefaceSpan", "Unhandled field while reading TypefaceSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new TypefaceSpan(family);
    }

    public static void writeTypefaceSpanToProto(@NonNull ProtoOutputStream out, TypefaceSpan span) {
        out.write(0x10900000001L, span.getFamily());
    }

    public static URLSpan createURLSpanFromProto(@NonNull ProtoInputStream in) throws Exception {
        String url = null;
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    url = in.readString(0x10900000001L);
                    continue block3;
                }
            }
            Log.w("URLSpan", "Unhandled field while reading URLSpan proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new URLSpan(url);
    }

    public static void writeURLSpanToProto(@NonNull ProtoOutputStream out, URLSpan span) {
        out.write(0x10900000001L, span.getURL());
    }

    public static UnderlineSpan createUnderlineSpanFromProto(@NonNull ProtoInputStream in) {
        return new UnderlineSpan();
    }

    public static void writeUnderlineSpanToProto(@NonNull ProtoOutputStream out, UnderlineSpan span) {
    }
}

