/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.Application;
import android.content.ContentResolver;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.function.BooleanSupplier;

public enum DesktopModeFlags {
    DISABLE_DESKTOP_LAUNCH_PARAMS_OUTSIDE_DESKTOP_BUG_FIX(Flags::disableDesktopLaunchParamsOutsideDesktopBugFix, true),
    DISABLE_NON_RESIZABLE_APP_SNAP_RESIZE(Flags::disableNonResizableAppSnapResizing, true),
    ENABLE_ACCESSIBLE_CUSTOM_HEADERS(Flags::enableAccessibleCustomHeaders, true),
    ENABLE_APP_HEADER_WITH_TASK_DENSITY(Flags::enableAppHeaderWithTaskDensity, true),
    ENABLE_CAMERA_COMPAT_SIMULATE_REQUESTED_ORIENTATION(Flags::enableCameraCompatForDesktopWindowing, true),
    ENABLE_CAPTION_COMPAT_INSET_FORCE_CONSUMPTION(Flags::enableCaptionCompatInsetForceConsumption, true),
    ENABLE_CAPTION_COMPAT_INSET_FORCE_CONSUMPTION_ALWAYS(Flags::enableCaptionCompatInsetForceConsumptionAlways, true),
    ENABLE_CASCADING_WINDOWS(Flags::enableCascadingWindows, true),
    ENABLE_DESKTOP_APP_HANDLE_ANIMATION(Flags::enableDesktopAppHandleAnimation, true),
    ENABLE_DESKTOP_APP_LAUNCH_ALTTAB_TRANSITIONS_BUGFIX(Flags::enableDesktopAppLaunchAlttabTransitionsBugfix, true),
    ENABLE_DESKTOP_APP_LAUNCH_TRANSITIONS_BUGFIX(Flags::enableDesktopAppLaunchTransitionsBugfix, true),
    ENABLE_DESKTOP_CLOSE_SHORTCUT_BUGFIX(Flags::enableDesktopCloseShortcutBugfix, false),
    ENABLE_DESKTOP_COMPAT_UI_VISIBILITY_STATUS(Flags::enableCompatUiVisibilityStatus, true),
    ENABLE_DESKTOP_IMMERSIVE_DRAG_BUGFIX(Flags::enableDesktopImmersiveDragBugfix, true),
    ENABLE_DESKTOP_INDICATOR_IN_SEPARATE_THREAD_BUGFIX(Flags::enableDesktopIndicatorInSeparateThreadBugfix, true),
    ENABLE_DESKTOP_OPENING_DEEPLINK_MINIMIZE_ANIMATION_BUGFIX(Flags::enableDesktopOpeningDeeplinkMinimizeAnimationBugfix, true),
    ENABLE_DESKTOP_RECENTS_TRANSITIONS_CORNERS_BUGFIX(Flags::enableDesktopRecentsTransitionsCornersBugfix, true),
    ENABLE_DESKTOP_SKIP_COMPAT_UI_EDUCATION_IN_DESKTOP_MODE_BUGFIX(Flags::skipCompatUiEducationInDesktopMode, true),
    ENABLE_DESKTOP_SYSTEM_DIALOGS_TRANSITIONS(Flags::enableDesktopSystemDialogsTransitions, true),
    ENABLE_DESKTOP_TAB_TEARING_MINIMIZE_ANIMATION_BUGFIX(Flags::enableDesktopTabTearingMinimizeAnimationBugfix, true),
    ENABLE_DESKTOP_TRAMPOLINE_CLOSE_ANIMATION_BUGFIX(Flags::enableDesktopTrampolineCloseAnimationBugfix, true),
    ENABLE_DESKTOP_WALLPAPER_ACTIVITY_FOR_SYSTEM_USER(Flags::enableDesktopWallpaperActivityForSystemUser, true),
    ENABLE_DESKTOP_WINDOWING_APP_TO_WEB(Flags::enableDesktopWindowingAppToWeb, true),
    ENABLE_DESKTOP_WINDOWING_APP_TO_WEB_EDUCATION(Flags::enableDesktopWindowingAppToWebEducation, true),
    ENABLE_DESKTOP_WINDOWING_BACK_NAVIGATION(Flags::enableDesktopWindowingBackNavigation, true),
    ENABLE_DESKTOP_WINDOWING_ENTER_TRANSITIONS_BUGFIX(Flags::enableDesktopWindowingEnterTransitionBugfix, true),
    ENABLE_DESKTOP_WINDOWING_EXIT_BY_MINIMIZE_TRANSITION_BUGFIX(Flags::enableDesktopWindowingExitByMinimizeTransitionBugfix, true),
    ENABLE_DESKTOP_WINDOWING_EXIT_TRANSITIONS_BUGFIX(Flags::enableDesktopWindowingExitTransitionsBugfix, true),
    ENABLE_DESKTOP_WINDOWING_HSUM(Flags::enableDesktopWindowingHsum, true),
    ENABLE_DESKTOP_WINDOWING_IMMERSIVE_HANDLE_HIDING(Flags::enableDesktopWindowingImmersiveHandleHiding, true),
    ENABLE_DESKTOP_WINDOWING_MODALS_POLICY(Flags::enableDesktopWindowingModalsPolicy, true),
    ENABLE_DESKTOP_WINDOWING_MODE(Flags::enableDesktopWindowingMode, true),
    ENABLE_DESKTOP_WINDOWING_MULTI_INSTANCE_FEATURES(Flags::enableDesktopWindowingMultiInstanceFeatures, true),
    ENABLE_DESKTOP_WINDOWING_PERSISTENCE(Flags::enableDesktopWindowingPersistence, true),
    ENABLE_DESKTOP_WINDOWING_PIP(Flags::enableDesktopWindowingPip, false),
    ENABLE_DESKTOP_WINDOWING_QUICK_SWITCH(Flags::enableDesktopWindowingQuickSwitch, true),
    ENABLE_DESKTOP_WINDOWING_SCVH_CACHE(Flags::enableDesktopWindowingScvhCacheBugFix, true),
    ENABLE_DESKTOP_WINDOWING_SIZE_CONSTRAINTS(Flags::enableDesktopWindowingSizeConstraints, true),
    ENABLE_DESKTOP_WINDOWING_TASKBAR_RUNNING_APPS(Flags::enableDesktopWindowingTaskbarRunningApps, true),
    ENABLE_DESKTOP_WINDOWING_TASK_LIMIT(Flags::enableDesktopWindowingTaskLimit, true),
    ENABLE_DESKTOP_WINDOWING_WALLPAPER_ACTIVITY(Flags::enableDesktopWindowingWallpaperActivity, true),
    ENABLE_DRAG_RESIZE_SET_UP_IN_BG_THREAD(Flags::enableDragResizeSetUpInBgThread, true),
    ENABLE_DRAG_TO_DESKTOP_INCOMING_TRANSITIONS_BUGFIX(Flags::enableDragToDesktopIncomingTransitionsBugfix, true),
    ENABLE_FULLY_IMMERSIVE_IN_DESKTOP(Flags::enableFullyImmersiveInDesktop, true),
    ENABLE_HANDLE_INPUT_FIX(Flags::enableHandleInputFix, true),
    ENABLE_HOLD_TO_DRAG_APP_HANDLE(Flags::enableHoldToDragAppHandle, true),
    ENABLE_INPUT_LAYER_TRANSITION_FIX(Flags::enableInputLayerTransitionFix, true),
    ENABLE_MINIMIZE_BUTTON(Flags::enableMinimizeButton, true),
    ENABLE_MODALS_FULLSCREEN_WITH_PERMISSIONS(Flags::enableModalsFullscreenWithPermission, true),
    ENABLE_OPAQUE_BACKGROUND_FOR_TRANSPARENT_WINDOWS(Flags::enableOpaqueBackgroundForTransparentWindows, true),
    ENABLE_QUICKSWITCH_DESKTOP_SPLIT_BUGFIX(Flags::enableQuickswitchDesktopSplitBugfix, true),
    ENABLE_REQUEST_FULLSCREEN_BUGFIX(Flags::enableRequestFullscreenBugfix, true),
    ENABLE_RESIZING_METRICS(Flags::enableResizingMetrics, true),
    ENABLE_RESTORE_TO_PREVIOUS_SIZE_FROM_DESKTOP_IMMERSIVE(Flags::enableRestoreToPreviousSizeFromDesktopImmersive, true),
    ENABLE_SHELL_INITIAL_BOUNDS_REGRESSION_BUG_FIX(Flags::enableShellInitialBoundsRegressionBugFix, true),
    ENABLE_START_LAUNCH_TRANSITION_FROM_TASKBAR_BUGFIX(Flags::enableStartLaunchTransitionFromTaskbarBugfix, true),
    ENABLE_TASKBAR_OVERFLOW(Flags::enableTaskbarOverflow, false),
    ENABLE_TASKBAR_RECENTS_LAYOUT_TRANSITION(Flags::enableTaskbarRecentsLayoutTransition, false),
    ENABLE_TASK_RESIZING_KEYBOARD_SHORTCUTS(Flags::enableTaskResizingKeyboardShortcuts, true),
    ENABLE_TASK_STACK_OBSERVER_IN_SHELL(Flags::enableTaskStackObserverInShell, true),
    ENABLE_THEMED_APP_HEADERS(Flags::enableThemedAppHeaders, true),
    ENABLE_TILE_RESIZING(Flags::enableTileResizing, true),
    ENABLE_TOP_VISIBLE_ROOT_TASK_PER_USER_TRACKING(Flags::enableTopVisibleRootTaskPerUserTracking, true),
    ENABLE_VISUAL_INDICATOR_IN_TRANSITION_BUGFIX(Flags::enableVisualIndicatorInTransitionBugfix, true),
    ENABLE_WINDOWING_DYNAMIC_INITIAL_BOUNDS(Flags::enableWindowingDynamicInitialBounds, true),
    ENABLE_WINDOWING_EDGE_DRAG_RESIZE(Flags::enableWindowingEdgeDragResize, true),
    ENABLE_WINDOWING_SCALED_RESIZING(Flags::enableWindowingScaledResizing, true),
    ENABLE_WINDOWING_TRANSITION_HANDLERS_OBSERVERS(Flags::enableWindowingTransitionHandlersObservers, false),
    EXCLUDE_CAPTION_FROM_APP_BOUNDS(Flags::excludeCaptionFromAppBounds, true),
    FORCE_CLOSE_TOP_TRANSPARENT_FULLSCREEN_TASK(Flags::forceCloseTopTransparentFullscreenTask, false),
    IGNORE_ASPECT_RATIO_RESTRICTIONS_FOR_RESIZEABLE_FREEFORM_ACTIVITIES(Flags::ignoreAspectRatioRestrictionsForResizeableFreeformActivities, true),
    INCLUDE_TOP_TRANSPARENT_FULLSCREEN_TASK_IN_DESKTOP_HEURISTIC(Flags::includeTopTransparentFullscreenTaskInDesktopHeuristic, true),
    INHERIT_TASK_BOUNDS_FOR_TRAMPOLINE_TASK_LAUNCHES(Flags::inheritTaskBoundsForTrampolineTaskLaunches, true),
    SKIP_DECOR_VIEW_RELAYOUT_WHEN_CLOSING_BUGFIX(Flags::skipDecorViewRelayoutWhenClosingBugfix, true);

    private static final String TAG = "DesktopModeFlags";
    private final BooleanSupplier mFlagFunction;
    private final boolean mShouldOverrideByDevOption;
    private static ToggleOverride sCachedToggleOverride;
    public static final String SYSTEM_PROPERTY_NAME = "persist.wm.debug.desktop_experience_devopts";

    private DesktopModeFlags(BooleanSupplier flagFunction, boolean shouldOverrideByDevOption) {
        this.mFlagFunction = flagFunction;
        this.mShouldOverrideByDevOption = shouldOverrideByDevOption;
    }

    public boolean isTrue() {
        return DesktopModeFlags.isFlagTrue(this.mFlagFunction, this.mShouldOverrideByDevOption);
    }

    public static boolean isDesktopModeForcedEnabled() {
        return DesktopModeFlags.getToggleOverride() == ToggleOverride.OVERRIDE_ON;
    }

    private static boolean isFlagTrue(BooleanSupplier flagFunction, boolean shouldOverrideByDevOption) {
        if (!shouldOverrideByDevOption) {
            return flagFunction.getAsBoolean();
        }
        if (Flags.showDesktopExperienceDevOption()) {
            boolean bl;
            switch (DesktopModeFlags.getToggleOverride().ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
                case 1: {
                    bl = flagFunction.getAsBoolean();
                    break;
                }
                case 2: {
                    bl = true;
                }
            }
            return bl;
        }
        if (Flags.showDesktopWindowingDevOption()) {
            boolean bl;
            boolean shouldToggleBeEnabledByDefault = Flags.enableDesktopWindowingMode();
            switch (DesktopModeFlags.getToggleOverride().ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    bl = flagFunction.getAsBoolean();
                    break;
                }
                case 1: {
                    if (!shouldToggleBeEnabledByDefault && flagFunction.getAsBoolean()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    bl = !shouldToggleBeEnabledByDefault || flagFunction.getAsBoolean();
                }
            }
            return bl;
        }
        return flagFunction.getAsBoolean();
    }

    private static ToggleOverride getToggleOverride() {
        ToggleOverride override;
        if (sCachedToggleOverride != null) {
            return sCachedToggleOverride;
        }
        sCachedToggleOverride = override = DesktopModeFlags.getToggleOverrideFromSystem();
        Log.d(TAG, "Toggle override initialized to: " + (Object)((Object)override));
        return override;
    }

    private static ToggleOverride getToggleOverrideFromSystem() {
        int settingValue;
        if (Flags.showDesktopExperienceDevOption()) {
            settingValue = SystemProperties.getInt(SYSTEM_PROPERTY_NAME, ToggleOverride.OVERRIDE_UNSET.getSetting());
        } else {
            Application application = ActivityThread.currentApplication();
            if (application == null) {
                Log.w(TAG, "Could not get the current application.");
                return ToggleOverride.OVERRIDE_UNSET;
            }
            ContentResolver contentResolver = application.getContentResolver();
            if (contentResolver == null) {
                Log.w(TAG, "Could not get the content resolver for the application.");
                return ToggleOverride.OVERRIDE_UNSET;
            }
            settingValue = Settings.Global.getInt(contentResolver, "override_desktop_mode_features", ToggleOverride.OVERRIDE_UNSET.getSetting());
        }
        return ToggleOverride.fromSetting(settingValue, ToggleOverride.OVERRIDE_UNSET);
    }

    public static enum ToggleOverride {
        OVERRIDE_UNSET,
        OVERRIDE_OFF,
        OVERRIDE_ON;


        public int getSetting() {
            int n;
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = -1;
                }
            }
            return n;
        }

        public static ToggleOverride fromSetting(int setting, @Nullable ToggleOverride fallback) {
            ToggleOverride toggleOverride;
            switch (setting) {
                case 1: {
                    toggleOverride = OVERRIDE_ON;
                    break;
                }
                case 0: {
                    toggleOverride = OVERRIDE_OFF;
                    break;
                }
                case -1: {
                    toggleOverride = OVERRIDE_UNSET;
                    break;
                }
                default: {
                    toggleOverride = fallback;
                }
            }
            return toggleOverride;
        }
    }

    public static class DesktopModeFlag {
        private final BooleanSupplier mFlagFunction;
        private final boolean mShouldOverrideByDevOption;

        public DesktopModeFlag(BooleanSupplier flagFunction, boolean shouldOverrideByDevOption) {
            this.mFlagFunction = flagFunction;
            this.mShouldOverrideByDevOption = shouldOverrideByDevOption;
        }

        public boolean isTrue() {
            return DesktopModeFlags.isFlagTrue(this.mFlagFunction, this.mShouldOverrideByDevOption);
        }
    }
}

