/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacksController;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.window.ConfigurationDispatcher;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;

public class SystemUiContext
extends ContextWrapper
implements ConfigurationDispatcher {
    private final ComponentCallbacksController mCallbacksController = new ComponentCallbacksController();

    public SystemUiContext(Context base) {
        super(base);
        if (!Flags.trackSystemUiContextBeforeWms()) {
            throw new UnsupportedOperationException("SystemUiContext can only be used after flag is enabled.");
        }
    }

    @Override
    public void registerComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.registerCallbacks(callback);
    }

    @Override
    public void unregisterComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.unregisterCallbacks(callback);
    }

    @Override
    public void dispatchConfigurationChanged(@NonNull Configuration newConfig) {
        this.mCallbacksController.dispatchConfigurationChanged(newConfig);
    }

    @Override
    public boolean shouldReportPrivateChanges() {
        return true;
    }
}

