/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.WindowContainerToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaskFragmentInfo
implements Parcelable {
    @NonNull
    private final IBinder mFragmentToken;
    @NonNull
    private final WindowContainerToken mToken;
    @NonNull
    private final Configuration mConfiguration = new Configuration();
    private final int mRunningActivityCount;
    private final boolean mIsVisible;
    @NonNull
    private final List<IBinder> mActivities = new ArrayList<IBinder>();
    @NonNull
    private final List<IBinder> mInRequestedTaskFragmentActivities = new ArrayList<IBinder>();
    private final Point mPositionInParent = new Point();
    private final boolean mIsTaskClearedForReuse;
    private final boolean mIsTaskFragmentClearedForPip;
    private final boolean mIsClearedForReorderActivityToFront;
    @NonNull
    private final Point mMinimumDimensions = new Point();
    private final boolean mIsTopNonFishingChild;
    @NonNull
    public static final Parcelable.Creator<TaskFragmentInfo> CREATOR = new Parcelable.Creator<TaskFragmentInfo>(){

        @Override
        public TaskFragmentInfo createFromParcel(Parcel in) {
            return new TaskFragmentInfo(in);
        }

        public TaskFragmentInfo[] newArray(int size) {
            return new TaskFragmentInfo[size];
        }
    };

    public TaskFragmentInfo(@NonNull IBinder fragmentToken, @NonNull WindowContainerToken token, @NonNull Configuration configuration, int runningActivityCount, boolean isVisible, @NonNull List<IBinder> activities, @NonNull List<IBinder> inRequestedTaskFragmentActivities, @NonNull Point positionInParent, boolean isTaskClearedForReuse, boolean isTaskFragmentClearedForPip, boolean isClearedForReorderActivityToFront, @NonNull Point minimumDimensions, boolean isTopNonFinishingChild) {
        this.mFragmentToken = Objects.requireNonNull(fragmentToken);
        this.mToken = Objects.requireNonNull(token);
        this.mConfiguration.setTo(configuration);
        this.mRunningActivityCount = runningActivityCount;
        this.mIsVisible = isVisible;
        this.mActivities.addAll(activities);
        this.mInRequestedTaskFragmentActivities.addAll(inRequestedTaskFragmentActivities);
        this.mPositionInParent.set(positionInParent);
        this.mIsTaskClearedForReuse = isTaskClearedForReuse;
        this.mIsTaskFragmentClearedForPip = isTaskFragmentClearedForPip;
        this.mIsClearedForReorderActivityToFront = isClearedForReorderActivityToFront;
        this.mMinimumDimensions.set(minimumDimensions);
        this.mIsTopNonFishingChild = isTopNonFinishingChild;
    }

    @NonNull
    public IBinder getFragmentToken() {
        return this.mFragmentToken;
    }

    @NonNull
    public WindowContainerToken getToken() {
        return this.mToken;
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public boolean isEmpty() {
        return this.mRunningActivityCount == 0;
    }

    public boolean hasRunningActivity() {
        return this.mRunningActivityCount > 0;
    }

    public int getRunningActivityCount() {
        return this.mRunningActivityCount;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    @NonNull
    public List<IBinder> getActivities() {
        return this.mActivities;
    }

    @NonNull
    public List<IBinder> getActivitiesRequestedInTaskFragment() {
        return this.mInRequestedTaskFragmentActivities;
    }

    @NonNull
    public Point getPositionInParent() {
        return this.mPositionInParent;
    }

    public boolean isTaskClearedForReuse() {
        return this.mIsTaskClearedForReuse;
    }

    public boolean isTaskFragmentClearedForPip() {
        return this.mIsTaskFragmentClearedForPip;
    }

    public boolean isClearedForReorderActivityToFront() {
        return this.mIsClearedForReorderActivityToFront;
    }

    public int getWindowingMode() {
        return this.mConfiguration.windowConfiguration.getWindowingMode();
    }

    public int getMinimumWidth() {
        return this.mMinimumDimensions.x;
    }

    public int getMinimumHeight() {
        return this.mMinimumDimensions.y;
    }

    public boolean isTopNonFinishingChild() {
        return this.mIsTopNonFishingChild;
    }

    public boolean equalsForTaskFragmentOrganizer(@Nullable TaskFragmentInfo that) {
        if (that == null) {
            return false;
        }
        return this.mFragmentToken.equals(that.mFragmentToken) && this.mToken.equals(that.mToken) && this.mRunningActivityCount == that.mRunningActivityCount && this.mIsVisible == that.mIsVisible && this.getWindowingMode() == that.getWindowingMode() && this.mActivities.equals(that.mActivities) && this.mInRequestedTaskFragmentActivities.equals(that.mInRequestedTaskFragmentActivities) && this.mPositionInParent.equals(that.mPositionInParent) && this.mIsTaskClearedForReuse == that.mIsTaskClearedForReuse && this.mIsTaskFragmentClearedForPip == that.mIsTaskFragmentClearedForPip && this.mIsClearedForReorderActivityToFront == that.mIsClearedForReorderActivityToFront && this.mMinimumDimensions.equals(that.mMinimumDimensions) && this.mIsTopNonFishingChild == that.mIsTopNonFishingChild;
    }

    private TaskFragmentInfo(Parcel in) {
        this.mFragmentToken = in.readStrongBinder();
        this.mToken = in.readTypedObject(WindowContainerToken.CREATOR);
        this.mConfiguration.readFromParcel(in);
        this.mRunningActivityCount = in.readInt();
        this.mIsVisible = in.readBoolean();
        in.readBinderList(this.mActivities);
        in.readBinderList(this.mInRequestedTaskFragmentActivities);
        this.mPositionInParent.readFromParcel(in);
        this.mIsTaskClearedForReuse = in.readBoolean();
        this.mIsTaskFragmentClearedForPip = in.readBoolean();
        this.mIsClearedForReorderActivityToFront = in.readBoolean();
        this.mMinimumDimensions.readFromParcel(in);
        this.mIsTopNonFishingChild = in.readBoolean();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStrongBinder(this.mFragmentToken);
        dest.writeTypedObject(this.mToken, flags);
        this.mConfiguration.writeToParcel(dest, flags);
        dest.writeInt(this.mRunningActivityCount);
        dest.writeBoolean(this.mIsVisible);
        dest.writeBinderList(this.mActivities);
        dest.writeBinderList(this.mInRequestedTaskFragmentActivities);
        this.mPositionInParent.writeToParcel(dest, flags);
        dest.writeBoolean(this.mIsTaskClearedForReuse);
        dest.writeBoolean(this.mIsTaskFragmentClearedForPip);
        dest.writeBoolean(this.mIsClearedForReorderActivityToFront);
        this.mMinimumDimensions.writeToParcel(dest, flags);
        dest.writeBoolean(this.mIsTopNonFishingChild);
    }

    public String toString() {
        return "TaskFragmentInfo{ fragmentToken=" + this.mFragmentToken + " token=" + this.mToken + " runningActivityCount=" + this.mRunningActivityCount + " isVisible=" + this.mIsVisible + " activities=" + this.mActivities + " inRequestedTaskFragmentActivities" + this.mInRequestedTaskFragmentActivities + " positionInParent=" + this.mPositionInParent + " isTaskClearedForReuse=" + this.mIsTaskClearedForReuse + " isTaskFragmentClearedForPip=" + this.mIsTaskFragmentClearedForPip + " mIsClearedForReorderActivityToFront=" + this.mIsClearedForReorderActivityToFront + " minimumDimensions=" + this.mMinimumDimensions + " isTopNonFinishingChild=" + this.mIsTopNonFishingChild + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

