/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacksController;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.window.ConfigurationDispatcher;
import android.window.WindowContextController;
import android.window.WindowProvider;
import android.window.WindowTokenClient;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.lang.ref.Reference;

public class WindowContext
extends ContextWrapper
implements WindowProvider,
ConfigurationDispatcher {
    private final WindowManager mWindowManager;
    private final int mType;
    @Nullable
    private final Bundle mOptions;
    private final ComponentCallbacksController mCallbacksController = new ComponentCallbacksController();
    private final WindowContextController mController;

    public WindowContext(@NonNull Context base, int type, @Nullable Bundle options) {
        super(base);
        this.mType = type;
        this.mOptions = options;
        this.mWindowManager = WindowManagerImpl.createWindowContextWindowManager((Context)this);
        WindowTokenClient token = (WindowTokenClient)this.getWindowContextToken();
        this.mController = new WindowContextController(token);
        Reference.reachabilityFence(this);
    }

    public void attachToDisplayArea() {
        this.mController.attachToDisplayArea(this.mType, this.getDisplayId(), this.mOptions);
    }

    public void reparentToDisplay(int displayId) {
        if (Flags.reparentWindowTokenApi()) {
            if (displayId == this.getDisplayId()) {
                return;
            }
            super.updateDisplay(displayId);
            this.mController.reparentToDisplayArea(this.mType, displayId, this.mOptions);
        }
    }

    @Override
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @VisibleForTesting
    public void release() {
        this.mController.detachIfNeeded();
        this.destroy();
    }

    @Override
    public void destroy() {
        try {
            this.mCallbacksController.clearCallbacks();
            this.getBaseContext().destroy();
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void registerComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.registerCallbacks(callback);
    }

    @Override
    public void unregisterComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.unregisterCallbacks(callback);
    }

    @Override
    public void dispatchConfigurationChanged(@NonNull Configuration newConfig) {
        this.mCallbacksController.dispatchConfigurationChanged(newConfig);
    }

    @Override
    public int getWindowType() {
        return this.mType;
    }

    @Override
    @Nullable
    public Bundle getWindowContextOptions() {
        return this.mOptions;
    }

    @Override
    public boolean shouldReportPrivateChanges() {
        return true;
    }
}

