/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.IApplicationThread;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Log;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import android.window.WindowContextInfo;
import android.window.WindowTokenClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;

public class WindowTokenClientController {
    private static final String TAG = WindowTokenClientController.class.getSimpleName();
    private static WindowTokenClientController sController;
    private final Object mLock = new Object();
    private final IApplicationThread mAppThread = ActivityThread.currentActivityThread().getApplicationThread();
    private final Handler mHandler = ActivityThread.currentActivityThread().getHandler();
    @GuardedBy(value={"mLock"})
    private final ArraySet<WindowTokenClient> mWindowTokenClients = new ArraySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static WindowTokenClientController getInstance() {
        Class<WindowTokenClientController> clazz = WindowTokenClientController.class;
        synchronized (WindowTokenClientController.class) {
            if (sController == null) {
                sController = new WindowTokenClientController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sController;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void overrideForTesting(@NonNull WindowTokenClientController controller) {
        Class<WindowTokenClientController> clazz = WindowTokenClientController.class;
        synchronized (WindowTokenClientController.class) {
            sController = controller;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    @NonNull
    public static WindowTokenClientController createInstanceForTesting() {
        return new WindowTokenClientController();
    }

    private WindowTokenClientController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Context getWindowContext(@NonNull IBinder clientToken) {
        if (!(clientToken instanceof WindowTokenClient)) {
            return null;
        }
        WindowTokenClient windowTokenClient = (WindowTokenClient)clientToken;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mWindowTokenClients.contains(windowTokenClient)) {
                return null;
            }
        }
        return windowTokenClient.getContext();
    }

    public boolean attachToDisplayArea(@NonNull WindowTokenClient client, int type, int displayId, @Nullable Bundle options) {
        WindowContextInfo info;
        try {
            info = this.getWindowManagerService().attachWindowContextToDisplayArea(this.mAppThread, client, type, displayId, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (info == null) {
            return false;
        }
        this.onWindowContextTokenAttached(client, info, false);
        return true;
    }

    public boolean attachToDisplayContent(@NonNull WindowTokenClient client, int displayId) {
        WindowContextInfo info;
        IWindowManager wms = this.getWindowManagerService();
        if (wms == null) {
            if (Flags.trackSystemUiContextBeforeWms()) {
                this.recordWindowContextToken(client);
            }
            return false;
        }
        try {
            info = wms.attachWindowContextToDisplayContent(this.mAppThread, client, displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (Exception e) {
            Log.e(TAG, "Failed attachToDisplayContent", e);
            return false;
        }
        if (info == null) {
            return false;
        }
        this.onWindowContextTokenAttached(client, info, false);
        return true;
    }

    public boolean attachToWindowToken(@NonNull WindowTokenClient client, @NonNull IBinder windowToken) {
        WindowContextInfo info;
        try {
            info = this.getWindowManagerService().attachWindowContextToWindowToken(this.mAppThread, client, windowToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (info == null) {
            return false;
        }
        this.onWindowContextTokenAttached(client, info, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachIfNeeded(@NonNull WindowTokenClient client) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mWindowTokenClients.remove(client)) {
                return;
            }
        }
        IWindowManager wms = this.getWindowManagerService();
        if (wms == null) {
            return;
        }
        try {
            wms.detachWindowContext(client);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reparentToDisplayArea(@NonNull WindowTokenClient client, int displayId) {
        try {
            if (!this.getWindowManagerService().reparentWindowContextToDisplayArea(this.mAppThread, client, displayId)) {
                Log.e(TAG, "Didn't succeed reparenting of " + client + " to displayId=" + displayId);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void onWindowContextTokenAttached(@NonNull WindowTokenClient client, @NonNull WindowContextInfo info, boolean shouldReportConfigChange) {
        this.recordWindowContextToken(client);
        if (shouldReportConfigChange) {
            client.postOnConfigurationChanged(info.getConfiguration(), info.getDisplayId());
        } else {
            client.onConfigurationChanged(info.getConfiguration(), info.getDisplayId(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordWindowContextToken(@NonNull WindowTokenClient client) {
        Object object = this.mLock;
        synchronized (object) {
            this.mWindowTokenClients.add(client);
        }
    }

    public void onWindowContextInfoChanged(@NonNull IBinder clientToken, @NonNull WindowContextInfo info) {
        WindowTokenClient windowTokenClient = this.getWindowTokenClientIfAttached(clientToken);
        if (windowTokenClient != null) {
            windowTokenClient.onConfigurationChanged(info.getConfiguration(), info.getDisplayId());
        }
    }

    public void onWindowContextWindowRemoved(@NonNull IBinder clientToken) {
        WindowTokenClient windowTokenClient = this.getWindowTokenClientIfAttached(clientToken);
        if (windowTokenClient != null) {
            windowTokenClient.onWindowTokenRemoved();
        }
    }

    public void onWindowConfigurationChanged(@NonNull IBinder clientToken, @NonNull Configuration config, int displayId) {
        WindowTokenClient windowTokenClient = this.getWindowTokenClientIfAttached(clientToken);
        if (windowTokenClient != null) {
            if (this.mHandler.getLooper().isCurrentThread()) {
                windowTokenClient.onConfigurationChanged(config, displayId);
            } else {
                windowTokenClient.postOnConfigurationChanged(config, displayId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private WindowTokenClient getWindowTokenClientIfAttached(@NonNull IBinder clientToken) {
        if (!(clientToken instanceof WindowTokenClient)) {
            Log.e(TAG, "getWindowTokenClient failed for non-window token " + clientToken);
            return null;
        }
        WindowTokenClient windowTokenClient = (WindowTokenClient)clientToken;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mWindowTokenClients.contains(windowTokenClient)) {
                Log.w(TAG, "Can't find attached WindowTokenClient for " + clientToken);
                return null;
            }
        }
        return windowTokenClient;
    }

    @VisibleForTesting
    @Nullable
    public IWindowManager getWindowManagerService() {
        return WindowManagerGlobal.getWindowManagerService();
    }
}

