/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.IUriGrantsManager;
import android.app.SharedElementCallback;
import android.app.UriGrantsManager;
import android.app.prediction.AppPredictionContext;
import android.app.prediction.AppPredictionManager;
import android.app.prediction.AppPredictor;
import android.app.prediction.AppTarget;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.AppTargetId;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.service.chooser.ChooserTarget;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.HashedStringCache;
import android.util.Log;
import android.util.PluralsMessageFormatter;
import android.util.Size;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Space;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.AppPredictionServiceResolverComparator;
import com.android.internal.app.ChooserActivityLogger;
import com.android.internal.app.ChooserActivityLoggerImpl;
import com.android.internal.app.ChooserGridLayoutManager;
import com.android.internal.app.ChooserListAdapter;
import com.android.internal.app.ChooserMultiProfilePagerAdapter;
import com.android.internal.app.ChooserStackedAppDialogFragment;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.NoCrossProfileEmptyStateProvider;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverAppPredictorCallback;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.ResolverRankerServiceResolverComparator;
import com.android.internal.app.ResolverViewPager;
import com.android.internal.app.chooser.ChooserTargetInfo;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.app.chooser.MultiDisplayResolveInfo;
import com.android.internal.app.chooser.NotSelectableTargetInfo;
import com.android.internal.app.chooser.SelectableTargetInfo;
import com.android.internal.app.chooser.TargetInfo;
import com.android.internal.content.PackageMonitor;
import com.android.internal.hidden_from_bootclasspath.android.service.chooser.Flags;
import com.android.internal.lang.System_Delegate;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.widget.GridLayoutManager;
import com.android.internal.widget.RecyclerView;
import com.android.internal.widget.ResolverDrawerLayout;
import com.android.internal.widget.ViewPager;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ChooserActivity
extends ResolverActivity
implements ChooserListAdapter.ChooserListCommunicator,
SelectableTargetInfo.SelectableTargetInfoCommunicator {
    private static final String TAG = "ChooserActivity";
    private AppPredictor mPersonalAppPredictor;
    private AppPredictor mWorkAppPredictor;
    private boolean mShouldDisplayLandscape;
    public static final String EXTRA_PRIVATE_RETAIN_IN_ON_STOP = "com.android.internal.app.ChooserActivity.EXTRA_PRIVATE_RETAIN_IN_ON_STOP";
    public static final String FIRST_IMAGE_PREVIEW_TRANSITION_NAME = "screenshot_preview_image";
    private static final String PREF_NUM_SHEET_EXPANSIONS = "pref_num_sheet_expansions";
    private static final String CHIP_LABEL_METADATA_KEY = "android.service.chooser.chip_label";
    private static final String CHIP_ICON_METADATA_KEY = "android.service.chooser.chip_icon";
    private static final boolean DEBUG = true;
    private static final boolean USE_PREDICTION_MANAGER_FOR_SHARE_ACTIVITIES = true;
    private static final String APP_PREDICTION_SHARE_UI_SURFACE = "share";
    public static final String LAUNCH_LOCATION_DIRECT_SHARE = "direct_share";
    public static final String CHOOSER_TARGET = "chooser_target";
    private static final String SHORTCUT_TARGET = "shortcut_target";
    private static final int APP_PREDICTION_SHARE_TARGET_QUERY_PACKAGE_LIMIT = 20;
    public static final String APP_PREDICTION_INTENT_FILTER_KEY = "intent_filter";
    private static final String SHARED_TEXT_KEY = "shared_text";
    private static final String PLURALS_COUNT = "count";
    private static final String PLURALS_FILE_NAME = "file_name";
    private static final String IMAGE_EDITOR_SHARED_ELEMENT = "screenshot_preview_image";
    private boolean mIsAppPredictorComponentAvailable;
    private Map<ChooserTarget, AppTarget> mDirectShareAppTargetCache;
    private Map<ChooserTarget, ShortcutInfo> mDirectShareShortcutInfoCache;
    public static final int TARGET_TYPE_DEFAULT = 0;
    public static final int TARGET_TYPE_CHOOSER_TARGET = 1;
    public static final int TARGET_TYPE_SHORTCUTS_FROM_SHORTCUT_MANAGER = 2;
    public static final int TARGET_TYPE_SHORTCUTS_FROM_PREDICTION_SERVICE = 3;
    public static final int SELECTION_TYPE_SERVICE = 1;
    public static final int SELECTION_TYPE_APP = 2;
    public static final int SELECTION_TYPE_STANDARD = 3;
    public static final int SELECTION_TYPE_COPY = 4;
    public static final int SELECTION_TYPE_NEARBY = 5;
    public static final int SELECTION_TYPE_EDIT = 6;
    private static final int SCROLL_STATUS_IDLE = 0;
    private static final int SCROLL_STATUS_SCROLLING_VERTICAL = 1;
    private static final int SCROLL_STATUS_SCROLLING_HORIZONTAL = 2;
    protected ChooserActivityLogger mChooserActivityLogger;
    private static final int NO_DIRECT_SHARE_ANIM_IN_MILLIS = 200;
    private static final float DIRECT_SHARE_EXPANSION_RATE = 0.78f;
    private static final int DEFAULT_SALT_EXPIRATION_DAYS = 7;
    private int mMaxHashSaltDays = DeviceConfig.getInt("systemui", "hash_salt_max_days", 7);
    private static final boolean DEFAULT_IS_NEARBY_SHARE_FIRST_TARGET_IN_RANKED_APP = false;
    private boolean mIsNearbyShareFirstTargetInRankedApp = DeviceConfig.getBoolean("systemui", "is_nearby_share_first_target_in_ranked_app", false);
    private static final int DEFAULT_LIST_VIEW_UPDATE_DELAY_MS = 0;
    private static final int URI_PERMISSION_INTENT_FLAGS = 195;
    @VisibleForTesting
    int mListViewUpdateDelayMs = DeviceConfig.getInt("systemui", "sharesheet_list_view_update_delay", 0);
    private Bundle mReplacementExtras;
    private IntentSender mChosenComponentSender;
    private IntentSender mRefinementIntentSender;
    private RefinementResultReceiver mRefinementResultReceiver;
    private ChooserTarget[] mCallerChooserTargets;
    private ComponentName[] mFilteredComponentNames;
    private Intent mReferrerFillInIntent;
    private long mChooserShownTime;
    protected boolean mIsSuccessfullySelected;
    private long mQueriedSharingShortcutsTimeMs;
    private int mCurrAvailableWidth = 0;
    private Insets mLastAppliedInsets = null;
    private int mLastNumberOfChildren = -1;
    private int mMaxTargetsPerRow = 1;
    private static final String TARGET_DETAILS_FRAGMENT_TAG = "targetDetailsFragment";
    private static final int MAX_LOG_RANK_POSITION = 12;
    private static final int MAX_EXTRA_INITIAL_INTENTS = 2;
    private static final int MAX_EXTRA_CHOOSER_TARGETS = 2;
    private SharedPreferences mPinnedSharedPrefs;
    private static final String PINNED_SHARED_PREFS_NAME = "chooser_pin_settings";
    protected static final int CONTENT_PREVIEW_IMAGE = 1;
    protected static final int CONTENT_PREVIEW_FILE = 2;
    protected static final int CONTENT_PREVIEW_TEXT = 3;
    protected MetricsLogger mMetricsLogger;
    private ContentPreviewCoordinator mPreviewCoord;
    private int mScrollStatus = 0;
    @VisibleForTesting
    protected ChooserMultiProfilePagerAdapter mChooserMultiProfilePagerAdapter;
    private final EnterTransitionAnimationDelegate mEnterTransitionAnimationDelegate = new EnterTransitionAnimationDelegate();
    private boolean mRemoveSharedElements = false;
    private View mContentView = null;
    private final ChooserHandler mChooserHandler = new ChooserHandler();

    @UnsupportedAppUsage
    public ChooserActivity() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        boolean shouldFilterNearby;
        Parcelable[] targetsParcelable;
        if (Settings.Secure.getIntForUser(this.getContentResolver(), "secure_frp_mode", 0, this.getUserId()) == 1) {
            Log.e(TAG, "Sharing disabled due to active FRP lock.");
            super.onCreate(savedInstanceState);
            this.finish();
            return;
        }
        long intentReceivedTime = System_Delegate.currentTimeMillis();
        this.mLatencyTracker.onActionStart(16);
        this.getChooserActivityLogger().logSharesheetTriggered();
        this.mIsAppPredictorComponentAvailable = this.isAppPredictionServiceAvailable();
        this.mIsSuccessfullySelected = false;
        Intent intent = this.getIntent();
        Object targetParcelable = intent.getParcelableExtra("android.intent.extra.INTENT");
        if (targetParcelable instanceof Uri) {
            try {
                targetParcelable = Intent.parseUri(targetParcelable.toString(), 1);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (!(targetParcelable instanceof Intent)) {
            Log.w(TAG, "Target is not an intent: " + targetParcelable);
            this.finish();
            super.onCreate(null);
            return;
        }
        Intent target = (Intent)targetParcelable;
        if (target != null) {
            this.modifyTargetIntent(target);
        }
        if ((targetsParcelable = intent.getParcelableArrayExtra("android.intent.extra.ALTERNATE_INTENTS")) != null) {
            boolean offset = target == null;
            Intent[] additionalTargets = new Intent[offset ? targetsParcelable.length - 1 : targetsParcelable.length];
            for (int i = 0; i < targetsParcelable.length; ++i) {
                if (!(targetsParcelable[i] instanceof Intent)) {
                    Log.w(TAG, "EXTRA_ALTERNATE_INTENTS array entry #" + i + " is not an Intent: " + targetsParcelable[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent additionalTarget = (Intent)targetsParcelable[i];
                if (i == 0 && target == null) {
                    target = additionalTarget;
                    this.modifyTargetIntent(target);
                    continue;
                }
                additionalTargets[offset ? i - 1 : i] = additionalTarget;
                this.modifyTargetIntent(additionalTarget);
            }
            this.setAdditionalTargets(additionalTargets);
        }
        this.mReplacementExtras = intent.getBundleExtra("android.intent.extra.REPLACEMENT_EXTRAS");
        CharSequence title = null;
        if (target != null) {
            if (!this.isSendAction(target)) {
                title = intent.getCharSequenceExtra("android.intent.extra.TITLE");
            } else {
                Log.w(TAG, "Ignoring intent's EXTRA_TITLE, deprecated in P. You may wish to set a preview title by using EXTRA_TITLE property of the wrapped EXTRA_INTENT.");
            }
        }
        int defaultTitleRes = 0;
        if (title == null) {
            defaultTitleRes = 17039847;
        }
        Parcelable[] pa = intent.getParcelableArrayExtra("android.intent.extra.INITIAL_INTENTS");
        Intent[] initialIntents = null;
        if (pa != null) {
            int count = Math.min(pa.length, 2);
            initialIntents = new Intent[count];
            for (int i = 0; i < count; ++i) {
                if (!(pa[i] instanceof Intent)) {
                    Log.w(TAG, "Initial intent #" + i + " not an Intent: " + pa[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent in = (Intent)pa[i];
                this.modifyTargetIntent(in);
                initialIntents[i] = in;
            }
        }
        this.mReferrerFillInIntent = new Intent().putExtra("android.intent.extra.REFERRER", this.getReferrer());
        this.mChosenComponentSender = intent.getParcelableExtra("android.intent.extra.CHOSEN_COMPONENT_INTENT_SENDER", IntentSender.class);
        this.mRefinementIntentSender = intent.getParcelableExtra("android.intent.extra.CHOOSER_REFINEMENT_INTENT_SENDER", IntentSender.class);
        this.setSafeForwardingMode(true);
        this.mPinnedSharedPrefs = ChooserActivity.getPinnedSharedPrefs(this);
        pa = intent.getParcelableArrayExtra("android.intent.extra.EXCLUDE_COMPONENTS");
        ComponentName nearbySharingComponent = this.getNearbySharingComponent();
        boolean bl = shouldFilterNearby = !this.shouldNearbyShareBeFirstInRankedRow() && nearbySharingComponent != null;
        if (pa != null) {
            ComponentName[] names = new ComponentName[pa.length + (shouldFilterNearby ? 1 : 0)];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof ComponentName)) {
                    Log.w(TAG, "Filtered component #" + i + " not a ComponentName: " + pa[i]);
                    names = null;
                    break;
                }
                names[i] = (ComponentName)pa[i];
            }
            if (shouldFilterNearby) {
                names[names.length - 1] = nearbySharingComponent;
            }
            this.mFilteredComponentNames = names;
        } else if (shouldFilterNearby) {
            this.mFilteredComponentNames = new ComponentName[1];
            this.mFilteredComponentNames[0] = nearbySharingComponent;
        }
        pa = intent.getParcelableArrayExtra("android.intent.extra.CHOOSER_TARGETS");
        if (pa != null) {
            int count = Math.min(pa.length, 2);
            ChooserTarget[] targets = new ChooserTarget[count];
            for (int i = 0; i < count; ++i) {
                if (!(pa[i] instanceof ChooserTarget)) {
                    Log.w(TAG, "Chooser target #" + i + " not a ChooserTarget: " + pa[i]);
                    targets = null;
                    break;
                }
                ChooserTarget chooserTarget = (ChooserTarget)pa[i];
                if (!this.hasValidIcon(chooserTarget)) {
                    chooserTarget = ChooserActivity.removeIcon(chooserTarget);
                }
                targets[i] = chooserTarget;
            }
            this.mCallerChooserTargets = targets;
        }
        this.mMaxTargetsPerRow = this.getResources().getInteger(17694790);
        this.mShouldDisplayLandscape = this.shouldDisplayLandscape(this.getResources().getConfiguration().orientation);
        this.setRetainInOnStop(intent.getBooleanExtra(EXTRA_PRIVATE_RETAIN_IN_ON_STOP, false));
        super.onCreate(savedInstanceState, target, title, defaultTitleRes, initialIntents, null, false);
        this.mChooserShownTime = System_Delegate.currentTimeMillis();
        long systemCost = this.mChooserShownTime - intentReceivedTime;
        this.getMetricsLogger().write(new LogMaker(214).setSubtype(this.isWorkProfile() ? 2 : 1).addTaggedData(1649, target.getType()).addTaggedData(1653, systemCost));
        if (this.mResolverDrawerLayout != null) {
            this.mResolverDrawerLayout.addOnLayoutChangeListener(this::handleLayoutChange);
            if (this.isSendAction(target)) {
                this.mResolverDrawerLayout.setOnScrollChangeListener(this::handleScroll);
            }
            this.mResolverDrawerLayout.setOnCollapsedChangedListener(new ResolverDrawerLayout.OnCollapsedChangedListener(){
                private boolean mWrittenOnce = false;

                @Override
                public void onCollapsedChanged(boolean isCollapsed) {
                    if (!isCollapsed && !this.mWrittenOnce) {
                        ChooserActivity.this.incrementNumSheetExpansions();
                        this.mWrittenOnce = true;
                    }
                    ChooserActivity.this.getChooserActivityLogger().logSharesheetExpansionChanged(isCollapsed);
                }
            });
        }
        Log.d(TAG, "System Time Cost is " + systemCost);
        this.getChooserActivityLogger().logShareStarted(259, this.getReferrerPackageName(), target.getType(), this.mCallerChooserTargets == null ? 0 : this.mCallerChooserTargets.length, initialIntents == null ? 0 : initialIntents.length, this.isWorkProfile(), this.findPreferredContentPreview(this.getTargetIntent(), this.getContentResolver()), target.getAction());
        this.mDirectShareShortcutInfoCache = new HashMap<ChooserTarget, ShortcutInfo>();
        this.setEnterSharedElementCallback(new SharedElementCallback(){

            @Override
            public void onMapSharedElements(List<String> names, Map<String, View> sharedElements) {
                if (ChooserActivity.this.mRemoveSharedElements) {
                    names.remove("screenshot_preview_image");
                    sharedElements.remove("screenshot_preview_image");
                }
                super.onMapSharedElements(names, sharedElements);
                ChooserActivity.this.mRemoveSharedElements = false;
            }
        });
        this.mEnterTransitionAnimationDelegate.postponeTransition();
    }

    @Override
    protected int appliedThemeResId() {
        return 16974852;
    }

    private AppPredictor setupAppPredictorForUser(UserHandle userHandle, AppPredictor.Callback appPredictorCallback) {
        AppPredictor appPredictor = this.getAppPredictorForDirectShareIfEnabled(userHandle);
        if (appPredictor == null) {
            return null;
        }
        this.mDirectShareAppTargetCache = new HashMap<ChooserTarget, AppTarget>();
        appPredictor.registerPredictionUpdates(this.getMainExecutor(), appPredictorCallback);
        return appPredictor;
    }

    private ResolverAppPredictorCallback createAppPredictorCallback(ChooserListAdapter chooserListAdapter) {
        return new ResolverAppPredictorCallback(resultList -> {
            if (this.isFinishing() || this.isDestroyed()) {
                return;
            }
            if (chooserListAdapter.getCount() == 0) {
                return;
            }
            if (resultList.isEmpty() && this.shouldQueryShortcutManager(chooserListAdapter.getUserHandle())) {
                this.queryDirectShareTargets(chooserListAdapter, true);
                return;
            }
            ArrayList<ShortcutManager.ShareShortcutInfo> shareShortcutInfos = new ArrayList<ShortcutManager.ShareShortcutInfo>();
            ArrayList<AppTarget> shortcutResults = new ArrayList<AppTarget>();
            for (AppTarget appTarget : resultList) {
                if (appTarget.getShortcutInfo() == null) continue;
                shortcutResults.add(appTarget);
            }
            resultList = shortcutResults;
            for (AppTarget appTarget : resultList) {
                shareShortcutInfos.add(new ShortcutManager.ShareShortcutInfo(appTarget.getShortcutInfo(), new ComponentName(appTarget.getPackageName(), appTarget.getClassName())));
            }
            this.sendShareShortcutInfoList((List<ShortcutManager.ShareShortcutInfo>)shareShortcutInfos, chooserListAdapter, (List<AppTarget>)resultList, chooserListAdapter.getUserHandle());
        });
    }

    static SharedPreferences getPinnedSharedPrefs(Context context) {
        File prefsFile = new File(new File(Environment.getDataUserCePackageDirectory(StorageManager.UUID_PRIVATE_INTERNAL, context.getUserId(), context.getPackageName()), "shared_prefs"), "chooser_pin_settings.xml");
        return context.getSharedPreferences(prefsFile, 0);
    }

    @Override
    protected AbstractMultiProfilePagerAdapter createMultiProfilePagerAdapter(Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed) {
        this.mChooserMultiProfilePagerAdapter = this.shouldShowTabs() ? this.createChooserMultiProfilePagerAdapterForTwoProfiles(initialIntents, rList, filterLastUsed) : this.createChooserMultiProfilePagerAdapterForOneProfile(initialIntents, rList, filterLastUsed);
        return this.mChooserMultiProfilePagerAdapter;
    }

    @Override
    protected AbstractMultiProfilePagerAdapter.EmptyStateProvider createBlockerEmptyStateProvider() {
        boolean isSendAction = this.isSendAction(this.getTargetIntent());
        NoCrossProfileEmptyStateProvider.DevicePolicyBlockerEmptyState noWorkToPersonalEmptyState = new NoCrossProfileEmptyStateProvider.DevicePolicyBlockerEmptyState(this, "Core.RESOLVER_CROSS_PROFILE_BLOCKED_TITLE", 17041695, isSendAction ? "Core.RESOLVER_CANT_SHARE_WITH_PERSONAL" : "Core.RESOLVER_CANT_ACCESS_PERSONAL", isSendAction ? 17041693 : 17041691, 158, "intent_chooser");
        NoCrossProfileEmptyStateProvider.DevicePolicyBlockerEmptyState noPersonalToWorkEmptyState = new NoCrossProfileEmptyStateProvider.DevicePolicyBlockerEmptyState(this, "Core.RESOLVER_CROSS_PROFILE_BLOCKED_TITLE", 17041695, isSendAction ? "Core.RESOLVER_CANT_SHARE_WITH_WORK" : "Core.RESOLVER_CANT_ACCESS_WORK", isSendAction ? 17041694 : 17041692, 159, "intent_chooser");
        return new NoCrossProfileEmptyStateProvider(this.getPersonalProfileUserHandle(), noWorkToPersonalEmptyState, noPersonalToWorkEmptyState, this.createCrossProfileIntentsChecker(), this.getTabOwnerUserHandleForLaunch());
    }

    private ChooserMultiProfilePagerAdapter createChooserMultiProfilePagerAdapterForOneProfile(Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed) {
        ChooserGridAdapter adapter = this.createChooserGridAdapter(this, this.mIntents, initialIntents, rList, filterLastUsed, this.getPersonalProfileUserHandle());
        return new ChooserMultiProfilePagerAdapter(this, adapter, this.createEmptyStateProvider(null), this.mQuietModeManager, null, this.getCloneProfileUserHandle(), this.mMaxTargetsPerRow);
    }

    private ChooserMultiProfilePagerAdapter createChooserMultiProfilePagerAdapterForTwoProfiles(Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed) {
        int selectedProfile = this.findSelectedProfile();
        ChooserGridAdapter personalAdapter = this.createChooserGridAdapter(this, this.mIntents, (Intent[])(selectedProfile == 0 ? initialIntents : null), rList, filterLastUsed, this.getPersonalProfileUserHandle());
        ChooserGridAdapter workAdapter = this.createChooserGridAdapter(this, this.mIntents, (Intent[])(selectedProfile == 1 ? initialIntents : null), rList, filterLastUsed, this.getWorkProfileUserHandle());
        return new ChooserMultiProfilePagerAdapter(this, personalAdapter, workAdapter, this.createEmptyStateProvider(this.getWorkProfileUserHandle()), this.mQuietModeManager, selectedProfile, this.getWorkProfileUserHandle(), this.getCloneProfileUserHandle(), this.mMaxTargetsPerRow);
    }

    private int findSelectedProfile() {
        int selectedProfile = this.getSelectedProfileExtra();
        if (selectedProfile == -1) {
            selectedProfile = this.getProfileForUser(this.getTabOwnerUserHandleForLaunch());
        }
        return selectedProfile;
    }

    @Override
    protected boolean postRebuildList(boolean rebuildCompleted) {
        this.updateStickyContentPreview();
        if (this.shouldShowStickyContentPreview() || this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter().getSystemRowCount() != 0) {
            this.logActionShareWithPreview();
        }
        return this.postRebuildListInternal(rebuildCompleted);
    }

    private boolean isAppPredictionServiceAvailable() {
        return this.getPackageManager().getAppPredictionServicePackageName() != null;
    }

    protected boolean isWorkProfile() {
        return this.getSystemService(UserManager.class).getUserInfo(UserHandle.myUserId()).isManagedProfile();
    }

    @Override
    protected PackageMonitor createPackageMonitor(final ResolverListAdapter listAdapter) {
        return new PackageMonitor(){

            @Override
            public void onSomePackagesChanged() {
                ChooserActivity.this.handlePackagesChanged(listAdapter);
            }
        };
    }

    public void handlePackagesChanged() {
        this.handlePackagesChanged(null);
    }

    private void handlePackagesChanged(@Nullable ResolverListAdapter listAdapter) {
        this.mPinnedSharedPrefs = ChooserActivity.getPinnedSharedPrefs(this);
        if (listAdapter == null) {
            this.mChooserMultiProfilePagerAdapter.getActiveListAdapter().handlePackagesChanged();
            if (this.mChooserMultiProfilePagerAdapter.getCount() > 1) {
                this.mChooserMultiProfilePagerAdapter.getInactiveListAdapter().handlePackagesChanged();
            }
        } else {
            listAdapter.handlePackagesChanged();
        }
        this.updateProfileViewButton();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onCopyButtonClicked(View v) {
        Intent targetIntent = this.getTargetIntent();
        if (targetIntent == null) {
            this.finish();
            return;
        }
        String action = targetIntent.getAction();
        ClipData clipData = null;
        if ("android.intent.action.SEND".equals(action)) {
            String extraText = targetIntent.getStringExtra("android.intent.extra.TEXT");
            Uri extraStream = targetIntent.getParcelableExtra("android.intent.extra.STREAM", Uri.class);
            if (extraText != null) {
                clipData = ClipData.newPlainText(null, extraText);
            } else {
                if (extraStream == null) {
                    Log.w(TAG, "No data available to copy to clipboard");
                    return;
                }
                clipData = ClipData.newUri(this.getContentResolver(), null, extraStream);
            }
        } else {
            if (!"android.intent.action.SEND_MULTIPLE".equals(action)) {
                Log.w(TAG, "Action (" + action + ") not supported for copying to clipboard");
                return;
            }
            ArrayList<Uri> streams = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM", Uri.class);
            clipData = ClipData.newUri(this.getContentResolver(), null, streams.get(0));
            for (int i = 1; i < streams.size(); ++i) {
                clipData.addItem(this.getContentResolver(), new ClipData.Item(streams.get(i)));
            }
        }
        ClipboardManager clipboardManager = (ClipboardManager)this.getSystemService("clipboard");
        clipboardManager.setPrimaryClipAsPackage(clipData, this.getReferrerPackageName());
        LogMaker targetLogMaker = new LogMaker(1749).setSubtype(1);
        this.getMetricsLogger().write(targetLogMaker);
        this.getChooserActivityLogger().logShareTargetSelected(4, "", -1, false);
        this.setResult(-1);
        this.finish();
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d(TAG, "onResume: " + this.getComponentName().flattenToShortString());
        this.maybeCancelFinishAnimation();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ViewPager viewPager = (ViewPager)this.findViewById(16909458);
        if (viewPager.isLayoutRtl()) {
            this.mMultiProfilePagerAdapter.setupViewPager(viewPager);
        }
        this.mShouldDisplayLandscape = this.shouldDisplayLandscape(newConfig.orientation);
        this.mMaxTargetsPerRow = this.getResources().getInteger(17694790);
        this.mChooserMultiProfilePagerAdapter.setMaxTargetsPerRow(this.mMaxTargetsPerRow);
        this.adjustPreviewWidth(newConfig.orientation, null);
        this.updateStickyContentPreview();
        this.updateTabPadding();
    }

    private boolean shouldDisplayLandscape(int orientation) {
        return orientation == 2 && !this.isInMultiWindowMode();
    }

    private void adjustPreviewWidth(int orientation, View parent) {
        int width = -1;
        if (this.mShouldDisplayLandscape) {
            width = this.getResources().getDimensionPixelSize(17105105);
        }
        parent = parent == null ? this.getWindow().getDecorView() : parent;
        this.updateLayoutWidth(16908963, width, parent);
        this.updateLayoutWidth(16908966, width, parent);
        this.updateLayoutWidth(16908953, width, parent);
    }

    private void updateTabPadding() {
        if (this.shouldShowTabs()) {
            Object tabs = this.findViewById(16908307);
            float iconSize = this.getResources().getDimension(17105100);
            float padding = ((float)((View)tabs).getWidth() - (float)this.mMaxTargetsPerRow * iconSize) / (float)this.mMaxTargetsPerRow / 2.0f;
            ((View)tabs).setPadding((int)(padding -= this.getResources().getDimension(17105715)), 0, (int)padding, 0);
        }
    }

    private void updateLayoutWidth(int layoutResourceId, int width, View parent) {
        Object view = parent.findViewById(layoutResourceId);
        if (view != null && ((View)view).getLayoutParams() != null) {
            ViewGroup.LayoutParams params = ((View)view).getLayoutParams();
            params.width = width;
            ((View)view).setLayoutParams(params);
        }
    }

    protected ViewGroup createContentPreviewView(ViewGroup parent) {
        Intent targetIntent = this.getTargetIntent();
        int previewType = this.findPreferredContentPreview(targetIntent, this.getContentResolver());
        return this.displayContentPreview(previewType, targetIntent, this.getLayoutInflater(), parent);
    }

    @VisibleForTesting
    protected ComponentName getNearbySharingComponent() {
        String nearbyComponent = Settings.Secure.getString(this.getContentResolver(), "nearby_sharing_component");
        if (TextUtils.isEmpty(nearbyComponent)) {
            nearbyComponent = this.getString(17039942);
        }
        if (TextUtils.isEmpty(nearbyComponent)) {
            return null;
        }
        return ComponentName.unflattenFromString(nearbyComponent);
    }

    @VisibleForTesting
    @Nullable
    protected ComponentName getEditSharingComponent() {
        String editorPackage = this.getApplicationContext().getString(17040095);
        if (editorPackage == null || TextUtils.isEmpty(editorPackage)) {
            return null;
        }
        return ComponentName.unflattenFromString(editorPackage);
    }

    @VisibleForTesting
    protected TargetInfo getEditSharingTarget(Intent originalIntent) {
        ComponentName cn = this.getEditSharingComponent();
        Intent resolveIntent = new Intent(originalIntent);
        resolveIntent.setFlags(originalIntent.getFlags() & 0xC3);
        resolveIntent.setComponent(cn);
        resolveIntent.setAction("android.intent.action.EDIT");
        String originalAction = originalIntent.getAction();
        if ("android.intent.action.SEND".equals(originalAction)) {
            Uri uri;
            if (resolveIntent.getData() == null && (uri = resolveIntent.getParcelableExtra("android.intent.extra.STREAM", Uri.class)) != null) {
                String mimeType = this.getContentResolver().getType(uri);
                resolveIntent.setDataAndType(uri, mimeType);
            }
        } else {
            Log.e(TAG, originalAction + " is not supported.");
            return null;
        }
        ResolveInfo ri = this.getPackageManager().resolveActivity(resolveIntent, 128);
        if (ri == null || ri.activityInfo == null) {
            Log.e(TAG, "Device-specified image edit component (" + cn + ") not available");
            return null;
        }
        DisplayResolveInfo dri = new DisplayResolveInfo(originalIntent, ri, this.getString(17041800), "", resolveIntent, null);
        dri.setDisplayIcon(this.getDrawable(17302983));
        return dri;
    }

    @VisibleForTesting
    protected TargetInfo getNearbySharingTarget(Intent originalIntent) {
        ComponentName cn = this.getNearbySharingComponent();
        if (cn == null) {
            return null;
        }
        Intent resolveIntent = new Intent(originalIntent);
        resolveIntent.setComponent(cn);
        ResolveInfo ri = this.getPackageManager().resolveActivity(resolveIntent, 128);
        if (ri == null || ri.activityInfo == null) {
            Log.e(TAG, "Device-specified nearby sharing component (" + cn + ") not available");
            return null;
        }
        CharSequence name = null;
        Drawable icon = null;
        Bundle metaData = ri.activityInfo.metaData;
        if (metaData != null) {
            try {
                Resources pkgRes = this.getPackageManager().getResourcesForActivity(cn);
                int nameResId = metaData.getInt(CHIP_LABEL_METADATA_KEY);
                name = pkgRes.getString(nameResId);
                int resId = metaData.getInt(CHIP_ICON_METADATA_KEY);
                icon = pkgRes.getDrawable(resId);
            }
            catch (Resources.NotFoundException pkgRes) {
            }
            catch (PackageManager.NameNotFoundException pkgRes) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty(name)) {
            name = ri.loadLabel(this.getPackageManager());
        }
        if (icon == null) {
            icon = ri.loadIcon(this.getPackageManager());
        }
        DisplayResolveInfo dri = new DisplayResolveInfo(originalIntent, ri, name, "", resolveIntent, null);
        dri.setDisplayIcon(icon);
        return dri;
    }

    private Button createActionButton(Drawable icon, CharSequence title, View.OnClickListener r) {
        Button b = (Button)LayoutInflater.from(this).inflate(17367133, null);
        if (icon != null) {
            int size = this.getResources().getDimensionPixelSize(17105092);
            icon.setBounds(0, 0, size, size);
            b.setCompoundDrawablesRelative(icon, null, null, null);
        }
        b.setText(title);
        b.setOnClickListener(r);
        return b;
    }

    private Button createCopyButton() {
        Button b = this.createActionButton(this.getDrawable(17302858), this.getString(0x1040001), this::onCopyButtonClicked);
        b.setId(16908918);
        return b;
    }

    @Nullable
    private Button createNearbyButton(Intent originalIntent) {
        TargetInfo ti = this.getNearbySharingTarget(originalIntent);
        if (ti == null) {
            return null;
        }
        Button b = this.createActionButton(ti.getDisplayIcon(this), ti.getDisplayLabel(), unused -> {
            this.getChooserActivityLogger().logShareTargetSelected(5, "", -1, false);
            this.safelyStartActivityAsUser(ti, this.getPersonalProfileUserHandle());
            this.finish();
        });
        b.setId(16908921);
        return b;
    }

    @Nullable
    private Button createEditButton(Intent originalIntent) {
        TargetInfo ti = this.getEditSharingTarget(originalIntent);
        if (ti == null) {
            return null;
        }
        Button b = this.createActionButton(ti.getDisplayIcon(this), ti.getDisplayLabel(), unused -> {
            this.getChooserActivityLogger().logShareTargetSelected(6, "", -1, false);
            View firstImgView = this.getFirstVisibleImgPreviewView();
            if (firstImgView == null) {
                this.safelyStartActivityAsUser(ti, this.getPersonalProfileUserHandle());
                this.finish();
            } else {
                ActivityOptions options = ActivityOptions.makeSceneTransitionAnimation((Activity)this, firstImgView, "screenshot_preview_image");
                this.safelyStartActivityAsUser(ti, this.getPersonalProfileUserHandle(), options.toBundle());
                this.startFinishAnimation();
            }
        });
        b.setId(16908919);
        return b;
    }

    @Nullable
    private View getFirstVisibleImgPreviewView() {
        Object firstImage = this.findViewById(16908956);
        return firstImage != null && ((View)firstImage).isVisibleToUser() ? (View)firstImage : null;
    }

    private void addActionButton(ViewGroup parent, Button b) {
        if (b == null) {
            return;
        }
        ViewGroup.MarginLayoutParams lp = new ViewGroup.MarginLayoutParams(-2, -2);
        int gap = this.getResources().getDimensionPixelSize(17105708) / 2;
        lp.setMarginsRelative(gap, 0, gap, 0);
        parent.addView((View)b, lp);
    }

    private ViewGroup displayContentPreview(int previewType, Intent targetIntent, LayoutInflater layoutInflater, ViewGroup parent) {
        ViewGroup layout2 = null;
        switch (previewType) {
            case 3: {
                layout2 = this.displayTextContentPreview(targetIntent, layoutInflater, parent);
                break;
            }
            case 1: {
                layout2 = this.displayImageContentPreview(targetIntent, layoutInflater, parent);
                break;
            }
            case 2: {
                layout2 = this.displayFileContentPreview(targetIntent, layoutInflater, parent);
                break;
            }
            default: {
                Log.e(TAG, "Unexpected content preview type: " + previewType);
            }
        }
        if (layout2 != null) {
            this.adjustPreviewWidth(this.getResources().getConfiguration().orientation, layout2);
        }
        if (previewType != 1) {
            this.mEnterTransitionAnimationDelegate.markImagePreviewReady();
        }
        return layout2;
    }

    private ViewGroup displayTextContentPreview(Intent targetIntent, LayoutInflater layoutInflater, ViewGroup parent) {
        CharSequence sharingText;
        ViewGroup contentPreviewLayout = (ViewGroup)layoutInflater.inflate(17367141, parent, false);
        ViewGroup actionRow = (ViewGroup)contentPreviewLayout.findViewById(16908917);
        this.addActionButton(actionRow, this.createCopyButton());
        if (this.shouldNearbyShareBeIncludedAsActionButton()) {
            this.addActionButton(actionRow, this.createNearbyButton(targetIntent));
        }
        if ((sharingText = targetIntent.getCharSequenceExtra("android.intent.extra.TEXT")) == null) {
            ((View)contentPreviewLayout.findViewById(16908963)).setVisibility(8);
        } else {
            TextView textView = (TextView)contentPreviewLayout.findViewById(16908961);
            textView.setText(sharingText);
        }
        String previewTitle = targetIntent.getStringExtra("android.intent.extra.TITLE");
        if (TextUtils.isEmpty(previewTitle)) {
            ((View)contentPreviewLayout.findViewById(16908966)).setVisibility(8);
        } else {
            TextView previewTitleView = (TextView)contentPreviewLayout.findViewById(16908965);
            previewTitleView.setText(previewTitle);
            ClipData previewData = targetIntent.getClipData();
            Uri previewThumbnail = null;
            if (previewData != null && previewData.getItemCount() > 0) {
                ClipData.Item previewDataItem = previewData.getItemAt(0);
                previewThumbnail = previewDataItem.getUri();
            }
            ImageView previewThumbnailView = (ImageView)contentPreviewLayout.findViewById(16908964);
            if (!ChooserActivity.validForContentPreview(previewThumbnail)) {
                previewThumbnailView.setVisibility(8);
            } else {
                this.mPreviewCoord = new ContentPreviewCoordinator(contentPreviewLayout, false);
                this.mPreviewCoord.loadUriIntoView(16908964, previewThumbnail, 0);
            }
        }
        return contentPreviewLayout;
    }

    private ViewGroup displayImageContentPreview(Intent targetIntent, LayoutInflater layoutInflater, ViewGroup parent) {
        ViewGroup contentPreviewLayout = (ViewGroup)layoutInflater.inflate(17367140, parent, false);
        ViewGroup imagePreview = (ViewGroup)contentPreviewLayout.findViewById(16908960);
        ViewGroup actionRow = (ViewGroup)contentPreviewLayout.findViewById(16908917);
        if (this.shouldNearbyShareBeIncludedAsActionButton()) {
            this.addActionButton(actionRow, this.createNearbyButton(targetIntent));
        }
        this.addActionButton(actionRow, this.createEditButton(targetIntent));
        this.mPreviewCoord = new ContentPreviewCoordinator(contentPreviewLayout, false);
        String action = targetIntent.getAction();
        if ("android.intent.action.SEND".equals(action)) {
            Uri uri = targetIntent.getParcelableExtra("android.intent.extra.STREAM", Uri.class);
            if (!ChooserActivity.validForContentPreview(uri)) {
                imagePreview.setVisibility(8);
                return contentPreviewLayout;
            }
            ((View)imagePreview.findViewById(16908956)).setTransitionName("screenshot_preview_image");
            this.mPreviewCoord.loadUriIntoView(16908956, uri, 0);
        } else {
            ContentResolver resolver = this.getContentResolver();
            ArrayList<Uri> uris = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM", Uri.class);
            ArrayList<Uri> imageUris = new ArrayList<Uri>();
            for (Uri uri : uris) {
                if (!ChooserActivity.validForContentPreview(uri) || !this.isImageType(resolver.getType(uri))) continue;
                imageUris.add(uri);
            }
            if (imageUris.size() == 0) {
                Log.i(TAG, "Attempted to display image preview area with zero available images detected in EXTRA_STREAM list");
                imagePreview.setVisibility(8);
                return contentPreviewLayout;
            }
            ((View)imagePreview.findViewById(16908956)).setTransitionName("screenshot_preview_image");
            this.mPreviewCoord.loadUriIntoView(16908956, (Uri)imageUris.get(0), 0);
            if (imageUris.size() == 2) {
                this.mPreviewCoord.loadUriIntoView(16908957, (Uri)imageUris.get(1), 0);
            } else if (imageUris.size() > 2) {
                this.mPreviewCoord.loadUriIntoView(16908958, (Uri)imageUris.get(1), 0);
                this.mPreviewCoord.loadUriIntoView(16908959, (Uri)imageUris.get(2), imageUris.size() - 3);
            }
        }
        return contentPreviewLayout;
    }

    @VisibleForTesting
    public Cursor queryResolver(ContentResolver resolver, Uri uri) {
        return resolver.query(uri, null, null, null, null);
    }

    private FileInfo extractFileInfo(Uri uri, ContentResolver resolver) {
        int index;
        String fileName = null;
        boolean hasThumbnail = false;
        try (Cursor cursor = this.queryResolver(resolver, uri);){
            if (cursor != null && cursor.getCount() > 0) {
                int nameIndex = cursor.getColumnIndex("_display_name");
                int titleIndex = cursor.getColumnIndex("title");
                int flagsIndex = cursor.getColumnIndex("flags");
                cursor.moveToFirst();
                if (nameIndex != -1) {
                    fileName = cursor.getString(nameIndex);
                } else if (titleIndex != -1) {
                    fileName = cursor.getString(titleIndex);
                }
                if (flagsIndex != -1) {
                    hasThumbnail = (cursor.getInt(flagsIndex) & 1) != 0;
                }
            }
        }
        catch (NullPointerException | SecurityException e) {
            this.logContentPreviewWarning(uri);
        }
        if (TextUtils.isEmpty(fileName) && (index = (fileName = uri.getPath()).lastIndexOf(47)) != -1) {
            fileName = fileName.substring(index + 1);
        }
        return new FileInfo(fileName, hasThumbnail);
    }

    private void logContentPreviewWarning(Uri uri) {
        Log.w(TAG, "Could not load (" + uri.toString() + ") thumbnail/name for preview. If desired, consider using Intent#createChooser to launch the ChooserActivity, and set your Intent's clipData and flags in accordance with that method's documentation");
    }

    private ViewGroup displayFileContentPreview(Intent targetIntent, LayoutInflater layoutInflater, ViewGroup parent) {
        String action;
        ViewGroup contentPreviewLayout = (ViewGroup)layoutInflater.inflate(17367139, parent, false);
        ViewGroup actionRow = (ViewGroup)contentPreviewLayout.findViewById(16908917);
        if (this.shouldNearbyShareBeIncludedAsActionButton()) {
            this.addActionButton(actionRow, this.createNearbyButton(targetIntent));
        }
        if ("android.intent.action.SEND".equals(action = targetIntent.getAction())) {
            Uri uri = targetIntent.getParcelableExtra("android.intent.extra.STREAM", Uri.class);
            if (!ChooserActivity.validForContentPreview(uri)) {
                contentPreviewLayout.setVisibility(8);
                return contentPreviewLayout;
            }
            this.loadFileUriIntoView(uri, contentPreviewLayout);
        } else {
            List<Uri> uris = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM", Uri.class);
            int uriCount = (uris = uris.stream().filter(ChooserActivity::validForContentPreview).collect(Collectors.toList())).size();
            if (uriCount == 0) {
                contentPreviewLayout.setVisibility(8);
                Log.i(TAG, "Appears to be no uris available in EXTRA_STREAM, removing preview area");
                return contentPreviewLayout;
            }
            if (uriCount == 1) {
                this.loadFileUriIntoView(uris.get(0), contentPreviewLayout);
            } else {
                FileInfo fileInfo = this.extractFileInfo(uris.get(0), this.getContentResolver());
                int remUriCount = uriCount - 1;
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put(PLURALS_COUNT, remUriCount);
                arguments.put(PLURALS_FILE_NAME, fileInfo.name);
                String fileName = PluralsMessageFormatter.format(this.getResources(), arguments, 17040419);
                TextView fileNameView = (TextView)contentPreviewLayout.findViewById(16908955);
                fileNameView.setText(fileName);
                Object thumbnailView = contentPreviewLayout.findViewById(16908954);
                ((View)thumbnailView).setVisibility(8);
                ImageView fileIconView = (ImageView)contentPreviewLayout.findViewById(16908952);
                fileIconView.setVisibility(0);
                fileIconView.setImageResource(17302587);
            }
        }
        return contentPreviewLayout;
    }

    private void loadFileUriIntoView(Uri uri, View parent) {
        FileInfo fileInfo = this.extractFileInfo(uri, this.getContentResolver());
        TextView fileNameView = (TextView)parent.findViewById(16908955);
        fileNameView.setText(fileInfo.name);
        if (fileInfo.hasThumbnail) {
            this.mPreviewCoord = new ContentPreviewCoordinator(parent, false);
            this.mPreviewCoord.loadUriIntoView(16908954, uri, 0);
        } else {
            Object thumbnailView = parent.findViewById(16908954);
            ((View)thumbnailView).setVisibility(8);
            ImageView fileIconView = (ImageView)parent.findViewById(16908952);
            fileIconView.setVisibility(0);
            fileIconView.setImageResource(17302236);
        }
    }

    private static boolean validForContentPreview(Uri uri) throws SecurityException {
        if (uri == null) {
            return false;
        }
        int userId = ContentProvider.getUserIdFromUri(uri, -2);
        if (userId != -2 && userId != UserHandle.myUserId()) {
            Log.e(TAG, "dropped invalid content URI belonging to user " + userId);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected boolean isImageType(String mimeType) {
        return mimeType != null && mimeType.startsWith("image/");
    }

    private int findPreferredContentPreview(Uri uri, ContentResolver resolver) {
        if (uri == null) {
            return 3;
        }
        String mimeType = resolver.getType(uri);
        return this.isImageType(mimeType) ? 1 : 2;
    }

    private int findPreferredContentPreview(Intent targetIntent, ContentResolver resolver) {
        String action = targetIntent.getAction();
        if ("android.intent.action.SEND".equals(action)) {
            Uri uri = targetIntent.getParcelableExtra("android.intent.extra.STREAM", Uri.class);
            return this.findPreferredContentPreview(uri, resolver);
        }
        if ("android.intent.action.SEND_MULTIPLE".equals(action)) {
            ArrayList<Uri> uris = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM", Uri.class);
            if (uris == null || uris.isEmpty()) {
                return 3;
            }
            for (Uri uri : uris) {
                if (this.findPreferredContentPreview(uri, resolver) != 2) continue;
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private int getNumSheetExpansions() {
        return this.getPreferences(0).getInt(PREF_NUM_SHEET_EXPANSIONS, 0);
    }

    private void incrementNumSheetExpansions() {
        this.getPreferences(0).edit().putInt(PREF_NUM_SHEET_EXPANSIONS, this.getNumSheetExpansions() + 1).apply();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.maybeCancelFinishAnimation()) {
            this.finish();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.isFinishing()) {
            this.mLatencyTracker.onActionCancel(16);
        }
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.mChooserHandler.removeAllMessages();
        if (this.mPreviewCoord != null) {
            this.mPreviewCoord.cancelLoads();
        }
        this.mChooserMultiProfilePagerAdapter.getActiveListAdapter().destroyAppPredictor();
        if (this.mChooserMultiProfilePagerAdapter.getInactiveListAdapter() != null) {
            this.mChooserMultiProfilePagerAdapter.getInactiveListAdapter().destroyAppPredictor();
        }
        this.mPersonalAppPredictor = null;
        this.mWorkAppPredictor = null;
    }

    @Override
    public Intent getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        Bundle replExtras;
        Intent result = defIntent;
        if (this.mReplacementExtras != null && (replExtras = this.mReplacementExtras.getBundle(aInfo.packageName)) != null) {
            result = new Intent(defIntent);
            result.putExtras(replExtras);
        }
        if (aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_PARENT) || aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            result = Intent.createChooser(result, this.getIntent().getCharSequenceExtra("android.intent.extra.TITLE"));
            result.putExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", false);
        }
        return result;
    }

    @Override
    public void onActivityStarted(TargetInfo cti) {
        ComponentName target;
        if (this.mChosenComponentSender != null && (target = cti.getResolvedComponentName()) != null) {
            Intent fillIn = new Intent().putExtra("android.intent.extra.CHOSEN_COMPONENT", target);
            try {
                this.mChosenComponentSender.sendIntent(this, -1, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                Slog.e(TAG, "Unable to launch supplied IntentSender to report the chosen component: " + e);
            }
        }
    }

    @Override
    public void addUseDifferentAppLabelIfNecessary(ResolverListAdapter adapter) {
        if (this.mCallerChooserTargets != null && this.mCallerChooserTargets.length > 0) {
            this.mChooserMultiProfilePagerAdapter.getActiveListAdapter().addServiceResults(null, Lists.newArrayList(this.mCallerChooserTargets), 0, null);
        }
    }

    @Override
    public int getLayoutResource() {
        return 17367138;
    }

    @Override
    public boolean shouldGetActivityMetadata() {
        return true;
    }

    @Override
    public boolean shouldAutoLaunchSingleChoice(TargetInfo target) {
        if (!super.shouldAutoLaunchSingleChoice(target)) {
            return false;
        }
        return this.getIntent().getBooleanExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", true);
    }

    private void modifyTargetIntent(Intent in) {
        if (this.isSendAction(in)) {
            in.addFlags(0x8080000);
        }
    }

    @Override
    protected boolean onTargetSelected(TargetInfo target, boolean alwaysCheck) {
        if (this.mRefinementIntentSender != null) {
            Intent fillIn = new Intent();
            List<Intent> sourceIntents = target.getAllSourceIntents();
            if (!sourceIntents.isEmpty()) {
                fillIn.putExtra("android.intent.extra.INTENT", sourceIntents.get(0));
                if (sourceIntents.size() > 1) {
                    Parcelable[] alts = new Intent[sourceIntents.size() - 1];
                    int N2 = sourceIntents.size();
                    for (int i = 1; i < N2; ++i) {
                        alts[i - 1] = sourceIntents.get(i);
                    }
                    fillIn.putExtra("android.intent.extra.ALTERNATE_INTENTS", alts);
                }
                if (this.mRefinementResultReceiver != null) {
                    this.mRefinementResultReceiver.destroy();
                }
                this.mRefinementResultReceiver = new RefinementResultReceiver(this, target, null);
                fillIn.putExtra("android.intent.extra.RESULT_RECEIVER", this.mRefinementResultReceiver);
                try {
                    this.mRefinementIntentSender.sendIntent(this, 0, fillIn, null, null);
                    return false;
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e(TAG, "Refinement IntentSender failed to send", e);
                }
            }
        }
        this.updateModelAndChooserCounts(target);
        return super.onTargetSelected(target, alwaysCheck);
    }

    @Override
    public void startSelected(int which, boolean always, boolean filtered) {
        MultiDisplayResolveInfo mti;
        ChooserListAdapter currentListAdapter = this.mChooserMultiProfilePagerAdapter.getActiveListAdapter();
        TargetInfo targetInfo = currentListAdapter.targetInfoForPosition(which, filtered);
        if (targetInfo != null && targetInfo instanceof NotSelectableTargetInfo) {
            return;
        }
        long selectionCost = System_Delegate.currentTimeMillis() - this.mChooserShownTime;
        if (targetInfo instanceof MultiDisplayResolveInfo && !(mti = (MultiDisplayResolveInfo)targetInfo).hasSelected()) {
            ChooserStackedAppDialogFragment f = new ChooserStackedAppDialogFragment();
            Bundle b = new Bundle();
            b.putParcelable("user_handle", targetInfo.getResolveInfo().userHandle);
            b.putObject("multi_dri_key", mti);
            b.putInt("which_key", which);
            f.setArguments(b);
            f.show(this.getFragmentManager(), TARGET_DETAILS_FRAGMENT_TAG);
            return;
        }
        super.startSelected(which, always, filtered);
        if (currentListAdapter.getCount() > 0) {
            int cat = 0;
            int value = which;
            int directTargetAlsoRanked = -1;
            int numCallerProvided = 0;
            HashedStringCache.HashResult directTargetHashed = null;
            switch (currentListAdapter.getPositionTargetType(which)) {
                case 1: {
                    cat = 216;
                    ChooserTarget target = currentListAdapter.getChooserTargetForValue(value);
                    directTargetHashed = HashedStringCache.getInstance().hashString(this, TAG, target.getComponentName().getPackageName() + target.getTitle().toString(), this.mMaxHashSaltDays);
                    SelectableTargetInfo selectableTargetInfo = (SelectableTargetInfo)targetInfo;
                    directTargetAlsoRanked = this.getRankedPosition(selectableTargetInfo);
                    if (this.mCallerChooserTargets != null) {
                        numCallerProvided = this.mCallerChooserTargets.length;
                    }
                    this.getChooserActivityLogger().logShareTargetSelected(1, targetInfo.getResolveInfo().activityInfo.processName, value, selectableTargetInfo.isPinned());
                    break;
                }
                case 0: 
                case 2: {
                    cat = 215;
                    numCallerProvided = currentListAdapter.getCallerTargetCount();
                    this.getChooserActivityLogger().logShareTargetSelected(2, targetInfo.getResolveInfo().activityInfo.processName, value -= currentListAdapter.getSurfacedTargetInfo().size(), targetInfo.isPinned());
                    break;
                }
                case 3: {
                    value = -1;
                    cat = 217;
                    this.getChooserActivityLogger().logShareTargetSelected(3, targetInfo.getResolveInfo().activityInfo.processName, value, false);
                }
            }
            if (cat != 0) {
                LogMaker targetLogMaker = new LogMaker(cat).setSubtype(value);
                if (directTargetHashed != null) {
                    targetLogMaker.addTaggedData(1704, directTargetHashed.hashedString);
                    targetLogMaker.addTaggedData(1705, directTargetHashed.saltGeneration);
                    targetLogMaker.addTaggedData(1087, directTargetAlsoRanked);
                }
                targetLogMaker.addTaggedData(1086, numCallerProvided);
                this.getMetricsLogger().write(targetLogMaker);
            }
            if (this.mIsSuccessfullySelected) {
                Log.d(TAG, "User Selection Time Cost is " + selectionCost);
                Log.d(TAG, "position of selected app/service/caller is " + Integer.toString(value));
                MetricsLogger.histogram(null, "user_selection_cost_for_smart_sharing", (int)selectionCost);
                MetricsLogger.histogram(null, "app_position_for_smart_sharing", value);
            }
        }
    }

    private int getRankedPosition(SelectableTargetInfo targetInfo) {
        String targetPackageName = targetInfo.getChooserTarget().getComponentName().getPackageName();
        ChooserListAdapter currentListAdapter = this.mChooserMultiProfilePagerAdapter.getActiveListAdapter();
        int maxRankedResults = Math.min(currentListAdapter.mDisplayList.size(), 12);
        for (int i = 0; i < maxRankedResults; ++i) {
            if (!((DisplayResolveInfo)currentListAdapter.mDisplayList.get((int)i)).getResolveInfo().activityInfo.packageName.equals(targetPackageName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected boolean shouldAddFooterView() {
        return true;
    }

    @Override
    protected void applyFooterView(int height) {
        int count = this.mChooserMultiProfilePagerAdapter.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.mChooserMultiProfilePagerAdapter.getAdapterForIndex(i).setFooterHeight(height);
        }
    }

    private IntentFilter getTargetIntentFilter() {
        try {
            Intent intent = this.getTargetIntent();
            String dataString = intent.getDataString();
            if (intent.getType() == null) {
                if (!TextUtils.isEmpty(dataString)) {
                    return new IntentFilter(intent.getAction(), dataString);
                }
                Log.e(TAG, "Failed to get target intent filter: intent data and type are null");
                return null;
            }
            IntentFilter intentFilter = new IntentFilter(intent.getAction(), intent.getType());
            ArrayList<Uri> contentUris = new ArrayList<Uri>();
            if ("android.intent.action.SEND".equals(intent.getAction())) {
                Uri uri = intent.getParcelableExtra("android.intent.extra.STREAM", Uri.class);
                if (uri != null) {
                    contentUris.add(uri);
                }
            } else {
                ArrayList<Uri> uris = intent.getParcelableArrayListExtra("android.intent.extra.STREAM", Uri.class);
                if (uris != null) {
                    contentUris.addAll(uris);
                }
            }
            for (Uri uri : contentUris) {
                intentFilter.addDataScheme(uri.getScheme());
                intentFilter.addDataAuthority(uri.getAuthority(), null);
                intentFilter.addDataPath(uri.getPath(), 0);
            }
            return intentFilter;
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to get target intent filter", e);
            return null;
        }
    }

    @VisibleForTesting
    protected void queryDirectShareTargets(ChooserListAdapter adapter, boolean skipAppPredictionService) {
        AppPredictor appPredictor;
        this.mQueriedSharingShortcutsTimeMs = System_Delegate.currentTimeMillis();
        UserHandle userHandle = adapter.getUserHandle();
        if (!skipAppPredictionService && (appPredictor = this.getAppPredictorForDirectShareIfEnabled(userHandle)) != null) {
            appPredictor.requestPredictionUpdate();
            return;
        }
        IntentFilter filter = this.getTargetIntentFilter();
        if (filter == null) {
            return;
        }
        AsyncTask.execute(() -> {
            Context selectedProfileContext = this.createContextAsUser(userHandle, 0);
            ShortcutManager sm = (ShortcutManager)selectedProfileContext.getSystemService("shortcut");
            List<ShortcutManager.ShareShortcutInfo> resultList = sm.getShareTargets(filter);
            this.sendShareShortcutInfoList(resultList, adapter, null, userHandle);
        });
    }

    private boolean shouldQueryShortcutManager(UserHandle userHandle) {
        if (!this.shouldShowTabs()) {
            return true;
        }
        if (!this.getWorkProfileUserHandle().equals(userHandle)) {
            return true;
        }
        if (!this.isUserRunning(userHandle)) {
            return false;
        }
        if (!this.isUserUnlocked(userHandle)) {
            return false;
        }
        return !this.isQuietModeEnabled(userHandle);
    }

    private void sendShareShortcutInfoList(List<ShortcutManager.ShareShortcutInfo> resultList, ChooserListAdapter chooserListAdapter, @Nullable List<AppTarget> appTargets, UserHandle userHandle) {
        if (appTargets != null && appTargets.size() != resultList.size()) {
            throw new RuntimeException("resultList and appTargets must have the same size. resultList.size()=" + resultList.size() + " appTargets.size()=" + appTargets.size());
        }
        Context selectedProfileContext = this.createContextAsUser(userHandle, 0);
        for (int i = resultList.size() - 1; i >= 0; --i) {
            String packageName = resultList.get(i).getTargetComponent().getPackageName();
            if (this.isPackageEnabled(selectedProfileContext, packageName)) continue;
            resultList.remove(i);
            if (appTargets == null) continue;
            appTargets.remove(i);
        }
        int shortcutType = appTargets == null ? 2 : 3;
        ArrayList<ServiceResultInfo> resultRecords = new ArrayList<ServiceResultInfo>();
        for (int i = 0; i < chooserListAdapter.getDisplayResolveInfoCount(); ++i) {
            DisplayResolveInfo displayResolveInfo = chooserListAdapter.getDisplayResolveInfo(i);
            List<ShortcutManager.ShareShortcutInfo> matchingShortcuts = this.filterShortcutsByTargetComponentName(resultList, displayResolveInfo.getResolvedComponentName());
            if (matchingShortcuts.isEmpty()) continue;
            List<ChooserTarget> chooserTargets = this.convertToChooserTarget(matchingShortcuts, resultList, appTargets, shortcutType);
            ServiceResultInfo resultRecord = new ServiceResultInfo(displayResolveInfo, chooserTargets, userHandle);
            resultRecords.add(resultRecord);
        }
        this.sendShortcutManagerShareTargetResults(shortcutType, resultRecords.toArray(new ServiceResultInfo[0]));
    }

    private List<ShortcutManager.ShareShortcutInfo> filterShortcutsByTargetComponentName(List<ShortcutManager.ShareShortcutInfo> allShortcuts, ComponentName requiredTarget) {
        ArrayList<ShortcutManager.ShareShortcutInfo> matchingShortcuts = new ArrayList<ShortcutManager.ShareShortcutInfo>();
        for (ShortcutManager.ShareShortcutInfo shortcut : allShortcuts) {
            if (!requiredTarget.equals(shortcut.getTargetComponent())) continue;
            matchingShortcuts.add(shortcut);
        }
        return matchingShortcuts;
    }

    @VisibleForTesting
    protected void sendShortcutManagerShareTargetResults(int shortcutType, ServiceResultInfo[] results) {
        Message msg = Message.obtain();
        msg.what = 7;
        msg.obj = results;
        msg.arg1 = shortcutType;
        this.mChooserHandler.sendMessage(msg);
    }

    private boolean isPackageEnabled(Context context, String packageName) {
        ApplicationInfo appInfo;
        if (TextUtils.isEmpty(packageName)) {
            return false;
        }
        try {
            appInfo = context.getPackageManager().getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return appInfo != null && appInfo.enabled && (appInfo.flags & 0x40000000) == 0;
    }

    @VisibleForTesting
    @NonNull
    public List<ChooserTarget> convertToChooserTarget(@NonNull List<ShortcutManager.ShareShortcutInfo> matchingShortcuts, @NonNull List<ShortcutManager.ShareShortcutInfo> allShortcuts, @Nullable List<AppTarget> allAppTargets, int shortcutType) {
        ArrayList<Integer> scoreList = new ArrayList<Integer>();
        if (shortcutType == 2) {
            for (int i = 0; i < matchingShortcuts.size(); ++i) {
                int shortcutRank = matchingShortcuts.get(i).getShortcutInfo().getRank();
                if (scoreList.contains(shortcutRank)) continue;
                scoreList.add(shortcutRank);
            }
            Collections.sort(scoreList);
        }
        ArrayList<ChooserTarget> chooserTargetList = new ArrayList<ChooserTarget>(matchingShortcuts.size());
        for (int i = 0; i < matchingShortcuts.size(); ++i) {
            float score;
            ShortcutInfo shortcutInfo = matchingShortcuts.get(i).getShortcutInfo();
            int indexInAllShortcuts = allShortcuts.indexOf(matchingShortcuts.get(i));
            if (shortcutType == 3) {
                score = Math.max(1.0f - 0.01f * (float)indexInAllShortcuts, 0.0f);
            } else {
                int rankIndex = scoreList.indexOf(shortcutInfo.getRank());
                score = Math.max(1.0f - 0.01f * (float)rankIndex, 0.0f);
            }
            Bundle extras = new Bundle();
            extras.putString("android.intent.extra.shortcut.ID", shortcutInfo.getId());
            ChooserTarget chooserTarget = new ChooserTarget(shortcutInfo.getLabel(), null, score, matchingShortcuts.get(i).getTargetComponent().clone(), extras);
            chooserTargetList.add(chooserTarget);
            if (this.mDirectShareAppTargetCache != null && allAppTargets != null) {
                this.mDirectShareAppTargetCache.put(chooserTarget, allAppTargets.get(indexInAllShortcuts));
            }
            if (this.mDirectShareShortcutInfoCache == null) continue;
            this.mDirectShareShortcutInfoCache.put(chooserTarget, shortcutInfo);
        }
        Comparator byScore = (a, b) -> -Float.compare(a.getScore(), b.getScore());
        Collections.sort(chooserTargetList, byScore);
        return chooserTargetList;
    }

    private void logDirectShareTargetReceived(int logCategory) {
        int apiLatency = (int)(System_Delegate.currentTimeMillis() - this.mQueriedSharingShortcutsTimeMs);
        this.getMetricsLogger().write(new LogMaker(logCategory).setSubtype(apiLatency));
    }

    void updateModelAndChooserCounts(TargetInfo info) {
        if (info != null && info instanceof MultiDisplayResolveInfo) {
            info = ((MultiDisplayResolveInfo)info).getSelectedTarget();
        }
        if (info != null) {
            this.sendClickToAppPredictor(info);
            ResolveInfo ri = info.getResolveInfo();
            Intent targetIntent = this.getTargetIntent();
            if (ri != null && ri.activityInfo != null && targetIntent != null) {
                ChooserListAdapter currentListAdapter = this.mChooserMultiProfilePagerAdapter.getActiveListAdapter();
                if (currentListAdapter != null) {
                    this.sendImpressionToAppPredictor(info, currentListAdapter);
                    currentListAdapter.updateModel(info);
                    currentListAdapter.updateChooserCounts(ri.activityInfo.packageName, targetIntent.getAction(), ri.userHandle);
                }
                Log.d(TAG, "ResolveInfo Package is " + ri.activityInfo.packageName);
                Log.d(TAG, "Action to be updated is " + targetIntent.getAction());
            } else {
                Log.d(TAG, "Can not log Chooser Counts of null ResovleInfo");
            }
        }
        this.mIsSuccessfullySelected = true;
    }

    private void sendImpressionToAppPredictor(TargetInfo targetInfo, ChooserListAdapter adapter) {
        AppPredictor directShareAppPredictor = this.getAppPredictorForDirectShareIfEnabled(this.mChooserMultiProfilePagerAdapter.getCurrentUserHandle());
        if (directShareAppPredictor == null) {
            return;
        }
        if (targetInfo instanceof ChooserTargetInfo) {
            return;
        }
        List<ChooserTargetInfo> surfacedTargetInfo = adapter.getSurfacedTargetInfo();
        ArrayList<AppTargetId> targetIds = new ArrayList<AppTargetId>();
        for (ChooserTargetInfo chooserTargetInfo : surfacedTargetInfo) {
            ChooserTarget chooserTarget = chooserTargetInfo.getChooserTarget();
            ComponentName componentName = chooserTarget.getComponentName();
            if (!this.mDirectShareShortcutInfoCache.containsKey(chooserTarget)) continue;
            String shortcutId = this.mDirectShareShortcutInfoCache.get(chooserTarget).getId();
            targetIds.add(new AppTargetId(String.format("%s/%s/%s", shortcutId, componentName.flattenToString(), SHORTCUT_TARGET)));
        }
        directShareAppPredictor.notifyLaunchLocationShown(LAUNCH_LOCATION_DIRECT_SHARE, targetIds);
    }

    private void sendClickToAppPredictor(TargetInfo targetInfo) {
        AppPredictor directShareAppPredictor = this.getAppPredictorForDirectShareIfEnabled(this.mChooserMultiProfilePagerAdapter.getCurrentUserHandle());
        if (directShareAppPredictor == null) {
            return;
        }
        if (!(targetInfo instanceof ChooserTargetInfo)) {
            return;
        }
        ChooserTarget chooserTarget = ((ChooserTargetInfo)targetInfo).getChooserTarget();
        AppTarget appTarget = null;
        if (this.mDirectShareAppTargetCache != null) {
            appTarget = this.mDirectShareAppTargetCache.get(chooserTarget);
        }
        if (appTarget != null) {
            directShareAppPredictor.notifyAppTargetEvent(new AppTargetEvent.Builder(appTarget, 1).setLaunchLocation(LAUNCH_LOCATION_DIRECT_SHARE).build());
        }
    }

    @Nullable
    private AppPredictor createAppPredictor(UserHandle userHandle) {
        if (!this.mIsAppPredictorComponentAvailable) {
            return null;
        }
        if (this.getPersonalProfileUserHandle().equals(userHandle)) {
            if (this.mPersonalAppPredictor != null) {
                return this.mPersonalAppPredictor;
            }
        } else if (this.mWorkAppPredictor != null) {
            return this.mWorkAppPredictor;
        }
        Context contextAsUser = this.createContextAsUser(userHandle, 0);
        IntentFilter filter = this.getTargetIntentFilter();
        Bundle extras = new Bundle();
        extras.putParcelable(APP_PREDICTION_INTENT_FILTER_KEY, filter);
        this.populateTextContent(extras);
        AppPredictionContext appPredictionContext = new AppPredictionContext.Builder(contextAsUser).setUiSurface(APP_PREDICTION_SHARE_UI_SURFACE).setPredictedTargetCount(20).setExtras(extras).build();
        AppPredictionManager appPredictionManager = contextAsUser.getSystemService(AppPredictionManager.class);
        AppPredictor appPredictionSession = appPredictionManager.createAppPredictionSession(appPredictionContext);
        if (this.getPersonalProfileUserHandle().equals(userHandle)) {
            this.mPersonalAppPredictor = appPredictionSession;
        } else {
            this.mWorkAppPredictor = appPredictionSession;
        }
        return appPredictionSession;
    }

    private void populateTextContent(Bundle extras) {
        Intent intent = this.getTargetIntent();
        String sharedText = intent.getStringExtra("android.intent.extra.TEXT");
        extras.putString(SHARED_TEXT_KEY, sharedText);
    }

    @Nullable
    private AppPredictor getAppPredictorForDirectShareIfEnabled(UserHandle userHandle) {
        return !ActivityManager.isLowRamDeviceStatic() ? this.createAppPredictor(userHandle) : null;
    }

    @Nullable
    private AppPredictor getAppPredictorForShareActivitiesIfEnabled(UserHandle userHandle) {
        return this.getCloneProfileUserHandle() == null ? this.createAppPredictor(userHandle) : null;
    }

    void onRefinementResult(TargetInfo selectedTarget, Intent matchingIntent) {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        if (selectedTarget == null) {
            Log.e(TAG, "Refinement result intent did not match any known targets; canceling");
        } else if (!this.checkTargetSourceIntent(selectedTarget, matchingIntent)) {
            Log.e(TAG, "onRefinementResult: Selected target " + selectedTarget + " cannot match refined source intent " + matchingIntent);
        } else {
            TargetInfo clonedTarget = selectedTarget.cloneFilledIn(matchingIntent, 0);
            if (super.onTargetSelected(clonedTarget, false)) {
                this.updateModelAndChooserCounts(clonedTarget);
                this.finish();
                return;
            }
        }
        this.onRefinementCanceled();
    }

    void onRefinementCanceled() {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.finish();
    }

    boolean checkTargetSourceIntent(TargetInfo target, Intent matchingIntent) {
        List<Intent> targetIntents = target.getAllSourceIntents();
        int N2 = targetIntents.size();
        for (int i = 0; i < N2; ++i) {
            Intent targetIntent = targetIntents.get(i);
            if (!targetIntent.filterEquals(matchingIntent)) continue;
            return true;
        }
        return false;
    }

    protected MetricsLogger getMetricsLogger() {
        if (this.mMetricsLogger == null) {
            this.mMetricsLogger = new MetricsLogger();
        }
        return this.mMetricsLogger;
    }

    protected ChooserActivityLogger getChooserActivityLogger() {
        if (this.mChooserActivityLogger == null) {
            this.mChooserActivityLogger = new ChooserActivityLoggerImpl();
        }
        return this.mChooserActivityLogger;
    }

    @VisibleForTesting
    public ChooserGridAdapter createChooserGridAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed, UserHandle userHandle) {
        ChooserListAdapter chooserListAdapter = this.createChooserListAdapter(context, payloadIntents, initialIntents, rList, filterLastUsed, userHandle);
        ResolverAppPredictorCallback appPredictorCallbackWrapper = this.createAppPredictorCallback(chooserListAdapter);
        AppPredictor.Callback appPredictorCallback = appPredictorCallbackWrapper.asCallback();
        AppPredictor appPredictor = this.setupAppPredictorForUser(userHandle, appPredictorCallback);
        chooserListAdapter.setAppPredictor(appPredictor);
        chooserListAdapter.setAppPredictorCallback(appPredictorCallback, appPredictorCallbackWrapper);
        return new ChooserGridAdapter(chooserListAdapter);
    }

    @VisibleForTesting
    public ChooserListAdapter createChooserListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed, UserHandle userHandle) {
        UserHandle initialIntentsUserSpace = this.isLaunchedAsCloneProfile() && userHandle.equals(this.getPersonalProfileUserHandle()) ? this.getCloneProfileUserHandle() : userHandle;
        return new ChooserListAdapter(context, payloadIntents, initialIntents, rList, filterLastUsed, this.createListController(userHandle), this, this, context.getPackageManager(), this.getChooserActivityLogger(), initialIntentsUserSpace);
    }

    @Override
    @VisibleForTesting
    protected ResolverListController createListController(UserHandle userHandle) {
        AppPredictor appPredictor = this.getAppPredictorForShareActivitiesIfEnabled(userHandle);
        AbstractResolverComparator resolverComparator = appPredictor != null ? new AppPredictionServiceResolverComparator(this, this.getTargetIntent(), this.getReferrerPackageName(), appPredictor, userHandle, this.getChooserActivityLogger()) : new ResolverRankerServiceResolverComparator((Context)this, this.getTargetIntent(), this.getReferrerPackageName(), null, this.getChooserActivityLogger(), this.getResolverRankerServiceUserHandleList(userHandle));
        UserHandle queryIntentsUser = this.getQueryIntentsUser(userHandle);
        return new ChooserListController(this, this.mPm, this.getTargetIntent(), this.getReferrerPackageName(), this.mLaunchedFromUid, userHandle, resolverComparator, queryIntentsUser == null ? userHandle : queryIntentsUser);
    }

    @VisibleForTesting
    protected Bitmap loadThumbnail(Uri uri, Size size) {
        if (uri == null || size == null) {
            return null;
        }
        try {
            return this.getContentResolver().loadThumbnail(uri, size, null);
        }
        catch (IOException | NullPointerException | SecurityException ex) {
            this.logContentPreviewWarning(uri);
            return null;
        }
    }

    private void handleScroll(View view, int x, int y, int oldx, int oldy) {
        if (this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter() != null) {
            this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter().handleScroll(view, y, oldy);
        }
    }

    private void handleLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        boolean insetsChanged;
        if (this.mChooserMultiProfilePagerAdapter == null) {
            return;
        }
        RecyclerView recyclerView = this.mChooserMultiProfilePagerAdapter.getActiveAdapterView();
        ChooserGridAdapter gridAdapter = this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter();
        if (gridAdapter == null || recyclerView == null || recyclerView.computeVerticalScrollOffset() != 0) {
            return;
        }
        int availableWidth = right - left - v.getPaddingLeft() - v.getPaddingRight();
        boolean isLayoutUpdated = gridAdapter.consumeLayoutRequest() || gridAdapter.calculateChooserTargetWidth(availableWidth) || recyclerView.getAdapter() == null || availableWidth != this.mCurrAvailableWidth;
        boolean bl = insetsChanged = !Objects.equals(this.mLastAppliedInsets, this.mSystemWindowInsets);
        if (isLayoutUpdated || insetsChanged || this.mLastNumberOfChildren != recyclerView.getChildCount()) {
            int initialProfile;
            UserHandle currentUserHandle;
            int currentProfile;
            this.mCurrAvailableWidth = availableWidth;
            if (isLayoutUpdated) {
                recyclerView.setAdapter(gridAdapter);
                ((GridLayoutManager)recyclerView.getLayoutManager()).setSpanCount(this.mMaxTargetsPerRow);
                this.updateTabPadding();
            }
            if ((currentProfile = this.getProfileForUser(currentUserHandle = this.mChooserMultiProfilePagerAdapter.getCurrentUserHandle())) != (initialProfile = this.findSelectedProfile())) {
                return;
            }
            if (this.mLastNumberOfChildren == recyclerView.getChildCount() && !insetsChanged) {
                return;
            }
            this.getMainThreadHandler().post(() -> {
                if (this.mResolverDrawerLayout == null || gridAdapter == null) {
                    return;
                }
                int offset = this.calculateDrawerOffset(top, bottom, recyclerView, gridAdapter);
                this.mResolverDrawerLayout.setCollapsibleHeightReserved(offset);
                this.mEnterTransitionAnimationDelegate.markOffsetCalculated();
                this.mLastAppliedInsets = this.mSystemWindowInsets;
            });
        }
    }

    private int calculateDrawerOffset(int top, int bottom, RecyclerView recyclerView, ChooserGridAdapter gridAdapter) {
        int bottomInset;
        int offset = bottomInset = this.mSystemWindowInsets != null ? this.mSystemWindowInsets.bottom : 0;
        int rowsToShow = gridAdapter.getSystemRowCount() + gridAdapter.getProfileRowCount() + gridAdapter.getServiceTargetRowCount() + gridAdapter.getCallerAndRankedTargetRowCount();
        if (rowsToShow == 0) {
            rowsToShow = gridAdapter.getRowCount();
        }
        if (rowsToShow == 0 && !this.shouldShowStickyContentPreview()) {
            return offset += this.getResources().getDimensionPixelSize(17105101);
        }
        Object stickyContentPreview = this.findViewById(16908950);
        if (this.shouldShowStickyContentPreview() && this.isStickyContentPreviewShowing()) {
            offset += ((View)stickyContentPreview).getHeight();
        }
        if (this.shouldShowTabs()) {
            offset += ((View)this.findViewById(16908307)).getHeight();
        }
        if (recyclerView.getVisibility() == 0) {
            boolean isExpandable;
            int directShareHeight = 0;
            rowsToShow = Math.min(4, rowsToShow);
            boolean shouldShowExtraRow = this.shouldShowExtraRow(rowsToShow);
            this.mLastNumberOfChildren = recyclerView.getChildCount();
            int childCount = recyclerView.getChildCount();
            for (int i = 0; i < childCount && rowsToShow > 0; ++i) {
                View child = recyclerView.getChildAt(i);
                if (((GridLayoutManager.LayoutParams)child.getLayoutParams()).getSpanIndex() != 0) continue;
                int height = child.getHeight();
                offset += height;
                if (shouldShowExtraRow) {
                    offset += height;
                }
                if (gridAdapter.getTargetType(recyclerView.getChildAdapterPosition(child)) == 1) {
                    directShareHeight = height;
                }
                --rowsToShow;
            }
            boolean bl = isExpandable = this.getResources().getConfiguration().orientation == 1 && !this.isInMultiWindowMode();
            if (directShareHeight != 0 && this.shouldShowContentPreview() && isExpandable) {
                int requiredExpansionHeight = (int)((float)directShareHeight / 0.78f);
                int topInset = this.mSystemWindowInsets != null ? this.mSystemWindowInsets.top : 0;
                int minHeight = bottom - top - this.mResolverDrawerLayout.getAlwaysShowHeight() - requiredExpansionHeight - topInset - bottomInset;
                offset = Math.min(offset, minHeight);
            }
        } else {
            ViewGroup currentEmptyStateView = this.getActiveEmptyStateView();
            if (currentEmptyStateView.getVisibility() == 0) {
                offset += currentEmptyStateView.getHeight();
            }
        }
        return Math.min(offset, bottom - top);
    }

    private boolean shouldShowExtraRow(int rowsToShow) {
        return this.shouldShowTabs() && rowsToShow == 1 && this.mChooserMultiProfilePagerAdapter.shouldShowEmptyStateScreen(this.mChooserMultiProfilePagerAdapter.getInactiveListAdapter());
    }

    private int getProfileForUser(UserHandle currentUserHandle) {
        if (currentUserHandle.equals(this.getWorkProfileUserHandle())) {
            return 1;
        }
        return 0;
    }

    private ViewGroup getActiveEmptyStateView() {
        int currentPage = this.mChooserMultiProfilePagerAdapter.getCurrentPage();
        return this.mChooserMultiProfilePagerAdapter.getItem(currentPage).getEmptyStateView();
    }

    @Override
    public void onHandlePackagesChanged(ResolverListAdapter listAdapter) {
        this.mChooserMultiProfilePagerAdapter.getActiveListAdapter().notifyDataSetChanged();
        super.onHandlePackagesChanged(listAdapter);
    }

    @Override
    public ResolverListAdapter.ActivityInfoPresentationGetter makePresentationGetter(ActivityInfo info) {
        return this.mChooserMultiProfilePagerAdapter.getActiveListAdapter().makePresentationGetter(info);
    }

    @Override
    public Intent getReferrerFillInIntent() {
        return this.mReferrerFillInIntent;
    }

    @Override
    public int getMaxRankedTargets() {
        return this.mMaxTargetsPerRow;
    }

    @Override
    public void sendListViewUpdateMessage(UserHandle userHandle) {
        Message msg = Message.obtain();
        msg.what = 6;
        msg.obj = userHandle;
        this.mChooserHandler.sendMessageDelayed(msg, this.mListViewUpdateDelayMs);
    }

    @Override
    public void onListRebuilt(ResolverListAdapter listAdapter, boolean rebuildComplete) {
        this.setupScrollListener();
        ChooserListAdapter chooserListAdapter = (ChooserListAdapter)listAdapter;
        if (chooserListAdapter.getUserHandle().equals(this.mChooserMultiProfilePagerAdapter.getCurrentUserHandle())) {
            this.mChooserMultiProfilePagerAdapter.getActiveAdapterView().setAdapter(this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter());
            this.mChooserMultiProfilePagerAdapter.setupListAdapter(this.mChooserMultiProfilePagerAdapter.getCurrentPage());
        }
        if (chooserListAdapter.mDisplayList == null || chooserListAdapter.mDisplayList.isEmpty()) {
            chooserListAdapter.notifyDataSetChanged();
        } else {
            chooserListAdapter.updateAlphabeticalList();
        }
        if (rebuildComplete) {
            this.getChooserActivityLogger().logSharesheetAppLoadComplete();
            this.maybeQueryAdditionalPostProcessingTargets(chooserListAdapter);
            this.mLatencyTracker.onActionEnd(16);
        }
    }

    private void maybeQueryAdditionalPostProcessingTargets(ChooserListAdapter chooserListAdapter) {
        if (ActivityManager.isLowRamDeviceStatic()) {
            return;
        }
        if (!this.shouldQueryShortcutManager(chooserListAdapter.getUserHandle())) {
            return;
        }
        Log.d(TAG, "querying direct share targets from ShortcutManager");
        this.queryDirectShareTargets(chooserListAdapter, false);
    }

    @VisibleForTesting
    protected boolean isUserRunning(UserHandle userHandle) {
        UserManager userManager = this.getSystemService(UserManager.class);
        return userManager.isUserRunning(userHandle);
    }

    @VisibleForTesting
    protected boolean isUserUnlocked(UserHandle userHandle) {
        UserManager userManager = this.getSystemService(UserManager.class);
        return userManager.isUserUnlocked(userHandle);
    }

    @VisibleForTesting
    protected boolean isQuietModeEnabled(UserHandle userHandle) {
        UserManager userManager = this.getSystemService(UserManager.class);
        return userManager.isQuietModeEnabled(userHandle);
    }

    private void setupScrollListener() {
        if (this.mResolverDrawerLayout == null) {
            return;
        }
        int elevatedViewResId = this.shouldShowTabs() ? 16908307 : 16908920;
        Object elevatedView = this.mResolverDrawerLayout.findViewById(elevatedViewResId);
        float defaultElevation = ((View)elevatedView).getElevation();
        float chooserHeaderScrollElevation = this.getResources().getDimensionPixelSize(17105099);
        this.mChooserMultiProfilePagerAdapter.getActiveAdapterView().addOnScrollListener(new RecyclerView.OnScrollListener((View)elevatedView, chooserHeaderScrollElevation, defaultElevation){
            final /* synthetic */ View val$elevatedView;
            final /* synthetic */ float val$chooserHeaderScrollElevation;
            final /* synthetic */ float val$defaultElevation;
            {
                this.val$elevatedView = view;
                this.val$chooserHeaderScrollElevation = f;
                this.val$defaultElevation = f2;
            }

            @Override
            public void onScrollStateChanged(RecyclerView view, int scrollState) {
                if (scrollState == 0) {
                    if (ChooserActivity.this.mScrollStatus == 1) {
                        ChooserActivity.this.mScrollStatus = 0;
                        ChooserActivity.this.setHorizontalScrollingEnabled(true);
                    }
                } else if (scrollState == 1 && ChooserActivity.this.mScrollStatus == 0) {
                    ChooserActivity.this.mScrollStatus = 1;
                    ChooserActivity.this.setHorizontalScrollingEnabled(false);
                }
            }

            @Override
            public void onScrolled(RecyclerView view, int dx, int dy) {
                View child;
                if (view.getChildCount() > 0 && ((child = view.getLayoutManager().findViewByPosition(0)) == null || child.getTop() < 0)) {
                    this.val$elevatedView.setElevation(this.val$chooserHeaderScrollElevation);
                    return;
                }
                this.val$elevatedView.setElevation(this.val$defaultElevation);
            }
        });
    }

    @Override
    public boolean isSendAction(Intent targetIntent) {
        if (targetIntent == null) {
            return false;
        }
        String action = targetIntent.getAction();
        if (action == null) {
            return false;
        }
        return "android.intent.action.SEND".equals(action) || "android.intent.action.SEND_MULTIPLE".equals(action);
    }

    private boolean shouldShowStickyContentPreview() {
        return this.shouldShowStickyContentPreviewNoOrientationCheck() && !this.getResources().getBoolean(17892041);
    }

    private boolean shouldShowStickyContentPreviewNoOrientationCheck() {
        ResolverListAdapter adapter = this.mMultiProfilePagerAdapter.getListAdapterForUserHandle(UserHandle.of(UserHandle.myUserId()));
        boolean isEmpty = adapter == null || adapter.getCount() == 0;
        return this.shouldShowTabs() && (!isEmpty || this.shouldShowStickyContentPreviewWhenEmpty()) && this.shouldShowContentPreview();
    }

    protected boolean shouldShowStickyContentPreviewWhenEmpty() {
        return false;
    }

    @Override
    public boolean shouldShowContentPreview() {
        return this.isSendAction(this.getTargetIntent());
    }

    @Override
    public boolean shouldShowServiceTargets() {
        return this.shouldShowContentPreview() && !ActivityManager.isLowRamDeviceStatic();
    }

    private void updateStickyContentPreview() {
        ViewGroup contentPreviewContainer;
        if (this.shouldShowStickyContentPreviewNoOrientationCheck() && (contentPreviewContainer = (ViewGroup)this.findViewById(16908950)).getChildCount() == 0) {
            ViewGroup contentPreviewView = this.createContentPreviewView(contentPreviewContainer);
            contentPreviewContainer.addView(contentPreviewView);
        }
        if (this.shouldShowStickyContentPreview()) {
            this.showStickyContentPreview();
        } else {
            this.hideStickyContentPreview();
        }
    }

    private void showStickyContentPreview() {
        if (this.isStickyContentPreviewShowing()) {
            return;
        }
        ViewGroup contentPreviewContainer = (ViewGroup)this.findViewById(16908950);
        contentPreviewContainer.setVisibility(0);
    }

    private boolean isStickyContentPreviewShowing() {
        ViewGroup contentPreviewContainer = (ViewGroup)this.findViewById(16908950);
        return contentPreviewContainer.getVisibility() == 0;
    }

    private void hideStickyContentPreview() {
        if (!this.isStickyContentPreviewShowing()) {
            return;
        }
        ViewGroup contentPreviewContainer = (ViewGroup)this.findViewById(16908950);
        contentPreviewContainer.setVisibility(8);
    }

    private void logActionShareWithPreview() {
        Intent targetIntent = this.getTargetIntent();
        int previewType = this.findPreferredContentPreview(targetIntent, this.getContentResolver());
        this.getMetricsLogger().write(new LogMaker(1652).setSubtype(previewType));
    }

    private void startFinishAnimation() {
        View rootView = this.findRootView();
        if (rootView != null) {
            rootView.startAnimation(new FinishAnimation(this, rootView));
        }
    }

    private boolean maybeCancelFinishAnimation() {
        Animation animation;
        View rootView = this.findRootView();
        Animation animation2 = animation = rootView == null ? null : rootView.getAnimation();
        if (animation instanceof FinishAnimation) {
            boolean hasEnded = animation.hasEnded();
            animation.cancel();
            rootView.clearAnimation();
            return !hasEnded;
        }
        return false;
    }

    private View findRootView() {
        if (this.mContentView == null) {
            this.mContentView = this.findViewById(0x1020002);
        }
        return this.mContentView;
    }

    @Override
    public void onButtonClick(View v) {
    }

    @Override
    protected void resetButtonBar() {
    }

    @Override
    protected String getMetricsCategory() {
        return "intent_chooser";
    }

    @Override
    protected void onProfileTabSelected() {
        ChooserGridAdapter currentRootAdapter = this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter();
        currentRootAdapter.updateDirectShareExpansion();
        this.setVerticalScrollEnabled(true);
        if (this.mResolverDrawerLayout != null) {
            this.mResolverDrawerLayout.scrollNestedScrollableChildBackToTop();
        }
    }

    @Override
    protected WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
        if (this.shouldShowTabs()) {
            this.mChooserMultiProfilePagerAdapter.setEmptyStateBottomOffset(insets.getSystemWindowInsetBottom());
            this.mChooserMultiProfilePagerAdapter.setupContainerPadding((View)this.getActiveEmptyStateView().findViewById(16909501));
        }
        WindowInsets result = super.onApplyWindowInsets(v, insets);
        if (this.mResolverDrawerLayout != null) {
            this.mResolverDrawerLayout.requestLayout();
        }
        return result;
    }

    private void setHorizontalScrollingEnabled(boolean enabled) {
        ResolverViewPager viewPager = (ResolverViewPager)this.findViewById(16909458);
        viewPager.setSwipingEnabled(enabled);
    }

    private void setVerticalScrollEnabled(boolean enabled) {
        ChooserGridLayoutManager layoutManager = (ChooserGridLayoutManager)this.mChooserMultiProfilePagerAdapter.getActiveAdapterView().getLayoutManager();
        layoutManager.setVerticalScrollEnabled(enabled);
    }

    @Override
    void onHorizontalSwipeStateChanged(int state) {
        if (state == 1) {
            if (this.mScrollStatus == 0) {
                this.mScrollStatus = 2;
                this.setVerticalScrollEnabled(false);
            }
        } else if (state == 0 && this.mScrollStatus == 2) {
            this.mScrollStatus = 0;
            this.setVerticalScrollEnabled(true);
        }
    }

    @Override
    protected void maybeLogProfileChange() {
        this.getChooserActivityLogger().logShareheetProfileChanged();
    }

    private boolean shouldNearbyShareBeFirstInRankedRow() {
        return ActivityManager.isLowRamDeviceStatic() && this.mIsNearbyShareFirstTargetInRankedApp;
    }

    private boolean shouldNearbyShareBeIncludedAsActionButton() {
        return !this.shouldNearbyShareBeFirstInRankedRow();
    }

    private boolean hasValidIcon(ChooserTarget target) {
        Icon icon = target.getIcon();
        if (icon == null) {
            return true;
        }
        if (icon.getType() == 4 || icon.getType() == 6) {
            Uri uri = icon.getUri();
            try {
                this.getUriGrantsManager().checkGrantUriPermission_ignoreNonSystem(this.getLaunchedFromUid(), this.getPackageName(), ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri));
            }
            catch (RemoteException | SecurityException e) {
                Log.e(TAG, "Failed to get URI permission for: " + uri, e);
                return false;
            }
        }
        return true;
    }

    private IUriGrantsManager getUriGrantsManager() {
        return UriGrantsManager.getService();
    }

    private static ChooserTarget removeIcon(ChooserTarget target) {
        if (target == null) {
            return null;
        }
        return new ChooserTarget(target.getTitle(), null, target.getScore(), target.getComponentName(), target.getIntentExtras());
    }

    private class EnterTransitionAnimationDelegate
    implements View.OnLayoutChangeListener {
        private boolean mPreviewReady = false;
        private boolean mOffsetCalculated = false;

        private EnterTransitionAnimationDelegate() {
        }

        void postponeTransition() {
            ChooserActivity.this.postponeEnterTransition();
        }

        void markImagePreviewReady() {
            if (!this.mPreviewReady) {
                this.mPreviewReady = true;
                this.maybeStartListenForLayout();
            }
        }

        void markOffsetCalculated() {
            if (!this.mOffsetCalculated) {
                this.mOffsetCalculated = true;
                this.maybeStartListenForLayout();
            }
        }

        private void maybeStartListenForLayout() {
            if (this.mPreviewReady && this.mOffsetCalculated && ChooserActivity.this.mResolverDrawerLayout != null) {
                if (ChooserActivity.this.mResolverDrawerLayout.isInLayout()) {
                    ChooserActivity.this.startPostponedEnterTransition();
                } else {
                    ChooserActivity.this.mResolverDrawerLayout.addOnLayoutChangeListener(this);
                    ChooserActivity.this.mResolverDrawerLayout.requestLayout();
                }
            }
        }

        @Override
        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            v.removeOnLayoutChangeListener(this);
            ChooserActivity.this.startPostponedEnterTransition();
        }
    }

    private class ChooserHandler
    extends Handler {
        private static final int LIST_VIEW_UPDATE_MESSAGE = 6;
        private static final int SHORTCUT_MANAGER_ALL_SHARE_TARGET_RESULTS = 7;

        private ChooserHandler() {
        }

        private void removeAllMessages() {
            this.removeMessages(6);
            this.removeMessages(7);
        }

        @Override
        public void handleMessage(Message msg) {
            if (ChooserActivity.this.mChooserMultiProfilePagerAdapter.getActiveListAdapter() == null || ChooserActivity.this.isDestroyed()) {
                return;
            }
            switch (msg.what) {
                case 6: {
                    Log.d(ChooserActivity.TAG, "LIST_VIEW_UPDATE_MESSAGE; ");
                    UserHandle userHandle = (UserHandle)msg.obj;
                    ChooserActivity.this.mChooserMultiProfilePagerAdapter.getListAdapterForUserHandle(userHandle).refreshListView();
                    break;
                }
                case 7: {
                    ServiceResultInfo[] resultInfos;
                    Log.d(ChooserActivity.TAG, "SHORTCUT_MANAGER_ALL_SHARE_TARGET_RESULTS");
                    for (ServiceResultInfo resultInfo : resultInfos = (ServiceResultInfo[])msg.obj) {
                        ChooserListAdapter adapterForUserHandle;
                        if (resultInfo.resultTargets == null || (adapterForUserHandle = ChooserActivity.this.mChooserMultiProfilePagerAdapter.getListAdapterForUserHandle(resultInfo.userHandle)) == null) continue;
                        adapterForUserHandle.addServiceResults(resultInfo.originalTarget, resultInfo.resultTargets, msg.arg1, ChooserActivity.this.mDirectShareShortcutInfoCache);
                    }
                    ChooserActivity.this.logDirectShareTargetReceived(1718);
                    ChooserActivity.this.sendVoiceChoicesIfNeeded();
                    ChooserActivity.this.getChooserActivityLogger().logSharesheetDirectLoadComplete();
                    ChooserActivity.this.mChooserMultiProfilePagerAdapter.getActiveListAdapter().completeServiceTargetLoading();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    @VisibleForTesting
    public class ChooserGridAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private ChooserListAdapter mChooserListAdapter;
        private final LayoutInflater mLayoutInflater;
        private DirectShareViewHolder mDirectShareViewHolder;
        private int mChooserTargetWidth = 0;
        private boolean mShowAzLabelIfPoss;
        private boolean mLayoutRequested = false;
        private int mFooterHeight = 0;
        private static final int VIEW_TYPE_DIRECT_SHARE = 0;
        private static final int VIEW_TYPE_NORMAL = 1;
        private static final int VIEW_TYPE_CONTENT_PREVIEW = 2;
        private static final int VIEW_TYPE_PROFILE = 3;
        private static final int VIEW_TYPE_AZ_LABEL = 4;
        private static final int VIEW_TYPE_CALLER_AND_RANK = 5;
        private static final int VIEW_TYPE_FOOTER = 6;
        private static final int NUM_EXPANSIONS_TO_HIDE_AZ_LABEL = 20;
        private final Set<ViewHolderBase> mBoundViewHolders = new HashSet<ViewHolderBase>();

        ChooserGridAdapter(ChooserListAdapter wrappedAdapter) {
            this.mChooserListAdapter = wrappedAdapter;
            this.mLayoutInflater = LayoutInflater.from(ChooserActivity.this);
            this.mShowAzLabelIfPoss = ChooserActivity.this.getNumSheetExpansions() < 20;
            wrappedAdapter.registerDataSetObserver(new DataSetObserver(){

                @Override
                public void onChanged() {
                    super.onChanged();
                    ChooserGridAdapter.this.notifyDataSetChanged();
                }

                @Override
                public void onInvalidated() {
                    super.onInvalidated();
                    ChooserGridAdapter.this.notifyDataSetChanged();
                }
            });
            if (Flags.notifySingleItemChangeOnIconLoad()) {
                wrappedAdapter.setOnIconLoadedListener(this::onTargetIconLoaded);
            }
        }

        private void onTargetIconLoaded(DisplayResolveInfo info) {
            for (ViewHolderBase holder : this.mBoundViewHolders) {
                switch (holder.getViewType()) {
                    case 1: {
                        TargetInfo itemInfo = this.mChooserListAdapter.getItem(((ItemViewHolder)holder).mListPosition);
                        if (info != itemInfo) break;
                        this.notifyItemChanged(holder.getAdapterPosition());
                        break;
                    }
                    case 5: {
                        ItemGroupViewHolder groupHolder = (ItemGroupViewHolder)holder;
                        if (!this.suggestedAppsGroupContainsTarget(groupHolder, info)) break;
                        this.notifyItemChanged(holder.getAdapterPosition());
                    }
                }
            }
        }

        public void setFooterHeight(int height) {
            this.mFooterHeight = height;
        }

        public boolean calculateChooserTargetWidth(int width) {
            if (width == 0) {
                return false;
            }
            int maxWidth = ChooserActivity.this.getResources().getDimensionPixelSize(17105108);
            width = Math.min(maxWidth, width);
            int newWidth = width / ChooserActivity.this.mMaxTargetsPerRow;
            if (newWidth != this.mChooserTargetWidth) {
                this.mChooserTargetWidth = newWidth;
                return true;
            }
            return false;
        }

        public void hideContentPreview() {
            this.mLayoutRequested = true;
            this.notifyDataSetChanged();
        }

        public boolean consumeLayoutRequest() {
            boolean oldValue = this.mLayoutRequested;
            this.mLayoutRequested = false;
            return oldValue;
        }

        public int getRowCount() {
            return (int)((double)(this.getSystemRowCount() + this.getProfileRowCount() + this.getServiceTargetRowCount() + this.getCallerAndRankedTargetRowCount() + this.getAzLabelRowCount()) + Math.ceil((float)this.mChooserListAdapter.getAlphaTargetCount() / (float)ChooserActivity.this.mMaxTargetsPerRow));
        }

        public int getSystemRowCount() {
            if (ChooserActivity.this.shouldShowTabs()) {
                return 0;
            }
            if (!ChooserActivity.this.shouldShowContentPreview()) {
                return 0;
            }
            if (this.mChooserListAdapter == null || this.mChooserListAdapter.getCount() == 0) {
                return 0;
            }
            return 1;
        }

        public int getProfileRowCount() {
            if (ChooserActivity.this.shouldShowTabs()) {
                return 0;
            }
            return this.mChooserListAdapter.getOtherProfile() == null ? 0 : 1;
        }

        public int getFooterRowCount() {
            return 1;
        }

        public int getCallerAndRankedTargetRowCount() {
            return (int)Math.ceil(((float)this.mChooserListAdapter.getCallerTargetCount() + (float)this.mChooserListAdapter.getRankedTargetCount()) / (float)ChooserActivity.this.mMaxTargetsPerRow);
        }

        public int getServiceTargetRowCount() {
            return ChooserActivity.this.shouldShowServiceTargets() ? 1 : 0;
        }

        public int getAzLabelRowCount() {
            return this.mShowAzLabelIfPoss && this.mChooserListAdapter.getAlphaTargetCount() > 0 ? 1 : 0;
        }

        @Override
        public int getItemCount() {
            return this.getSystemRowCount() + this.getProfileRowCount() + this.getServiceTargetRowCount() + this.getCallerAndRankedTargetRowCount() + this.getAzLabelRowCount() + this.mChooserListAdapter.getAlphaTargetCount() + this.getFooterRowCount();
        }

        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            switch (viewType) {
                case 2: {
                    return new ItemViewHolder(ChooserActivity.this.createContentPreviewView(parent), false, viewType);
                }
                case 3: {
                    return new ItemViewHolder(this.createProfileView(parent), false, viewType);
                }
                case 4: {
                    return new ItemViewHolder(this.createAzLabelView(parent), false, viewType);
                }
                case 1: {
                    return new ItemViewHolder(this.mChooserListAdapter.createView(parent), true, viewType);
                }
                case 0: 
                case 5: {
                    return this.createItemGroupViewHolder(viewType, parent);
                }
                case 6: {
                    Space sp = new Space(parent.getContext());
                    sp.setLayoutParams(new RecyclerView.LayoutParams(-1, this.mFooterHeight));
                    return new FooterViewHolder(sp, viewType);
                }
            }
            return null;
        }

        @Override
        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (Flags.notifySingleItemChangeOnIconLoad()) {
                this.mBoundViewHolders.add((ViewHolderBase)holder);
            }
            int viewType = ((ViewHolderBase)holder).getViewType();
            switch (viewType) {
                case 0: 
                case 5: {
                    this.bindItemGroupViewHolder(position, (ItemGroupViewHolder)holder);
                    break;
                }
                case 1: {
                    this.bindItemViewHolder(position, (ItemViewHolder)holder);
                    break;
                }
            }
        }

        @Override
        public void onViewRecycled(RecyclerView.ViewHolder holder) {
            if (Flags.notifySingleItemChangeOnIconLoad()) {
                this.mBoundViewHolders.remove((ViewHolderBase)holder);
            }
            super.onViewRecycled(holder);
        }

        @Override
        public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
            if (Flags.notifySingleItemChangeOnIconLoad()) {
                this.mBoundViewHolders.remove((ViewHolderBase)holder);
            }
            return super.onFailedToRecycleView(holder);
        }

        @Override
        public int getItemViewType(int position) {
            int count;
            int countSum = count = this.getSystemRowCount();
            if (count > 0 && position < countSum) {
                return 2;
            }
            count = this.getProfileRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 3;
            }
            count = this.getServiceTargetRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 0;
            }
            count = this.getCallerAndRankedTargetRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 5;
            }
            count = this.getAzLabelRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 4;
            }
            if (position == this.getItemCount() - 1) {
                return 6;
            }
            return 1;
        }

        public int getTargetType(int position) {
            return this.mChooserListAdapter.getPositionTargetType(this.getListPosition(position));
        }

        private View createProfileView(ViewGroup parent) {
            View profileRow = this.mLayoutInflater.inflate(17367143, parent, false);
            ChooserActivity.this.mProfileView = profileRow.findViewById(16909457);
            ChooserActivity.this.mProfileView.setOnClickListener(ChooserActivity.this::onProfileClick);
            ChooserActivity.this.updateProfileViewButton();
            return profileRow;
        }

        private View createAzLabelView(ViewGroup parent) {
            return this.mLayoutInflater.inflate(17367135, parent, false);
        }

        private ItemGroupViewHolder loadViewsIntoGroup(final ItemGroupViewHolder holder) {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            int exactSpec = View.MeasureSpec.makeMeasureSpec(this.mChooserTargetWidth, 0x40000000);
            int columnCount = holder.getColumnCount();
            boolean isDirectShare = holder instanceof DirectShareViewHolder;
            for (int i = 0; i < columnCount; ++i) {
                View v = this.mChooserListAdapter.createView(holder.getRowByIndex(i));
                final int column = i;
                v.setOnClickListener(new View.OnClickListener(){

                    @Override
                    public void onClick(View v) {
                        ChooserActivity.this.startSelected(holder.getItemIndex(column), false, true);
                    }
                });
                holder.addView(i, v);
                if (isDirectShare) {
                    ResolverListAdapter.ViewHolder vh = (ResolverListAdapter.ViewHolder)v.getTag();
                    vh.text.setLines(2);
                    vh.text.setHorizontallyScrolling(false);
                    vh.text2.setVisibility(8);
                }
                v.measure(exactSpec, spec);
                this.setViewBounds(v, v.getMeasuredWidth(), v.getMeasuredHeight());
            }
            ViewGroup viewGroup = holder.getViewGroup();
            holder.measure();
            this.setViewBounds(viewGroup, -1, holder.getMeasuredRowHeight());
            if (isDirectShare) {
                DirectShareViewHolder dsvh = (DirectShareViewHolder)holder;
                this.setViewBounds(dsvh.getRow(0), -1, dsvh.getMinRowHeight());
                this.setViewBounds(dsvh.getRow(1), -1, dsvh.getMinRowHeight());
            }
            viewGroup.setTag(holder);
            return holder;
        }

        private void setViewBounds(View view, int widthPx, int heightPx) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(widthPx, heightPx);
                view.setLayoutParams(lp);
            } else {
                lp.height = heightPx;
                lp.width = widthPx;
            }
        }

        ItemGroupViewHolder createItemGroupViewHolder(int viewType, ViewGroup parent) {
            if (viewType == 0) {
                ViewGroup parentGroup = (ViewGroup)this.mLayoutInflater.inflate(17367145, parent, false);
                ViewGroup row1 = (ViewGroup)this.mLayoutInflater.inflate(17367144, parentGroup, false);
                ViewGroup row2 = (ViewGroup)this.mLayoutInflater.inflate(17367144, parentGroup, false);
                parentGroup.addView(row1);
                parentGroup.addView(row2);
                this.mDirectShareViewHolder = new DirectShareViewHolder(parentGroup, Lists.newArrayList(row1, row2), ChooserActivity.this.mMaxTargetsPerRow, viewType, ChooserActivity.this.mChooserMultiProfilePagerAdapter::getActiveListAdapter);
                this.loadViewsIntoGroup(this.mDirectShareViewHolder);
                return this.mDirectShareViewHolder;
            }
            ViewGroup row = (ViewGroup)this.mLayoutInflater.inflate(17367144, parent, false);
            SingleRowViewHolder holder = new SingleRowViewHolder(row, ChooserActivity.this.mMaxTargetsPerRow, viewType);
            this.loadViewsIntoGroup(holder);
            return holder;
        }

        int getRowType(int rowPosition) {
            int positionType = this.mChooserListAdapter.getPositionTargetType(rowPosition);
            if (positionType == 0) {
                return 2;
            }
            if (this.getAzLabelRowCount() > 0 && positionType == 3) {
                return 2;
            }
            return positionType;
        }

        void bindItemViewHolder(int position, ItemViewHolder holder) {
            int listPosition;
            View v = holder.itemView;
            holder.mListPosition = listPosition = this.getListPosition(position);
            this.mChooserListAdapter.bindView(listPosition, v);
        }

        void bindItemGroupViewHolder(int position, ItemGroupViewHolder holder) {
            TextView textView;
            int end;
            ViewGroup viewGroup = (ViewGroup)holder.itemView;
            int start = this.getListPosition(position);
            int startType = this.getRowType(start);
            int columnCount = holder.getColumnCount();
            for (end = start + columnCount - 1; this.getRowType(end) != startType && end >= start; --end) {
            }
            if (end == start && this.mChooserListAdapter.getItem(start) instanceof EmptyTargetInfo && (textView = (TextView)viewGroup.findViewById(16908923)).getVisibility() != 0) {
                textView.setAlpha(0.0f);
                textView.setVisibility(0);
                textView.setText(17039851);
                ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)textView, "alpha", 0.0f, 1.0f);
                fadeAnim.setInterpolator(new DecelerateInterpolator(1.0f));
                float translationInPx = ChooserActivity.this.getResources().getDimensionPixelSize(17105106);
                textView.setTranslationY(translationInPx);
                ObjectAnimator translateAnim = ObjectAnimator.ofFloat((Object)textView, "translationY", 0.0f);
                translateAnim.setInterpolator(new DecelerateInterpolator(1.0f));
                AnimatorSet animSet = new AnimatorSet();
                animSet.setDuration(200L);
                animSet.setStartDelay(200L);
                animSet.playTogether(fadeAnim, translateAnim);
                animSet.start();
            }
            for (int i = 0; i < columnCount; ++i) {
                View v = holder.getView(i);
                if (start + i <= end) {
                    holder.setViewVisibility(i, 0);
                    holder.setItemIndex(i, start + i);
                    this.mChooserListAdapter.bindView(holder.getItemIndex(i), v);
                    continue;
                }
                holder.setViewVisibility(i, 4);
            }
        }

        private boolean suggestedAppsGroupContainsTarget(ItemGroupViewHolder holder, DisplayResolveInfo info) {
            int end;
            int position = holder.getAdapterPosition();
            int start = this.getListPosition(position);
            int startType = this.getRowType(start);
            int columnCount = holder.getColumnCount();
            for (end = start + columnCount - 1; this.getRowType(end) != startType && end >= start; --end) {
            }
            for (int i = 0; i < columnCount; ++i) {
                if (start + i > end || this.mChooserListAdapter.getItem(holder.getItemIndex(i)) != info) continue;
                return true;
            }
            return false;
        }

        int getListPosition(int position) {
            int serviceCount;
            int serviceRows;
            if ((position -= this.getSystemRowCount() + this.getProfileRowCount()) < (serviceRows = (int)Math.ceil((float)(serviceCount = this.mChooserListAdapter.getServiceTargetCount()) / (float)ChooserActivity.this.getMaxRankedTargets()))) {
                return position * ChooserActivity.this.mMaxTargetsPerRow;
            }
            int callerAndRankedCount = this.mChooserListAdapter.getCallerTargetCount() + this.mChooserListAdapter.getRankedTargetCount();
            int callerAndRankedRows = this.getCallerAndRankedTargetRowCount();
            if ((position -= serviceRows) < callerAndRankedRows) {
                return serviceCount + position * ChooserActivity.this.mMaxTargetsPerRow;
            }
            return callerAndRankedCount + serviceCount + (position -= this.getAzLabelRowCount() + callerAndRankedRows);
        }

        public void handleScroll(View v, int y, int oldy) {
            boolean canExpandDirectShare = this.canExpandDirectShare();
            if (this.mDirectShareViewHolder != null && canExpandDirectShare) {
                this.mDirectShareViewHolder.handleScroll(ChooserActivity.this.mChooserMultiProfilePagerAdapter.getActiveAdapterView(), y, oldy, ChooserActivity.this.mMaxTargetsPerRow);
            }
        }

        private boolean canExpandDirectShare() {
            return false;
        }

        public ChooserListAdapter getListAdapter() {
            return this.mChooserListAdapter;
        }

        boolean shouldCellSpan(int position) {
            return this.getItemViewType(position) == 1;
        }

        void updateDirectShareExpansion() {
            if (this.mDirectShareViewHolder == null || !this.canExpandDirectShare()) {
                return;
            }
            RecyclerView activeAdapterView = ChooserActivity.this.mChooserMultiProfilePagerAdapter.getActiveAdapterView();
            if (ChooserActivity.this.mResolverDrawerLayout.isCollapsed()) {
                this.mDirectShareViewHolder.collapse(activeAdapterView);
            } else {
                this.mDirectShareViewHolder.expand(activeAdapterView);
            }
        }
    }

    private class ContentPreviewCoordinator {
        private static final int IMAGE_FADE_IN_MILLIS = 150;
        private static final int IMAGE_LOAD_TIMEOUT = 1;
        private static final int IMAGE_LOAD_INTO_VIEW = 2;
        private final int mImageLoadTimeoutMillis;
        private final View mParentView;
        private boolean mHideParentOnFail;
        private boolean mAtLeastOneLoaded;
        private final Handler mHandler;

        private void setupPreDrawForSharedElementTransition(final View v) {
            v.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    v.getViewTreeObserver().removeOnPreDrawListener(this);
                    if (!ChooserActivity.this.mRemoveSharedElements && ChooserActivity.this.isActivityTransitionRunning()) {
                        ChooserActivity.this.getWindow().setWindowAnimations(0);
                    }
                    ChooserActivity.this.mEnterTransitionAnimationDelegate.markImagePreviewReady();
                    return true;
                }
            });
        }

        ContentPreviewCoordinator(View parentView, boolean hideParentOnFail) {
            this.mImageLoadTimeoutMillis = ChooserActivity.this.getResources().getInteger(0x10E0000);
            this.mAtLeastOneLoaded = false;
            this.mHandler = new Handler(){

                @Override
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            ContentPreviewCoordinator.this.maybeHideContentPreview();
                            break;
                        }
                        case 2: {
                            if (ChooserActivity.this.isFinishing()) break;
                            LoadUriTask task = (LoadUriTask)msg.obj;
                            RoundedRectImageView imageView = (RoundedRectImageView)ContentPreviewCoordinator.this.mParentView.findViewById(task.mImageResourceId);
                            if (task.mBmp == null) {
                                imageView.setVisibility(8);
                                ContentPreviewCoordinator.this.maybeHideContentPreview();
                                return;
                            }
                            ContentPreviewCoordinator.this.mAtLeastOneLoaded = true;
                            imageView.setVisibility(0);
                            imageView.setAlpha(0.0f);
                            imageView.setImageBitmap(task.mBmp);
                            ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)imageView, "alpha", 0.0f, 1.0f);
                            fadeAnim.setInterpolator(new DecelerateInterpolator(1.0f));
                            ((ValueAnimator)fadeAnim).setDuration(150L);
                            ((ValueAnimator)fadeAnim).start();
                            if (task.mExtraCount > 0) {
                                imageView.setExtraImageCount(task.mExtraCount);
                            }
                            ContentPreviewCoordinator.this.setupPreDrawForSharedElementTransition(imageView);
                        }
                    }
                }
            };
            this.mParentView = parentView;
            this.mHideParentOnFail = hideParentOnFail;
        }

        private void loadUriIntoView(int imageResourceId, Uri uri, int extraImages) {
            this.mHandler.sendEmptyMessageDelayed(1, this.mImageLoadTimeoutMillis);
            AsyncTask.THREAD_POOL_EXECUTOR.execute(() -> {
                int size = ChooserActivity.this.getResources().getDimensionPixelSize(17105104);
                Bitmap bmp = ChooserActivity.this.loadThumbnail(uri, new Size(size, size));
                Message msg = Message.obtain();
                msg.what = 2;
                msg.obj = new LoadUriTask(this, imageResourceId, uri, extraImages, bmp);
                this.mHandler.sendMessage(msg);
            });
        }

        private void cancelLoads() {
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(1);
        }

        private void maybeHideContentPreview() {
            if (!this.mAtLeastOneLoaded) {
                if (this.mHideParentOnFail) {
                    Log.i(ChooserActivity.TAG, "Hiding image preview area. Timed out waiting for preview to load within " + this.mImageLoadTimeoutMillis + "ms.");
                    this.collapseParentView();
                    if (ChooserActivity.this.shouldShowTabs()) {
                        ChooserActivity.this.hideStickyContentPreview();
                    } else if (ChooserActivity.this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter() != null) {
                        ChooserActivity.this.mChooserMultiProfilePagerAdapter.getCurrentRootAdapter().hideContentPreview();
                    }
                    this.mHideParentOnFail = false;
                }
                ChooserActivity.this.mRemoveSharedElements = true;
                ChooserActivity.this.mEnterTransitionAnimationDelegate.markImagePreviewReady();
            }
        }

        private void collapseParentView() {
            View v = this.mParentView;
            int widthSpec = View.MeasureSpec.makeMeasureSpec(v.getWidth(), 0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec(0, 0x40000000);
            v.measure(widthSpec, heightSpec);
            v.getLayoutParams().height = 0;
            v.layout(v.getLeft(), v.getTop(), v.getRight(), v.getTop());
            v.invalidate();
        }

        class LoadUriTask {
            public final Uri mUri;
            public final int mImageResourceId;
            public final int mExtraCount;
            public final Bitmap mBmp;

            LoadUriTask(ContentPreviewCoordinator this$1, int imageResourceId, Uri uri, int extraCount, Bitmap bmp) {
                this.mImageResourceId = imageResourceId;
                this.mUri = uri;
                this.mExtraCount = extraCount;
                this.mBmp = bmp;
            }
        }
    }

    private static class FileInfo {
        public final String name;
        public final boolean hasThumbnail;

        FileInfo(String name, boolean hasThumbnail) {
            this.name = name;
            this.hasThumbnail = hasThumbnail;
        }
    }

    static class RefinementResultReceiver
    extends ResultReceiver {
        private ChooserActivity mChooserActivity;
        private TargetInfo mSelectedTarget;

        public RefinementResultReceiver(ChooserActivity host, TargetInfo target, Handler handler) {
            super(handler);
            this.mChooserActivity = host;
            this.mSelectedTarget = target;
        }

        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (this.mChooserActivity == null) {
                Log.e(ChooserActivity.TAG, "Destroyed RefinementResultReceiver received a result");
                return;
            }
            if (resultData == null) {
                Log.e(ChooserActivity.TAG, "RefinementResultReceiver received null resultData");
                return;
            }
            switch (resultCode) {
                case 0: {
                    this.mChooserActivity.onRefinementCanceled();
                    break;
                }
                case -1: {
                    Object intentParcelable = resultData.getParcelable("android.intent.extra.INTENT");
                    if (intentParcelable instanceof Intent) {
                        this.mChooserActivity.onRefinementResult(this.mSelectedTarget, (Intent)intentParcelable);
                        break;
                    }
                    Log.e(ChooserActivity.TAG, "RefinementResultReceiver received RESULT_OK but no Intent in resultData with key Intent.EXTRA_INTENT");
                    break;
                }
                default: {
                    Log.w(ChooserActivity.TAG, "Unknown result code " + resultCode + " sent to RefinementResultReceiver");
                }
            }
        }

        public void destroy() {
            this.mChooserActivity = null;
            this.mSelectedTarget = null;
        }
    }

    @VisibleForTesting
    public static class ServiceResultInfo {
        public final DisplayResolveInfo originalTarget;
        public final List<ChooserTarget> resultTargets;
        public final UserHandle userHandle;

        public ServiceResultInfo(DisplayResolveInfo ot, List<ChooserTarget> rt, UserHandle userHandle) {
            this.originalTarget = ot;
            this.resultTargets = rt;
            this.userHandle = userHandle;
        }
    }

    public class ChooserListController
    extends ResolverListController {
        public ChooserListController(Context context, PackageManager pm, Intent targetIntent, String referrerPackageName, int launchedFromUid, UserHandle userId, AbstractResolverComparator resolverComparator, UserHandle queryIntentsAsUser) {
            super(context, pm, targetIntent, referrerPackageName, launchedFromUid, userId, resolverComparator, queryIntentsAsUser);
        }

        @Override
        boolean isComponentFiltered(ComponentName name) {
            if (ChooserActivity.this.mFilteredComponentNames == null) {
                return false;
            }
            for (ComponentName filteredComponentName : ChooserActivity.this.mFilteredComponentNames) {
                if (!name.equals(filteredComponentName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isComponentPinned(ComponentName name) {
            return false;
        }

        @Override
        public boolean isFixedAtTop(ComponentName name) {
            return name != null && name.equals(ChooserActivity.this.getNearbySharingComponent()) && ChooserActivity.this.shouldNearbyShareBeFirstInRankedRow();
        }
    }

    private static class FinishAnimation
    extends AlphaAnimation
    implements Animation.AnimationListener {
        @Nullable
        private Activity mActivity;
        @Nullable
        private View mRootView;
        private final float mFromAlpha;

        FinishAnimation(@NonNull Activity activity, @NonNull View rootView) {
            super(rootView.getAlpha(), 0.0f);
            this.mActivity = activity;
            this.mRootView = rootView;
            this.mFromAlpha = rootView.getAlpha();
            this.setInterpolator(new LinearInterpolator());
            long duration = activity.getWindow().getTransitionBackgroundFadeDuration();
            this.setDuration(duration);
            this.setStartOffset(duration);
            super.setAnimationListener(this);
        }

        @Override
        public void setAnimationListener(Animation.AnimationListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void cancel() {
            if (this.mRootView != null) {
                this.mRootView.setAlpha(this.mFromAlpha);
            }
            this.cleanup();
            super.cancel();
        }

        @Override
        public void onAnimationStart(Animation animation) {
        }

        @Override
        public void onAnimationEnd(Animation animation) {
            Activity activity = this.mActivity;
            this.cleanup();
            if (activity != null) {
                activity.finish();
            }
        }

        @Override
        public void onAnimationRepeat(Animation animation) {
        }

        private void cleanup() {
            this.mActivity = null;
            this.mRootView = null;
        }
    }

    public static class RoundedRectImageView
    extends ImageView {
        private int mRadius = 0;
        private Path mPath = new Path();
        private Paint mOverlayPaint = new Paint(0);
        private Paint mRoundRectPaint = new Paint(0);
        private Paint mTextPaint = new Paint(1);
        private String mExtraImageCount = null;

        public RoundedRectImageView(Context context) {
            super(context);
        }

        public RoundedRectImageView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public RoundedRectImageView(Context context, AttributeSet attrs, int defStyleAttr) {
            this(context, attrs, defStyleAttr, 0);
        }

        public RoundedRectImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.mRadius = context.getResources().getDimensionPixelSize(17105094);
            this.mOverlayPaint.setColor(-1728053248);
            this.mOverlayPaint.setStyle(Paint.Style.FILL);
            this.mRoundRectPaint.setColor(context.getResources().getColor(17170935));
            this.mRoundRectPaint.setStyle(Paint.Style.STROKE);
            this.mRoundRectPaint.setStrokeWidth(context.getResources().getDimensionPixelSize(17105102));
            this.mTextPaint.setColor(-1);
            this.mTextPaint.setTextSize(context.getResources().getDimensionPixelSize(17105103));
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        }

        private void updatePath(int width, int height) {
            this.mPath.reset();
            int imageWidth = width - this.getPaddingRight() - this.getPaddingLeft();
            int imageHeight = height - this.getPaddingBottom() - this.getPaddingTop();
            this.mPath.addRoundRect(this.getPaddingLeft(), this.getPaddingTop(), imageWidth, imageHeight, this.mRadius, this.mRadius, Path.Direction.CW);
        }

        public void setRadius(int radius) {
            this.mRadius = radius;
            this.updatePath(this.getWidth(), this.getHeight());
        }

        public void setExtraImageCount(int count) {
            this.mExtraImageCount = count > 0 ? "+" + count : null;
        }

        @Override
        protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
            super.onSizeChanged(width, height, oldWidth, oldHeight);
            this.updatePath(width, height);
        }

        @Override
        protected void onDraw(Canvas canvas) {
            if (this.mRadius != 0) {
                canvas.clipPath(this.mPath);
            }
            super.onDraw(canvas);
            int x = this.getPaddingLeft();
            int y = this.getPaddingRight();
            int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
            int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
            if (this.mExtraImageCount != null) {
                canvas.drawRect(x, y, width, height, this.mOverlayPaint);
                int xPos = canvas.getWidth() / 2;
                int yPos = (int)((float)canvas.getHeight() / 2.0f - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
                canvas.drawText(this.mExtraImageCount, xPos, yPos, this.mTextPaint);
            }
            canvas.drawRoundRect(x, y, width, height, this.mRadius, this.mRadius, this.mRoundRectPaint);
        }
    }

    static class ChooserTargetRankingInfo {
        public final List<AppTarget> scores;
        public final UserHandle userHandle;

        ChooserTargetRankingInfo(List<AppTarget> chooserTargetScores, UserHandle userHandle) {
            this.scores = chooserTargetScores;
            this.userHandle = userHandle;
        }
    }

    static class DirectShareViewHolder
    extends ItemGroupViewHolder {
        private final ViewGroup mParent;
        private final List<ViewGroup> mRows;
        private int mCellCountPerRow;
        private boolean mHideDirectShareExpansion = false;
        private int mDirectShareMinHeight = 0;
        private int mDirectShareCurrHeight = 0;
        private int mDirectShareMaxHeight = 0;
        private final boolean[] mCellVisibility;
        private final Supplier<ChooserListAdapter> mListAdapterSupplier;

        DirectShareViewHolder(ViewGroup parent, List<ViewGroup> rows, int cellCountPerRow, int viewType, Supplier<ChooserListAdapter> listAdapterSupplier) {
            super(rows.size() * cellCountPerRow, parent, viewType);
            this.mParent = parent;
            this.mRows = rows;
            this.mCellCountPerRow = cellCountPerRow;
            this.mCellVisibility = new boolean[rows.size() * cellCountPerRow];
            Arrays.fill(this.mCellVisibility, true);
            this.mListAdapterSupplier = listAdapterSupplier;
        }

        @Override
        public ViewGroup addView(int index, View v) {
            ViewGroup row = this.getRowByIndex(index);
            row.addView(v);
            this.mCells[index] = v;
            return row;
        }

        @Override
        public ViewGroup getViewGroup() {
            return this.mParent;
        }

        @Override
        public ViewGroup getRowByIndex(int index) {
            return this.mRows.get(index / this.mCellCountPerRow);
        }

        @Override
        public ViewGroup getRow(int rowNumber) {
            return this.mRows.get(rowNumber);
        }

        @Override
        public void measure() {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            this.getRow(0).measure(spec, spec);
            this.getRow(1).measure(spec, spec);
            this.mDirectShareMinHeight = this.getRow(0).getMeasuredHeight();
            this.mDirectShareCurrHeight = this.mDirectShareCurrHeight > 0 ? this.mDirectShareCurrHeight : this.mDirectShareMinHeight;
            this.mDirectShareMaxHeight = 2 * this.mDirectShareMinHeight;
        }

        @Override
        public int getMeasuredRowHeight() {
            return this.mDirectShareCurrHeight;
        }

        public int getMinRowHeight() {
            return this.mDirectShareMinHeight;
        }

        @Override
        public void setViewVisibility(int i, int visibility) {
            final View v = this.getView(i);
            if (visibility == 0) {
                this.mCellVisibility[i] = true;
                v.setVisibility(visibility);
                v.setAlpha(1.0f);
            } else if (visibility == 4 && this.mCellVisibility[i]) {
                this.mCellVisibility[i] = false;
                ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)v, "alpha", 1.0f, 0.0f);
                ((ValueAnimator)fadeAnim).setDuration(200L);
                fadeAnim.setInterpolator(new AccelerateInterpolator(1.0f));
                fadeAnim.addListener(new AnimatorListenerAdapter(this){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        v.setVisibility(4);
                    }
                });
                ((ValueAnimator)fadeAnim).start();
            }
        }

        public void handleScroll(RecyclerView view, int y, int oldy, int maxTargetsPerRow) {
            boolean notExpanded;
            boolean bl = notExpanded = this.mDirectShareCurrHeight == this.mDirectShareMinHeight;
            if (notExpanded) {
                if (this.mHideDirectShareExpansion) {
                    return;
                }
                ChooserListAdapter adapter = this.mListAdapterSupplier.get();
                int validTargets = adapter.getSelectableServiceTargetCount();
                if (validTargets <= maxTargetsPerRow) {
                    this.mHideDirectShareExpansion = true;
                    return;
                }
            }
            int yDiff = (int)((float)(oldy - y) * 0.78f);
            int prevHeight = this.mDirectShareCurrHeight;
            int newHeight = Math.min(prevHeight + yDiff, this.mDirectShareMaxHeight);
            newHeight = Math.max(newHeight, this.mDirectShareMinHeight);
            yDiff = newHeight - prevHeight;
            this.updateDirectShareRowHeight(view, yDiff, newHeight);
        }

        void expand(RecyclerView view) {
            this.updateDirectShareRowHeight(view, this.mDirectShareMaxHeight - this.mDirectShareCurrHeight, this.mDirectShareMaxHeight);
        }

        void collapse(RecyclerView view) {
            this.updateDirectShareRowHeight(view, this.mDirectShareMinHeight - this.mDirectShareCurrHeight, this.mDirectShareMinHeight);
        }

        private void updateDirectShareRowHeight(RecyclerView view, int yDiff, int newHeight) {
            if (view == null || view.getChildCount() == 0 || yDiff == 0) {
                return;
            }
            boolean foundExpansion = false;
            for (int i = 0; i < view.getChildCount(); ++i) {
                View child = view.getChildAt(i);
                if (foundExpansion) {
                    child.offsetTopAndBottom(yDiff);
                    continue;
                }
                if (child.getTag() == null || !(child.getTag() instanceof DirectShareViewHolder)) continue;
                int widthSpec = View.MeasureSpec.makeMeasureSpec(child.getWidth(), 0x40000000);
                int heightSpec = View.MeasureSpec.makeMeasureSpec(newHeight, 0x40000000);
                child.measure(widthSpec, heightSpec);
                child.getLayoutParams().height = child.getMeasuredHeight();
                child.layout(child.getLeft(), child.getTop(), child.getRight(), child.getTop() + child.getMeasuredHeight());
                foundExpansion = true;
            }
            if (foundExpansion) {
                this.mDirectShareCurrHeight = newHeight;
            }
        }
    }

    static class SingleRowViewHolder
    extends ItemGroupViewHolder {
        private final ViewGroup mRow;

        SingleRowViewHolder(ViewGroup row, int cellCount, int viewType) {
            super(cellCount, row, viewType);
            this.mRow = row;
        }

        @Override
        public ViewGroup getViewGroup() {
            return this.mRow;
        }

        @Override
        public ViewGroup getRowByIndex(int index) {
            return this.mRow;
        }

        @Override
        public ViewGroup getRow(int rowNumber) {
            if (rowNumber == 0) {
                return this.mRow;
            }
            return null;
        }

        @Override
        public ViewGroup addView(int index, View v) {
            this.mRow.addView(v);
            this.mCells[index] = v;
            return this.mRow;
        }

        @Override
        public void setViewVisibility(int i, int visibility) {
            this.getView(i).setVisibility(visibility);
        }
    }

    static abstract class ItemGroupViewHolder
    extends ViewHolderBase {
        protected int mMeasuredRowHeight;
        private int[] mItemIndices;
        protected final View[] mCells;
        private final int mColumnCount;

        ItemGroupViewHolder(int cellCount, View itemView, int viewType) {
            super(itemView, viewType);
            this.mCells = new View[cellCount];
            this.mItemIndices = new int[cellCount];
            this.mColumnCount = cellCount;
        }

        abstract ViewGroup addView(int var1, View var2);

        abstract ViewGroup getViewGroup();

        abstract ViewGroup getRowByIndex(int var1);

        abstract ViewGroup getRow(int var1);

        abstract void setViewVisibility(int var1, int var2);

        public int getColumnCount() {
            return this.mColumnCount;
        }

        public void measure() {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            this.getViewGroup().measure(spec, spec);
            this.mMeasuredRowHeight = this.getViewGroup().getMeasuredHeight();
        }

        public int getMeasuredRowHeight() {
            return this.mMeasuredRowHeight;
        }

        public void setItemIndex(int itemIndex, int listIndex) {
            this.mItemIndices[itemIndex] = listIndex;
        }

        public int getItemIndex(int itemIndex) {
            return this.mItemIndices[itemIndex];
        }

        public View getView(int index) {
            return this.mCells[index];
        }
    }

    static class FooterViewHolder
    extends ViewHolderBase {
        FooterViewHolder(View itemView, int viewType) {
            super(itemView, viewType);
        }
    }

    class ItemViewHolder
    extends ViewHolderBase {
        ResolverListAdapter.ViewHolder mWrappedViewHolder;
        int mListPosition;

        ItemViewHolder(View itemView, boolean isClickable, int viewType) {
            super(itemView, viewType);
            this.mListPosition = -1;
            this.mWrappedViewHolder = new ResolverListAdapter.ViewHolder(itemView);
            if (isClickable) {
                itemView.setOnClickListener(v -> ChooserActivity.this.startSelected(this.mListPosition, false, true));
            }
        }
    }

    static abstract class ViewHolderBase
    extends RecyclerView.ViewHolder {
        private int mViewType;

        ViewHolderBase(View itemView, int viewType) {
            super(itemView);
            this.mViewType = viewType;
        }

        int getViewType() {
            return this.mViewType;
        }
    }

    static class BaseChooserTargetComparator
    implements Comparator<ChooserTarget> {
        BaseChooserTargetComparator() {
        }

        @Override
        public int compare(ChooserTarget lhs, ChooserTarget rhs) {
            return (int)Math.signum(rhs.getScore() - lhs.getScore());
        }
    }

    protected static class EmptyTargetInfo
    extends NotSelectableTargetInfo {
        @Override
        public Drawable getDisplayIcon(Context context) {
            return null;
        }
    }

    static class PlaceHolderTargetInfo
    extends NotSelectableTargetInfo {
        PlaceHolderTargetInfo() {
        }

        @Override
        public Drawable getDisplayIcon(Context context) {
            AnimatedVectorDrawable avd = (AnimatedVectorDrawable)context.getDrawable(17302234);
            avd.start();
            return avd;
        }
    }

    static class AzInfoComparator
    implements Comparator<DisplayResolveInfo> {
        Comparator<DisplayResolveInfo> mComparator;

        AzInfoComparator(Context context) {
            Collator collator = Collator.getInstance(context.getResources().getConfiguration().locale);
            this.mComparator = Comparator.comparing(DisplayResolveInfo::getDisplayLabel, collator).thenComparingInt(displayResolveInfo -> displayResolveInfo.getResolveInfo().userHandle.getIdentifier());
        }

        @Override
        public int compare(DisplayResolveInfo lhsp, DisplayResolveInfo rhsp) {
            return this.mComparator.compare(lhsp, rhsp);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ContentPreviewType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShareTargetType {
    }
}

