/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.Nullable;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ChooserListAdapter;
import com.android.internal.hidden_from_bootclasspath.android.service.chooser.Flags;
import com.android.internal.widget.GridLayoutManager;
import com.android.internal.widget.RecyclerView;

public class ChooserGridLayoutManager
extends GridLayoutManager {
    private CharSequence mShortcutGroupTitle = "";
    private CharSequence mSuggestedAppsGroupTitle = "";
    private CharSequence mAllAppListGroupTitle = "";
    @Nullable
    private RecyclerView mRecyclerView;
    private boolean mVerticalScrollEnabled = true;

    public ChooserGridLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (Flags.announceShortcutsAndSuggestedAppsLegacy()) {
            this.readGroupTitles(context);
        }
    }

    public ChooserGridLayoutManager(Context context, int spanCount) {
        super(context, spanCount);
        if (Flags.announceShortcutsAndSuggestedAppsLegacy()) {
            this.readGroupTitles(context);
        }
    }

    public ChooserGridLayoutManager(Context context, int spanCount, int orientation, boolean reverseLayout) {
        super(context, spanCount, orientation, reverseLayout);
        if (Flags.announceShortcutsAndSuggestedAppsLegacy()) {
            this.readGroupTitles(context);
        }
    }

    private void readGroupTitles(Context context) {
        this.mShortcutGroupTitle = context.getString(17041856);
        this.mSuggestedAppsGroupTitle = context.getString(17041960);
        this.mAllAppListGroupTitle = context.getString(17039689);
    }

    @Override
    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.mRecyclerView = view;
    }

    @Override
    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.mRecyclerView = null;
    }

    @Override
    public int getRowCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return super.getRowCountForAccessibility(recycler, state) - 1;
    }

    void setVerticalScrollEnabled(boolean verticalScrollEnabled) {
        this.mVerticalScrollEnabled = verticalScrollEnabled;
    }

    @Override
    public boolean canScrollVertically() {
        return this.mVerticalScrollEnabled && super.canScrollVertically();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(RecyclerView.Recycler recycler, RecyclerView.State state, View host, AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoForItem(recycler, state, host, info);
        if (Flags.announceShortcutsAndSuggestedAppsLegacy() && host instanceof ViewGroup) {
            if (host.getId() == 16909590) {
                info.setClassName(ListView.class.getName());
                info.setContainerTitle(this.mShortcutGroupTitle);
                info.setCollectionInfo(this.createShortcutsA11yCollectionInfo((ViewGroup)host));
            } else if (host.getId() == 16908922) {
                RecyclerView.Adapter adapter = this.mRecyclerView == null ? null : this.mRecyclerView.getAdapter();
                ChooserListAdapter gridAdapter = adapter instanceof ChooserActivity.ChooserGridAdapter ? ((ChooserActivity.ChooserGridAdapter)adapter).getListAdapter() : null;
                info.setClassName(ListView.class.getName());
                info.setCollectionInfo(this.createSuggestedAppsA11yCollectionInfo((ViewGroup)host));
                if (gridAdapter == null || gridAdapter.getAlphaTargetCount() > 0) {
                    info.setContainerTitle(this.mSuggestedAppsGroupTitle);
                } else {
                    info.setContainerTitle(this.mAllAppListGroupTitle);
                }
            }
        }
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(RecyclerView.Recycler recycler, RecyclerView.State state, AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(recycler, state, info);
        if (Flags.announceShortcutsAndSuggestedAppsLegacy()) {
            info.setContainerTitle(this.mAllAppListGroupTitle);
        }
    }

    @Override
    public boolean isLayoutHierarchical(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return Flags.announceShortcutsAndSuggestedAppsLegacy() || super.isLayoutHierarchical(recycler, state);
    }

    private AccessibilityNodeInfo.CollectionInfo createShortcutsA11yCollectionInfo(ViewGroup container) {
        int rowCount = 0;
        int columnCount = 0;
        for (int i = 0; i < container.getChildCount(); ++i) {
            View row = container.getChildAt(i);
            int rowColumnCount = 0;
            if (row instanceof ViewGroup) {
                ViewGroup rowGroup = (ViewGroup)row;
                if (row.getVisibility() == 0) {
                    for (int j = 0; j < rowGroup.getChildCount(); ++j) {
                        View v = rowGroup.getChildAt(j);
                        if (v == null || v.getVisibility() != 0) continue;
                        ++rowColumnCount;
                        if (!(v instanceof TextView)) continue;
                        rowColumnCount = 1;
                        break;
                    }
                }
            }
            if (rowColumnCount <= 0) continue;
            ++rowCount;
            columnCount = Math.max(columnCount, rowColumnCount);
        }
        return AccessibilityNodeInfo.CollectionInfo.obtain(rowCount, columnCount, false);
    }

    private AccessibilityNodeInfo.CollectionInfo createSuggestedAppsA11yCollectionInfo(ViewGroup container) {
        int columnCount = 0;
        for (int i = 0; i < container.getChildCount(); ++i) {
            View v = container.getChildAt(i);
            if (v.getVisibility() != 0) continue;
            ++columnCount;
        }
        return AccessibilityNodeInfo.CollectionInfo.obtain(1, columnCount, false);
    }
}

