/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.EnforcePermission;
import android.annotation.RequiresNoPermission;
import android.app.ActivityThread;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.Binder;
import android.os.BluetoothBatteryStats;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.WakeLockStats;
import android.os.WorkSource;
import android.os.connectivity.CellularBatteryStats;
import android.os.connectivity.GpsBatteryStats;
import android.os.connectivity.WifiActivityEnergyInfo;
import android.os.connectivity.WifiBatteryStats;
import android.os.health.HealthStatsParceler;
import android.telephony.ModemActivityInfo;
import android.telephony.SignalStrength;
import java.util.ArrayList;
import java.util.List;

public interface IBatteryStats
extends IInterface {
    public static final int RESULT_OK = 0;
    public static final int RESULT_RUNTIME_EXCEPTION = 1;
    public static final int RESULT_SECURITY_EXCEPTION = 2;
    public static final String KEY_UID_SNAPSHOTS = "uid_snapshots";
    public static final String KEY_EXCEPTION_MESSAGE = "exception";

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStartSensor(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStopSensor(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStartVideo(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStopVideo(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStartAudio(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStopAudio(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteResetVideo() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteResetAudio() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteFlashlightOn(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteFlashlightOff(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStartCamera(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStopCamera(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteResetCamera() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteResetFlashlight() throws RemoteException;

    public void noteWakeupSensorEvent(long var1, int var3, int var4) throws RemoteException;

    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public List<BatteryUsageStats> getBatteryUsageStats(List<BatteryUsageStatsQuery> var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IBatteryStats.aidl:91:1:91:69")
    @RequiresNoPermission
    public boolean isCharging() throws RemoteException;

    @RequiresNoPermission
    public long computeBatteryTimeRemaining() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IBatteryStats.aidl:102:1:102:69")
    @RequiresNoPermission
    public long computeChargeTimeRemaining() throws RemoteException;

    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public long computeBatteryScreenOffRealtimeMs() throws RemoteException;

    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public long getScreenOffDischargeMah() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteEvent(int var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteSyncStart(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteSyncFinish(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteJobStart(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteJobFinish(String var1, int var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStartWakelock(int var1, int var2, String var3, String var4, int var5, boolean var6) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStopWakelock(int var1, int var2, String var3, String var4, int var5) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStartWakelockFromSource(WorkSource var1, int var2, String var3, String var4, int var5, boolean var6) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteChangeWakelockFromSource(WorkSource var1, int var2, String var3, String var4, int var5, WorkSource var6, int var7, String var8, String var9, int var10, boolean var11) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteStopWakelockFromSource(WorkSource var1, int var2, String var3, String var4, int var5) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteLongPartialWakelockStart(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteLongPartialWakelockStartFromSource(String var1, String var2, WorkSource var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteLongPartialWakelockFinish(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteLongPartialWakelockFinishFromSource(String var1, String var2, WorkSource var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteVibratorOn(int var1, long var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteVibratorOff(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteGpsChanged(WorkSource var1, WorkSource var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteGpsSignalQuality(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteScreenState(int var1, int var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteScreenBrightness(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteUserActivity(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWakeUp(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteInteractive(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteConnectivityChanged(int var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteMobileRadioPowerState(int var1, long var2, int var4) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void notePhoneOn() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void notePhoneOff() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void notePhoneSignalStrength(SignalStrength var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void notePhoneDataConnectionState(int var1, boolean var2, int var3, int var4, int var5) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void notePhoneState(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiOn() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiOff() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiRunning(WorkSource var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiRunningChanged(WorkSource var1, WorkSource var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiStopped(WorkSource var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiState(int var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiSupplicantStateChanged(int var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiRssiChanged(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteFullWifiLockAcquired(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteFullWifiLockReleased(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiScanStarted(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiScanStopped(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiMulticastEnabled(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiMulticastDisabled(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteFullWifiLockAcquiredFromSource(WorkSource var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteFullWifiLockReleasedFromSource(WorkSource var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiScanStartedFromSource(WorkSource var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiScanStoppedFromSource(WorkSource var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiBatchedScanStartedFromSource(WorkSource var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiBatchedScanStoppedFromSource(WorkSource var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiRadioPowerState(int var1, long var2, int var4) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public void noteNetworkInterfaceForTransports(String var1, int[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteNetworkStatsEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteDeviceIdleMode(int var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void setBatteryState(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IBatteryStats.aidl:235:1:235:69")
    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public long getAwakeTimeBattery() throws RemoteException;

    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public long getAwakeTimePlugged() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteBleScanStarted(WorkSource var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteBleScanStopped(WorkSource var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteBleScanReset() throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteBleScanResults(WorkSource var1, int var2) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.UPDATE_DEVICE_STATS", "android.permission.BATTERY_STATS"})
    public CellularBatteryStats getCellularBatteryStats() throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.UPDATE_DEVICE_STATS", "android.permission.BATTERY_STATS"})
    public WifiBatteryStats getWifiBatteryStats() throws RemoteException;

    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public GpsBatteryStats getGpsBatteryStats() throws RemoteException;

    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public WakeLockStats getWakeLockStats() throws RemoteException;

    @EnforcePermission(value="android.permission.BATTERY_STATS")
    public BluetoothBatteryStats getBluetoothBatteryStats() throws RemoteException;

    public HealthStatsParceler takeUidSnapshot(int var1) throws RemoteException;

    public HealthStatsParceler[] takeUidSnapshots(int[] var1) throws RemoteException;

    public void takeUidSnapshotsAsync(int[] var1, ResultReceiver var2) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteBluetoothControllerActivity(BluetoothActivityEnergyInfo var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteModemControllerActivity(ModemActivityInfo var1) throws RemoteException;

    @EnforcePermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void noteWifiControllerActivity(WifiActivityEnergyInfo var1) throws RemoteException;

    @EnforcePermission(value="android.permission.POWER_SAVER")
    public boolean setChargingStateUpdateDelayMillis(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.DEVICE_POWER")
    public void setChargerAcOnline(boolean var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.DEVICE_POWER")
    public void setBatteryLevel(int var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.DEVICE_POWER")
    public void unplugBattery(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.DEVICE_POWER")
    public void resetBattery(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.DEVICE_POWER")
    public void suspendBatteryInput() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBatteryStats {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "com.android.internal.app.IBatteryStats";
        static final int TRANSACTION_noteStartSensor = 1;
        static final int TRANSACTION_noteStopSensor = 2;
        static final int TRANSACTION_noteStartVideo = 3;
        static final int TRANSACTION_noteStopVideo = 4;
        static final int TRANSACTION_noteStartAudio = 5;
        static final int TRANSACTION_noteStopAudio = 6;
        static final int TRANSACTION_noteResetVideo = 7;
        static final int TRANSACTION_noteResetAudio = 8;
        static final int TRANSACTION_noteFlashlightOn = 9;
        static final int TRANSACTION_noteFlashlightOff = 10;
        static final int TRANSACTION_noteStartCamera = 11;
        static final int TRANSACTION_noteStopCamera = 12;
        static final int TRANSACTION_noteResetCamera = 13;
        static final int TRANSACTION_noteResetFlashlight = 14;
        static final int TRANSACTION_noteWakeupSensorEvent = 15;
        static final int TRANSACTION_getBatteryUsageStats = 16;
        static final int TRANSACTION_isCharging = 17;
        static final int TRANSACTION_computeBatteryTimeRemaining = 18;
        static final int TRANSACTION_computeChargeTimeRemaining = 19;
        static final int TRANSACTION_computeBatteryScreenOffRealtimeMs = 20;
        static final int TRANSACTION_getScreenOffDischargeMah = 21;
        static final int TRANSACTION_noteEvent = 22;
        static final int TRANSACTION_noteSyncStart = 23;
        static final int TRANSACTION_noteSyncFinish = 24;
        static final int TRANSACTION_noteJobStart = 25;
        static final int TRANSACTION_noteJobFinish = 26;
        static final int TRANSACTION_noteStartWakelock = 27;
        static final int TRANSACTION_noteStopWakelock = 28;
        static final int TRANSACTION_noteStartWakelockFromSource = 29;
        static final int TRANSACTION_noteChangeWakelockFromSource = 30;
        static final int TRANSACTION_noteStopWakelockFromSource = 31;
        static final int TRANSACTION_noteLongPartialWakelockStart = 32;
        static final int TRANSACTION_noteLongPartialWakelockStartFromSource = 33;
        static final int TRANSACTION_noteLongPartialWakelockFinish = 34;
        static final int TRANSACTION_noteLongPartialWakelockFinishFromSource = 35;
        static final int TRANSACTION_noteVibratorOn = 36;
        static final int TRANSACTION_noteVibratorOff = 37;
        static final int TRANSACTION_noteGpsChanged = 38;
        static final int TRANSACTION_noteGpsSignalQuality = 39;
        static final int TRANSACTION_noteScreenState = 40;
        static final int TRANSACTION_noteScreenBrightness = 41;
        static final int TRANSACTION_noteUserActivity = 42;
        static final int TRANSACTION_noteWakeUp = 43;
        static final int TRANSACTION_noteInteractive = 44;
        static final int TRANSACTION_noteConnectivityChanged = 45;
        static final int TRANSACTION_noteMobileRadioPowerState = 46;
        static final int TRANSACTION_notePhoneOn = 47;
        static final int TRANSACTION_notePhoneOff = 48;
        static final int TRANSACTION_notePhoneSignalStrength = 49;
        static final int TRANSACTION_notePhoneDataConnectionState = 50;
        static final int TRANSACTION_notePhoneState = 51;
        static final int TRANSACTION_noteWifiOn = 52;
        static final int TRANSACTION_noteWifiOff = 53;
        static final int TRANSACTION_noteWifiRunning = 54;
        static final int TRANSACTION_noteWifiRunningChanged = 55;
        static final int TRANSACTION_noteWifiStopped = 56;
        static final int TRANSACTION_noteWifiState = 57;
        static final int TRANSACTION_noteWifiSupplicantStateChanged = 58;
        static final int TRANSACTION_noteWifiRssiChanged = 59;
        static final int TRANSACTION_noteFullWifiLockAcquired = 60;
        static final int TRANSACTION_noteFullWifiLockReleased = 61;
        static final int TRANSACTION_noteWifiScanStarted = 62;
        static final int TRANSACTION_noteWifiScanStopped = 63;
        static final int TRANSACTION_noteWifiMulticastEnabled = 64;
        static final int TRANSACTION_noteWifiMulticastDisabled = 65;
        static final int TRANSACTION_noteFullWifiLockAcquiredFromSource = 66;
        static final int TRANSACTION_noteFullWifiLockReleasedFromSource = 67;
        static final int TRANSACTION_noteWifiScanStartedFromSource = 68;
        static final int TRANSACTION_noteWifiScanStoppedFromSource = 69;
        static final int TRANSACTION_noteWifiBatchedScanStartedFromSource = 70;
        static final int TRANSACTION_noteWifiBatchedScanStoppedFromSource = 71;
        static final int TRANSACTION_noteWifiRadioPowerState = 72;
        static final int TRANSACTION_noteNetworkInterfaceForTransports = 73;
        static final String[] PERMISSIONS_noteNetworkInterfaceForTransports = new String[]{"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"};
        static final int TRANSACTION_noteNetworkStatsEnabled = 74;
        static final int TRANSACTION_noteDeviceIdleMode = 75;
        static final int TRANSACTION_setBatteryState = 76;
        static final int TRANSACTION_getAwakeTimeBattery = 77;
        static final int TRANSACTION_getAwakeTimePlugged = 78;
        static final int TRANSACTION_noteBleScanStarted = 79;
        static final int TRANSACTION_noteBleScanStopped = 80;
        static final int TRANSACTION_noteBleScanReset = 81;
        static final int TRANSACTION_noteBleScanResults = 82;
        static final int TRANSACTION_getCellularBatteryStats = 83;
        static final String[] PERMISSIONS_getCellularBatteryStats = new String[]{"android.permission.UPDATE_DEVICE_STATS", "android.permission.BATTERY_STATS"};
        static final int TRANSACTION_getWifiBatteryStats = 84;
        static final String[] PERMISSIONS_getWifiBatteryStats = new String[]{"android.permission.UPDATE_DEVICE_STATS", "android.permission.BATTERY_STATS"};
        static final int TRANSACTION_getGpsBatteryStats = 85;
        static final int TRANSACTION_getWakeLockStats = 86;
        static final int TRANSACTION_getBluetoothBatteryStats = 87;
        static final int TRANSACTION_takeUidSnapshot = 88;
        static final int TRANSACTION_takeUidSnapshots = 89;
        static final int TRANSACTION_takeUidSnapshotsAsync = 90;
        static final int TRANSACTION_noteBluetoothControllerActivity = 91;
        static final int TRANSACTION_noteModemControllerActivity = 92;
        static final int TRANSACTION_noteWifiControllerActivity = 93;
        static final int TRANSACTION_setChargingStateUpdateDelayMillis = 94;
        static final int TRANSACTION_setChargerAcOnline = 95;
        static final int TRANSACTION_setBatteryLevel = 96;
        static final int TRANSACTION_unplugBattery = 97;
        static final int TRANSACTION_resetBattery = 98;
        static final int TRANSACTION_suspendBatteryInput = 99;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IBatteryStats asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBatteryStats) {
                return (IBatteryStats)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "noteStartSensor";
                }
                case 2: {
                    return "noteStopSensor";
                }
                case 3: {
                    return "noteStartVideo";
                }
                case 4: {
                    return "noteStopVideo";
                }
                case 5: {
                    return "noteStartAudio";
                }
                case 6: {
                    return "noteStopAudio";
                }
                case 7: {
                    return "noteResetVideo";
                }
                case 8: {
                    return "noteResetAudio";
                }
                case 9: {
                    return "noteFlashlightOn";
                }
                case 10: {
                    return "noteFlashlightOff";
                }
                case 11: {
                    return "noteStartCamera";
                }
                case 12: {
                    return "noteStopCamera";
                }
                case 13: {
                    return "noteResetCamera";
                }
                case 14: {
                    return "noteResetFlashlight";
                }
                case 15: {
                    return "noteWakeupSensorEvent";
                }
                case 16: {
                    return "getBatteryUsageStats";
                }
                case 17: {
                    return "isCharging";
                }
                case 18: {
                    return "computeBatteryTimeRemaining";
                }
                case 19: {
                    return "computeChargeTimeRemaining";
                }
                case 20: {
                    return "computeBatteryScreenOffRealtimeMs";
                }
                case 21: {
                    return "getScreenOffDischargeMah";
                }
                case 22: {
                    return "noteEvent";
                }
                case 23: {
                    return "noteSyncStart";
                }
                case 24: {
                    return "noteSyncFinish";
                }
                case 25: {
                    return "noteJobStart";
                }
                case 26: {
                    return "noteJobFinish";
                }
                case 27: {
                    return "noteStartWakelock";
                }
                case 28: {
                    return "noteStopWakelock";
                }
                case 29: {
                    return "noteStartWakelockFromSource";
                }
                case 30: {
                    return "noteChangeWakelockFromSource";
                }
                case 31: {
                    return "noteStopWakelockFromSource";
                }
                case 32: {
                    return "noteLongPartialWakelockStart";
                }
                case 33: {
                    return "noteLongPartialWakelockStartFromSource";
                }
                case 34: {
                    return "noteLongPartialWakelockFinish";
                }
                case 35: {
                    return "noteLongPartialWakelockFinishFromSource";
                }
                case 36: {
                    return "noteVibratorOn";
                }
                case 37: {
                    return "noteVibratorOff";
                }
                case 38: {
                    return "noteGpsChanged";
                }
                case 39: {
                    return "noteGpsSignalQuality";
                }
                case 40: {
                    return "noteScreenState";
                }
                case 41: {
                    return "noteScreenBrightness";
                }
                case 42: {
                    return "noteUserActivity";
                }
                case 43: {
                    return "noteWakeUp";
                }
                case 44: {
                    return "noteInteractive";
                }
                case 45: {
                    return "noteConnectivityChanged";
                }
                case 46: {
                    return "noteMobileRadioPowerState";
                }
                case 47: {
                    return "notePhoneOn";
                }
                case 48: {
                    return "notePhoneOff";
                }
                case 49: {
                    return "notePhoneSignalStrength";
                }
                case 50: {
                    return "notePhoneDataConnectionState";
                }
                case 51: {
                    return "notePhoneState";
                }
                case 52: {
                    return "noteWifiOn";
                }
                case 53: {
                    return "noteWifiOff";
                }
                case 54: {
                    return "noteWifiRunning";
                }
                case 55: {
                    return "noteWifiRunningChanged";
                }
                case 56: {
                    return "noteWifiStopped";
                }
                case 57: {
                    return "noteWifiState";
                }
                case 58: {
                    return "noteWifiSupplicantStateChanged";
                }
                case 59: {
                    return "noteWifiRssiChanged";
                }
                case 60: {
                    return "noteFullWifiLockAcquired";
                }
                case 61: {
                    return "noteFullWifiLockReleased";
                }
                case 62: {
                    return "noteWifiScanStarted";
                }
                case 63: {
                    return "noteWifiScanStopped";
                }
                case 64: {
                    return "noteWifiMulticastEnabled";
                }
                case 65: {
                    return "noteWifiMulticastDisabled";
                }
                case 66: {
                    return "noteFullWifiLockAcquiredFromSource";
                }
                case 67: {
                    return "noteFullWifiLockReleasedFromSource";
                }
                case 68: {
                    return "noteWifiScanStartedFromSource";
                }
                case 69: {
                    return "noteWifiScanStoppedFromSource";
                }
                case 70: {
                    return "noteWifiBatchedScanStartedFromSource";
                }
                case 71: {
                    return "noteWifiBatchedScanStoppedFromSource";
                }
                case 72: {
                    return "noteWifiRadioPowerState";
                }
                case 73: {
                    return "noteNetworkInterfaceForTransports";
                }
                case 74: {
                    return "noteNetworkStatsEnabled";
                }
                case 75: {
                    return "noteDeviceIdleMode";
                }
                case 76: {
                    return "setBatteryState";
                }
                case 77: {
                    return "getAwakeTimeBattery";
                }
                case 78: {
                    return "getAwakeTimePlugged";
                }
                case 79: {
                    return "noteBleScanStarted";
                }
                case 80: {
                    return "noteBleScanStopped";
                }
                case 81: {
                    return "noteBleScanReset";
                }
                case 82: {
                    return "noteBleScanResults";
                }
                case 83: {
                    return "getCellularBatteryStats";
                }
                case 84: {
                    return "getWifiBatteryStats";
                }
                case 85: {
                    return "getGpsBatteryStats";
                }
                case 86: {
                    return "getWakeLockStats";
                }
                case 87: {
                    return "getBluetoothBatteryStats";
                }
                case 88: {
                    return "takeUidSnapshot";
                }
                case 89: {
                    return "takeUidSnapshots";
                }
                case 90: {
                    return "takeUidSnapshotsAsync";
                }
                case 91: {
                    return "noteBluetoothControllerActivity";
                }
                case 92: {
                    return "noteModemControllerActivity";
                }
                case 93: {
                    return "noteWifiControllerActivity";
                }
                case 94: {
                    return "setChargingStateUpdateDelayMillis";
                }
                case 95: {
                    return "setChargerAcOnline";
                }
                case 96: {
                    return "setBatteryLevel";
                }
                case 97: {
                    return "unplugBattery";
                }
                case 98: {
                    return "resetBattery";
                }
                case 99: {
                    return "suspendBatteryInput";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStartSensor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStopSensor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStartVideo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStopVideo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStartAudio(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStopAudio(_arg0);
                    break;
                }
                case 7: {
                    this.noteResetVideo();
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.noteResetAudio();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteFlashlightOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteFlashlightOff(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStartCamera(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStopCamera(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    this.noteResetCamera();
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    this.noteResetFlashlight();
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWakeupSensorEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    ArrayList<BatteryUsageStatsQuery> _arg0 = data.createTypedArrayList(BatteryUsageStatsQuery.CREATOR);
                    data.enforceNoDataAvail();
                    List<BatteryUsageStats> _result = this.getBatteryUsageStats(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 17: {
                    boolean _result = this.isCharging();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    long _result = this.computeBatteryTimeRemaining();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 19: {
                    long _result = this.computeChargeTimeRemaining();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 20: {
                    long _result = this.computeBatteryScreenOffRealtimeMs();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 21: {
                    long _result = this.getScreenOffDischargeMah();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteSyncStart(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteSyncFinish(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteJobStart(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteJobFinish(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteStartWakelock(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStopWakelock(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteStartWakelockFromSource(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    WorkSource _arg5 = data.readTypedObject(WorkSource.CREATOR);
                    int _arg6 = data.readInt();
                    String _arg7 = data.readString();
                    String _arg8 = data.readString();
                    int _arg9 = data.readInt();
                    boolean _arg10 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteChangeWakelockFromSource(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteStopWakelockFromSource(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteLongPartialWakelockStart(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    WorkSource _arg2 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteLongPartialWakelockStartFromSource(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteLongPartialWakelockFinish(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    WorkSource _arg2 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteLongPartialWakelockFinishFromSource(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.noteVibratorOn(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteVibratorOff(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    WorkSource _arg1 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteGpsChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteGpsSignalQuality(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteScreenState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteScreenBrightness(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteUserActivity(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWakeUp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteInteractive(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.noteConnectivityChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteMobileRadioPowerState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    this.notePhoneOn();
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    this.notePhoneOff();
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    SignalStrength _arg0 = data.readTypedObject(SignalStrength.CREATOR);
                    data.enforceNoDataAvail();
                    this.notePhoneSignalStrength(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notePhoneDataConnectionState(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notePhoneState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    this.noteWifiOn();
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    this.noteWifiOff();
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteWifiRunning(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    WorkSource _arg1 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteWifiRunningChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteWifiStopped(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.noteWifiState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteWifiSupplicantStateChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWifiRssiChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteFullWifiLockAcquired(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteFullWifiLockReleased(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWifiScanStarted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWifiScanStopped(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWifiMulticastEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWifiMulticastDisabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteFullWifiLockAcquiredFromSource(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteFullWifiLockReleasedFromSource(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteWifiScanStartedFromSource(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteWifiScanStoppedFromSource(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 70: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWifiBatchedScanStartedFromSource(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteWifiBatchedScanStoppedFromSource(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 72: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteWifiRadioPowerState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    String _arg0 = data.readString();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.noteNetworkInterfaceForTransports(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 74: {
                    this.noteNetworkStatsEnabled();
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteDeviceIdleMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 76: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    long _arg8 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setBatteryState(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    break;
                }
                case 77: {
                    long _result = this.getAwakeTimeBattery();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 78: {
                    long _result = this.getAwakeTimePlugged();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 79: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteBleScanStarted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 80: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteBleScanStopped(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 81: {
                    this.noteBleScanReset();
                    reply.writeNoException();
                    break;
                }
                case 82: {
                    WorkSource _arg0 = data.readTypedObject(WorkSource.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteBleScanResults(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 83: {
                    CellularBatteryStats _result = this.getCellularBatteryStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 84: {
                    WifiBatteryStats _result = this.getWifiBatteryStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 85: {
                    GpsBatteryStats _result = this.getGpsBatteryStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 86: {
                    WakeLockStats _result = this.getWakeLockStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 87: {
                    BluetoothBatteryStats _result = this.getBluetoothBatteryStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 88: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    HealthStatsParceler _result = this.takeUidSnapshot(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 89: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.takeUidSnapshots(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 90: {
                    int[] _arg0 = data.createIntArray();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.takeUidSnapshotsAsync(_arg0, _arg1);
                    break;
                }
                case 91: {
                    BluetoothActivityEnergyInfo _arg0 = data.readTypedObject(BluetoothActivityEnergyInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteBluetoothControllerActivity(_arg0);
                    break;
                }
                case 92: {
                    ModemActivityInfo _arg0 = data.readTypedObject(ModemActivityInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteModemControllerActivity(_arg0);
                    break;
                }
                case 93: {
                    WifiActivityEnergyInfo _arg0 = data.readTypedObject(WifiActivityEnergyInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.noteWifiControllerActivity(_arg0);
                    break;
                }
                case 94: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setChargingStateUpdateDelayMillis(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 95: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setChargerAcOnline(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBatteryLevel(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 97: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.unplugBattery(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 98: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.resetBattery(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 99: {
                    this.suspendBatteryInput();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void noteStartSensor_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStopSensor_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStartVideo_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStopVideo_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStartAudio_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStopAudio_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteResetVideo_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteResetAudio_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteFlashlightOn_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteFlashlightOff_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStartCamera_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStopCamera_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteResetCamera_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteResetFlashlight_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getBatteryUsageStats_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void computeBatteryScreenOffRealtimeMs_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getScreenOffDischargeMah_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteSyncStart_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteSyncFinish_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteJobStart_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteJobFinish_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStartWakelock_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStopWakelock_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStartWakelockFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteChangeWakelockFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteStopWakelockFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteLongPartialWakelockStart_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteLongPartialWakelockStartFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteLongPartialWakelockFinish_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteLongPartialWakelockFinishFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteVibratorOn_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteVibratorOff_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteGpsChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteGpsSignalQuality_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteScreenState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteScreenBrightness_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteUserActivity_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWakeUp_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteInteractive_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteConnectivityChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteMobileRadioPowerState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notePhoneOn_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notePhoneOff_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notePhoneSignalStrength_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notePhoneDataConnectionState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notePhoneState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiOn_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiOff_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiRunning_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiRunningChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiStopped_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiSupplicantStateChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiRssiChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteFullWifiLockAcquired_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteFullWifiLockReleased_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiScanStarted_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiScanStopped_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiMulticastEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiMulticastDisabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteFullWifiLockAcquiredFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteFullWifiLockReleasedFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiScanStartedFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiScanStoppedFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiBatchedScanStartedFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiBatchedScanStoppedFromSource_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiRadioPowerState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteNetworkInterfaceForTransports_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_noteNetworkInterfaceForTransports, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteNetworkStatsEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteDeviceIdleMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBatteryState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAwakeTimeBattery_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAwakeTimePlugged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteBleScanStarted_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteBleScanStopped_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteBleScanReset_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteBleScanResults_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getCellularBatteryStats_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getCellularBatteryStats, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getWifiBatteryStats_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getWifiBatteryStats, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getGpsBatteryStats_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getWakeLockStats_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getBluetoothBatteryStats_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BATTERY_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteBluetoothControllerActivity_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteModemControllerActivity_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void noteWifiControllerActivity_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setChargingStateUpdateDelayMillis_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.POWER_SAVER", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setChargerAcOnline_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DEVICE_POWER", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBatteryLevel_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DEVICE_POWER", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unplugBattery_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DEVICE_POWER", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void resetBattery_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DEVICE_POWER", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void suspendBatteryInput_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DEVICE_POWER", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 98;
        }

        private static class Proxy
        implements IBatteryStats {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStartSensor(int uid, int sensor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStopSensor(int uid, int sensor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStartVideo(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStopVideo(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStartAudio(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStopAudio(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteResetVideo() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void noteResetAudio() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteFlashlightOn(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteFlashlightOff(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStartCamera(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStopCamera(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteResetCamera() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteResetFlashlight() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWakeupSensorEvent(long elapsedNanos, int uid, int handle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(elapsedNanos);
                    _data.writeInt(uid);
                    _data.writeInt(handle);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BatteryUsageStats> getBatteryUsageStats(List<BatteryUsageStatsQuery> queries) throws RemoteException {
                ArrayList<BatteryUsageStats> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(queries, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BatteryUsageStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCharging() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long computeBatteryTimeRemaining() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long computeChargeTimeRemaining() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long computeBatteryScreenOffRealtimeMs() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getScreenOffDischargeMah() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteEvent(int code, String name, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeString(name);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteSyncStart(String name, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteSyncFinish(String name, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteJobStart(String name, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteJobFinish(String name, int uid, int stopReason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(uid);
                    _data.writeInt(stopReason);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStartWakelock(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeInt(type);
                    _data.writeBoolean(unimportantForLogging);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStopWakelock(int uid, int pid, String name, String historyName, int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStartWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    _data.writeInt(pid);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeInt(type);
                    _data.writeBoolean(unimportantForLogging);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteChangeWakelockFromSource(WorkSource ws, int pid, String name, String histyoryName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    _data.writeInt(pid);
                    _data.writeString(name);
                    _data.writeString(histyoryName);
                    _data.writeInt(type);
                    _data.writeTypedObject(newWs, 0);
                    _data.writeInt(newPid);
                    _data.writeString(newName);
                    _data.writeString(newHistoryName);
                    _data.writeInt(newType);
                    _data.writeBoolean(newUnimportantForLogging);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteStopWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    _data.writeInt(pid);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteLongPartialWakelockStart(String name, String historyName, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteLongPartialWakelockStartFromSource(String name, String historyName, WorkSource workSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeTypedObject(workSource, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteLongPartialWakelockFinish(String name, String historyName, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteLongPartialWakelockFinishFromSource(String name, String historyName, WorkSource workSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeString(historyName);
                    _data.writeTypedObject(workSource, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteVibratorOn(int uid, long durationMillis) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeLong(durationMillis);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteVibratorOff(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteGpsChanged(WorkSource oldSource, WorkSource newSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(oldSource, 0);
                    _data.writeTypedObject(newSource, 0);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteGpsSignalQuality(int signalLevel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(signalLevel);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteScreenState(int displayId, int state, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(state);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteScreenBrightness(int displayId, int brightness) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(brightness);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteUserActivity(int uid, int event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(event);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWakeUp(String reason, int reasonUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    _data.writeInt(reasonUid);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteInteractive(boolean interactive) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(interactive);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteConnectivityChanged(int type, String extra) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(extra);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteMobileRadioPowerState(int powerState, long timestampNs, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(powerState);
                    _data.writeLong(timestampNs);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notePhoneOn() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notePhoneOff() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notePhoneSignalStrength(SignalStrength signalStrength) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(signalStrength, 0);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notePhoneDataConnectionState(int dataType, boolean hasData, int serviceType, int nrState, int nrFrequency) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(dataType);
                    _data.writeBoolean(hasData);
                    _data.writeInt(serviceType);
                    _data.writeInt(nrState);
                    _data.writeInt(nrFrequency);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notePhoneState(int phoneState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneState);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiOn() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiOff() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiRunning(WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiRunningChanged(WorkSource oldWs, WorkSource newWs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(oldWs, 0);
                    _data.writeTypedObject(newWs, 0);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiStopped(WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiState(int wifiState, String accessPoint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(wifiState);
                    _data.writeString(accessPoint);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiSupplicantStateChanged(int supplState, boolean failedAuth) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(supplState);
                    _data.writeBoolean(failedAuth);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiRssiChanged(int newRssi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newRssi);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteFullWifiLockAcquired(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteFullWifiLockReleased(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiScanStarted(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiScanStopped(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiMulticastEnabled(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiMulticastDisabled(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteFullWifiLockAcquiredFromSource(WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteFullWifiLockReleasedFromSource(WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiScanStartedFromSource(WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiScanStoppedFromSource(WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiBatchedScanStartedFromSource(WorkSource ws, int csph) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    _data.writeInt(csph);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiBatchedScanStoppedFromSource(WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiRadioPowerState(int powerState, long timestampNs, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(powerState);
                    _data.writeLong(timestampNs);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteNetworkInterfaceForTransports(String iface, int[] transportTypes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeIntArray(transportTypes);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteNetworkStatsEnabled() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteDeviceIdleMode(int mode, String activeReason, int activeUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeString(activeReason);
                    _data.writeInt(activeUid);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBatteryState(int status, int health, int plugType, int level, int temp, int volt, int chargeUAh, int chargeFullUAh, long chargeTimeToFullSeconds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeInt(health);
                    _data.writeInt(plugType);
                    _data.writeInt(level);
                    _data.writeInt(temp);
                    _data.writeInt(volt);
                    _data.writeInt(chargeUAh);
                    _data.writeInt(chargeFullUAh);
                    _data.writeLong(chargeTimeToFullSeconds);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAwakeTimeBattery() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAwakeTimePlugged() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteBleScanStarted(WorkSource ws, boolean isUnoptimized) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    _data.writeBoolean(isUnoptimized);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteBleScanStopped(WorkSource ws, boolean isUnoptimized) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    _data.writeBoolean(isUnoptimized);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteBleScanReset() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteBleScanResults(WorkSource ws, int numNewResults) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ws, 0);
                    _data.writeInt(numNewResults);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CellularBatteryStats getCellularBatteryStats() throws RemoteException {
                CellularBatteryStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CellularBatteryStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiBatteryStats getWifiBatteryStats() throws RemoteException {
                WifiBatteryStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WifiBatteryStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GpsBatteryStats getGpsBatteryStats() throws RemoteException {
                GpsBatteryStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(GpsBatteryStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WakeLockStats getWakeLockStats() throws RemoteException {
                WakeLockStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WakeLockStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothBatteryStats getBluetoothBatteryStats() throws RemoteException {
                BluetoothBatteryStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BluetoothBatteryStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HealthStatsParceler takeUidSnapshot(int uid) throws RemoteException {
                HealthStatsParceler _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HealthStatsParceler.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HealthStatsParceler[] takeUidSnapshots(int[] uid) throws RemoteException {
                HealthStatsParceler[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(uid);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(HealthStatsParceler.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void takeUidSnapshotsAsync(int[] uid, ResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(uid);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(90, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteBluetoothControllerActivity(BluetoothActivityEnergyInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(91, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteModemControllerActivity(ModemActivityInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(92, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteWifiControllerActivity(WifiActivityEnergyInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(93, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setChargingStateUpdateDelayMillis(int delay) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(delay);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setChargerAcOnline(boolean online, boolean forceUpdate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(online);
                    _data.writeBoolean(forceUpdate);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBatteryLevel(int level, boolean forceUpdate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(level);
                    _data.writeBoolean(forceUpdate);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unplugBattery(boolean forceUpdate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(forceUpdate);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetBattery(boolean forceUpdate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(forceUpdate);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suspendBatteryInput() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBatteryStats {
        @Override
        public void noteStartSensor(int uid, int sensor) throws RemoteException {
        }

        @Override
        public void noteStopSensor(int uid, int sensor) throws RemoteException {
        }

        @Override
        public void noteStartVideo(int uid) throws RemoteException {
        }

        @Override
        public void noteStopVideo(int uid) throws RemoteException {
        }

        @Override
        public void noteStartAudio(int uid) throws RemoteException {
        }

        @Override
        public void noteStopAudio(int uid) throws RemoteException {
        }

        @Override
        public void noteResetVideo() throws RemoteException {
        }

        @Override
        public void noteResetAudio() throws RemoteException {
        }

        @Override
        public void noteFlashlightOn(int uid) throws RemoteException {
        }

        @Override
        public void noteFlashlightOff(int uid) throws RemoteException {
        }

        @Override
        public void noteStartCamera(int uid) throws RemoteException {
        }

        @Override
        public void noteStopCamera(int uid) throws RemoteException {
        }

        @Override
        public void noteResetCamera() throws RemoteException {
        }

        @Override
        public void noteResetFlashlight() throws RemoteException {
        }

        @Override
        public void noteWakeupSensorEvent(long elapsedNanos, int uid, int handle) throws RemoteException {
        }

        @Override
        public List<BatteryUsageStats> getBatteryUsageStats(List<BatteryUsageStatsQuery> queries) throws RemoteException {
            return null;
        }

        @Override
        public boolean isCharging() throws RemoteException {
            return false;
        }

        @Override
        public long computeBatteryTimeRemaining() throws RemoteException {
            return 0L;
        }

        @Override
        public long computeChargeTimeRemaining() throws RemoteException {
            return 0L;
        }

        @Override
        public long computeBatteryScreenOffRealtimeMs() throws RemoteException {
            return 0L;
        }

        @Override
        public long getScreenOffDischargeMah() throws RemoteException {
            return 0L;
        }

        @Override
        public void noteEvent(int code, String name, int uid) throws RemoteException {
        }

        @Override
        public void noteSyncStart(String name, int uid) throws RemoteException {
        }

        @Override
        public void noteSyncFinish(String name, int uid) throws RemoteException {
        }

        @Override
        public void noteJobStart(String name, int uid) throws RemoteException {
        }

        @Override
        public void noteJobFinish(String name, int uid, int stopReason) throws RemoteException {
        }

        @Override
        public void noteStartWakelock(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging) throws RemoteException {
        }

        @Override
        public void noteStopWakelock(int uid, int pid, String name, String historyName, int type) throws RemoteException {
        }

        @Override
        public void noteStartWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) throws RemoteException {
        }

        @Override
        public void noteChangeWakelockFromSource(WorkSource ws, int pid, String name, String histyoryName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) throws RemoteException {
        }

        @Override
        public void noteStopWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type) throws RemoteException {
        }

        @Override
        public void noteLongPartialWakelockStart(String name, String historyName, int uid) throws RemoteException {
        }

        @Override
        public void noteLongPartialWakelockStartFromSource(String name, String historyName, WorkSource workSource) throws RemoteException {
        }

        @Override
        public void noteLongPartialWakelockFinish(String name, String historyName, int uid) throws RemoteException {
        }

        @Override
        public void noteLongPartialWakelockFinishFromSource(String name, String historyName, WorkSource workSource) throws RemoteException {
        }

        @Override
        public void noteVibratorOn(int uid, long durationMillis) throws RemoteException {
        }

        @Override
        public void noteVibratorOff(int uid) throws RemoteException {
        }

        @Override
        public void noteGpsChanged(WorkSource oldSource, WorkSource newSource) throws RemoteException {
        }

        @Override
        public void noteGpsSignalQuality(int signalLevel) throws RemoteException {
        }

        @Override
        public void noteScreenState(int displayId, int state, int reason) throws RemoteException {
        }

        @Override
        public void noteScreenBrightness(int displayId, int brightness) throws RemoteException {
        }

        @Override
        public void noteUserActivity(int uid, int event) throws RemoteException {
        }

        @Override
        public void noteWakeUp(String reason, int reasonUid) throws RemoteException {
        }

        @Override
        public void noteInteractive(boolean interactive) throws RemoteException {
        }

        @Override
        public void noteConnectivityChanged(int type, String extra) throws RemoteException {
        }

        @Override
        public void noteMobileRadioPowerState(int powerState, long timestampNs, int uid) throws RemoteException {
        }

        @Override
        public void notePhoneOn() throws RemoteException {
        }

        @Override
        public void notePhoneOff() throws RemoteException {
        }

        @Override
        public void notePhoneSignalStrength(SignalStrength signalStrength) throws RemoteException {
        }

        @Override
        public void notePhoneDataConnectionState(int dataType, boolean hasData, int serviceType, int nrState, int nrFrequency) throws RemoteException {
        }

        @Override
        public void notePhoneState(int phoneState) throws RemoteException {
        }

        @Override
        public void noteWifiOn() throws RemoteException {
        }

        @Override
        public void noteWifiOff() throws RemoteException {
        }

        @Override
        public void noteWifiRunning(WorkSource ws) throws RemoteException {
        }

        @Override
        public void noteWifiRunningChanged(WorkSource oldWs, WorkSource newWs) throws RemoteException {
        }

        @Override
        public void noteWifiStopped(WorkSource ws) throws RemoteException {
        }

        @Override
        public void noteWifiState(int wifiState, String accessPoint) throws RemoteException {
        }

        @Override
        public void noteWifiSupplicantStateChanged(int supplState, boolean failedAuth) throws RemoteException {
        }

        @Override
        public void noteWifiRssiChanged(int newRssi) throws RemoteException {
        }

        @Override
        public void noteFullWifiLockAcquired(int uid) throws RemoteException {
        }

        @Override
        public void noteFullWifiLockReleased(int uid) throws RemoteException {
        }

        @Override
        public void noteWifiScanStarted(int uid) throws RemoteException {
        }

        @Override
        public void noteWifiScanStopped(int uid) throws RemoteException {
        }

        @Override
        public void noteWifiMulticastEnabled(int uid) throws RemoteException {
        }

        @Override
        public void noteWifiMulticastDisabled(int uid) throws RemoteException {
        }

        @Override
        public void noteFullWifiLockAcquiredFromSource(WorkSource ws) throws RemoteException {
        }

        @Override
        public void noteFullWifiLockReleasedFromSource(WorkSource ws) throws RemoteException {
        }

        @Override
        public void noteWifiScanStartedFromSource(WorkSource ws) throws RemoteException {
        }

        @Override
        public void noteWifiScanStoppedFromSource(WorkSource ws) throws RemoteException {
        }

        @Override
        public void noteWifiBatchedScanStartedFromSource(WorkSource ws, int csph) throws RemoteException {
        }

        @Override
        public void noteWifiBatchedScanStoppedFromSource(WorkSource ws) throws RemoteException {
        }

        @Override
        public void noteWifiRadioPowerState(int powerState, long timestampNs, int uid) throws RemoteException {
        }

        @Override
        public void noteNetworkInterfaceForTransports(String iface, int[] transportTypes) throws RemoteException {
        }

        @Override
        public void noteNetworkStatsEnabled() throws RemoteException {
        }

        @Override
        public void noteDeviceIdleMode(int mode, String activeReason, int activeUid) throws RemoteException {
        }

        @Override
        public void setBatteryState(int status, int health, int plugType, int level, int temp, int volt, int chargeUAh, int chargeFullUAh, long chargeTimeToFullSeconds) throws RemoteException {
        }

        @Override
        public long getAwakeTimeBattery() throws RemoteException {
            return 0L;
        }

        @Override
        public long getAwakeTimePlugged() throws RemoteException {
            return 0L;
        }

        @Override
        public void noteBleScanStarted(WorkSource ws, boolean isUnoptimized) throws RemoteException {
        }

        @Override
        public void noteBleScanStopped(WorkSource ws, boolean isUnoptimized) throws RemoteException {
        }

        @Override
        public void noteBleScanReset() throws RemoteException {
        }

        @Override
        public void noteBleScanResults(WorkSource ws, int numNewResults) throws RemoteException {
        }

        @Override
        public CellularBatteryStats getCellularBatteryStats() throws RemoteException {
            return null;
        }

        @Override
        public WifiBatteryStats getWifiBatteryStats() throws RemoteException {
            return null;
        }

        @Override
        public GpsBatteryStats getGpsBatteryStats() throws RemoteException {
            return null;
        }

        @Override
        public WakeLockStats getWakeLockStats() throws RemoteException {
            return null;
        }

        @Override
        public BluetoothBatteryStats getBluetoothBatteryStats() throws RemoteException {
            return null;
        }

        @Override
        public HealthStatsParceler takeUidSnapshot(int uid) throws RemoteException {
            return null;
        }

        @Override
        public HealthStatsParceler[] takeUidSnapshots(int[] uid) throws RemoteException {
            return null;
        }

        @Override
        public void takeUidSnapshotsAsync(int[] uid, ResultReceiver result) throws RemoteException {
        }

        @Override
        public void noteBluetoothControllerActivity(BluetoothActivityEnergyInfo info) throws RemoteException {
        }

        @Override
        public void noteModemControllerActivity(ModemActivityInfo info) throws RemoteException {
        }

        @Override
        public void noteWifiControllerActivity(WifiActivityEnergyInfo info) throws RemoteException {
        }

        @Override
        public boolean setChargingStateUpdateDelayMillis(int delay) throws RemoteException {
            return false;
        }

        @Override
        public void setChargerAcOnline(boolean online, boolean forceUpdate) throws RemoteException {
        }

        @Override
        public void setBatteryLevel(int level, boolean forceUpdate) throws RemoteException {
        }

        @Override
        public void unplugBattery(boolean forceUpdate) throws RemoteException {
        }

        @Override
        public void resetBattery(boolean forceUpdate) throws RemoteException {
        }

        @Override
        public void suspendBatteryInput() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

