/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.compat;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.compat.flags.Flags;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@RavenwoodKeepWholeClass
public class ChangeReporter {
    private static final String TAG = "CompatChangeReporter";
    private static final Function<Integer, Set<ChangeReport>> NEW_CHANGE_REPORT_SET = uid -> Collections.synchronizedSet(new HashSet());
    private int mSource;
    private final ConcurrentHashMap<Integer, Set<ChangeReport>> mReportedChanges;
    private boolean mDebugLogAll;
    public static final int STATE_UNKNOWN_STATE = 0;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_DISABLED = 2;
    public static final int STATE_LOGGED = 3;
    public static final int SOURCE_UNKNOWN_SOURCE = 0;
    public static final int SOURCE_APP_PROCESS = 1;
    public static final int SOURCE_SYSTEM_SERVER = 2;

    public ChangeReporter(int source) {
        this.mSource = source;
        this.mReportedChanges = new ConcurrentHashMap();
        this.mDebugLogAll = false;
    }

    public void reportChange(int uid, long changeId, int state, boolean isKnownSystemApp, boolean isLoggableBySdk) {
        boolean isAlreadyReported = this.checkAndSetIsAlreadyReported(uid, new ChangeReport(changeId, state));
        if (this.shouldWriteToStatsLog(isKnownSystemApp, isAlreadyReported)) {
            FrameworkStatsLog.write(228, uid, changeId, state, this.mSource);
        }
        if (this.shouldWriteToDebug(isAlreadyReported, state, isLoggableBySdk)) {
            this.debugLog(uid, changeId, state);
        }
    }

    public void reportChange(int uid, long changeId, int state) {
        this.reportChange(uid, changeId, state, false, true);
    }

    public void startDebugLogAll() {
        this.mDebugLogAll = true;
    }

    public void stopDebugLogAll() {
        this.mDebugLogAll = false;
    }

    @VisibleForTesting
    boolean shouldWriteToStatsLog(boolean isKnownSystemApp, boolean isAlreadyReported) {
        return !isKnownSystemApp && !isAlreadyReported;
    }

    private boolean shouldWriteToDebug(boolean isAlreadyReported, int state, boolean isLoggableBySdk) {
        if (this.mDebugLogAll) {
            return true;
        }
        if (isAlreadyReported) {
            return false;
        }
        boolean skipLoggingFlag = Flags.skipOldAndDisabledCompatLogging();
        if (!skipLoggingFlag || Log.isLoggable(TAG, 3)) {
            return true;
        }
        return isLoggableBySdk && state != 2;
    }

    @VisibleForTesting
    boolean shouldWriteToDebug(int uid, long changeId, int state) {
        return this.shouldWriteToDebug(uid, changeId, state, true);
    }

    @VisibleForTesting
    boolean shouldWriteToDebug(int uid, long changeId, int state, boolean isLoggableBySdk) {
        return this.shouldWriteToDebug(this.isAlreadyReported(uid, new ChangeReport(changeId, state)), state, isLoggableBySdk);
    }

    private boolean checkAndSetIsAlreadyReported(int uid, ChangeReport changeReport) {
        boolean isAlreadyReported = this.isAlreadyReported(uid, changeReport);
        if (!isAlreadyReported) {
            this.markAsReported(uid, changeReport);
        }
        return isAlreadyReported;
    }

    private boolean isAlreadyReported(int uid, ChangeReport report) {
        return this.mReportedChanges.getOrDefault(uid, Collections.EMPTY_SET).contains(report);
    }

    @VisibleForTesting
    boolean isAlreadyReported(int uid, long changeId, int state) {
        return this.isAlreadyReported(uid, new ChangeReport(changeId, state));
    }

    private void markAsReported(int uid, ChangeReport report) {
        this.mReportedChanges.computeIfAbsent(uid, NEW_CHANGE_REPORT_SET).add(report);
    }

    public void resetReportedChanges(int uid) {
        this.mReportedChanges.remove(uid);
    }

    private void debugLog(int uid, long changeId, int state) {
        String message = TextUtils.formatSimple("Compat change id reported: %d; UID %d; state: %s", changeId, uid, ChangeReporter.stateToString(state));
        if (this.mSource == 2) {
            Slog.d(TAG, message);
        } else {
            Log.d(TAG, message);
        }
    }

    private static String stateToString(int state) {
        switch (state) {
            case 3: {
                return "LOGGED";
            }
            case 1: {
                return "ENABLED";
            }
            case 2: {
                return "DISABLED";
            }
        }
        return "UNKNOWN";
    }

    private static class ChangeReport {
        long mChangeId;
        int mState;

        ChangeReport(long changeId, int state) {
            this.mChangeId = changeId;
            this.mState = state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeReport that = (ChangeReport)o;
            return this.mChangeId == that.mChangeId && this.mState == that.mState;
        }

        public int hashCode() {
            return Objects.hash(this.mChangeId, this.mState);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

