/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.compat;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RavenwoodKeepWholeClass
public class OverrideAllowedState
implements Parcelable {
    public static final int ALLOWED = 0;
    public static final int DISABLED_NOT_DEBUGGABLE = 1;
    public static final int DISABLED_NON_TARGET_SDK = 2;
    public static final int DISABLED_TARGET_SDK_TOO_HIGH = 3;
    public static final int DEFERRED_VERIFICATION = 4;
    public static final int LOGGING_ONLY_CHANGE = 5;
    public static final int PLATFORM_TOO_OLD = 6;
    public final int state;
    public final int appTargetSdk;
    public final int changeIdTargetSdk;
    @NonNull
    public static final Parcelable.Creator<OverrideAllowedState> CREATOR = new Parcelable.Creator<OverrideAllowedState>(){

        @Override
        public OverrideAllowedState createFromParcel(Parcel parcel) {
            OverrideAllowedState info = new OverrideAllowedState(parcel);
            return info;
        }

        public OverrideAllowedState[] newArray(int size) {
            return new OverrideAllowedState[size];
        }
    };

    private OverrideAllowedState(Parcel parcel) {
        this.state = parcel.readInt();
        this.appTargetSdk = parcel.readInt();
        this.changeIdTargetSdk = parcel.readInt();
    }

    public OverrideAllowedState(int state, int appTargetSdk, int changeIdTargetSdk) {
        this.state = state;
        this.appTargetSdk = appTargetSdk;
        this.changeIdTargetSdk = changeIdTargetSdk;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.state);
        out.writeInt(this.appTargetSdk);
        out.writeInt(this.changeIdTargetSdk);
    }

    public void enforce(long changeId, String packageName) throws SecurityException {
        switch (this.state) {
            case 0: 
            case 4: {
                return;
            }
            case 1: {
                throw new SecurityException("Cannot override a change on a non-debuggable app and user build.");
            }
            case 2: {
                throw new SecurityException("Cannot override a default enabled/disabled change on a user build.");
            }
            case 3: {
                throw new SecurityException(String.format("Cannot override %1$d for %2$s because the app's targetSdk (%3$d) is above the change's targetSdk threshold (%4$d)", changeId, packageName, this.appTargetSdk, this.changeIdTargetSdk));
            }
            case 5: {
                throw new SecurityException(String.format("Cannot override %1$d because it is marked as a logging-only change.", changeId));
            }
            case 6: {
                throw new SecurityException(String.format("Cannot override %1$d for %2$s because the change's targetSdk threshold (%3$d) is above the platform sdk.", changeId, packageName, this.changeIdTargetSdk));
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideAllowedState)) {
            return false;
        }
        OverrideAllowedState otherState = (OverrideAllowedState)obj;
        return this.state == otherState.state && this.appTargetSdk == otherState.appTargetSdk && this.changeIdTargetSdk == otherState.changeIdTargetSdk;
    }

    private String stateName() {
        switch (this.state) {
            case 0: {
                return "ALLOWED";
            }
            case 1: {
                return "DISABLED_NOT_DEBUGGABLE";
            }
            case 2: {
                return "DISABLED_NON_TARGET_SDK";
            }
            case 3: {
                return "DISABLED_TARGET_SDK_TOO_HIGH";
            }
            case 4: {
                return "DEFERRED_VERIFICATION";
            }
            case 5: {
                return "LOGGING_ONLY_CHANGE";
            }
            case 6: {
                return "PLATFORM_TOO_OLD";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "OverrideAllowedState(state=" + this.stateName() + "; appTargetSdk=" + this.appTargetSdk + "; changeIdTargetSdk=" + this.changeIdTargetSdk + ")";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

