/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.pm.parsing.ApkLiteParseUtils;
import android.content.pm.parsing.PackageLite;
import android.content.pm.parsing.result.ParseResult;
import android.content.pm.parsing.result.ParseTypeImpl;
import android.os.IBinder;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os._Original_Build;
import android.os.incremental.IIncrementalService;
import android.os.incremental.IncrementalManager;
import android.os.incremental.IncrementalStorage;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class NativeLibraryHelper {
    private static final String TAG = "NativeHelper";
    private static final boolean DEBUG_NATIVE = false;
    public static final String LIB_DIR_NAME = "lib";
    public static final String LIB64_DIR_NAME = "lib64";
    public static final String CLEAR_ABI_OVERRIDE = "-";
    private static final int BITCODE_PRESENT = 1;

    private static long nativeOpenApk(String string2) {
        return OverrideMethod.invokeL("com.android.internal.content.NativeLibraryHelper#nativeOpenApk(Ljava/lang/String;)J", true, null);
    }

    private static long nativeOpenApkFd(FileDescriptor fileDescriptor, String string2) {
        return OverrideMethod.invokeL("com.android.internal.content.NativeLibraryHelper#nativeOpenApkFd(Ljava/io/FileDescriptor;Ljava/lang/String;)J", true, null);
    }

    private static void nativeClose(long l) {
        OverrideMethod.invokeV("com.android.internal.content.NativeLibraryHelper#nativeClose(J)V", true, null);
    }

    private static long nativeSumNativeBinaries(long l, String string2) {
        return OverrideMethod.invokeL("com.android.internal.content.NativeLibraryHelper#nativeSumNativeBinaries(JLjava/lang/String;)J", true, null);
    }

    private static int nativeCopyNativeBinaries(long l, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        return OverrideMethod.invokeI("com.android.internal.content.NativeLibraryHelper#nativeCopyNativeBinaries(JLjava/lang/String;Ljava/lang/String;ZZZ)I", true, null);
    }

    private static int nativeCheckAlignment(long l, String string2, String string3, boolean bl, boolean bl2) {
        return OverrideMethod.invokeI("com.android.internal.content.NativeLibraryHelper#nativeCheckAlignment(JLjava/lang/String;Ljava/lang/String;ZZ)I", true, null);
    }

    private static long sumNativeBinaries(Handle handle, String abi) {
        long sum = 0L;
        for (long apkHandle : handle.apkHandles) {
            sum += NativeLibraryHelper.nativeSumNativeBinaries(apkHandle, abi);
        }
        return sum;
    }

    public static int copyNativeBinaries(Handle handle, File sharedLibraryDir, String abi) {
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.nativeCopyNativeBinaries(apkHandle, sharedLibraryDir.getPath(), abi, handle.extractNativeLibs, handle.debuggable, handle.pageSizeCompatDisabled);
            if (res == 1) continue;
            return res;
        }
        return 1;
    }

    public static int findSupportedAbi(Handle handle, String[] supportedAbis) {
        int finalRes = -114;
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.nativeFindSupportedAbi(apkHandle, supportedAbis);
            if (res == -114) continue;
            if (res == -113) {
                if (finalRes >= 0) continue;
                finalRes = -113;
                continue;
            }
            if (res >= 0) {
                if (finalRes >= 0 && res >= finalRes) continue;
                finalRes = res;
                continue;
            }
            return res;
        }
        return finalRes;
    }

    private static int nativeFindSupportedAbi(long l, String[] stringArray) {
        return OverrideMethod.invokeI("com.android.internal.content.NativeLibraryHelper#nativeFindSupportedAbi(J[Ljava/lang/String;)I", true, null);
    }

    public static void removeNativeBinariesLI(String nativeLibraryPath) {
        if (nativeLibraryPath == null) {
            return;
        }
        NativeLibraryHelper.removeNativeBinariesFromDirLI(new File(nativeLibraryPath), false);
    }

    public static void removeNativeBinariesFromDirLI(File nativeLibraryRoot, boolean deleteRootDir) {
        if (nativeLibraryRoot.exists()) {
            File[] files = nativeLibraryRoot.listFiles();
            if (files != null) {
                for (int nn = 0; nn < files.length; ++nn) {
                    if (files[nn].isDirectory()) {
                        NativeLibraryHelper.removeNativeBinariesFromDirLI(files[nn], true);
                        continue;
                    }
                    if (files[nn].delete()) continue;
                    Slog.w(TAG, "Could not delete native binary: " + files[nn].getPath());
                }
            }
            if (deleteRootDir && !nativeLibraryRoot.delete()) {
                Slog.w(TAG, "Could not delete native binary directory: " + nativeLibraryRoot.getPath());
            }
        }
    }

    public static void createNativeLibrarySubdir(File path) throws IOException {
        if (!path.isDirectory()) {
            path.delete();
            if (!path.mkdir()) {
                throw new IOException("Cannot create " + path.getPath());
            }
            try {
                Os.chmod(path.getPath(), OsConstants.S_IRWXU | OsConstants.S_IRGRP | OsConstants.S_IXGRP | OsConstants.S_IROTH | OsConstants.S_IXOTH);
            }
            catch (ErrnoException e) {
                throw new IOException("Cannot chmod native library directory " + path.getPath(), e);
            }
        } else if (!SELinux.restorecon(path)) {
            throw new IOException("Cannot set SELinux context for " + path.getPath());
        }
    }

    private static long sumNativeBinariesForSupportedAbi(Handle handle, String[] abiList) {
        int abi = NativeLibraryHelper.findSupportedAbi(handle, abiList);
        if (abi >= 0) {
            return NativeLibraryHelper.sumNativeBinaries(handle, abiList[abi]);
        }
        return 0L;
    }

    public static int copyNativeBinariesForSupportedAbi(Handle handle, File libraryRoot, String[] abiList, boolean useIsaSubdir, boolean isIncremental) throws IOException {
        int copyRet;
        int abi = NativeLibraryHelper.findSupportedAbi(handle, abiList);
        if (abi < 0) {
            return abi;
        }
        String supportedAbi = abiList[abi];
        String instructionSet = VMRuntime.getInstructionSet(supportedAbi);
        File subDir = useIsaSubdir ? new File(libraryRoot, instructionSet) : libraryRoot;
        if (isIncremental) {
            int res = NativeLibraryHelper.incrementalConfigureNativeBinariesForSupportedAbi(handle, subDir, supportedAbi);
            if (res != 1) {
                return res;
            }
            return abi;
        }
        NativeLibraryHelper.createNativeLibrarySubdir(libraryRoot);
        if (subDir != libraryRoot) {
            NativeLibraryHelper.createNativeLibrarySubdir(subDir);
        }
        if ((copyRet = NativeLibraryHelper.copyNativeBinaries(handle, subDir, supportedAbi)) != 1) {
            return copyRet;
        }
        return abi;
    }

    public static int copyNativeBinariesWithOverride(Handle handle, File libraryRoot, String abiOverride, boolean isIncremental) {
        try {
            if (handle.multiArch) {
                if (abiOverride != null && !CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                    Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
                }
                int copyRet = -114;
                if (_Original_Build.SUPPORTED_32_BIT_ABIS.length > 0 && (copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, _Original_Build.SUPPORTED_32_BIT_ABIS, true, isIncremental)) < 0 && copyRet != -114 && copyRet != -113) {
                    Slog.w(TAG, "Failure copying 32 bit native libraries; copyRet=" + copyRet);
                    return copyRet;
                }
                if (_Original_Build.SUPPORTED_64_BIT_ABIS.length > 0 && (copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, _Original_Build.SUPPORTED_64_BIT_ABIS, true, isIncremental)) < 0 && copyRet != -114 && copyRet != -113) {
                    Slog.w(TAG, "Failure copying 64 bit native libraries; copyRet=" + copyRet);
                    return copyRet;
                }
            } else {
                int copyRet;
                String[] abiList;
                String[] stringArray;
                String cpuAbiOverride = null;
                if (CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                    cpuAbiOverride = null;
                } else if (abiOverride != null) {
                    cpuAbiOverride = abiOverride;
                }
                if (cpuAbiOverride != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = cpuAbiOverride;
                } else {
                    stringArray = abiList = _Original_Build.SUPPORTED_ABIS;
                }
                if (_Original_Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                    abiList = _Original_Build.SUPPORTED_32_BIT_ABIS;
                }
                if ((copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, abiList, true, isIncremental)) < 0 && copyRet != -114) {
                    Slog.w(TAG, "Failure copying native libraries [errorCode=" + copyRet + "]");
                    return copyRet;
                }
            }
            return 1;
        }
        catch (IOException e) {
            Slog.e(TAG, "Copying native libraries failed", e);
            return -110;
        }
    }

    public static int checkAlignmentForCompatMode(Handle handle, String libraryRoot, boolean nativeLibraryRootRequiresIsa, String abiOverride) {
        int abi = NativeLibraryHelper.findSupportedAbi(handle, _Original_Build.SUPPORTED_64_BIT_ABIS);
        if (abi < 0) {
            return -1;
        }
        String supportedAbi = _Original_Build.SUPPORTED_64_BIT_ABIS[abi];
        String instructionSet = VMRuntime.getInstructionSet(supportedAbi);
        String subDir = libraryRoot;
        if (nativeLibraryRootRequiresIsa) {
            subDir = subDir + "/" + instructionSet;
        }
        int mode = 0;
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.nativeCheckAlignment(apkHandle, subDir, _Original_Build.SUPPORTED_64_BIT_ABIS[abi], handle.extractNativeLibs, handle.debuggable);
            if (res == -1) {
                return res;
            }
            mode |= res;
        }
        return mode;
    }

    public static long sumNativeBinariesWithOverride(Handle handle, String abiOverride) throws IOException {
        long sum = 0L;
        if (handle.multiArch) {
            if (abiOverride != null && !CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
            }
            if (_Original_Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, _Original_Build.SUPPORTED_32_BIT_ABIS);
            }
            if (_Original_Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, _Original_Build.SUPPORTED_64_BIT_ABIS);
            }
        } else {
            String[] abiList;
            String[] stringArray;
            String cpuAbiOverride = null;
            if (CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                cpuAbiOverride = null;
            } else if (abiOverride != null) {
                cpuAbiOverride = abiOverride;
            }
            if (cpuAbiOverride != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = cpuAbiOverride;
            } else {
                stringArray = abiList = _Original_Build.SUPPORTED_ABIS;
            }
            if (_Original_Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                abiList = _Original_Build.SUPPORTED_32_BIT_ABIS;
            }
            sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, abiList);
        }
        return sum;
    }

    private static int incrementalConfigureNativeBinariesForSupportedAbi(Handle handle, File libSubDir, String abi) {
        File apkParent;
        String[] apkPaths = handle.apkPaths;
        if (apkPaths == null || apkPaths.length == 0) {
            Slog.e(TAG, "No apks to extract native libraries from.");
            return -110;
        }
        IBinder incrementalService = ServiceManager.getService("incremental");
        if (incrementalService == null) {
            return -110;
        }
        IncrementalManager incrementalManager = new IncrementalManager(IIncrementalService.Stub.asInterface(incrementalService));
        IncrementalStorage incrementalStorage = incrementalManager.openStorage((apkParent = new File(apkPaths[0]).getParentFile()).getAbsolutePath());
        if (incrementalStorage == null) {
            Slog.e(TAG, "Failed to find incremental storage");
            return -110;
        }
        String libRelativeDir = NativeLibraryHelper.getRelativePath(apkParent, libSubDir);
        if (libRelativeDir == null) {
            return -110;
        }
        for (int i = 0; i < apkPaths.length; ++i) {
            if (incrementalStorage.configureNativeBinaries(apkPaths[i], libRelativeDir, abi, handle.extractNativeLibs)) continue;
            return -110;
        }
        return 1;
    }

    private static String getRelativePath(File base, File target) {
        try {
            Path basePath = base.toPath();
            Path targetPath = target.toPath();
            Path relativePath = basePath.relativize(targetPath);
            if (relativePath.toString().isEmpty()) {
                return "";
            }
            return relativePath.toString();
        }
        catch (IllegalArgumentException ex) {
            Slog.e(TAG, "Failed to find relative path between: " + base.getAbsolutePath() + " and: " + target.getAbsolutePath());
            return null;
        }
    }

    private static int hasRenderscriptBitcode(long l) {
        return OverrideMethod.invokeI("com.android.internal.content.NativeLibraryHelper#hasRenderscriptBitcode(J)I", true, null);
    }

    public static boolean hasRenderscriptBitcode(Handle handle) throws IOException {
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.hasRenderscriptBitcode(apkHandle);
            if (res < 0) {
                throw new IOException("Error scanning APK, code: " + res);
            }
            if (res != 1) continue;
            return true;
        }
        return false;
    }

    public static class Handle
    implements Closeable {
        private final CloseGuard mGuard = CloseGuard.get();
        private volatile boolean mClosed;
        final String[] apkPaths;
        final long[] apkHandles;
        final boolean multiArch;
        final boolean extractNativeLibs;
        final boolean debuggable;
        final boolean pageSizeCompatDisabled;

        public static Handle create(File packageFile) throws IOException {
            ParseTypeImpl input = ParseTypeImpl.forDefaultParsing();
            ParseResult<PackageLite> ret = ApkLiteParseUtils.parsePackageLite(input.reset(), packageFile, 0);
            if (ret.isError()) {
                throw new IOException("Failed to parse package: " + packageFile, ret.getException());
            }
            return Handle.create(ret.getResult());
        }

        public static Handle create(PackageLite lite) throws IOException {
            boolean isPageSizeCompatDisabled = lite.getPageSizeCompat() == 64;
            return Handle.create(lite.getAllApkPaths(), lite.isMultiArch(), lite.isExtractNativeLibs(), lite.isDebuggable(), isPageSizeCompatDisabled);
        }

        public static Handle create(List<String> codePaths, boolean multiArch, boolean extractNativeLibs, boolean debuggable, boolean isPageSizeCompatDisabled) throws IOException {
            int size = codePaths.size();
            String[] apkPaths = new String[size];
            long[] apkHandles = new long[size];
            for (int i = 0; i < size; ++i) {
                String path;
                apkPaths[i] = path = codePaths.get(i);
                apkHandles[i] = NativeLibraryHelper.nativeOpenApk(path);
                if (apkHandles[i] != 0L) continue;
                for (int j = 0; j < i; ++j) {
                    NativeLibraryHelper.nativeClose(apkHandles[j]);
                }
                throw new IOException("Unable to open APK: " + path);
            }
            return new Handle(apkPaths, apkHandles, multiArch, extractNativeLibs, debuggable, isPageSizeCompatDisabled);
        }

        public static Handle createFd(PackageLite lite, FileDescriptor fd) throws IOException {
            long[] apkHandles = new long[1];
            String path = lite.getBaseApkPath();
            apkHandles[0] = NativeLibraryHelper.nativeOpenApkFd(fd, path);
            if (apkHandles[0] == 0L) {
                throw new IOException("Unable to open APK " + path + " from fd " + fd);
            }
            boolean isPageSizeCompatDisabled = lite.getPageSizeCompat() == 64;
            return new Handle(new String[]{path}, apkHandles, lite.isMultiArch(), lite.isExtractNativeLibs(), lite.isDebuggable(), isPageSizeCompatDisabled);
        }

        Handle(String[] apkPaths, long[] apkHandles, boolean multiArch, boolean extractNativeLibs, boolean debuggable, boolean isPageSizeCompatDisabled) {
            this.apkPaths = apkPaths;
            this.apkHandles = apkHandles;
            this.multiArch = multiArch;
            this.extractNativeLibs = extractNativeLibs;
            this.debuggable = debuggable;
            this.pageSizeCompatDisabled = isPageSizeCompatDisabled;
            this.mGuard.open("close");
        }

        @Override
        public void close() {
            for (long apkHandle : this.apkHandles) {
                NativeLibraryHelper.nativeClose(apkHandle);
            }
            this.mGuard.close();
            this.mClosed = true;
        }

        protected void finalize() throws Throwable {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            try {
                if (!this.mClosed) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

