/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.util.Log;
import com.android.internal.inputmethod.CancellationGroup;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompletableFutureUtil {
    private CompletableFutureUtil() {
    }

    @Nullable
    private static <T> T getValueOrRethrowErrorInternal(@NonNull CompletableFuture<T> future) {
        boolean interrupted = false;
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                throw new RuntimeException(cause.getMessage(), cause.getCause());
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T getValueOrNullInternal(@NonNull CompletableFuture<T> future, @Nullable String tag, @Nullable String methodName, long timeoutMillis, @Nullable CancellationGroup cancellationGroup) {
        boolean needsToUnregister = cancellationGroup != null && cancellationGroup.tryRegisterFutureOrCancelImmediately(future);
        boolean interrupted = false;
        while (true) {
            try {
                T t = future.get(timeoutMillis, TimeUnit.MILLISECONDS);
                return t;
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof CancellationException) {
                    CompletableFutureUtil.logCancellationInternal(tag, methodName);
                    T t = null;
                    return t;
                }
                CompletableFutureUtil.logErrorInternal(tag, methodName, e.getMessage());
                T t = null;
                return t;
            }
            catch (CancellationException e) {
                CompletableFutureUtil.logCancellationInternal(tag, methodName);
                T t = null;
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (TimeoutException e) {
                CompletableFutureUtil.logTimeoutInternal(tag, methodName, timeoutMillis);
                T t = null;
                return t;
            }
            catch (Throwable e) {
                T t;
                block18: {
                    CompletableFutureUtil.logErrorInternal(tag, methodName, e.getMessage());
                    t = null;
                    if (needsToUnregister) {
                        cancellationGroup.unregisterFuture(future);
                    }
                    if (!interrupted) break block18;
                    Thread.currentThread().interrupt();
                }
                return t;
            }
            break;
        }
        finally {
            if (needsToUnregister) {
                cancellationGroup.unregisterFuture(future);
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void logTimeoutInternal(@Nullable String tag, @Nullable String methodName, long timeout) {
        if (tag == null || methodName == null) {
            return;
        }
        Log.w(tag, methodName + " didn't respond in " + timeout + " msec.");
    }

    private static void logErrorInternal(@Nullable String tag, @Nullable String methodName, @Nullable String errorString) {
        if (tag == null || methodName == null) {
            return;
        }
        Log.w(tag, methodName + " was failed with an exception=" + errorString);
    }

    private static void logCancellationInternal(@Nullable String tag, @Nullable String methodName) {
        if (tag == null || methodName == null) {
            return;
        }
        Log.w(tag, methodName + " was cancelled.");
    }

    @Nullable
    public static <T> T getResult(@NonNull CompletableFuture<T> future) {
        return CompletableFutureUtil.getValueOrRethrowErrorInternal(future);
    }

    public static boolean getBooleanResult(@NonNull CompletableFuture<Boolean> future) {
        return CompletableFutureUtil.getValueOrRethrowErrorInternal(future);
    }

    public static int getIntegerResult(@NonNull CompletableFuture<Integer> future) {
        return CompletableFutureUtil.getValueOrRethrowErrorInternal(future);
    }

    public static boolean getResultOrFalse(@NonNull CompletableFuture<Boolean> future, @Nullable String tag, @Nullable String methodName, @Nullable CancellationGroup cancellationGroup, long timeoutMillis) {
        Boolean obj = CompletableFutureUtil.getValueOrNullInternal(future, tag, methodName, timeoutMillis, cancellationGroup);
        return obj != null ? obj : false;
    }

    public static int getResultOrZero(@NonNull CompletableFuture<Integer> future, @Nullable String tag, @Nullable String methodName, @Nullable CancellationGroup cancellationGroup, long timeoutMillis) {
        Integer obj = CompletableFutureUtil.getValueOrNullInternal(future, tag, methodName, timeoutMillis, cancellationGroup);
        return obj != null ? obj : 0;
    }

    @Nullable
    public static <T> T getResultOrNull(@NonNull CompletableFuture<T> future, @Nullable String tag, @Nullable String methodName, @Nullable CancellationGroup cancellationGroup, long timeoutMillis) {
        return CompletableFutureUtil.getValueOrNullInternal(future, tag, methodName, timeoutMillis, cancellationGroup);
    }
}

