/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;

public interface IConnectionlessHandwritingCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IConnectionlessHandwritingCallback";

    public void onResult(CharSequence var1) throws RemoteException;

    public void onError(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectionlessHandwritingCallback {
        static final int TRANSACTION_onResult = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IConnectionlessHandwritingCallback.DESCRIPTOR);
        }

        public static IConnectionlessHandwritingCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IConnectionlessHandwritingCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IConnectionlessHandwritingCallback) {
                return (IConnectionlessHandwritingCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IConnectionlessHandwritingCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    CharSequence _arg0 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.onResult(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IConnectionlessHandwritingCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IConnectionlessHandwritingCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(CharSequence text) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IConnectionlessHandwritingCallback.DESCRIPTOR);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IConnectionlessHandwritingCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IConnectionlessHandwritingCallback {
        @Override
        public void onResult(CharSequence text) throws RemoteException {
        }

        @Override
        public void onError(int errorCode) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

