/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.BatteryStats;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os._Original_Build;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.EventLogTags;
import com.android.internal.os.BatteryStatsHistoryIterator;
import com.android.internal.os.Clock;
import com.android.internal.os.MonotonicClock;
import com.android.internal.os.PowerStats;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;

@RavenwoodKeepWholeClass
public class BatteryStatsHistory {
    private static final boolean DEBUG = false;
    private static final String TAG = "BatteryStatsHistory";
    private static final int VERSION = 214;
    static final int DELTA_TIME_MASK = 524287;
    static final int DELTA_TIME_LONG = 524287;
    static final int DELTA_TIME_INT = 524286;
    static final int DELTA_TIME_ABS = 524285;
    static final int DELTA_BATTERY_LEVEL_FLAG = 524288;
    static final int DELTA_STATE_FLAG = 0x100000;
    static final int DELTA_STATE2_FLAG = 0x200000;
    static final int DELTA_WAKELOCK_FLAG = 0x400000;
    static final int DELTA_EVENT_FLAG = 0x800000;
    static final int DELTA_BATTERY_CHARGE_FLAG = 0x1000000;
    static final int DELTA_STATE_MASK = -33554432;
    static final int STATE_BATTERY_MASK = -16777216;
    static final int STATE_BATTERY_STATUS_MASK = 7;
    static final int STATE_BATTERY_STATUS_SHIFT = 29;
    static final int STATE_BATTERY_HEALTH_MASK = 7;
    static final int STATE_BATTERY_HEALTH_SHIFT = 26;
    static final int STATE_BATTERY_PLUG_MASK = 3;
    static final int STATE_BATTERY_PLUG_SHIFT = 24;
    static final int BATTERY_LEVEL_LEVEL_MASK = -16777216;
    static final int BATTERY_LEVEL_LEVEL_SHIFT = 24;
    static final int BATTERY_LEVEL_TEMP_MASK = 0xFF8000;
    static final int BATTERY_LEVEL_TEMP_SHIFT = 15;
    static final int BATTERY_LEVEL_VOLT_MASK = 32764;
    static final int BATTERY_LEVEL_VOLT_SHIFT = 2;
    static final int BATTERY_LEVEL_OVERFLOW_FLAG = 2;
    static final int BATTERY_LEVEL_DETAILS_FLAG = 1;
    static final int BATTERY_LEVEL2_TEMP_MASK = -65536;
    static final int BATTERY_LEVEL2_TEMP_SHIFT = 16;
    static final int BATTERY_LEVEL2_VOLT_MASK = 65535;
    static final int BATTERY_LEVEL2_VOLT_SHIFT = 0;
    static final int TAG_FIRST_OCCURRENCE_FLAG = 32768;
    static final int EXTENSION_POWER_STATS_DESCRIPTOR_FLAG = 1;
    static final int EXTENSION_POWER_STATS_FLAG = 2;
    static final int EXTENSION_PROCESS_STATE_CHANGE_FLAG = 4;
    static final int STATE1_TRACE_MASK = 0x3FFFFFFF;
    static final int STATE2_TRACE_MASK = -1;
    private static final int EXTRA_BUFFER_SIZE_WHEN_DIR_LOCKED = 100000;
    private final Parcel mHistoryBuffer;
    private final Clock mClock;
    private int mMaxHistoryBufferSize;
    private BatteryHistoryFragment mActiveFragment;
    private final BatteryHistoryStore mStore;
    private List<Parcel> mHistoryParcels = null;
    private final ReentrantLock mWriteLock = new ReentrantLock();
    private final BatteryStats.HistoryItem mHistoryCur = new BatteryStats.HistoryItem();
    private boolean mHaveBatteryLevel;
    private boolean mRecordingHistory;
    static final int HISTORY_TAG_INDEX_LIMIT = 32766;
    private static final int MAX_HISTORY_TAG_STRING_LENGTH = 1024;
    private final HashMap<BatteryStats.HistoryTag, Integer> mHistoryTagPool = new HashMap();
    private SparseArray<BatteryStats.HistoryTag> mHistoryTags;
    private final BatteryStats.HistoryItem mHistoryLastWritten = new BatteryStats.HistoryItem();
    private final BatteryStats.HistoryItem mHistoryLastLastWritten = new BatteryStats.HistoryItem();
    private final BatteryStats.HistoryItem mHistoryAddTmp = new BatteryStats.HistoryItem();
    private int mNextHistoryTagIdx = 0;
    private int mNumHistoryTagChars = 0;
    private int mHistoryBufferLastPos = -1;
    private long mTrackRunningHistoryElapsedRealtimeMs = 0L;
    private long mTrackRunningHistoryUptimeMs = 0L;
    private final MonotonicClock mMonotonicClock;
    private long mHistoryBufferStartTime;
    private long mHistoryMonotonicEndTime;
    private long mMonotonicHistorySize;
    private final ArraySet<PowerStats.Descriptor> mWrittenPowerStatsDescriptors = new ArraySet();
    private boolean mMutable = true;
    private int mIteratorCookie;
    private final BatteryStatsHistory mWritableHistory;
    private TraceDelegate mTracer;
    private int mTraceLastState = 0;
    private int mTraceLastState2 = 0;
    private final EventLogger mEventLogger;

    public BatteryStatsHistory(Parcel historyBuffer, int maxHistoryBufferSize, @Nullable BatteryHistoryStore store, Clock clock, MonotonicClock monotonicClock, TraceDelegate tracer, EventLogger eventLogger) {
        this(historyBuffer, maxHistoryBufferSize, store, clock, monotonicClock, tracer, eventLogger, null);
    }

    private BatteryStatsHistory(@Nullable Parcel historyBuffer, int maxHistoryBufferSize, @Nullable BatteryHistoryStore store, @NonNull Clock clock, @NonNull MonotonicClock monotonicClock, @NonNull TraceDelegate tracer, @NonNull EventLogger eventLogger, @Nullable BatteryStatsHistory writableHistory) {
        this.mMaxHistoryBufferSize = maxHistoryBufferSize;
        this.mTracer = tracer;
        this.mClock = clock;
        this.mMonotonicClock = monotonicClock;
        this.mEventLogger = eventLogger;
        this.mWritableHistory = writableHistory;
        if (this.mWritableHistory != null) {
            this.mMutable = false;
            this.mHistoryBufferStartTime = this.mWritableHistory.mHistoryBufferStartTime;
            this.mHistoryMonotonicEndTime = this.mWritableHistory.mHistoryMonotonicEndTime;
        }
        if (historyBuffer != null) {
            this.mHistoryBuffer = historyBuffer;
        } else {
            this.mHistoryBuffer = Parcel.obtain();
            this.initHistoryBuffer();
        }
        if (writableHistory != null) {
            this.mStore = writableHistory.mStore;
        } else {
            this.mStore = store;
            if (this.mStore != null) {
                BatteryHistoryFragment activeFile = this.mStore.getLatestFragment();
                if (activeFile == null) {
                    activeFile = this.mStore.createFragment(this.mMonotonicClock.monotonicTime());
                }
                this.setActiveFragment(activeFile);
            }
        }
    }

    private BatteryStatsHistory(Parcel parcel) {
        this.mClock = Clock.SYSTEM_CLOCK;
        this.mTracer = null;
        this.mStore = null;
        this.mEventLogger = new EventLogger();
        this.mWritableHistory = null;
        this.mMutable = false;
        byte[] historyBlob = parcel.readBlob();
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryBuffer.unmarshall(historyBlob, 0, historyBlob.length);
        this.mMonotonicClock = null;
        this.readFromParcel(parcel, true);
    }

    private void initHistoryBuffer() {
        this.mTrackRunningHistoryElapsedRealtimeMs = 0L;
        this.mTrackRunningHistoryUptimeMs = 0L;
        this.mWrittenPowerStatsDescriptors.clear();
        this.mHistoryBufferStartTime = this.mMonotonicClock.monotonicTime();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(this.mMaxHistoryBufferSize / 2);
        this.mHistoryLastLastWritten.clear();
        this.mHistoryLastWritten.clear();
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
    }

    public void setMaxHistoryBufferSize(int maxHistoryBufferSize) {
        this.mMaxHistoryBufferSize = maxHistoryBufferSize;
    }

    public int getEstimatedItemCount() {
        int estimatedBytes = this.mHistoryBuffer.dataSize();
        if (this.mStore != null) {
            estimatedBytes += this.mStore.getMaxHistorySize() * 10;
        }
        if (this.mHistoryParcels != null) {
            for (int i = this.mHistoryParcels.size() - 1; i >= 0; --i) {
                estimatedBytes += this.mHistoryParcels.get(i).dataSize();
            }
        }
        return estimatedBytes / 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatteryStatsHistory copy() {
        Trace.traceBegin(524288L, "BatteryStatsHistory.copy");
        try {
            BatteryStatsHistory batteryStatsHistory = this;
            synchronized (batteryStatsHistory) {
                Parcel historyBufferCopy = Parcel.obtain();
                historyBufferCopy.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
                BatteryStatsHistory batteryStatsHistory2 = new BatteryStatsHistory(historyBufferCopy, 0, this.mStore, null, null, null, this.mEventLogger, this);
                return batteryStatsHistory2;
            }
        }
        finally {
            Trace.traceEnd(524288L);
        }
    }

    public boolean isReadOnly() {
        return !this.mMutable || this.mActiveFragment == null || this.mStore == null;
    }

    private void setActiveFragment(BatteryHistoryFragment file) {
        this.mActiveFragment = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNextFragment(long elapsedRealtimeMs) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.startNextFragmentLocked(elapsedRealtimeMs);
        }
    }

    @GuardedBy(value={"this"})
    private void startNextFragmentLocked(long elapsedRealtimeMs) {
        long start = SystemClock.uptimeMillis();
        this.writeHistory(true);
        long monotonicStartTime = this.mMonotonicClock.monotonicTime(elapsedRealtimeMs);
        this.setActiveFragment(this.mStore.createFragment(monotonicStartTime));
        this.mHistoryBufferStartTime = monotonicStartTime;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(this.mMaxHistoryBufferSize / 2);
        this.mHistoryBufferLastPos = -1;
        this.mHistoryLastWritten.clear();
        this.mHistoryLastLastWritten.clear();
        for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
            entry.setValue(entry.getValue() | 0x8000);
        }
        this.mWrittenPowerStatsDescriptors.clear();
    }

    public boolean isResetEnabled() {
        return this.mStore == null || !this.mStore.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mMonotonicHistorySize = 0L;
            this.initHistoryBuffer();
            if (this.mStore != null) {
                this.mStore.reset();
                this.setActiveFragment(this.mStore.createFragment(this.mHistoryBufferStartTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartTime() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            BatteryHistoryFragment firstFragment = this.mStore.getEarliestFragment();
            if (firstFragment != null) {
                return firstFragment.monotonicTimeMs;
            }
            return this.mHistoryBufferStartTime;
        }
    }

    @NonNull
    public BatteryStatsHistoryIterator iterate(long startTimeMs, long endTimeMs) {
        if (this.mMutable || this.mIteratorCookie != 0) {
            return this.copy().iterate(startTimeMs, endTimeMs);
        }
        if (this.mStore != null) {
            this.mStore.lock();
        }
        BatteryStatsHistoryIterator iterator = new BatteryStatsHistoryIterator(this, startTimeMs, endTimeMs);
        this.mIteratorCookie = System.identityHashCode(iterator);
        Trace.asyncTraceBegin(524288L, "BatteryStatsHistory.iterate", this.mIteratorCookie);
        return iterator;
    }

    void iteratorFinished() {
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        if (this.mStore != null) {
            this.mStore.unlock();
        }
        Trace.asyncTraceEnd(524288L, "BatteryStatsHistory.iterate", this.mIteratorCookie);
        this.mIteratorCookie = 0;
    }

    Queue<BatteryHistoryParcelContainer> getParcelContainers(long startTimeMs, long endTimeMs) {
        if (this.mMutable) {
            throw new IllegalStateException("Iterating over a mutable battery history");
        }
        if (endTimeMs == -1L || endTimeMs == 0L) {
            endTimeMs = Long.MAX_VALUE;
        }
        ArrayDeque<BatteryHistoryParcelContainer> containers = new ArrayDeque<BatteryHistoryParcelContainer>();
        if (this.mStore != null) {
            List<BatteryHistoryFragment> fragments = this.mStore.getFragments();
            for (int i = 0; i < fragments.size(); ++i) {
                BatteryHistoryFragment fragment = fragments.get(i);
                if (fragment.monotonicTimeMs >= endTimeMs) break;
                if (fragment.monotonicTimeMs >= this.mHistoryBufferStartTime || i < fragments.size() - 1 && fragments.get((int)(i + 1)).monotonicTimeMs < startTimeMs) continue;
                containers.add(new BatteryHistoryParcelContainer(fragment));
            }
        }
        if (this.mHistoryParcels != null) {
            for (int i = 0; i < this.mHistoryParcels.size(); ++i) {
                long monotonicEndTime;
                long monotonicStartTime;
                Parcel p = this.mHistoryParcels.get(i);
                if (!this.verifyVersion(p) || (monotonicStartTime = p.readLong()) >= endTimeMs || (monotonicEndTime = p.readLong()) < startTimeMs) continue;
                p.readLong();
                p.readInt();
                containers.add(new BatteryHistoryParcelContainer(p, monotonicStartTime));
            }
        }
        if (this.mHistoryBufferStartTime < endTimeMs) {
            this.mHistoryBuffer.setDataPosition(0);
            containers.add(new BatteryHistoryParcelContainer(this.mHistoryBuffer, this.mHistoryBufferStartTime));
        }
        return containers;
    }

    public boolean readFragmentToParcel(Parcel out, BatteryHistoryFragment fragment) {
        byte[] data = this.mStore.readFragment(fragment);
        if (data == null || data.length == 0) {
            return false;
        }
        out.unmarshall(data, 0, data.length);
        out.setDataPosition(0);
        if (!this.verifyVersion(out)) {
            return false;
        }
        out.readLong();
        out.readLong();
        out.readLong();
        return true;
    }

    private boolean verifyVersion(Parcel p) {
        p.setDataPosition(0);
        int version = p.readInt();
        return version == 214;
    }

    public void writeSummaryToParcel(Parcel out, boolean inclHistory) {
        out.writeBoolean(inclHistory);
        if (inclHistory) {
            this.writeToParcel(out);
        }
        out.writeInt(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            out.writeInt(ent.getValue());
            out.writeString(tag.string);
            out.writeInt(tag.uid);
        }
    }

    public void readSummaryFromParcel(Parcel in) {
        boolean inclHistory = in.readBoolean();
        if (inclHistory) {
            this.readFromParcel(in);
        }
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        int numTags = in.readInt();
        for (int i = 0; i < numTags; ++i) {
            int idx = in.readInt();
            String str = in.readString();
            int uid = in.readInt();
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.string = str;
            tag.uid = uid;
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(tag, idx);
            if (idx >= this.mNextHistoryTagIdx) {
                this.mNextHistoryTagIdx = idx + 1;
            }
            this.mNumHistoryTagChars += tag.string.length() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel out) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.writeHistoryBuffer(out);
            if (this.mStore != null) {
                this.writeToParcel(out, false, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToBatteryUsageStatsParcel(Parcel out, long preferredHistoryDurationMs) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            out.writeBlob(this.mHistoryBuffer.marshall());
            if (this.mStore != null) {
                this.writeToParcel(out, true, this.mHistoryMonotonicEndTime - preferredHistoryDurationMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToParcel(Parcel out, boolean useBlobs, long preferredEarliestIncludedTimestampMs) {
        Trace.traceBegin(524288L, "BatteryStatsHistory.writeToParcel");
        this.mStore.lock();
        try {
            long start = SystemClock.uptimeMillis();
            List<BatteryHistoryFragment> fragments = this.mStore.getFragments();
            for (int i = 0; i < fragments.size() - 1; ++i) {
                long monotonicEndTime = Long.MAX_VALUE;
                if (i < fragments.size() - 1) {
                    monotonicEndTime = fragments.get((int)(i + 1)).monotonicTimeMs;
                }
                if (monotonicEndTime < preferredEarliestIncludedTimestampMs) continue;
                byte[] data = this.mStore.readFragment(fragments.get(i));
                if (data == null) {
                    Slog.e(TAG, "Error reading history fragment " + fragments.get(i));
                    continue;
                }
                if (data.length == 0) continue;
                out.writeBoolean(true);
                if (useBlobs) {
                    out.writeBlob(data, 0, data.length);
                    continue;
                }
                out.writeByteArray(data, 0, data.length);
            }
            out.writeBoolean(false);
        }
        finally {
            this.mStore.unlock();
            Trace.traceEnd(524288L);
        }
    }

    public static BatteryStatsHistory createFromBatteryUsageStatsParcel(Parcel in) {
        return new BatteryStatsHistory(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readSummary() {
        if (this.mActiveFragment == null) {
            Slog.w(TAG, "readSummary: no history file associated with this instance");
            return false;
        }
        Parcel parcel = Parcel.obtain();
        try {
            byte[] data = this.mStore.readFragment(this.mActiveFragment);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            if (data.length > 0) {
                parcel.unmarshall(data, 0, data.length);
                parcel.setDataPosition(0);
                this.readHistoryBuffer(parcel);
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading battery history", e);
            this.reset();
            boolean bl = false;
            return bl;
        }
        finally {
            parcel.recycle();
        }
        return true;
    }

    public void readFromParcel(Parcel in) {
        this.readHistoryBuffer(in);
        this.readFromParcel(in, false);
    }

    private void readFromParcel(Parcel in, boolean useBlobs) {
        long start = SystemClock.uptimeMillis();
        this.mHistoryParcels = new ArrayList<Parcel>();
        while (in.readBoolean()) {
            byte[] temp = useBlobs ? in.readBlob() : in.createByteArray();
            if (temp == null || temp.length == 0) continue;
            Parcel p = Parcel.obtain();
            p.unmarshall(temp, 0, temp.length);
            p.setDataPosition(0);
            this.mHistoryParcels.add(p);
        }
    }

    @VisibleForTesting
    public BatteryHistoryStore getBatteryHistoryStore() {
        return this.mStore;
    }

    @VisibleForTesting
    public BatteryHistoryFragment getActiveFragment() {
        return this.mActiveFragment;
    }

    public int getHistoryUsedSize() {
        int ret = this.mStore.getSize();
        ret += this.mHistoryBuffer.dataSize();
        if (this.mHistoryParcels != null) {
            for (int i = 0; i < this.mHistoryParcels.size(); ++i) {
                ret += this.mHistoryParcels.get(i).dataSize();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryRecordingEnabled(boolean enabled) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mRecordingHistory = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecordingHistory() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            return this.mRecordingHistory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void forceRecordAllHistory() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHaveBatteryLevel = true;
            this.mRecordingHistory = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecordingHistory(long elapsedRealtimeMs, long uptimeMs, boolean reset) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mRecordingHistory = true;
            this.mHistoryCur.currentTime = this.mClock.currentTimeMillis();
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, reset ? (byte)7 : 5);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueRecordingHistory() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            if (this.mHistoryBuffer.dataPosition() <= 0 && !this.mStore.hasCompletedFragments()) {
                return;
            }
            this.mRecordingHistory = true;
            long elapsedRealtimeMs = this.mClock.elapsedRealtime();
            long uptimeMs = this.mClock.uptimeMillis();
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, (byte)4);
            this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatteryState(boolean charging, int status, int level, int chargeUah) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHaveBatteryLevel = true;
            this.setChargingState(charging);
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryChargeUah = chargeUah;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatteryState(int status, int level, int health, int plugType, int temperature, int voltageMv, int chargeUah) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHaveBatteryLevel = true;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryHealth = (byte)health;
            this.mHistoryCur.batteryPlugType = (byte)plugType;
            this.mHistoryCur.batteryTemperature = (short)temperature;
            this.mHistoryCur.batteryVoltage = (short)voltageMv;
            this.mHistoryCur.batteryChargeUah = chargeUah;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluggedInState(boolean pluggedIn) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states = pluggedIn ? (this.mHistoryCur.states |= 0x80000) : (this.mHistoryCur.states &= 0xFFF7FFFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChargingState(boolean charging) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 = charging ? (this.mHistoryCur.states2 |= 0x1000000) : (this.mHistoryCur.states2 &= 0xFEFFFFFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEvent(long elapsedRealtimeMs, long uptimeMs, int code, String name, int uid) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.eventCode = code;
            this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
            this.mHistoryCur.eventTag.string = name;
            this.mHistoryCur.eventTag.uid = uid;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCurrentTimeChange(long elapsedRealtimeMs, long uptimeMs, long currentTimeMs) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            if (!this.mRecordingHistory) {
                return;
            }
            this.mHistoryCur.currentTime = currentTimeMs;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, (byte)5);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordShutdownEvent(long elapsedRealtimeMs, long uptimeMs, long currentTimeMs) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            if (!this.mRecordingHistory) {
                return;
            }
            this.mHistoryCur.currentTime = currentTimeMs;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, (byte)8);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordBatteryState(long elapsedRealtimeMs, long uptimeMs, int batteryLevel, boolean isPlugged) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.batteryLevel = (byte)batteryLevel;
            this.setPluggedInState(isPlugged);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordPowerStats(long elapsedRealtimeMs, long uptimeMs, PowerStats powerStats) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.powerStats = powerStats;
            this.mHistoryCur.states2 |= 0x20000;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordProcessStateChange(long elapsedRealtimeMs, long uptimeMs, int uid, int processState) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.processStateChange = this.mHistoryCur.localProcessStateChange;
            this.mHistoryCur.processStateChange.uid = uid;
            this.mHistoryCur.processStateChange.processState = processState;
            this.mHistoryCur.states2 |= 0x20000;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordWifiConsumedCharge(long elapsedRealtimeMs, long uptimeMs, double monitoredRailChargeMah) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.wifiRailChargeMah += monitoredRailChargeMah;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordWakelockStartEvent(long elapsedRealtimeMs, long uptimeMs, String historyName, int uid) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
            this.mHistoryCur.wakelockTag.string = historyName;
            this.mHistoryCur.wakelockTag.uid = uid;
            this.recordStateStartEvent(elapsedRealtimeMs, uptimeMs, 0x40000000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeUpdateWakelockTag(long elapsedRealtimeMs, long uptimeMs, String historyName, int uid) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            if (this.mHistoryLastWritten.cmd != 0) {
                return false;
            }
            if (this.mHistoryLastWritten.wakelockTag != null) {
                this.mHistoryLastWritten.wakelockTag = null;
                this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                this.mHistoryCur.wakelockTag.string = historyName;
                this.mHistoryCur.wakelockTag.uid = uid;
                this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordWakelockStopEvent(long elapsedRealtimeMs, long uptimeMs, String historyName, int uid) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            (this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag).string = historyName != null ? historyName : "";
            this.mHistoryCur.wakelockTag.uid = uid;
            this.recordStateStopEvent(elapsedRealtimeMs, uptimeMs, 0x40000000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordStateStartEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states |= stateFlags;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordStateStartEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags, int uid, String name) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states |= stateFlags;
            this.mHistoryCur.eventCode = 32789;
            this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
            this.mHistoryCur.eventTag.uid = uid;
            this.mHistoryCur.eventTag.string = name;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordStateStopEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states &= ~stateFlags;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordStateStopEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags, int uid, String name) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states &= ~stateFlags;
            this.mHistoryCur.eventCode = 16405;
            this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
            this.mHistoryCur.eventTag.uid = uid;
            this.mHistoryCur.eventTag.string = name;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordStateChangeEvent(long elapsedRealtimeMs, long uptimeMs, int stateStartFlags, int stateStopFlags) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states = (this.mHistoryCur.states | stateStartFlags) & ~stateStopFlags;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordState2StartEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 |= stateFlags;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordState2StartEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags, int uid, String name) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 |= stateFlags;
            this.mHistoryCur.eventCode = 32789;
            this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
            this.mHistoryCur.eventTag.uid = uid;
            this.mHistoryCur.eventTag.string = name;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordState2StopEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags, int uid, String name) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 &= ~stateFlags;
            this.mHistoryCur.eventCode = 16405;
            this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
            this.mHistoryCur.eventTag.uid = uid;
            this.mHistoryCur.eventTag.string = name;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordState2StopEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 &= ~stateFlags;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordWakeupEvent(long elapsedRealtimeMs, long uptimeMs, String reason) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.wakeReasonTag = this.mHistoryCur.localWakeReasonTag;
            this.mHistoryCur.wakeReasonTag.string = reason;
            this.mHistoryCur.wakeReasonTag.uid = 0;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordScreenBrightnessEvent(long elapsedRealtimeMs, long uptimeMs, int brightnessBin) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, brightnessBin, 0, 7);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordGpsSignalQualityEvent(long elapsedRealtimeMs, long uptimeMs, int signalLevel) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, signalLevel, 7, 384);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordDeviceIdleEvent(long elapsedRealtimeMs, long uptimeMs, int mode) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, mode, 25, 0x6000000);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordPhoneStateChangeEvent(long elapsedRealtimeMs, long uptimeMs, int addStateFlag, int removeStateFlag, int state, int signalStrength) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states = (this.mHistoryCur.states | addStateFlag) & ~removeStateFlag;
            if (state != -1) {
                this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, state, 6, 448);
            }
            if (signalStrength != -1) {
                this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, signalStrength, 3, 56);
            }
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordDataConnectionTypeChangeEvent(long elapsedRealtimeMs, long uptimeMs, int dataConnectionType) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, dataConnectionType, 9, 15872);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordNrStateChangeEvent(long elapsedRealtimeMs, long uptimeMs, int nrState) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, nrState, 9, 1536);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordWifiSupplicantStateChangeEvent(long elapsedRealtimeMs, long uptimeMs, int supplState) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, supplState, 0, 15);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordWifiSignalStrengthChangeEvent(long elapsedRealtimeMs, long uptimeMs, int strengthBin) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, strengthBin, 4, 112);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
    }

    private void recordTraceEvents(int code, BatteryStats.HistoryTag tag) {
        if (code == 0) {
            return;
        }
        int idx = code & 0xFFFF3FFF;
        String prefix = (code & 0x8000) != 0 ? "+" : ((code & 0x4000) != 0 ? "-" : "");
        String[] names = BatteryStats.HISTORY_EVENT_NAMES;
        if (idx < 0 || idx >= names.length) {
            return;
        }
        String track = "battery_stats." + names[idx];
        String name = prefix + names[idx] + "=" + tag.uid + ":\"" + tag.string + "\"";
        this.mTracer.traceInstantEvent(track, name);
    }

    private void recordTraceCounters(int oldval, int newval, int mask, BatteryStats.BitDescription[] descriptions) {
        int diff = (oldval ^ newval) & mask;
        if (diff == 0) {
            return;
        }
        for (int i = 0; i < descriptions.length; ++i) {
            BatteryStats.BitDescription bd = descriptions[i];
            if ((diff & bd.mask) == 0) continue;
            int value = bd.shift < 0 ? ((newval & bd.mask) != 0 ? 1 : 0) : (newval & bd.mask) >> bd.shift;
            this.mTracer.traceCounter("battery_stats." + bd.name, value);
        }
    }

    private int setBitField(int bits, int value, int shift, int mask) {
        int shiftedValue = value << shift;
        if ((shiftedValue & ~mask) != 0) {
            Slog.wtfStack(TAG, "Value " + Integer.toHexString(value) + " does not fit in the bit field: " + Integer.toHexString(mask));
            shiftedValue &= mask;
        }
        return bits & ~mask | shiftedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordHistoryStepDetails(BatteryStats.HistoryStepDetails details, long elapsedRealtimeMs, long uptimeMs) {
        if (details.isEmpty()) {
            return;
        }
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryCur.stepDetails = details;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
            this.mHistoryCur.stepDetails = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHistoryItem(long elapsedRealtimeMs, long uptimeMs) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            long diffElapsedMs;
            long diffUptimeMs;
            if (this.mTrackRunningHistoryElapsedRealtimeMs != 0L && (diffUptimeMs = uptimeMs - this.mTrackRunningHistoryUptimeMs) < (diffElapsedMs = elapsedRealtimeMs - this.mTrackRunningHistoryElapsedRealtimeMs) - 20L) {
                long wakeElapsedTimeMs = elapsedRealtimeMs - (diffElapsedMs - diffUptimeMs);
                this.mHistoryAddTmp.setTo(this.mHistoryLastWritten);
                this.mHistoryAddTmp.wakelockTag = null;
                this.mHistoryAddTmp.wakeReasonTag = null;
                this.mHistoryAddTmp.powerStats = null;
                this.mHistoryAddTmp.processStateChange = null;
                this.mHistoryAddTmp.eventCode = 0;
                this.mHistoryAddTmp.states &= Integer.MAX_VALUE;
                this.mHistoryAddTmp.stepDetails = null;
                this.writeHistoryItem(wakeElapsedTimeMs, uptimeMs, this.mHistoryAddTmp);
            }
            this.mHistoryCur.states |= Integer.MIN_VALUE;
            this.mTrackRunningHistoryElapsedRealtimeMs = elapsedRealtimeMs;
            this.mTrackRunningHistoryUptimeMs = uptimeMs;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur);
        }
    }

    @GuardedBy(value={"this"})
    private void writeHistoryItem(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        if (cur.eventCode != 0 && cur.eventTag.string == null) {
            Slog.wtfStack(TAG, "Event " + Integer.toHexString(cur.eventCode) + " without a name");
        }
        if (this.mTracer != null && this.mTracer.tracingEnabled()) {
            this.recordTraceEvents(cur.eventCode, cur.eventTag);
            this.recordTraceCounters(this.mTraceLastState, cur.states, 0x3FFFFFFF, BatteryStats.HISTORY_STATE_DESCRIPTIONS);
            this.recordTraceCounters(this.mTraceLastState2, cur.states2, -1, BatteryStats.HISTORY_STATE2_DESCRIPTIONS);
            this.mTraceLastState = cur.states;
            this.mTraceLastState2 = cur.states2;
        }
        if (!(this.mHaveBatteryLevel && this.mRecordingHistory || cur.powerStats != null || cur.processStateChange != null)) {
            return;
        }
        if (!this.mMutable) {
            throw new ConcurrentModificationException("Battery history is not writable");
        }
        long timeDiffMs = this.mMonotonicClock.monotonicTime(elapsedRealtimeMs) - this.mHistoryLastWritten.time;
        int diffStates = this.mHistoryLastWritten.states ^ cur.states;
        int diffStates2 = this.mHistoryLastWritten.states2 ^ cur.states2;
        int lastDiffStates = this.mHistoryLastWritten.states ^ this.mHistoryLastLastWritten.states;
        int lastDiffStates2 = this.mHistoryLastWritten.states2 ^ this.mHistoryLastLastWritten.states2;
        if (!(this.mHistoryBufferLastPos < 0 || this.mHistoryLastWritten.cmd != 0 || timeDiffMs >= 1000L || (diffStates & lastDiffStates) != 0 || (diffStates2 & lastDiffStates2) != 0 || this.mHistoryLastWritten.tagsFirstOccurrence || cur.tagsFirstOccurrence || this.mHistoryLastWritten.wakelockTag != null && cur.wakelockTag != null || this.mHistoryLastWritten.wakeReasonTag != null && cur.wakeReasonTag != null || this.mHistoryLastWritten.stepDetails != null || this.mHistoryLastWritten.eventCode != 0 && cur.eventCode != 0 || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || this.mHistoryLastWritten.batteryStatus != cur.batteryStatus || this.mHistoryLastWritten.batteryHealth != cur.batteryHealth || this.mHistoryLastWritten.batteryPlugType != cur.batteryPlugType || this.mHistoryLastWritten.batteryTemperature != cur.batteryTemperature || this.mHistoryLastWritten.batteryVoltage != cur.batteryVoltage || this.mHistoryLastWritten.powerStats != null || this.mHistoryLastWritten.processStateChange != null)) {
            this.mMonotonicHistorySize -= (long)(this.mHistoryBuffer.dataSize() - this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
            this.mHistoryBufferLastPos = -1;
            elapsedRealtimeMs -= timeDiffMs;
            if (this.mHistoryLastWritten.wakelockTag != null) {
                cur.wakelockTag = cur.localWakelockTag;
                cur.wakelockTag.setTo(this.mHistoryLastWritten.wakelockTag);
            }
            if (this.mHistoryLastWritten.wakeReasonTag != null) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                cur.wakeReasonTag.setTo(this.mHistoryLastWritten.wakeReasonTag);
            }
            if (this.mHistoryLastWritten.eventCode != 0) {
                cur.eventCode = this.mHistoryLastWritten.eventCode;
                cur.eventTag = cur.localEventTag;
                cur.eventTag.setTo(this.mHistoryLastWritten.eventTag);
            }
            this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
        }
        if (this.maybeFlushBufferAndWriteHistoryItem(cur, elapsedRealtimeMs, uptimeMs)) {
            return;
        }
        if (this.mHistoryBuffer.dataSize() == 0) {
            BatteryStats.HistoryItem copy = new BatteryStats.HistoryItem();
            copy.setTo(cur);
            copy.currentTime = this.mClock.currentTimeMillis();
            copy.wakelockTag = null;
            copy.wakeReasonTag = null;
            copy.eventCode = 0;
            copy.eventTag = null;
            copy.tagsFirstOccurrence = false;
            copy.powerStats = null;
            copy.processStateChange = null;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, copy, (byte)7);
        }
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, cur, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    private boolean maybeFlushBufferAndWriteHistoryItem(BatteryStats.HistoryItem cur, long elapsedRealtimeMs, long uptimeMs) {
        boolean successfullyLocked;
        int dataSize = this.mHistoryBuffer.dataSize();
        if (dataSize < this.mMaxHistoryBufferSize) {
            return false;
        }
        if (this.mMaxHistoryBufferSize == 0) {
            Slog.wtf(TAG, "mMaxHistoryBufferSize should not be zero when writing history");
            this.mMaxHistoryBufferSize = 1024;
        }
        if (!(successfullyLocked = this.mStore.tryLock())) {
            if (dataSize < this.mMaxHistoryBufferSize + 100000) {
                return false;
            }
            Slog.wtf(TAG, "History buffer overflow exceeds 100000 bytes");
        }
        BatteryStats.HistoryItem copy = new BatteryStats.HistoryItem();
        copy.setTo(cur);
        try {
            this.startNextFragment(elapsedRealtimeMs);
        }
        finally {
            if (successfullyLocked) {
                this.mStore.unlock();
            }
        }
        this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, false);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, copy, (byte)0);
        return true;
    }

    @GuardedBy(value={"this"})
    private void writeHistoryItem(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur, byte cmd) {
        if (!this.mMutable) {
            throw new ConcurrentModificationException("Battery history is not writable");
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        boolean hasTags = this.mHistoryLastWritten.tagsFirstOccurrence || cur.tagsFirstOccurrence;
        this.mHistoryLastWritten.setTo(this.mMonotonicClock.monotonicTime(elapsedRealtimeMs), cmd, cur);
        if (this.mHistoryLastWritten.time < this.mHistoryLastLastWritten.time - 60000L) {
            Slog.wtf(TAG, "Significantly earlier event written to battery history: time=" + this.mHistoryLastWritten.time + " previous=" + this.mHistoryLastLastWritten.time);
        }
        this.mHistoryLastWritten.tagsFirstOccurrence = hasTags;
        this.writeHistoryDelta(this.mHistoryBuffer, this.mHistoryLastWritten, this.mHistoryLastLastWritten);
        this.mMonotonicHistorySize += (long)(this.mHistoryBuffer.dataSize() - this.mHistoryBufferLastPos);
        cur.wakelockTag = null;
        cur.wakeReasonTag = null;
        cur.eventCode = 0;
        cur.eventTag = null;
        cur.tagsFirstOccurrence = false;
        cur.powerStats = null;
        cur.processStateChange = null;
    }

    @GuardedBy(value={"this"})
    private void writeHistoryDelta(Parcel dest, BatteryStats.HistoryItem cur, BatteryStats.HistoryItem last) {
        boolean batteryChargeChanged;
        boolean state2IntChanged;
        int stateInt;
        boolean stateIntChanged;
        boolean batteryLevelIntChanged;
        this.mHistoryMonotonicEndTime = cur.time;
        if (last == null || cur.cmd != 0) {
            dest.writeInt(524285);
            cur.writeToParcel(dest, 0);
            return;
        }
        int extensionFlags = 0;
        long deltaTime = cur.time - last.time;
        int batteryLevelInt = this.buildBatteryLevelInt(cur, last);
        int lastStateInt = this.buildStateInt(last);
        int deltaTimeToken = deltaTime < 0L || deltaTime > Integer.MAX_VALUE ? 524287 : (deltaTime >= 524285L ? 524286 : (int)deltaTime);
        int firstToken = deltaTimeToken | cur.states & 0xFE000000;
        if (cur.stepDetails != null) {
            batteryLevelInt |= 1;
        }
        boolean bl = batteryLevelIntChanged = batteryLevelInt != 0;
        if (batteryLevelIntChanged) {
            firstToken |= 0x80000;
        }
        boolean bl2 = stateIntChanged = (stateInt = this.buildStateInt(cur)) != lastStateInt;
        if (stateIntChanged) {
            firstToken |= 0x100000;
        }
        if (cur.powerStats != null) {
            extensionFlags |= 2;
            if (!this.mWrittenPowerStatsDescriptors.contains(cur.powerStats.descriptor)) {
                extensionFlags |= 1;
            }
        }
        if (cur.processStateChange != null) {
            extensionFlags |= 4;
        }
        cur.states2 = extensionFlags != 0 ? (cur.states2 |= 0x20000) : (cur.states2 &= 0xFFFDFFFF);
        boolean bl3 = state2IntChanged = cur.states2 != last.states2 || extensionFlags != 0;
        if (state2IntChanged) {
            firstToken |= 0x200000;
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            firstToken |= 0x400000;
        }
        if (cur.eventCode != 0) {
            firstToken |= 0x800000;
        }
        boolean bl4 = batteryChargeChanged = cur.batteryChargeUah != last.batteryChargeUah;
        if (batteryChargeChanged) {
            firstToken |= 0x1000000;
        }
        dest.writeInt(firstToken);
        if (deltaTimeToken >= 524286) {
            if (deltaTimeToken == 524286) {
                dest.writeInt((int)deltaTime);
            } else {
                dest.writeLong(deltaTime);
            }
        }
        if (batteryLevelIntChanged) {
            boolean overflow = (batteryLevelInt & 2) != 0;
            int extendedBatteryLevelInt = 0;
            dest.writeInt(batteryLevelInt);
            if (overflow) {
                extendedBatteryLevelInt = this.buildExtendedBatteryLevelInt(cur);
                dest.writeInt(extendedBatteryLevelInt);
            }
        }
        if (stateIntChanged) {
            dest.writeInt(stateInt);
        }
        if (state2IntChanged) {
            dest.writeInt(cur.states2);
        }
        cur.tagsFirstOccurrence = false;
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            int wakeLockIndex = cur.wakelockTag != null ? this.writeHistoryTag(cur.wakelockTag) : 65535;
            int wakeReasonIndex = cur.wakeReasonTag != null ? this.writeHistoryTag(cur.wakeReasonTag) : 65535;
            dest.writeInt(wakeReasonIndex << 16 | wakeLockIndex);
            if (cur.wakelockTag != null && (wakeLockIndex & 0x8000) != 0) {
                cur.wakelockTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
            if (cur.wakeReasonTag != null && (wakeReasonIndex & 0x8000) != 0) {
                cur.wakeReasonTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
        }
        if (cur.eventCode != 0) {
            int index = this.writeHistoryTag(cur.eventTag);
            int codeAndIndex = this.setBitField(cur.eventCode & 0xFFFF, index, 16, -65536);
            dest.writeInt(codeAndIndex);
            if ((index & 0x8000) != 0) {
                cur.eventTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
        }
        if (cur.stepDetails != null) {
            cur.stepDetails.writeToParcel(dest);
        }
        if (batteryChargeChanged) {
            dest.writeInt(cur.batteryChargeUah);
        }
        dest.writeDouble(cur.modemRailChargeMah);
        dest.writeDouble(cur.wifiRailChargeMah);
        if (extensionFlags != 0) {
            dest.writeInt(extensionFlags);
            if (cur.powerStats != null) {
                if ((extensionFlags & 1) != 0) {
                    cur.powerStats.descriptor.writeSummaryToParcel(dest);
                    this.mWrittenPowerStatsDescriptors.add(cur.powerStats.descriptor);
                }
                cur.powerStats.writeToParcel(dest);
            }
            if (cur.processStateChange != null) {
                cur.processStateChange.writeToParcel(dest);
            }
        }
    }

    private boolean signedValueFits(int value, int mask, int shift) {
        int msbAndLostBitsMask = ~((mask >>>= shift) >>> 1);
        int msbAndLostBits = value & msbAndLostBitsMask;
        return msbAndLostBits == 0 || msbAndLostBits == msbAndLostBitsMask;
    }

    private int buildBatteryLevelInt(BatteryStats.HistoryItem cur, BatteryStats.HistoryItem prev) {
        int levelDelta = cur.batteryLevel - prev.batteryLevel;
        int tempDelta = cur.batteryTemperature - prev.batteryTemperature;
        int voltDelta = cur.batteryVoltage - prev.batteryVoltage;
        boolean overflow = !this.signedValueFits(tempDelta, 0xFF8000, 2) || !this.signedValueFits(voltDelta, 32764, 15);
        int batt = 0;
        batt |= levelDelta << 24 & 0xFF000000;
        if (overflow) {
            batt |= 2;
        } else {
            batt |= tempDelta << 15 & 0xFF8000;
            batt |= voltDelta << 2 & 0x7FFC;
        }
        return batt;
    }

    private int buildExtendedBatteryLevelInt(BatteryStats.HistoryItem cur) {
        int battExt = 0;
        battExt |= cur.batteryTemperature << 16 & 0xFFFF0000;
        return battExt |= cur.batteryVoltage << 0 & 0xFFFF;
    }

    private int buildStateInt(BatteryStats.HistoryItem h) {
        int plugType = 0;
        if ((h.batteryPlugType & 1) != 0) {
            plugType = 1;
        } else if ((h.batteryPlugType & 2) != 0) {
            plugType = 2;
        } else if ((h.batteryPlugType & 4) != 0) {
            plugType = 3;
        }
        return (h.batteryStatus & 7) << 29 | (h.batteryHealth & 7) << 26 | (plugType & 3) << 24 | h.states & 0xFFFFFF;
    }

    @GuardedBy(value={"this"})
    private int writeHistoryTag(BatteryStats.HistoryTag tag) {
        Integer idxObj;
        int stringLength;
        if (tag.string == null) {
            Slog.wtfStack(TAG, "writeHistoryTag called with null name");
            tag.string = "";
        }
        if ((stringLength = tag.string.length()) > 1024) {
            Slog.e(TAG, "Long battery history tag: " + tag.string);
            tag.string = tag.string.substring(0, 1024);
        }
        if ((idxObj = this.mHistoryTagPool.get(tag)) != null) {
            int idx = idxObj;
            if ((idx & 0x8000) != 0) {
                this.mHistoryTagPool.put(tag, idx & 0xFFFF7FFF);
            }
            return idx;
        }
        if (this.mNextHistoryTagIdx < 32766) {
            int idx = this.mNextHistoryTagIdx++;
            BatteryStats.HistoryTag key = new BatteryStats.HistoryTag();
            key.setTo(tag);
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(key, idx);
            this.mNumHistoryTagChars += stringLength + 1;
            if (this.mHistoryTags != null) {
                this.mHistoryTags.put(idx, key);
            }
            return idx | 0x8000;
        }
        tag.poolIdx = -1;
        return 65534;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitCurrentHistoryBatchLocked() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.mHistoryLastWritten.cmd = (byte)-1;
        }
    }

    public void writeHistory() {
        this.writeHistory(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistory(boolean fragmentComplete) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            if (this.isReadOnly()) {
                Slog.w(TAG, "writeHistory: this instance instance is read-only");
                return;
            }
            this.mMonotonicClock.write();
            Parcel p = Parcel.obtain();
            try {
                long start = SystemClock.uptimeMillis();
                this.writeHistoryBuffer(p);
                this.writeParcelLocked(p, this.mActiveFragment, fragmentComplete);
            }
            finally {
                p.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readHistoryBuffer(Parcel in) throws ParcelFormatException {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            int version = in.readInt();
            if (version != 214) {
                Slog.w("BatteryStats", "readHistoryBuffer: version got " + version + ", expected " + 214 + "; erasing old stats");
                return;
            }
            this.mHistoryBufferStartTime = in.readLong();
            this.mHistoryMonotonicEndTime = in.readLong();
            this.mMonotonicHistorySize = in.readLong();
            this.mHistoryBuffer.setDataSize(0);
            this.mHistoryBuffer.setDataPosition(0);
            int bufSize = in.readInt();
            int curPos = in.dataPosition();
            if (bufSize >= this.mMaxHistoryBufferSize * 100) {
                throw new ParcelFormatException("File corrupt: history data buffer too large " + bufSize);
            }
            if ((bufSize & 0xFFFFFFFC) != bufSize) {
                throw new ParcelFormatException("File corrupt: history data buffer not aligned " + bufSize);
            }
            this.mHistoryBuffer.appendFrom(in, curPos, bufSize);
            in.setDataPosition(curPos + bufSize);
        }
    }

    @GuardedBy(value={"this"})
    private void writeHistoryBuffer(Parcel out) {
        out.writeInt(214);
        out.writeLong(this.mHistoryBufferStartTime);
        out.writeLong(this.mHistoryMonotonicEndTime);
        out.writeLong(this.mMonotonicHistorySize);
        out.writeInt(this.mHistoryBuffer.dataSize());
        out.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    private void writeParcelLocked(Parcel p, BatteryHistoryFragment fragment, boolean fragmentComplete) {
        this.mWriteLock.lock();
        try {
            long startTimeMs = SystemClock.uptimeMillis();
            this.mStore.writeFragment(fragment, p.marshall(), fragmentComplete);
            this.mEventLogger.writeCommitSysConfigFile(startTimeMs);
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryStringPoolSize() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            return this.mHistoryTagPool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryStringPoolBytes() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            return this.mNumHistoryTagChars;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryTagPoolString(int index) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.ensureHistoryTagArray();
            BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
            return historyTag != null ? historyTag.string : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTagPoolUid(int index) {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.ensureHistoryTagArray();
            BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
            return historyTag != null ? historyTag.uid : -1;
        }
    }

    @GuardedBy(value={"this"})
    private void ensureHistoryTagArray() {
        if (this.mHistoryTags != null) {
            return;
        }
        this.mHistoryTags = new SparseArray(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
            this.mHistoryTags.put((int)(entry.getValue() & 0xFFFF7FFF), entry.getKey());
        }
    }

    public long getMonotonicHistorySize() {
        return this.mMonotonicHistorySize;
    }

    public void dump(PrintWriter pw, long startTimeMs, long endTimeMs) {
        BatteryStats.HistoryPrinter printer = new BatteryStats.HistoryPrinter();
        try (BatteryStatsHistoryIterator iterate = this.iterate(startTimeMs, endTimeMs);){
            while (iterate.hasNext()) {
                BatteryStats.HistoryItem next = iterate.next();
                printer.printNextItem(pw, next, 0L, false, true);
            }
        }
        pw.flush();
    }

    public static interface BatteryHistoryStore {
        public int getMaxHistorySize();

        public List<BatteryHistoryFragment> getFragments();

        @Nullable
        public BatteryHistoryFragment getEarliestFragment();

        @Nullable
        public BatteryHistoryFragment getLatestFragment();

        public void lock();

        public boolean tryLock();

        public void unlock();

        public boolean isLocked();

        public int getSize();

        public boolean hasCompletedFragments();

        public BatteryHistoryFragment createFragment(long var1);

        public void writeFragment(BatteryHistoryFragment var1, @NonNull byte[] var2, boolean var3);

        @Nullable
        public byte[] readFragment(BatteryHistoryFragment var1);

        public void reset();
    }

    @VisibleForTesting
    @RavenwoodKeepWholeClass
    public static class TraceDelegate {
        private final boolean mShouldSetProperty = _Original_Build.IS_USERDEBUG && Process.myUid() == 1000;

        public boolean tracingEnabled() {
            return Trace.isTagEnabled(131072L) || this.mShouldSetProperty;
        }

        public void traceCounter(@NonNull String name, int value) {
            Trace.traceCounter(131072L, name, value);
            if (this.mShouldSetProperty) {
                try {
                    SystemProperties.set("debug.tracing." + name, Integer.toString(value));
                }
                catch (RuntimeException e) {
                    Slog.e(BatteryStatsHistory.TAG, "Failed to set debug.tracing." + name, e);
                }
            }
        }

        public void traceInstantEvent(@NonNull String track, @NonNull String name) {
            Trace.instantForTrack(131072L, track, name);
        }
    }

    public static class EventLogger {
        public void writeCommitSysConfigFile(long startTimeMs) {
            EventLogTags.writeCommitSysConfigFile("batterystats", SystemClock.uptimeMillis() - startTimeMs);
        }
    }

    public static abstract class BatteryHistoryFragment
    implements Comparable<BatteryHistoryFragment> {
        public final long monotonicTimeMs;

        public BatteryHistoryFragment(long monotonicTimeMs) {
            this.monotonicTimeMs = monotonicTimeMs;
        }

        @Override
        public int compareTo(BatteryHistoryFragment o) {
            return Long.compare(this.monotonicTimeMs, o.monotonicTimeMs);
        }

        public boolean equals(Object o) {
            return this.monotonicTimeMs == ((BatteryHistoryFragment)o).monotonicTimeMs;
        }

        public int hashCode() {
            return Long.hashCode(this.monotonicTimeMs);
        }
    }

    class BatteryHistoryParcelContainer {
        private boolean mParcelReadyForReading;
        private Parcel mParcel;
        private BatteryHistoryFragment mFragment;
        private long mMonotonicStartTime;

        BatteryHistoryParcelContainer(Parcel parcel, long monotonicStartTime) {
            this.mParcel = parcel;
            this.mMonotonicStartTime = monotonicStartTime;
            this.mParcelReadyForReading = true;
        }

        BatteryHistoryParcelContainer(BatteryHistoryFragment fragment) {
            this.mFragment = fragment;
            this.mMonotonicStartTime = fragment.monotonicTimeMs;
            this.mParcelReadyForReading = false;
        }

        @Nullable
        Parcel getParcel() {
            if (this.mParcelReadyForReading) {
                return this.mParcel;
            }
            Parcel parcel = Parcel.obtain();
            if (BatteryStatsHistory.this.readFragmentToParcel(parcel, this.mFragment)) {
                parcel.readInt();
                this.mParcel = parcel;
            } else {
                parcel.recycle();
            }
            this.mParcelReadyForReading = true;
            return this.mParcel;
        }

        long getMonotonicStartTime() {
            return this.mMonotonicStartTime;
        }

        void close() {
            if (this.mParcel != null && this.mFragment != null) {
                this.mParcel.recycle();
            }
            this.mParcel = null;
            this.mFragment = null;
        }
    }

    @RavenwoodKeepWholeClass
    public static class VarintParceler {
        public void writeLongArray(Parcel parcel, long[] values) {
            if (values.length == 0) {
                return;
            }
            int out = 0;
            int shift = 0;
            for (long value : values) {
                boolean done = false;
                while (!done) {
                    byte b;
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        b = (byte)value;
                        done = true;
                    } else {
                        b = (byte)((int)value & 0x7F | 0x80);
                        value >>>= 7;
                    }
                    if (shift == 32) {
                        parcel.writeInt(out);
                        shift = 0;
                        out = 0;
                    }
                    out |= (b & 0xFF) << shift;
                    shift += 8;
                }
            }
            if (shift != 0) {
                parcel.writeInt(out);
            }
        }

        public void readLongArray(Parcel parcel, long[] values) {
            if (values.length == 0) {
                return;
            }
            int in = parcel.readInt();
            int available = 4;
            for (int i = 0; i < values.length; ++i) {
                int shift;
                long result = 0L;
                for (shift = 0; shift < 64; shift += 7) {
                    if (available == 0) {
                        in = parcel.readInt();
                        available = 4;
                    }
                    byte b = (byte)in;
                    in >>= 8;
                    --available;
                    result |= (long)(b & 0x7F) << shift;
                    if ((b & 0x80) != 0) continue;
                    values[i] = result;
                    break;
                }
                if (shift < 64) continue;
                throw new ParcelFormatException("Invalid varint format");
            }
        }
    }
}

