/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Intent;
import android.os.SystemClock;
import com.android.internal.os.anr.AnrLatencyTracker;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TimeoutRecord {
    public final int mKind;
    public final String mReason;
    public final long mEndUptimeMillis;
    public final boolean mEndTakenBeforeLocks;
    public final AnrLatencyTracker mLatencyTracker;
    private AutoCloseable mExpiredTimer;

    private TimeoutRecord(int kind, @NonNull String reason, long endUptimeMillis, boolean endTakenBeforeLocks) {
        this.mKind = kind;
        this.mReason = reason;
        this.mEndUptimeMillis = endUptimeMillis;
        this.mEndTakenBeforeLocks = endTakenBeforeLocks;
        this.mLatencyTracker = new AnrLatencyTracker(kind, endUptimeMillis);
        this.mExpiredTimer = null;
    }

    private static TimeoutRecord endingNow(int kind, String reason) {
        long endUptimeMillis = SystemClock.uptimeMillis();
        return new TimeoutRecord(kind, reason, endUptimeMillis, true);
    }

    private static TimeoutRecord endingApproximatelyNow(int kind, String reason) {
        long endUptimeMillis = SystemClock.uptimeMillis();
        return new TimeoutRecord(kind, reason, endUptimeMillis, false);
    }

    @NonNull
    public static TimeoutRecord forBroadcastReceiver(@NonNull Intent intent, @Nullable String packageName, @Nullable String className) {
        Intent logIntent;
        if (packageName != null) {
            if (className != null) {
                logIntent = new Intent(intent);
                logIntent.setComponent(new ComponentName(packageName, className));
            } else {
                logIntent = new Intent(intent);
                logIntent.setPackage(packageName);
            }
        } else {
            logIntent = intent;
        }
        return TimeoutRecord.forBroadcastReceiver(logIntent);
    }

    @NonNull
    public static TimeoutRecord forBroadcastReceiver(@NonNull Intent intent) {
        StringBuilder reason = new StringBuilder("Broadcast of ");
        intent.toString(reason);
        return TimeoutRecord.endingNow(3, reason.toString());
    }

    @NonNull
    public static TimeoutRecord forBroadcastReceiver(@NonNull Intent intent, long timeoutDurationMs) {
        StringBuilder reason = new StringBuilder("Broadcast of ");
        intent.toString(reason);
        reason.append(", waited ");
        reason.append(timeoutDurationMs);
        reason.append("ms");
        return TimeoutRecord.endingNow(3, reason.toString());
    }

    @NonNull
    public static TimeoutRecord forInputDispatchNoFocusedWindow(@NonNull String reason) {
        return TimeoutRecord.endingNow(1, reason);
    }

    @NonNull
    public static TimeoutRecord forInputDispatchWindowUnresponsive(@NonNull String reason) {
        return TimeoutRecord.endingNow(2, reason);
    }

    @NonNull
    public static TimeoutRecord forServiceExec(@NonNull String shortInstanceName, long timeoutDurationMs) {
        String reason = "executing service " + shortInstanceName + ", waited " + timeoutDurationMs + "ms";
        return TimeoutRecord.endingNow(5, reason);
    }

    @NonNull
    public static TimeoutRecord forServiceStartWithEndTime(@NonNull String reason, long endUptimeMillis) {
        return new TimeoutRecord(4, reason, endUptimeMillis, true);
    }

    @NonNull
    public static TimeoutRecord forContentProvider(@NonNull String reason) {
        return TimeoutRecord.endingApproximatelyNow(6, reason);
    }

    @NonNull
    public static TimeoutRecord forApp(@NonNull String reason) {
        return TimeoutRecord.endingApproximatelyNow(7, reason);
    }

    @NonNull
    public static TimeoutRecord forShortFgsTimeout(String reason) {
        return TimeoutRecord.endingNow(8, reason);
    }

    @NonNull
    public static TimeoutRecord forJobService(String reason) {
        return TimeoutRecord.endingNow(9, reason);
    }

    @NonNull
    public static TimeoutRecord forAppStart(String reason) {
        return TimeoutRecord.endingNow(10, reason);
    }

    @NonNull
    public TimeoutRecord setExpiredTimer(@Nullable AutoCloseable handle) {
        this.mExpiredTimer = handle;
        return this;
    }

    public void closeExpiredTimer() {
        try {
            if (this.mExpiredTimer != null) {
                this.mExpiredTimer.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeoutKind {
        public static final int INPUT_DISPATCH_NO_FOCUSED_WINDOW = 1;
        public static final int INPUT_DISPATCH_WINDOW_UNRESPONSIVE = 2;
        public static final int BROADCAST_RECEIVER = 3;
        public static final int SERVICE_START = 4;
        public static final int SERVICE_EXEC = 5;
        public static final int CONTENT_PROVIDER = 6;
        public static final int APP_REGISTERED = 7;
        public static final int SHORT_FGS_TIMEOUT = 8;
        public static final int JOB_SERVICE = 9;
        public static final int APP_START = 10;
    }
}

