/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.ApplicationInfo;
import android.content.pm.ProcessInfo;
import android.net.Credentials;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.os.FactoryTest;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.Trace;
import android.os._Original_Build;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.compat.IPlatformCompat;
import com.android.internal.net.NetworkUtilsInternal;
import com.android.internal.os.ZygoteArguments;
import com.android.internal.os.ZygoteCommandBuffer;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.ZygoteHooks;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoUtils;

public class Zygote {
    public static final int DEBUG_ENABLE_JDWP = 1;
    public static final int DEBUG_ENABLE_CHECKJNI = 2;
    public static final int DEBUG_ENABLE_ASSERT = 4;
    public static final int DEBUG_ENABLE_SAFEMODE = 8;
    public static final int DEBUG_ENABLE_JNI_LOGGING = 16;
    public static final int DEBUG_GENERATE_DEBUG_INFO = 32;
    public static final int DEBUG_ALWAYS_JIT = 64;
    public static final int DEBUG_NATIVE_DEBUGGABLE = 128;
    public static final int DEBUG_JAVA_DEBUGGABLE = 256;
    public static final int DISABLE_VERIFIER = 512;
    public static final int ONLY_USE_SYSTEM_OAT_FILES = 1024;
    public static final int DEBUG_GENERATE_MINI_DEBUG_INFO = 2048;
    public static final int API_ENFORCEMENT_POLICY_MASK = 12288;
    public static final int API_ENFORCEMENT_POLICY_SHIFT = Integer.numberOfTrailingZeros(12288);
    public static final int PROFILE_SYSTEM_SERVER = 16384;
    public static final int PROFILE_FROM_SHELL = 32768;
    public static final int USE_APP_IMAGE_STARTUP_CACHE = 65536;
    public static final int DEBUG_IGNORE_APP_SIGNAL_HANDLER = 131072;
    public static final int DISABLE_TEST_API_ENFORCEMENT_POLICY = 262144;
    public static final int MEMORY_TAG_LEVEL_MASK = 0x180000;
    public static final int MEMORY_TAG_LEVEL_NONE = 0;
    public static final int MEMORY_TAG_LEVEL_TBI = 524288;
    public static final int MEMORY_TAG_LEVEL_ASYNC = 0x100000;
    public static final int MEMORY_TAG_LEVEL_SYNC = 0x180000;
    public static final int GWP_ASAN_LEVEL_MASK = 0x600000;
    public static final int GWP_ASAN_LEVEL_NEVER = 0;
    public static final int GWP_ASAN_LEVEL_LOTTERY = 0x200000;
    public static final int GWP_ASAN_LEVEL_ALWAYS = 0x400000;
    public static final int GWP_ASAN_LEVEL_DEFAULT = 0x600000;
    public static final int NATIVE_HEAP_ZERO_INIT_ENABLED = 0x800000;
    public static final int PROFILEABLE = 0x1000000;
    public static final int DEBUG_ENABLE_PTRACE = 0x2000000;
    public static final int ENABLE_PAGE_SIZE_APP_COMPAT = 0x4000000;
    public static final int MOUNT_EXTERNAL_NONE = 0;
    public static final int MOUNT_EXTERNAL_DEFAULT = 1;
    public static final int MOUNT_EXTERNAL_INSTALLER = 2;
    public static final int MOUNT_EXTERNAL_PASS_THROUGH = 3;
    public static final int MOUNT_EXTERNAL_ANDROID_WRITABLE = 4;
    static final int USAP_MANAGEMENT_MESSAGE_BYTES = 8;
    public static final String START_AS_TOP_APP_ARG = "--is-top-app";
    public static final String PKG_DATA_INFO_MAP = "--pkg-data-info-map";
    public static final String ALLOWLISTED_DATA_INFO_MAP = "--allowlisted-data-info-map";
    public static final String BIND_MOUNT_APP_STORAGE_DIRS = "--bind-mount-storage-dirs";
    public static final String BIND_MOUNT_APP_DATA_DIRS = "--bind-mount-data-dirs";
    public static final String BIND_MOUNT_SYSPROP_OVERRIDES = "--bind-mount-sysprop-overrides";
    public static final String CHILD_ZYGOTE_SOCKET_NAME_ARG = "--zygote-socket=";
    public static final String CHILD_ZYGOTE_ABI_LIST_ARG = "--abi-list=";
    public static final String CHILD_ZYGOTE_UID_RANGE_START = "--uid-range-start=";
    public static final String CHILD_ZYGOTE_UID_RANGE_END = "--uid-range-end=";
    private static final String TAG = "Zygote";
    private static final String ANDROID_SOCKET_PREFIX = "ANDROID_SOCKET_";
    public static final long PROPERTY_CHECK_INTERVAL = 60000L;
    public static final int SOCKET_BUFFER_SIZE = 256;
    private static final int PRIORITY_MAX = -20;
    static final int[][] INT_ARRAY_2D = new int[0][0];
    public static final String PRIMARY_SOCKET_NAME = "zygote";
    public static final String SECONDARY_SOCKET_NAME = "zygote_secondary";
    public static final String USAP_POOL_PRIMARY_SOCKET_NAME = "usap_pool_primary";
    public static final String USAP_POOL_SECONDARY_SOCKET_NAME = "usap_pool_secondary";
    private static final String USAP_ERROR_PREFIX = "Invalid command to USAP: ";
    private static final boolean ENABLE_JDWP = SystemProperties.get("persist.debug.dalvik.vm.jdwp.enabled").equals("1");
    private static final boolean ENABLE_PTRACE = SystemProperties.get("persist.debug.ptrace.enabled").equals("1");
    private static final long NATIVE_HEAP_POINTER_TAGGING = 135754954L;
    private static final long NATIVE_HEAP_POINTER_TAGGING_SECONDARY_ZYGOTE = 207557677L;
    private static final long NATIVE_MEMTAG_ASYNC = 135772972L;
    private static final long NATIVE_MEMTAG_SYNC = 177438394L;
    private static final long NATIVE_HEAP_ZERO_INIT = 178038272L;
    private static final long GWP_ASAN = 135634846L;

    private Zygote() {
    }

    private static boolean containsInetGid(int[] gids) {
        for (int i = 0; i < gids.length; ++i) {
            if (gids[i] != 3003) continue;
            return true;
        }
        return false;
    }

    static int forkAndSpecialize(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, int mountExternal, String seInfo, String niceName, int[] fdsToClose, int[] fdsToIgnore, boolean startChildZygote, String instructionSet, String appDataDir, boolean isTopApp, String[] pkgDataInfoList, String[] allowlistedDataInfoList, boolean bindMountAppDataDirs, boolean bindMountAppStorageDirs, boolean bindMountSyspropOverrides) {
        ZygoteHooks.preFork();
        int pid = Zygote.nativeForkAndSpecialize(uid, gid, gids, runtimeFlags, rlimits, mountExternal, seInfo, niceName, fdsToClose, fdsToIgnore, startChildZygote, instructionSet, appDataDir, isTopApp, pkgDataInfoList, allowlistedDataInfoList, bindMountAppDataDirs, bindMountAppStorageDirs, bindMountSyspropOverrides);
        if (pid == 0) {
            Trace.traceBegin(64L, "PostFork");
            if (gids != null && gids.length > 0) {
                NetworkUtilsInternal.setAllowNetworkingForProcess(Zygote.containsInetGid(gids));
            }
        }
        Thread.currentThread().setPriority(5);
        ZygoteHooks.postForkCommon();
        return pid;
    }

    private static int nativeForkAndSpecialize(int n, int n2, int[] nArray, int n3, int[][] nArray2, int n4, String string2, String string3, int[] nArray3, int[] nArray4, boolean bl, String string4, String string5, boolean bl2, String[] stringArray, String[] stringArray2, boolean bl3, boolean bl4, boolean bl5) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeForkAndSpecialize(II[II[[IILjava/lang/String;Ljava/lang/String;[I[IZLjava/lang/String;Ljava/lang/String;Z[Ljava/lang/String;[Ljava/lang/String;ZZZ)I", true, null);
    }

    private static void specializeAppProcess(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, int mountExternal, String seInfo, String niceName, boolean startChildZygote, String instructionSet, String appDataDir, boolean isTopApp, String[] pkgDataInfoList, String[] allowlistedDataInfoList, boolean bindMountAppDataDirs, boolean bindMountAppStorageDirs, boolean bindMountSyspropOverrides) {
        Zygote.nativeSpecializeAppProcess(uid, gid, gids, runtimeFlags, rlimits, mountExternal, seInfo, niceName, startChildZygote, instructionSet, appDataDir, isTopApp, pkgDataInfoList, allowlistedDataInfoList, bindMountAppDataDirs, bindMountAppStorageDirs, bindMountSyspropOverrides);
        Trace.traceBegin(64L, "PostFork");
        if (gids != null && gids.length > 0) {
            NetworkUtilsInternal.setAllowNetworkingForProcess(Zygote.containsInetGid(gids));
        }
        Thread.currentThread().setPriority(5);
        ZygoteHooks.postForkCommon();
    }

    private static void nativeSpecializeAppProcess(int n, int n2, int[] nArray, int n3, int[][] nArray2, int n4, String string2, String string3, boolean bl, String string4, String string5, boolean bl2, String[] stringArray, String[] stringArray2, boolean bl3, boolean bl4, boolean bl5) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeSpecializeAppProcess(II[II[[IILjava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Z[Ljava/lang/String;[Ljava/lang/String;ZZZ)V", true, null);
    }

    static void nativePreApplicationInit() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativePreApplicationInit()V", true, null);
    }

    static int forkSystemServer(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, long permittedCapabilities, long effectiveCapabilities) {
        ZygoteHooks.preFork();
        int pid = Zygote.nativeForkSystemServer(uid, gid, gids, runtimeFlags, rlimits, permittedCapabilities, effectiveCapabilities);
        Thread.currentThread().setPriority(5);
        ZygoteHooks.postForkCommon();
        return pid;
    }

    private static int nativeForkSystemServer(int n, int n2, int[] nArray, int n3, int[][] nArray2, long l, long l2) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeForkSystemServer(II[II[[IJJ)I", true, null);
    }

    protected static void nativeAllowFileAcrossFork(String string2) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeAllowFileAcrossFork(Ljava/lang/String;)V", true, null);
    }

    static void allowAppFilesAcrossFork(ApplicationInfo appInfo) {
        for (String path : appInfo.getAllApkPaths()) {
            Zygote.nativeAllowFileAcrossFork(path);
        }
    }

    static void markOpenedFilesBeforePreload() {
        Zygote.nativeMarkOpenedFilesBeforePreload();
    }

    private static void nativeMarkOpenedFilesBeforePreload() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeMarkOpenedFilesBeforePreload()V", true, null);
    }

    static void allowFilesOpenedByPreload() {
        Zygote.nativeAllowFilesOpenedByPreload();
    }

    private static void nativeAllowFilesOpenedByPreload() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeAllowFilesOpenedByPreload()V", true, null);
    }

    protected static void nativeInstallSeccompUidGidFilter(int n, int n2) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeInstallSeccompUidGidFilter(II)V", true, null);
    }

    static void initNativeState(boolean isPrimary) {
        Zygote.nativeInitNativeState(isPrimary);
    }

    protected static void nativeInitNativeState(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeInitNativeState(Z)V", true, null);
    }

    public static String getConfigurationProperty(String propertyName, String defaultValue) {
        return SystemProperties.get(String.join((CharSequence)".", "persist.device_config", "runtime_native", propertyName), defaultValue);
    }

    static void emptyUsapPool() {
        Zygote.nativeEmptyUsapPool();
    }

    private static void nativeEmptyUsapPool() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeEmptyUsapPool()V", true, null);
    }

    public static boolean getConfigurationPropertyBoolean(String propertyName, Boolean defaultValue) {
        return SystemProperties.getBoolean(String.join((CharSequence)".", "persist.device_config", "runtime_native", propertyName), defaultValue);
    }

    static int getUsapPoolCount() {
        return Zygote.nativeGetUsapPoolCount();
    }

    private static int nativeGetUsapPoolCount() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeGetUsapPoolCount()I", true, null);
    }

    static FileDescriptor getUsapPoolEventFD() {
        FileDescriptor fd = new FileDescriptor();
        fd.setInt$(Zygote.nativeGetUsapPoolEventFD());
        return fd;
    }

    private static int nativeGetUsapPoolEventFD() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeGetUsapPoolEventFD()I", true, null);
    }

    @Nullable
    static Runnable forkUsap(LocalServerSocket usapPoolSocket, int[] sessionSocketRawFDs, boolean isPriorityFork) {
        FileDescriptor writeFD;
        FileDescriptor readFD;
        try {
            FileDescriptor[] pipeFDs = Os.pipe2(OsConstants.O_CLOEXEC);
            readFD = pipeFDs[0];
            writeFD = pipeFDs[1];
        }
        catch (ErrnoException errnoEx) {
            throw new IllegalStateException("Unable to create USAP pipe.", errnoEx);
        }
        int pid = Zygote.nativeForkApp(readFD.getInt$(), writeFD.getInt$(), sessionSocketRawFDs, false, isPriorityFork);
        if (pid == 0) {
            IoUtils.closeQuietly(readFD);
            return Zygote.childMain(null, usapPoolSocket, writeFD);
        }
        if (pid == -1) {
            return null;
        }
        IoUtils.closeQuietly(writeFD);
        Zygote.nativeAddUsapTableEntry(pid, readFD.getInt$());
        return null;
    }

    private static int nativeForkApp(int n, int n2, int[] nArray, boolean bl, boolean bl2) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeForkApp(II[IZZ)I", true, null);
    }

    @CriticalNative
    private static void nativeAddUsapTableEntry(int n, int n2) {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeAddUsapTableEntry(II)V", true, null);
    }

    @Nullable
    static Runnable forkSimpleApps(@NonNull ZygoteCommandBuffer argBuffer, @NonNull FileDescriptor zygoteSocket, int expectedUid, int minUid, @Nullable String firstNiceName) {
        boolean in_child = argBuffer.forkRepeatedly(zygoteSocket, expectedUid, minUid, firstNiceName);
        if (in_child) {
            return Zygote.childMain(argBuffer, null, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Runnable childMain(@Nullable ZygoteCommandBuffer argBuffer, @Nullable LocalServerSocket usapPoolSocket, FileDescriptor writePipe) {
        ZygoteArguments args;
        DataOutputStream usapOutputStream;
        int pid;
        block27: {
            pid = Process.myPid();
            usapOutputStream = null;
            args = null;
            LocalSocket sessionSocket = null;
            if (argBuffer == null) {
                Process.setArgV0(Process.is64Bit() ? "usap64" : "usap32");
                Zygote.boostUsapPriority();
                while (true) {
                    ZygoteCommandBuffer tmpArgBuffer = null;
                    try {
                        sessionSocket = usapPoolSocket.accept();
                        Zygote.blockSigTerm();
                        usapOutputStream = new DataOutputStream(sessionSocket.getOutputStream());
                        Credentials peerCredentials = sessionSocket.getPeerCredentials();
                        tmpArgBuffer = new ZygoteCommandBuffer(sessionSocket);
                        args = ZygoteArguments.getInstance(tmpArgBuffer);
                        Zygote.applyUidSecurityPolicy(args, peerCredentials);
                        Zygote.validateUsapCommand(args);
                        break block27;
                    }
                    catch (Exception ex) {
                        Log.e("USAP", ex.getMessage());
                        Zygote.unblockSigTerm();
                        IoUtils.closeQuietly(sessionSocket);
                        IoUtils.closeQuietly(tmpArgBuffer);
                        continue;
                    }
                    break;
                }
            }
            Zygote.blockSigTerm();
            try {
                args = ZygoteArguments.getInstance(argBuffer);
            }
            catch (Exception ex) {
                Log.e("AppStartup", ex.getMessage());
                throw new AssertionError("Failed to parse application start command", ex);
            }
        }
        if (args == null) {
            throw new AssertionError((Object)"Empty command line");
        }
        try {
            Zygote.applyDebuggerSystemProperty(args);
            int[][] rlimits = null;
            if (args.mRLimits != null) {
                rlimits = (int[][])args.mRLimits.toArray((T[])INT_ARRAY_2D);
            }
            if (argBuffer == null) {
                try {
                    usapOutputStream.writeInt(pid);
                }
                catch (IOException ioEx) {
                    Log.e("USAP", "Failed to write response to session socket: " + ioEx.getMessage());
                    throw new RuntimeException(ioEx);
                }
                finally {
                    try {
                        FileDescriptor fd = usapPoolSocket.getFileDescriptor();
                        usapPoolSocket.close();
                        Os.close(fd);
                    }
                    catch (ErrnoException | IOException ex) {
                        Log.e("USAP", "Failed to close USAP pool socket");
                        throw new RuntimeException(ex);
                    }
                }
            }
            if (writePipe != null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
                    DataOutputStream outputStream = new DataOutputStream(buffer);
                    outputStream.writeLong(pid);
                    outputStream.flush();
                    Os.write(writePipe, buffer.toByteArray(), 0, buffer.size());
                }
                catch (Exception ex) {
                    Log.e("USAP", String.format("Failed to write PID (%d) to pipe (%d): %s", pid, writePipe.getInt$(), ex.getMessage()));
                    throw new RuntimeException(ex);
                }
                finally {
                    IoUtils.closeQuietly(writePipe);
                }
            }
            Zygote.specializeAppProcess(args.mUid, args.mGid, args.mGids, args.mRuntimeFlags, rlimits, args.mMountExternal, args.mSeInfo, args.mNiceName, args.mStartChildZygote, args.mInstructionSet, args.mAppDataDir, args.mIsTopApp, args.mPkgDataInfoList, args.mAllowlistedDataInfoList, args.mBindMountAppDataDirs, args.mBindMountAppStorageDirs, args.mBindMountSyspropOverrides);
            Zygote.setAppProcessName(args, TAG);
            Trace.traceEnd(64L);
            Runnable runnable = ZygoteInit.zygoteInit(args.mTargetSdkVersion, args.mDisabledCompatChanges, args.mRemainingArgs, null);
            return runnable;
        }
        finally {
            Zygote.unblockSigTerm();
        }
    }

    private static void blockSigTerm() {
        Zygote.nativeBlockSigTerm();
    }

    private static void nativeBlockSigTerm() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeBlockSigTerm()V", true, null);
    }

    private static void unblockSigTerm() {
        Zygote.nativeUnblockSigTerm();
    }

    private static void nativeUnblockSigTerm() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeUnblockSigTerm()V", true, null);
    }

    private static void boostUsapPriority() {
        Zygote.nativeBoostUsapPriority();
    }

    private static void nativeBoostUsapPriority() {
        OverrideMethod.invokeV("com.android.internal.os.Zygote#nativeBoostUsapPriority()V", true, null);
    }

    static void setAppProcessName(ZygoteArguments args, String loggingTag) {
        if (args.mNiceName != null) {
            Process.setArgV0(args.mNiceName);
        } else if (args.mPackageName != null) {
            Process.setArgV0(args.mPackageName);
        } else {
            Log.w(loggingTag, "Unable to set package name.");
        }
    }

    private static void validateUsapCommand(ZygoteArguments args) {
        if (args.mAbiListQuery) {
            throw new IllegalArgumentException("Invalid command to USAP: --query-abi-list");
        }
        if (args.mPidQuery) {
            throw new IllegalArgumentException("Invalid command to USAP: --get-pid");
        }
        if (args.mPreloadDefault) {
            throw new IllegalArgumentException("Invalid command to USAP: --preload-default");
        }
        if (args.mPreloadApp != null) {
            throw new IllegalArgumentException("Invalid command to USAP: --preload-app");
        }
        if (args.mStartChildZygote) {
            throw new IllegalArgumentException("Invalid command to USAP: --start-child-zygote");
        }
        if (args.mApiDenylistExemptions != null) {
            throw new IllegalArgumentException("Invalid command to USAP: --set-api-denylist-exemptions");
        }
        if (args.mHiddenApiAccessLogSampleRate != -1) {
            throw new IllegalArgumentException("Invalid command to USAP: --hidden-api-log-sampling-rate=");
        }
        if (args.mHiddenApiAccessStatslogSampleRate != -1) {
            throw new IllegalArgumentException("Invalid command to USAP: --hidden-api-statslog-sampling-rate=");
        }
        if (args.mInvokeWith != null) {
            throw new IllegalArgumentException("Invalid command to USAP: --invoke-with");
        }
        if (args.mPermittedCapabilities != 0L || args.mEffectiveCapabilities != 0L) {
            throw new ZygoteSecurityException("Client may not specify capabilities: permitted=0x" + Long.toHexString(args.mPermittedCapabilities) + ", effective=0x" + Long.toHexString(args.mEffectiveCapabilities));
        }
    }

    static int[] getUsapPipeFDs() {
        return Zygote.nativeGetUsapPipeFDs();
    }

    private static int[] nativeGetUsapPipeFDs() {
        return (int[])OverrideMethod.invokeA("com.android.internal.os.Zygote#nativeGetUsapPipeFDs()[I", true, null);
    }

    static boolean removeUsapTableEntry(int usapPID) {
        return Zygote.nativeRemoveUsapTableEntry(usapPID);
    }

    @CriticalNative
    private static boolean nativeRemoveUsapTableEntry(int n) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeRemoveUsapTableEntry(I)Z", true, null) != 0;
    }

    static int minChildUid(Credentials peer) {
        if (peer.getUid() == 1000 && FactoryTest.getMode() == 0) {
            return 1000;
        }
        return 0;
    }

    static void applyUidSecurityPolicy(ZygoteArguments args, Credentials peer) throws ZygoteSecurityException {
        if (args.mUidSpecified && args.mUid < Zygote.minChildUid(peer)) {
            throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
        }
        if (!args.mUidSpecified) {
            args.mUid = peer.getUid();
            args.mUidSpecified = true;
        }
        if (!args.mGidSpecified) {
            args.mGid = peer.getGid();
            args.mGidSpecified = true;
        }
    }

    static void applyDebuggerSystemProperty(ZygoteArguments args) {
        if (_Original_Build.IS_ENG || _Original_Build.IS_USERDEBUG && ENABLE_JDWP) {
            args.mRuntimeFlags |= 1;
            args.mRuntimeFlags |= 0x2000000;
        }
        if (_Original_Build.IS_ENG || _Original_Build.IS_USERDEBUG && ENABLE_PTRACE) {
            args.mRuntimeFlags |= 0x2000000;
        }
    }

    static void applyInvokeWithSecurityPolicy(ZygoteArguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (args.mInvokeWith != null && peerUid != 0 && (args.mRuntimeFlags & 0x2000001) == 0) {
            throw new ZygoteSecurityException("Peer is permitted to specify an explicit invoke-with wrapper command only for debuggable applications.");
        }
    }

    public static String getWrapProperty(String appName) {
        if (appName == null || appName.isEmpty()) {
            return null;
        }
        String propertyValue = SystemProperties.get("wrap." + appName);
        if (propertyValue != null && !propertyValue.isEmpty()) {
            return propertyValue;
        }
        return null;
    }

    static void applyInvokeWithSystemProperty(ZygoteArguments args) {
        if (args.mInvokeWith == null) {
            args.mInvokeWith = Zygote.getWrapProperty(args.mNiceName);
        }
    }

    static LocalServerSocket createManagedSocketFromInitSocket(String socketName) {
        int fileDesc;
        String fullSocketName = ANDROID_SOCKET_PREFIX + socketName;
        try {
            String env = System.getenv(fullSocketName);
            fileDesc = Integer.parseInt(env);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Socket unset or invalid: " + fullSocketName, ex);
        }
        try {
            FileDescriptor fd = new FileDescriptor();
            fd.setInt$(fileDesc);
            return new LocalServerSocket(fd);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error building socket from file descriptor: " + fileDesc, ex);
        }
    }

    private static void callPostForkSystemServerHooks(int runtimeFlags) {
        ZygoteHooks.postForkSystemServer(runtimeFlags);
    }

    private static void callPostForkChildHooks(int runtimeFlags, boolean isSystemServer, boolean isZygote, String instructionSet) {
        ZygoteHooks.postForkChild(runtimeFlags, isSystemServer, isZygote, instructionSet);
    }

    static void execShell(String command) {
        String[] args = new String[]{"/system/bin/sh", "-c", command};
        try {
            Os.execv(args[0], args);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    static void appendQuotedShellArgs(StringBuilder command, String[] args) {
        for (String arg : args) {
            command.append(" '").append(arg.replace("'", "'\\''")).append("'");
        }
    }

    @FastNative
    public static int nativeParseSigChld(byte[] byArray, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeParseSigChld([BI[I)I", true, null);
    }

    public static boolean nativeSupportsMemoryTagging() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeSupportsMemoryTagging()Z", true, null) != 0;
    }

    public static boolean nativeSupportsTaggedPointers() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeSupportsTaggedPointers()Z", true, null) != 0;
    }

    public static int nativeCurrentTaggingLevel() {
        return OverrideMethod.invokeI("com.android.internal.os.Zygote#nativeCurrentTaggingLevel()I", true, null);
    }

    private static int memtagModeToZygoteMemtagLevel(int memtagMode) {
        switch (memtagMode) {
            case 1: {
                return 0x100000;
            }
            case 2: {
                return 0x180000;
            }
        }
        return 0;
    }

    private static boolean isCompatChangeEnabled(long change, @NonNull ApplicationInfo info, @Nullable IPlatformCompat platformCompat, int enabledAfter) {
        try {
            if (platformCompat != null) {
                return platformCompat.isChangeEnabled(change, info);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return enabledAfter > 0 && info.targetSdkVersion > enabledAfter;
    }

    private static int getRequestedMemtagLevel(@NonNull ApplicationInfo info, @Nullable ProcessInfo processInfo, @Nullable IPlatformCompat platformCompat) {
        String appOverride = SystemProperties.get("persist.arm64.memtag.app." + info.packageName);
        if ("sync".equals(appOverride)) {
            return 0x180000;
        }
        if ("async".equals(appOverride)) {
            return 0x100000;
        }
        if ("off".equals(appOverride)) {
            return 0;
        }
        if (processInfo != null && processInfo.memtagMode != -1) {
            return Zygote.memtagModeToZygoteMemtagLevel(processInfo.memtagMode);
        }
        if (info.getMemtagMode() != -1) {
            return Zygote.memtagModeToZygoteMemtagLevel(info.getMemtagMode());
        }
        if (Zygote.isCompatChangeEnabled(177438394L, info, platformCompat, 0)) {
            return 0x180000;
        }
        if (Zygote.isCompatChangeEnabled(135772972L, info, platformCompat, 0)) {
            return 0x100000;
        }
        if (!info.allowsNativeHeapPointerTagging()) {
            return 0;
        }
        String defaultLevel = SystemProperties.get("persist.arm64.memtag.app_default");
        if ("sync".equals(defaultLevel)) {
            return 0x180000;
        }
        if ("async".equals(defaultLevel)) {
            return 0x100000;
        }
        if (Zygote.isCompatChangeEnabled(135754954L, info, platformCompat, 29)) {
            return 524288;
        }
        return 0;
    }

    private static int decideTaggingLevel(@NonNull ApplicationInfo info, @Nullable ProcessInfo processInfo, @Nullable IPlatformCompat platformCompat) {
        int level = Zygote.getRequestedMemtagLevel(info, processInfo, platformCompat);
        if (Zygote.nativeSupportsMemoryTagging()) {
            if (level == 524288) {
                level = 0;
            }
        } else if (Zygote.nativeSupportsTaggedPointers()) {
            if (level == 0x100000 || level == 0x180000) {
                level = 524288;
            }
        } else {
            level = 0;
        }
        if (level == 0x100000 && (_Original_Build.IS_USERDEBUG || _Original_Build.IS_ENG) && "sync".equals(SystemProperties.get("persist.arm64.memtag.default"))) {
            level = 0x180000;
        }
        return level;
    }

    private static int decideGwpAsanLevel(@NonNull ApplicationInfo info, @Nullable ProcessInfo processInfo, @Nullable IPlatformCompat platformCompat) {
        if (processInfo != null && processInfo.gwpAsanMode != -1) {
            return processInfo.gwpAsanMode == 1 ? 0x400000 : 0;
        }
        if (info.getGwpAsanMode() != -1) {
            return info.getGwpAsanMode() == 1 ? 0x400000 : 0;
        }
        if (Zygote.isCompatChangeEnabled(135634846L, info, platformCompat, 0)) {
            return 0x400000;
        }
        if ((info.flags & 1) != 0) {
            return 0x200000;
        }
        return 0x600000;
    }

    private static boolean enableNativeHeapZeroInit(@NonNull ApplicationInfo info, @Nullable ProcessInfo processInfo, @Nullable IPlatformCompat platformCompat) {
        if (processInfo != null && processInfo.nativeHeapZeroInitialized != -1) {
            return processInfo.nativeHeapZeroInitialized == 1;
        }
        if (info.getNativeHeapZeroInitialized() != -1) {
            return info.getNativeHeapZeroInitialized() == 1;
        }
        return Zygote.isCompatChangeEnabled(178038272L, info, platformCompat, 0);
    }

    public static int getMemorySafetyRuntimeFlags(@NonNull ApplicationInfo info, @Nullable ProcessInfo processInfo, @Nullable String instructionSet, @Nullable IPlatformCompat platformCompat) {
        int runtimeFlags = Zygote.decideGwpAsanLevel(info, processInfo, platformCompat);
        if (instructionSet == null || instructionSet.equals("arm64")) {
            runtimeFlags |= Zygote.decideTaggingLevel(info, processInfo, platformCompat);
        }
        if (Zygote.enableNativeHeapZeroInit(info, processInfo, platformCompat)) {
            runtimeFlags |= 0x800000;
        }
        return runtimeFlags;
    }

    public static int getMemorySafetyRuntimeFlagsForSecondaryZygote(@NonNull ApplicationInfo info, @Nullable ProcessInfo processInfo) {
        IPlatformCompat platformCompat = IPlatformCompat.Stub.asInterface(ServiceManager.getService("platform_compat"));
        int runtimeFlags = Zygote.getMemorySafetyRuntimeFlags(info, processInfo, null, platformCompat);
        if ((runtimeFlags & 0x180000) == 524288 && Zygote.isCompatChangeEnabled(207557677L, info, platformCompat, 31)) {
            runtimeFlags &= 0xFFE7FFFF;
            runtimeFlags |= 0;
        }
        return runtimeFlags;
    }
}

