/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.parsing;

import com.android.internal.pm.parsing.pkg.AndroidPackageLegacyUtils;
import com.android.server.pm.pkg.AndroidPackage;

public class AppInfoUtils {
    public static int appInfoFlags(AndroidPackage pkg) {
        int pkgWithoutStateFlags = AppInfoUtils.flag(pkg.isExternalStorage(), 262144) | AppInfoUtils.flag(pkg.isHardwareAccelerated(), 0x20000000) | AppInfoUtils.flag(pkg.isBackupAllowed(), 32768) | AppInfoUtils.flag(pkg.isKillAfterRestoreAllowed(), 65536) | AppInfoUtils.flag(pkg.isRestoreAnyVersion(), 131072) | AppInfoUtils.flag(pkg.isFullBackupOnly(), 0x4000000) | AppInfoUtils.flag(pkg.isPersistent(), 8) | AppInfoUtils.flag(pkg.isDebuggable(), 2) | AppInfoUtils.flag(pkg.isVmSafeMode(), 16384) | AppInfoUtils.flag(pkg.isDeclaredHavingCode(), 4) | AppInfoUtils.flag(pkg.isTaskReparentingAllowed(), 32) | AppInfoUtils.flag(pkg.isClearUserDataAllowed(), 64) | AppInfoUtils.flag(pkg.isLargeHeap(), 0x100000) | AppInfoUtils.flag(pkg.isCleartextTrafficAllowed(), 0x8000000) | AppInfoUtils.flag(pkg.isRtlSupported(), 0x400000) | AppInfoUtils.flag(pkg.isTestOnly(), 256) | AppInfoUtils.flag(pkg.isMultiArch(), Integer.MIN_VALUE) | AppInfoUtils.flag(pkg.isExtractNativeLibrariesRequested(), 0x10000000) | AppInfoUtils.flag(pkg.isGame(), 0x2000000) | AppInfoUtils.flag(pkg.isSmallScreensSupported(), 512) | AppInfoUtils.flag(pkg.isNormalScreensSupported(), 1024) | AppInfoUtils.flag(pkg.isLargeScreensSupported(), 2048) | AppInfoUtils.flag(pkg.isExtraLargeScreensSupported(), 524288) | AppInfoUtils.flag(pkg.isResizeable(), 4096) | AppInfoUtils.flag(pkg.isAnyDensity(), 8192) | AppInfoUtils.flag(AndroidPackageLegacyUtils.isSystem(pkg), 1) | AppInfoUtils.flag(pkg.isFactoryTest(), 16);
        return pkgWithoutStateFlags;
    }

    public static int appInfoPrivateFlags(AndroidPackage pkg) {
        int pkgWithoutStateFlags = AppInfoUtils.flag(pkg.isStaticSharedLibrary(), 16384) | AppInfoUtils.flag(pkg.isResourceOverlay(), 0x10000000) | AppInfoUtils.flag(pkg.isIsolatedSplitLoading(), 32768) | AppInfoUtils.flag(pkg.isHasDomainUrls(), 16) | AppInfoUtils.flag(pkg.isProfileableByShell(), 0x800000) | AppInfoUtils.flag(pkg.isBackupInForeground(), 8192) | AppInfoUtils.flag(pkg.isUseEmbeddedDex(), 0x2000000) | AppInfoUtils.flag(pkg.isDefaultToDeviceProtectedStorage(), 32) | AppInfoUtils.flag(pkg.isDirectBootAware(), 64) | AppInfoUtils.flag(pkg.isPartiallyDirectBootAware(), 256) | AppInfoUtils.flag(pkg.isClearUserDataOnFailedRestoreAllowed(), 0x4000000) | AppInfoUtils.flag(pkg.isAllowAudioPlaybackCapture(), 0x8000000) | AppInfoUtils.flag(pkg.isRequestLegacyExternalStorage(), 0x20000000) | AppInfoUtils.flag(pkg.isNonSdkApiRequested(), 0x400000) | AppInfoUtils.flag(pkg.isUserDataFragile(), 0x1000000) | AppInfoUtils.flag(pkg.isSaveStateDisallowed(), 2) | AppInfoUtils.flag(pkg.isResizeableActivityViaSdkVersion(), 4096) | AppInfoUtils.flag(pkg.isAllowNativeHeapPointerTagging(), Integer.MIN_VALUE) | AppInfoUtils.flag(AndroidPackageLegacyUtils.isSystemExt(pkg), 0x200000) | AppInfoUtils.flag(AndroidPackageLegacyUtils.isPrivileged(pkg), 8) | AppInfoUtils.flag(AndroidPackageLegacyUtils.isOem(pkg), 131072) | AppInfoUtils.flag(AndroidPackageLegacyUtils.isVendor(pkg), 262144) | AppInfoUtils.flag(AndroidPackageLegacyUtils.isProduct(pkg), 524288) | AppInfoUtils.flag(AndroidPackageLegacyUtils.isOdm(pkg), 0x40000000) | AppInfoUtils.flag(pkg.isSignedWithPlatformKey(), 0x100000);
        Boolean resizeableActivity = pkg.getResizeableActivity();
        if (resizeableActivity != null) {
            pkgWithoutStateFlags = resizeableActivity.booleanValue() ? (pkgWithoutStateFlags |= 0x400) : (pkgWithoutStateFlags |= 0x800);
        }
        return pkgWithoutStateFlags;
    }

    public static int appInfoPrivateFlagsExt(AndroidPackage pkg, boolean isAllowlistedForHiddenApis) {
        int pkgWithoutStateFlags = AppInfoUtils.flag(pkg.isProfileable(), 1) | AppInfoUtils.flag(pkg.hasRequestForegroundServiceExemption(), 2) | AppInfoUtils.flag(pkg.isAttributionsUserVisible(), 4) | AppInfoUtils.flag(pkg.isOnBackInvokedCallbackEnabled(), 8) | AppInfoUtils.flag(isAllowlistedForHiddenApis, 16);
        return pkgWithoutStateFlags;
    }

    private static int flag(boolean hasFlag, int flag) {
        return hasFlag ? flag : 0;
    }
}

