/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.parsing.pkg;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.SigningDetails;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.pm.parsing.AppInfoUtils;
import com.android.internal.pm.parsing.pkg.AndroidPackageHidden;
import com.android.internal.pm.parsing.pkg.AndroidPackageInternal;
import com.android.internal.pm.parsing.pkg.ParsedPackage;
import com.android.internal.pm.pkg.AndroidPackageSplitImpl;
import com.android.internal.pm.pkg.component.ComponentMutateUtils;
import com.android.internal.pm.pkg.component.ParsedActivity;
import com.android.internal.pm.pkg.component.ParsedActivityImpl;
import com.android.internal.pm.pkg.component.ParsedApexSystemService;
import com.android.internal.pm.pkg.component.ParsedApexSystemServiceImpl;
import com.android.internal.pm.pkg.component.ParsedAttribution;
import com.android.internal.pm.pkg.component.ParsedAttributionImpl;
import com.android.internal.pm.pkg.component.ParsedComponent;
import com.android.internal.pm.pkg.component.ParsedInstrumentation;
import com.android.internal.pm.pkg.component.ParsedInstrumentationImpl;
import com.android.internal.pm.pkg.component.ParsedIntentInfo;
import com.android.internal.pm.pkg.component.ParsedMainComponent;
import com.android.internal.pm.pkg.component.ParsedPermission;
import com.android.internal.pm.pkg.component.ParsedPermissionGroup;
import com.android.internal.pm.pkg.component.ParsedPermissionGroupImpl;
import com.android.internal.pm.pkg.component.ParsedPermissionImpl;
import com.android.internal.pm.pkg.component.ParsedProcess;
import com.android.internal.pm.pkg.component.ParsedProcessImpl;
import com.android.internal.pm.pkg.component.ParsedProvider;
import com.android.internal.pm.pkg.component.ParsedProviderImpl;
import com.android.internal.pm.pkg.component.ParsedService;
import com.android.internal.pm.pkg.component.ParsedServiceImpl;
import com.android.internal.pm.pkg.component.ParsedUsesPermission;
import com.android.internal.pm.pkg.component.ParsedUsesPermissionImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageHidden;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Parcelling;
import com.android.server.pm.pkg.AndroidPackage;
import com.android.server.pm.pkg.AndroidPackageSplit;
import java.io.File;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import libcore.util.EmptyArray;

public class PackageImpl
implements ParsedPackage,
AndroidPackageInternal,
AndroidPackageHidden,
ParsingPackage,
ParsingPackageHidden,
Parcelable {
    private static final SparseArray<int[]> EMPTY_INT_ARRAY_SPARSE_ARRAY = new SparseArray();
    private static final Comparator<ParsedMainComponent> ORDER_COMPARATOR = (first, second) -> Integer.compare(second.getOrder(), first.getOrder());
    public static final Parcelling.BuiltIn.ForBoolean sForBoolean = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForBoolean.class);
    public static final Parcelling.BuiltIn.ForInternedString sForInternedString = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedString.class);
    public static final Parcelling.BuiltIn.ForInternedStringArray sForInternedStringArray = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringArray.class);
    public static final Parcelling.BuiltIn.ForInternedStringList sForInternedStringList = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringList.class);
    public static final Parcelling.BuiltIn.ForInternedStringValueMap sForInternedStringValueMap = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringValueMap.class);
    public static final Parcelling.BuiltIn.ForStringSet sForStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForStringSet.class);
    public static final Parcelling.BuiltIn.ForInternedStringSet sForInternedStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringSet.class);
    protected static final ParsingUtils.StringPairListParceler sForIntentInfoPairs = new ParsingUtils.StringPairListParceler();
    protected int versionCode;
    protected int versionCodeMajor;
    @NonNull
    protected String packageName;
    @NonNull
    protected String mBaseApkPath;
    @NonNull
    protected List<String> usesLibraries = Collections.emptyList();
    @NonNull
    protected List<String> usesOptionalLibraries = Collections.emptyList();
    @NonNull
    protected List<String> usesNativeLibraries = Collections.emptyList();
    @NonNull
    protected List<String> usesOptionalNativeLibraries = Collections.emptyList();
    @NonNull
    protected List<String> originalPackages = Collections.emptyList();
    @NonNull
    protected List<String> adoptPermissions = Collections.emptyList();
    @Deprecated
    @NonNull
    protected Set<String> requestedPermissions = Collections.emptySet();
    @NonNull
    protected List<String> protectedBroadcasts = Collections.emptyList();
    @NonNull
    protected List<ParsedActivity> activities = Collections.emptyList();
    @NonNull
    protected List<ParsedApexSystemService> apexSystemServices = Collections.emptyList();
    @NonNull
    protected List<ParsedActivity> receivers = Collections.emptyList();
    @NonNull
    protected List<ParsedService> services = Collections.emptyList();
    @NonNull
    protected List<ParsedProvider> providers = Collections.emptyList();
    @NonNull
    protected List<ParsedPermission> permissions = Collections.emptyList();
    @NonNull
    protected List<ParsedPermissionGroup> permissionGroups = Collections.emptyList();
    @NonNull
    protected List<ParsedInstrumentation> instrumentations = Collections.emptyList();
    @Nullable
    protected String volumeUuid;
    @NonNull
    protected String mPath;
    @Nullable
    protected String[] splitCodePaths;
    @NonNull
    protected UUID mStorageUuid;
    @Nullable
    private Boolean supportsSmallScreens;
    @Nullable
    private Boolean supportsNormalScreens;
    @Nullable
    private Boolean supportsLargeScreens;
    @Nullable
    private Boolean supportsExtraLargeScreens;
    @Nullable
    private Boolean resizeable;
    @Nullable
    private Boolean anyDensity;
    private int baseRevisionCode;
    @Nullable
    private String versionName;
    private int compileSdkVersion;
    @Nullable
    private String compileSdkVersionCodeName;
    @Nullable
    private String restrictedAccountType;
    @Nullable
    private String requiredAccountType;
    @Nullable
    private String mEmergencyInstaller;
    @Nullable
    private String overlayTarget;
    @Nullable
    private String overlayTargetOverlayableName;
    @Nullable
    private String overlayCategory;
    private int overlayPriority;
    @NonNull
    private Map<String, String> overlayables = Collections.emptyMap();
    @Nullable
    private String sdkLibraryName;
    private int sdkLibVersionMajor;
    @Nullable
    private String staticSharedLibraryName;
    private long staticSharedLibVersion;
    @NonNull
    private List<String> libraryNames = Collections.emptyList();
    @NonNull
    private List<String> usesStaticLibraries = Collections.emptyList();
    @Nullable
    private long[] usesStaticLibrariesVersions;
    @Nullable
    private String[][] usesStaticLibrariesCertDigests;
    @NonNull
    private List<String> usesSdkLibraries = Collections.emptyList();
    @Nullable
    private long[] usesSdkLibrariesVersionsMajor;
    @Nullable
    private String[][] usesSdkLibrariesCertDigests;
    @Nullable
    private boolean[] usesSdkLibrariesOptional;
    @Nullable
    private String sharedUserId;
    private int sharedUserLabel;
    @NonNull
    private List<ConfigurationInfo> configPreferences = Collections.emptyList();
    @NonNull
    private List<FeatureInfo> reqFeatures = Collections.emptyList();
    @NonNull
    private List<FeatureGroupInfo> featureGroups = Collections.emptyList();
    @Nullable
    private byte[] restrictUpdateHash;
    @NonNull
    private List<ParsedUsesPermission> usesPermissions = Collections.emptyList();
    @NonNull
    private Set<String> implicitPermissions = Collections.emptySet();
    @NonNull
    private Set<String> upgradeKeySets = Collections.emptySet();
    @NonNull
    private Map<String, ArraySet<PublicKey>> keySetMapping = Collections.emptyMap();
    @NonNull
    private List<ParsedAttribution> attributions = Collections.emptyList();
    @NonNull
    private List<Pair<String, ParsedIntentInfo>> preferredActivityFilters = Collections.emptyList();
    @NonNull
    private Map<String, ParsedProcess> processes = Collections.emptyMap();
    @Nullable
    private Bundle metaData;
    @NonNull
    private Map<String, PackageManager.Property> mProperties = Collections.emptyMap();
    @NonNull
    private SigningDetails signingDetails = SigningDetails.UNKNOWN;
    @NonNull
    private List<Intent> queriesIntents = Collections.emptyList();
    @NonNull
    private List<String> queriesPackages = Collections.emptyList();
    @NonNull
    private Set<String> queriesProviders = Collections.emptySet();
    @Nullable
    private String[] splitClassLoaderNames;
    @Nullable
    private SparseArray<int[]> splitDependencies;
    @Nullable
    private int[] splitFlags;
    @Nullable
    private String[] splitNames;
    @Nullable
    private int[] splitRevisionCodes;
    @Nullable
    private String appComponentFactory;
    @Nullable
    private String backupAgentName;
    private int banner;
    private int category = -1;
    @Nullable
    private String classLoaderName;
    @Nullable
    private String className;
    private int compatibleWidthLimitDp;
    private int descriptionRes;
    private int fullBackupContent;
    private int dataExtractionRules;
    private int iconRes;
    private int installLocation = -1;
    private int labelRes;
    private int largestWidthLimitDp;
    private int logo;
    @Nullable
    private String manageSpaceActivityName;
    private float maxAspectRatio;
    private float minAspectRatio;
    @Nullable
    private SparseIntArray minExtensionVersions;
    private int minSdkVersion = 1;
    private int maxSdkVersion = Integer.MAX_VALUE;
    private int networkSecurityConfigRes;
    @Nullable
    private CharSequence nonLocalizedLabel;
    @Nullable
    private String permission;
    @Nullable
    private String processName;
    private int requiresSmallestWidthDp;
    private int roundIconRes;
    private int targetSandboxVersion;
    private int targetSdkVersion = 0;
    @Nullable
    private String taskAffinity;
    private int theme;
    private int uiOptions;
    @Nullable
    private String zygotePreloadName;
    @Nullable
    private Boolean resizeableActivity;
    private int autoRevokePermissions;
    private int gwpAsanMode;
    private int memtagMode;
    private int nativeHeapZeroInitialized;
    private int mPageSizeAppCompatFlags = 0;
    @Nullable
    private Boolean requestRawExternalStorageAccess;
    @NonNull
    private Set<String> mimeGroups = Collections.emptySet();
    private long mBooleans = 0x100000000000L;
    private long mBooleans2 = 4L;
    @NonNull
    private Set<String> mKnownActivityEmbeddingCerts = Collections.emptySet();
    private long mLongVersionCode;
    private int mLocaleConfigRes;
    private boolean mAllowCrossUidActivitySwitchFromBelow;
    @Nullable
    private int[] mAlternateLauncherIconResIds;
    @Nullable
    private int[] mAlternateLauncherLabelResIds;
    private List<AndroidPackageSplit> mSplits;
    @NonNull
    private String[] mUsesLibrariesSorted;
    @NonNull
    private String[] mUsesOptionalLibrariesSorted;
    @NonNull
    private String[] mUsesSdkLibrariesSorted;
    @NonNull
    private String[] mUsesStaticLibrariesSorted;
    private Map<String, Boolean> mFeatureFlagState = new ArrayMap<String, Boolean>();
    private int mIntentMatchingFlags;
    @NonNull
    private final String manifestPackageName;
    @Nullable
    protected String nativeLibraryDir;
    @Nullable
    protected String nativeLibraryRootDir;
    @Nullable
    protected String primaryCpuAbi;
    @Nullable
    protected String secondaryCpuAbi;
    @Nullable
    protected String secondaryNativeLibraryDir;
    private int uid = -1;
    private boolean nativeLibraryRootRequiresIsa;
    private int mBaseAppInfoFlags;
    private int mBaseAppInfoPrivateFlags;
    private int mBaseAppInfoPrivateFlagsExt;
    private String mBaseAppDataCredentialProtectedDirForSystemUser;
    private String mBaseAppDataDeviceProtectedDirForSystemUser;
    ParsingPackageUtils.Callback mCallback;
    @NonNull
    public static final Parcelable.Creator<PackageImpl> CREATOR = new Parcelable.Creator<PackageImpl>(){

        @Override
        public PackageImpl createFromParcel(Parcel source) {
            return new PackageImpl(source);
        }

        public PackageImpl[] newArray(int size) {
            return new PackageImpl[size];
        }
    };

    @NonNull
    public static PackageImpl forParsing(@NonNull String packageName, @NonNull String baseCodePath, @NonNull String codePath, @NonNull TypedArray manifestArray, boolean isCoreApp, @Nullable ParsingPackageUtils.Callback callback) {
        return new PackageImpl(packageName, baseCodePath, codePath, manifestArray, isCoreApp, callback);
    }

    @NonNull
    public static AndroidPackage buildFakeForDeletion(String packageName, String volumeUuid) {
        return PackageImpl.forTesting(packageName).setVolumeUuid(volumeUuid).hideAsParsed().hideAsFinal();
    }

    @NonNull
    @VisibleForTesting
    public static ParsingPackage forTesting(String packageName) {
        return PackageImpl.forTesting(packageName, "");
    }

    @NonNull
    @VisibleForTesting
    public static ParsingPackage forTesting(String packageName, String baseCodePath) {
        return new PackageImpl(packageName, baseCodePath, baseCodePath, null, false, null);
    }

    @Override
    public PackageImpl addActivity(ParsedActivity parsedActivity) {
        this.activities = CollectionUtils.add(this.activities, parsedActivity);
        this.addMimeGroupsFromComponent(parsedActivity);
        return this;
    }

    @Override
    public PackageImpl addAdoptPermission(String adoptPermission) {
        this.adoptPermissions = CollectionUtils.add(this.adoptPermissions, TextUtils.safeIntern(adoptPermission));
        return this;
    }

    @Override
    public PackageImpl addApexSystemService(ParsedApexSystemService parsedApexSystemService) {
        this.apexSystemServices = CollectionUtils.add(this.apexSystemServices, parsedApexSystemService);
        return this;
    }

    @Override
    public PackageImpl addAttribution(ParsedAttribution attribution) {
        this.attributions = CollectionUtils.add(this.attributions, attribution);
        return this;
    }

    @Override
    public PackageImpl addConfigPreference(ConfigurationInfo configPreference) {
        this.configPreferences = CollectionUtils.add(this.configPreferences, configPreference);
        return this;
    }

    @Override
    public PackageImpl addFeatureGroup(FeatureGroupInfo featureGroup) {
        this.featureGroups = CollectionUtils.add(this.featureGroups, featureGroup);
        return this;
    }

    @Override
    public PackageImpl addImplicitPermission(String permission2) {
        this.addUsesPermission(new ParsedUsesPermissionImpl(permission2, 0));
        this.implicitPermissions = CollectionUtils.add(this.implicitPermissions, TextUtils.safeIntern(permission2));
        return this;
    }

    @Override
    public PackageImpl addInstrumentation(ParsedInstrumentation instrumentation) {
        this.instrumentations = CollectionUtils.add(this.instrumentations, instrumentation);
        return this;
    }

    @Override
    public PackageImpl addKeySet(String keySetName, PublicKey publicKey) {
        ArraySet<PublicKey> publicKeys = this.keySetMapping.get(keySetName);
        if (publicKeys == null) {
            publicKeys = new ArraySet();
        }
        publicKeys.add(publicKey);
        this.keySetMapping = CollectionUtils.add(this.keySetMapping, keySetName, publicKeys);
        return this;
    }

    @Override
    public PackageImpl addLibraryName(String libraryName) {
        this.libraryNames = CollectionUtils.add(this.libraryNames, TextUtils.safeIntern(libraryName));
        return this;
    }

    private void addMimeGroupsFromComponent(ParsedComponent component) {
        for (int i = component.getIntents().size() - 1; i >= 0; --i) {
            IntentFilter filter = component.getIntents().get(i).getIntentFilter();
            for (int groupIndex = filter.countMimeGroups() - 1; groupIndex >= 0; --groupIndex) {
                if (this.mimeGroups != null && this.mimeGroups.size() > 500) {
                    throw new IllegalStateException("Max limit on number of MIME Groups reached");
                }
                this.mimeGroups = CollectionUtils.add(this.mimeGroups, filter.getMimeGroup(groupIndex));
            }
        }
    }

    @Override
    public PackageImpl addOriginalPackage(String originalPackage) {
        this.originalPackages = CollectionUtils.add(this.originalPackages, originalPackage);
        return this;
    }

    @Override
    public ParsingPackage addOverlayable(String overlayableName, String actorName) {
        this.overlayables = CollectionUtils.add(this.overlayables, overlayableName, TextUtils.safeIntern(actorName));
        return this;
    }

    @Override
    public PackageImpl addPermission(ParsedPermission permission2) {
        this.permissions = CollectionUtils.add(this.permissions, permission2);
        return this;
    }

    @Override
    public PackageImpl addPermissionGroup(ParsedPermissionGroup permissionGroup) {
        this.permissionGroups = CollectionUtils.add(this.permissionGroups, permissionGroup);
        return this;
    }

    @Override
    public PackageImpl addPreferredActivityFilter(String className, ParsedIntentInfo intentInfo) {
        this.preferredActivityFilters = CollectionUtils.add(this.preferredActivityFilters, Pair.create(className, intentInfo));
        return this;
    }

    @Override
    public PackageImpl addProperty(@Nullable PackageManager.Property property) {
        if (property == null) {
            return this;
        }
        this.mProperties = CollectionUtils.add(this.mProperties, property.getName(), property);
        return this;
    }

    @Override
    public PackageImpl addProtectedBroadcast(String protectedBroadcast) {
        if (!this.protectedBroadcasts.contains(protectedBroadcast)) {
            this.protectedBroadcasts = CollectionUtils.add(this.protectedBroadcasts, TextUtils.safeIntern(protectedBroadcast));
        }
        return this;
    }

    @Override
    public PackageImpl addProvider(ParsedProvider parsedProvider) {
        this.providers = CollectionUtils.add(this.providers, parsedProvider);
        this.addMimeGroupsFromComponent(parsedProvider);
        return this;
    }

    @Override
    public PackageImpl addQueriesIntent(Intent intent) {
        this.queriesIntents = CollectionUtils.add(this.queriesIntents, intent);
        return this;
    }

    @Override
    public PackageImpl addQueriesPackage(String packageName) {
        this.queriesPackages = CollectionUtils.add(this.queriesPackages, TextUtils.safeIntern(packageName));
        return this;
    }

    @Override
    public PackageImpl addQueriesProvider(String authority) {
        this.queriesProviders = CollectionUtils.add(this.queriesProviders, authority);
        return this;
    }

    @Override
    public PackageImpl addReceiver(ParsedActivity parsedReceiver) {
        this.receivers = CollectionUtils.add(this.receivers, parsedReceiver);
        this.addMimeGroupsFromComponent(parsedReceiver);
        return this;
    }

    @Override
    public PackageImpl addReqFeature(FeatureInfo reqFeature) {
        this.reqFeatures = CollectionUtils.add(this.reqFeatures, reqFeature);
        return this;
    }

    @Override
    public PackageImpl addService(ParsedService parsedService) {
        this.services = CollectionUtils.add(this.services, parsedService);
        this.addMimeGroupsFromComponent(parsedService);
        return this;
    }

    @Override
    public PackageImpl addUsesLibrary(String libraryName) {
        if (!ArrayUtils.contains(this.usesLibraries, libraryName = TextUtils.safeIntern(libraryName))) {
            this.usesLibraries = CollectionUtils.add(this.usesLibraries, libraryName);
        }
        return this;
    }

    @Override
    public PackageImpl addUsesNativeLibrary(String libraryName) {
        if (!ArrayUtils.contains(this.usesNativeLibraries, libraryName = TextUtils.safeIntern(libraryName))) {
            this.usesNativeLibraries = CollectionUtils.add(this.usesNativeLibraries, libraryName);
        }
        return this;
    }

    @Override
    public PackageImpl addUsesOptionalLibrary(String libraryName) {
        if (!ArrayUtils.contains(this.usesOptionalLibraries, libraryName = TextUtils.safeIntern(libraryName))) {
            this.usesOptionalLibraries = CollectionUtils.add(this.usesOptionalLibraries, libraryName);
        }
        return this;
    }

    @Override
    public PackageImpl addUsesOptionalNativeLibrary(String libraryName) {
        if (!ArrayUtils.contains(this.usesOptionalNativeLibraries, libraryName = TextUtils.safeIntern(libraryName))) {
            this.usesOptionalNativeLibraries = CollectionUtils.add(this.usesOptionalNativeLibraries, libraryName);
        }
        return this;
    }

    @Override
    public PackageImpl addUsesPermission(ParsedUsesPermission permission2) {
        this.usesPermissions = CollectionUtils.add(this.usesPermissions, permission2);
        this.requestedPermissions = CollectionUtils.add(this.requestedPermissions, permission2.getName());
        return this;
    }

    @Override
    public PackageImpl addUsesSdkLibrary(String libraryName, long versionMajor, String[] certSha256Digests, boolean usesSdkLibrariesOptional) {
        this.usesSdkLibraries = CollectionUtils.add(this.usesSdkLibraries, TextUtils.safeIntern(libraryName));
        this.usesSdkLibrariesVersionsMajor = ArrayUtils.appendLong(this.usesSdkLibrariesVersionsMajor, versionMajor, true);
        this.usesSdkLibrariesCertDigests = ArrayUtils.appendElement(String[].class, this.usesSdkLibrariesCertDigests, certSha256Digests, true);
        this.usesSdkLibrariesOptional = ArrayUtils.appendBooleanDuplicatesAllowed(this.usesSdkLibrariesOptional, usesSdkLibrariesOptional);
        return this;
    }

    @Override
    public PackageImpl addUsesStaticLibrary(String libraryName, long version, String[] certSha256Digests) {
        this.usesStaticLibraries = CollectionUtils.add(this.usesStaticLibraries, TextUtils.safeIntern(libraryName));
        this.usesStaticLibrariesVersions = ArrayUtils.appendLong(this.usesStaticLibrariesVersions, version, true);
        this.usesStaticLibrariesCertDigests = ArrayUtils.appendElement(String[].class, this.usesStaticLibrariesCertDigests, certSha256Digests, true);
        return this;
    }

    @Override
    public boolean isAttributionsUserVisible() {
        return this.getBoolean(0x800000000000L);
    }

    @Override
    public PackageImpl asSplit(String[] splitNames, String[] splitCodePaths, int[] splitRevisionCodes, SparseArray<int[]> splitDependencies) {
        this.splitNames = splitNames;
        this.splitCodePaths = splitCodePaths;
        this.splitRevisionCodes = splitRevisionCodes;
        this.splitDependencies = splitDependencies;
        int count = splitNames.length;
        this.splitFlags = new int[count];
        this.splitClassLoaderNames = new String[count];
        return this;
    }

    protected void assignDerivedFields() {
        this.mStorageUuid = StorageManager.convert(this.volumeUuid);
        this.mLongVersionCode = PackageInfo.composeLongVersionCode(this.versionCodeMajor, this.versionCode);
    }

    @Nullable
    private ArrayMap<String, String> buildAppClassNamesByProcess() {
        if (ArrayUtils.size(this.processes) == 0) {
            return null;
        }
        ArrayMap<String, String> ret = new ArrayMap<String, String>(4);
        for (String processName : this.processes.keySet()) {
            ParsedProcess process = this.processes.get(processName);
            ArrayMap<String, String> appClassesByPackage = process.getAppClassNamesByPackage();
            for (int i = 0; i < appClassesByPackage.size(); ++i) {
                String appClassName;
                String packageName = appClassesByPackage.keyAt(i);
                if (!this.packageName.equals(packageName) || TextUtils.isEmpty(appClassName = appClassesByPackage.valueAt(i))) continue;
                ret.put(processName, appClassName);
            }
        }
        return ret;
    }

    @Override
    public List<AndroidPackageSplit> getSplits() {
        if (this.mSplits == null) {
            int index;
            ArrayList<AndroidPackageSplitImpl> splits = new ArrayList<AndroidPackageSplitImpl>();
            splits.add(new AndroidPackageSplitImpl(null, this.getBaseApkPath(), this.getBaseRevisionCode(), this.isDeclaredHavingCode() ? 4 : 0, this.getClassLoaderName()));
            if (this.splitNames != null) {
                for (index = 0; index < this.splitNames.length; ++index) {
                    splits.add(new AndroidPackageSplitImpl(this.splitNames[index], this.splitCodePaths[index], this.splitRevisionCodes[index], this.splitFlags[index], this.splitClassLoaderNames[index]));
                }
            }
            if (this.splitDependencies != null) {
                for (index = 0; index < this.splitDependencies.size(); ++index) {
                    int splitIndex = this.splitDependencies.keyAt(index);
                    int[] dependenciesByIndex = this.splitDependencies.valueAt(index);
                    ArrayList<AndroidPackageSplit> dependencies = new ArrayList<AndroidPackageSplit>();
                    for (int dependencyIndex : dependenciesByIndex) {
                        if (dependencyIndex < 0) continue;
                        dependencies.add((AndroidPackageSplit)splits.get(dependencyIndex));
                    }
                    ((AndroidPackageSplitImpl)splits.get(splitIndex)).fillDependencies(Collections.unmodifiableList(dependencies));
                }
            }
            this.mSplits = Collections.unmodifiableList(splits);
        }
        return this.mSplits;
    }

    public String toString() {
        return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    @Override
    @NonNull
    public List<ParsedActivity> getActivities() {
        return this.activities;
    }

    @Override
    @NonNull
    public List<String> getAdoptPermissions() {
        return this.adoptPermissions;
    }

    @Override
    @Nullable
    public int[] getAlternateLauncherIconResIds() {
        return this.mAlternateLauncherIconResIds;
    }

    @Override
    @Nullable
    public int[] getAlternateLauncherLabelResIds() {
        return this.mAlternateLauncherLabelResIds;
    }

    @Override
    @NonNull
    public List<ParsedApexSystemService> getApexSystemServices() {
        return this.apexSystemServices;
    }

    @Override
    @Nullable
    public String getAppComponentFactory() {
        return this.appComponentFactory;
    }

    @Override
    @NonNull
    public List<ParsedAttribution> getAttributions() {
        return this.attributions;
    }

    @Override
    public int getAutoRevokePermissions() {
        return this.autoRevokePermissions;
    }

    @Override
    @Nullable
    public String getBackupAgentName() {
        return this.backupAgentName;
    }

    @Override
    public int getBannerResourceId() {
        return this.banner;
    }

    @Override
    @NonNull
    public String getBaseApkPath() {
        return this.mBaseApkPath;
    }

    @Override
    public int getBaseRevisionCode() {
        return this.baseRevisionCode;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    @Nullable
    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    @Override
    @Nullable
    public String getApplicationClassName() {
        return this.className;
    }

    @Override
    public int getCompatibleWidthLimitDp() {
        return this.compatibleWidthLimitDp;
    }

    @Override
    public int getCompileSdkVersion() {
        return this.compileSdkVersion;
    }

    @Override
    @Nullable
    public String getCompileSdkVersionCodeName() {
        return this.compileSdkVersionCodeName;
    }

    @Override
    @NonNull
    public List<ConfigurationInfo> getConfigPreferences() {
        return this.configPreferences;
    }

    @Override
    public int getDataExtractionRulesResourceId() {
        return this.dataExtractionRules;
    }

    @Override
    public int getDescriptionResourceId() {
        return this.descriptionRes;
    }

    @Override
    @NonNull
    public List<FeatureGroupInfo> getFeatureGroups() {
        return this.featureGroups;
    }

    @Override
    public int getFullBackupContentResourceId() {
        return this.fullBackupContent;
    }

    @Override
    public int getGwpAsanMode() {
        return this.gwpAsanMode;
    }

    @Override
    public int getIconResourceId() {
        return this.iconRes;
    }

    @Override
    @NonNull
    public Set<String> getImplicitPermissions() {
        return this.implicitPermissions;
    }

    @Override
    public int getInstallLocation() {
        return this.installLocation;
    }

    @Override
    @NonNull
    public List<ParsedInstrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    @Override
    @NonNull
    public Map<String, ArraySet<PublicKey>> getKeySetMapping() {
        return this.keySetMapping;
    }

    @Override
    @NonNull
    public Set<String> getKnownActivityEmbeddingCerts() {
        return this.mKnownActivityEmbeddingCerts;
    }

    @Override
    public int getLabelResourceId() {
        return this.labelRes;
    }

    @Override
    public int getLargestWidthLimitDp() {
        return this.largestWidthLimitDp;
    }

    @Override
    @NonNull
    public List<String> getLibraryNames() {
        return this.libraryNames;
    }

    @Override
    public int getLocaleConfigResourceId() {
        return this.mLocaleConfigRes;
    }

    @Override
    public int getLogoResourceId() {
        return this.logo;
    }

    @Override
    @Nullable
    public String getManageSpaceActivityName() {
        return this.manageSpaceActivityName;
    }

    @Override
    public float getMaxAspectRatio() {
        return this.maxAspectRatio;
    }

    @Override
    public int getMaxSdkVersion() {
        return this.maxSdkVersion;
    }

    @Override
    public int getMemtagMode() {
        return this.memtagMode;
    }

    @Override
    @Nullable
    public Bundle getMetaData() {
        return this.metaData;
    }

    @Override
    @Nullable
    public Set<String> getMimeGroups() {
        return this.mimeGroups;
    }

    @Override
    public float getMinAspectRatio() {
        return this.minAspectRatio;
    }

    @Override
    @Nullable
    public SparseIntArray getMinExtensionVersions() {
        return this.minExtensionVersions;
    }

    @Override
    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    @Override
    public int getNativeHeapZeroInitialized() {
        return this.nativeHeapZeroInitialized;
    }

    @Override
    public int getPageSizeAppCompatFlags() {
        return this.mPageSizeAppCompatFlags;
    }

    @Override
    public int getNetworkSecurityConfigResourceId() {
        return this.networkSecurityConfigRes;
    }

    @Override
    @Nullable
    public CharSequence getNonLocalizedLabel() {
        return this.nonLocalizedLabel;
    }

    @Override
    @NonNull
    public List<String> getOriginalPackages() {
        return this.originalPackages;
    }

    @Override
    @Nullable
    public String getOverlayCategory() {
        return this.overlayCategory;
    }

    @Override
    public int getOverlayPriority() {
        return this.overlayPriority;
    }

    @Override
    @Nullable
    public String getOverlayTarget() {
        return this.overlayTarget;
    }

    @Override
    @Nullable
    public String getOverlayTargetOverlayableName() {
        return this.overlayTargetOverlayableName;
    }

    @Override
    @NonNull
    public Map<String, String> getOverlayables() {
        return this.overlayables;
    }

    @Override
    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.mPath;
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @Override
    @NonNull
    public List<ParsedPermissionGroup> getPermissionGroups() {
        return this.permissionGroups;
    }

    @Override
    @NonNull
    public List<ParsedPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    @NonNull
    public List<Pair<String, ParsedIntentInfo>> getPreferredActivityFilters() {
        return this.preferredActivityFilters;
    }

    @Override
    @NonNull
    public String getProcessName() {
        return this.processName != null ? this.processName : this.packageName;
    }

    @Override
    @NonNull
    public Map<String, ParsedProcess> getProcesses() {
        return this.processes;
    }

    @Override
    @NonNull
    public Map<String, PackageManager.Property> getProperties() {
        return this.mProperties;
    }

    @Override
    @NonNull
    public List<String> getProtectedBroadcasts() {
        return this.protectedBroadcasts;
    }

    @Override
    @NonNull
    public List<ParsedProvider> getProviders() {
        return this.providers;
    }

    @Override
    @NonNull
    public List<Intent> getQueriesIntents() {
        return this.queriesIntents;
    }

    @Override
    @NonNull
    public List<String> getQueriesPackages() {
        return this.queriesPackages;
    }

    @Override
    @NonNull
    public Set<String> getQueriesProviders() {
        return this.queriesProviders;
    }

    @Override
    @NonNull
    public List<ParsedActivity> getReceivers() {
        return this.receivers;
    }

    @Override
    @NonNull
    public List<FeatureInfo> getRequestedFeatures() {
        return this.reqFeatures;
    }

    @Override
    @Deprecated
    @NonNull
    public Set<String> getRequestedPermissions() {
        return this.requestedPermissions;
    }

    @Override
    @Nullable
    public String getRequiredAccountType() {
        return this.requiredAccountType;
    }

    @Override
    public int getRequiresSmallestWidthDp() {
        return this.requiresSmallestWidthDp;
    }

    @Override
    @Nullable
    public Boolean getResizeableActivity() {
        return this.resizeableActivity;
    }

    @Override
    @Nullable
    public byte[] getRestrictUpdateHash() {
        return this.restrictUpdateHash;
    }

    @Override
    @Nullable
    public String getRestrictedAccountType() {
        return this.restrictedAccountType;
    }

    @Override
    @Nullable
    public String getEmergencyInstaller() {
        return this.mEmergencyInstaller;
    }

    @Override
    public int getRoundIconResourceId() {
        return this.roundIconRes;
    }

    @Override
    @Nullable
    public String getSdkLibraryName() {
        return this.sdkLibraryName;
    }

    @Override
    public int getSdkLibVersionMajor() {
        return this.sdkLibVersionMajor;
    }

    @Override
    @NonNull
    public List<ParsedService> getServices() {
        return this.services;
    }

    @Override
    @Nullable
    public String getSharedUserId() {
        return this.sharedUserId;
    }

    @Override
    public int getSharedUserLabelResourceId() {
        return this.sharedUserLabel;
    }

    @Override
    @NonNull
    public SigningDetails getSigningDetails() {
        return this.signingDetails;
    }

    @Override
    @NonNull
    public String[] getSplitClassLoaderNames() {
        return this.splitClassLoaderNames == null ? EmptyArray.STRING : this.splitClassLoaderNames;
    }

    @Override
    @NonNull
    public String[] getSplitCodePaths() {
        return this.splitCodePaths == null ? EmptyArray.STRING : this.splitCodePaths;
    }

    @Override
    @Nullable
    public SparseArray<int[]> getSplitDependencies() {
        return this.splitDependencies == null ? EMPTY_INT_ARRAY_SPARSE_ARRAY : this.splitDependencies;
    }

    @Override
    @Nullable
    public int[] getSplitFlags() {
        return this.splitFlags;
    }

    @Override
    @NonNull
    public String[] getSplitNames() {
        return this.splitNames == null ? EmptyArray.STRING : this.splitNames;
    }

    @Override
    @NonNull
    public int[] getSplitRevisionCodes() {
        return this.splitRevisionCodes == null ? EmptyArray.INT : this.splitRevisionCodes;
    }

    @Override
    @Nullable
    public String getStaticSharedLibraryName() {
        return this.staticSharedLibraryName;
    }

    @Override
    public long getStaticSharedLibraryVersion() {
        return this.staticSharedLibVersion;
    }

    @Override
    public UUID getStorageUuid() {
        return this.mStorageUuid;
    }

    @Override
    public int getTargetSandboxVersion() {
        return this.targetSandboxVersion;
    }

    @Override
    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    @Override
    @Nullable
    public String getTaskAffinity() {
        return this.taskAffinity;
    }

    @Override
    public int getThemeResourceId() {
        return this.theme;
    }

    @Override
    public int getUiOptions() {
        return this.uiOptions;
    }

    @Override
    @NonNull
    public Set<String> getUpgradeKeySets() {
        return this.upgradeKeySets;
    }

    @Override
    @NonNull
    public List<String> getUsesLibraries() {
        return this.usesLibraries;
    }

    @Override
    @NonNull
    public String[] getUsesLibrariesSorted() {
        if (this.mUsesLibrariesSorted == null) {
            this.mUsesLibrariesSorted = PackageImpl.sortLibraries(this.usesLibraries);
        }
        return this.mUsesLibrariesSorted;
    }

    @Override
    @NonNull
    public List<String> getUsesNativeLibraries() {
        return this.usesNativeLibraries;
    }

    @Override
    @NonNull
    public List<String> getUsesOptionalLibraries() {
        return this.usesOptionalLibraries;
    }

    @Override
    @NonNull
    public String[] getUsesOptionalLibrariesSorted() {
        if (this.mUsesOptionalLibrariesSorted == null) {
            this.mUsesOptionalLibrariesSorted = PackageImpl.sortLibraries(this.usesOptionalLibraries);
        }
        return this.mUsesOptionalLibrariesSorted;
    }

    @Override
    @NonNull
    public List<String> getUsesOptionalNativeLibraries() {
        return this.usesOptionalNativeLibraries;
    }

    @Override
    @NonNull
    public List<ParsedUsesPermission> getUsesPermissions() {
        return this.usesPermissions;
    }

    @Override
    @NonNull
    public List<String> getUsesSdkLibraries() {
        return this.usesSdkLibraries;
    }

    @Override
    @NonNull
    public String[] getUsesSdkLibrariesSorted() {
        if (this.mUsesSdkLibrariesSorted == null) {
            this.mUsesSdkLibrariesSorted = PackageImpl.sortLibraries(this.usesSdkLibraries);
        }
        return this.mUsesSdkLibrariesSorted;
    }

    @Override
    @Nullable
    public String[][] getUsesSdkLibrariesCertDigests() {
        return this.usesSdkLibrariesCertDigests;
    }

    @Override
    @Nullable
    public long[] getUsesSdkLibrariesVersionsMajor() {
        return this.usesSdkLibrariesVersionsMajor;
    }

    @Override
    @Nullable
    public boolean[] getUsesSdkLibrariesOptional() {
        return this.usesSdkLibrariesOptional;
    }

    @Override
    @NonNull
    public List<String> getUsesStaticLibraries() {
        return this.usesStaticLibraries;
    }

    @Override
    @NonNull
    public String[] getUsesStaticLibrariesSorted() {
        if (this.mUsesStaticLibrariesSorted == null) {
            this.mUsesStaticLibrariesSorted = PackageImpl.sortLibraries(this.usesStaticLibraries);
        }
        return this.mUsesStaticLibrariesSorted;
    }

    @Override
    @Nullable
    public String[][] getUsesStaticLibrariesCertDigests() {
        return this.usesStaticLibrariesCertDigests;
    }

    @Override
    @Nullable
    public long[] getUsesStaticLibrariesVersions() {
        return this.usesStaticLibrariesVersions;
    }

    @Override
    public int getVersionCode() {
        return this.versionCode;
    }

    @Override
    public int getVersionCodeMajor() {
        return this.versionCodeMajor;
    }

    @Override
    @Nullable
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    @Nullable
    public String getVolumeUuid() {
        return this.volumeUuid;
    }

    @Override
    @Nullable
    public String getZygotePreloadName() {
        return this.zygotePreloadName;
    }

    @Override
    public boolean isAllowCrossUidActivitySwitchFromBelow() {
        return this.mAllowCrossUidActivitySwitchFromBelow;
    }

    @Override
    public boolean hasPreserveLegacyExternalStorage() {
        return this.getBoolean(0x2000000000L);
    }

    @Override
    public boolean hasRequestForegroundServiceExemption() {
        return this.getBoolean(0x400000000000L);
    }

    @Override
    @Nullable
    public Boolean hasRequestRawExternalStorageAccess() {
        return this.requestRawExternalStorageAccess;
    }

    @Override
    public boolean isAllowAudioPlaybackCapture() {
        return this.getBoolean(0x80000000L);
    }

    @Override
    public boolean isBackupAllowed() {
        return this.getBoolean(4L);
    }

    @Override
    public boolean isClearUserDataAllowed() {
        return this.getBoolean(2048L);
    }

    @Override
    public boolean isClearUserDataOnFailedRestoreAllowed() {
        return this.getBoolean(0x40000000L);
    }

    @Override
    public boolean isAllowNativeHeapPointerTagging() {
        return this.getBoolean(0x1000000000L);
    }

    @Override
    public boolean isTaskReparentingAllowed() {
        return this.getBoolean(1024L);
    }

    @Override
    public boolean isAnyDensity() {
        if (this.anyDensity == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.anyDensity;
    }

    @Override
    public boolean isBackupInForeground() {
        return this.getBoolean(0x1000000L);
    }

    @Override
    public boolean isHardwareAccelerated() {
        return this.getBoolean(2L);
    }

    @Override
    public boolean isSaveStateDisallowed() {
        return this.getBoolean(0x800000000L);
    }

    @Override
    public boolean isCrossProfile() {
        return this.getBoolean(0x80000000000L);
    }

    @Override
    public boolean isDebuggable() {
        return this.getBoolean(128L);
    }

    @Override
    public boolean isDefaultToDeviceProtectedStorage() {
        return this.getBoolean(0x4000000L);
    }

    @Override
    public boolean isDirectBootAware() {
        return this.getBoolean(0x8000000L);
    }

    @Override
    public boolean isEnabled() {
        return this.getBoolean(0x100000000000L);
    }

    @Override
    public boolean isExternalStorage() {
        return this.getBoolean(1L);
    }

    @Override
    public boolean isExtractNativeLibrariesRequested() {
        return this.getBoolean(131072L);
    }

    @Override
    public boolean isForceQueryable() {
        return this.getBoolean(0x40000000000L);
    }

    @Override
    public boolean isFullBackupOnly() {
        return this.getBoolean(32L);
    }

    @Override
    public boolean isGame() {
        return this.getBoolean(262144L);
    }

    @Override
    public boolean isDeclaredHavingCode() {
        return this.getBoolean(512L);
    }

    @Override
    public boolean isHasDomainUrls() {
        return this.getBoolean(0x400000L);
    }

    @Override
    public boolean isUserDataFragile() {
        return this.getBoolean(0x400000000L);
    }

    @Override
    public boolean isIsolatedSplitLoading() {
        return this.getBoolean(0x200000L);
    }

    @Override
    public boolean isKillAfterRestoreAllowed() {
        return this.getBoolean(8L);
    }

    @Override
    public boolean isLargeHeap() {
        return this.getBoolean(4096L);
    }

    @Override
    public boolean isLeavingSharedUser() {
        return this.getBoolean(0x8000000000000L);
    }

    @Override
    public boolean isMultiArch() {
        return this.getBoolean(65536L);
    }

    @Override
    public boolean isOnBackInvokedCallbackEnabled() {
        return this.getBoolean(0x4000000000000L);
    }

    @Override
    public boolean isResourceOverlay() {
        return this.getBoolean(0x100000L);
    }

    @Override
    public boolean isOverlayIsStatic() {
        return this.getBoolean(0x8000000000L);
    }

    @Override
    public boolean isPartiallyDirectBootAware() {
        return this.getBoolean(0x10000000L);
    }

    @Override
    public boolean isPersistent() {
        return this.getBoolean(64L);
    }

    @Override
    public boolean isProfileable() {
        return !this.getBoolean(0x200000000000L);
    }

    @Override
    public boolean isProfileableByShell() {
        return this.isProfileable() && this.getBoolean(0x800000L);
    }

    @Override
    public boolean isRequestLegacyExternalStorage() {
        return this.getBoolean(0x100000000L);
    }

    @Override
    public boolean isRequiredForAllUsers() {
        return this.getBoolean(0x4000000000L);
    }

    @Override
    public boolean isResetEnabledSettingsOnAppDataCleared() {
        return this.getBoolean(0x1000000000000L);
    }

    @Override
    public boolean isResizeable() {
        if (this.resizeable == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.resizeable;
    }

    @Override
    public boolean isResizeableActivityViaSdkVersion() {
        return this.getBoolean(0x20000000L);
    }

    @Override
    public boolean isRestoreAnyVersion() {
        return this.getBoolean(16L);
    }

    @Override
    public boolean isSdkLibrary() {
        return this.getBoolean(0x2000000000000L);
    }

    @Override
    public boolean isStaticSharedLibrary() {
        return this.getBoolean(524288L);
    }

    @Override
    public boolean isExtraLargeScreensSupported() {
        if (this.supportsExtraLargeScreens == null) {
            return this.targetSdkVersion >= 9;
        }
        return this.supportsExtraLargeScreens;
    }

    @Override
    public boolean isLargeScreensSupported() {
        if (this.supportsLargeScreens == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.supportsLargeScreens;
    }

    @Override
    public boolean isNormalScreensSupported() {
        return this.supportsNormalScreens == null || this.supportsNormalScreens != false;
    }

    @Override
    public boolean isRtlSupported() {
        return this.getBoolean(16384L);
    }

    @Override
    public boolean isSmallScreensSupported() {
        if (this.supportsSmallScreens == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.supportsSmallScreens;
    }

    @Override
    public boolean isTestOnly() {
        return this.getBoolean(32768L);
    }

    @Override
    public boolean is32BitAbiPreferred() {
        return this.getBoolean(0x10000000000L);
    }

    @Override
    public boolean isUseEmbeddedDex() {
        return this.getBoolean(0x2000000L);
    }

    @Override
    public boolean isCleartextTrafficAllowed() {
        return this.getBoolean(8192L);
    }

    @Override
    public boolean isNonSdkApiRequested() {
        return this.getBoolean(0x200000000L);
    }

    @Override
    public boolean isVisibleToInstantApps() {
        return this.getBoolean(0x20000000000L);
    }

    @Override
    public boolean isVmSafeMode() {
        return this.getBoolean(256L);
    }

    @Override
    public PackageImpl removeUsesOptionalNativeLibrary(String libraryName) {
        this.usesOptionalNativeLibraries = CollectionUtils.remove(this.usesOptionalNativeLibraries, libraryName);
        return this;
    }

    @Override
    public PackageImpl setAllowAudioPlaybackCapture(boolean value) {
        return this.setBoolean(0x80000000L, value);
    }

    @Override
    public PackageImpl setBackupAllowed(boolean value) {
        return this.setBoolean(4L, value);
    }

    @Override
    public PackageImpl setClearUserDataAllowed(boolean value) {
        return this.setBoolean(2048L, value);
    }

    @Override
    public PackageImpl setClearUserDataOnFailedRestoreAllowed(boolean value) {
        return this.setBoolean(0x40000000L, value);
    }

    @Override
    public PackageImpl setAllowNativeHeapPointerTagging(boolean value) {
        return this.setBoolean(0x1000000000L, value);
    }

    @Override
    public PackageImpl setAlternateLauncherIconResIds(@Nullable int[] alternateLauncherIconResIds) {
        this.mAlternateLauncherIconResIds = alternateLauncherIconResIds;
        return this;
    }

    @Override
    public PackageImpl setAlternateLauncherLabelResIds(@Nullable int[] alternateLauncherLabelResIds) {
        this.mAlternateLauncherLabelResIds = alternateLauncherLabelResIds;
        return this;
    }

    @Override
    public PackageImpl setTaskReparentingAllowed(boolean value) {
        return this.setBoolean(1024L, value);
    }

    @Override
    public PackageImpl setAnyDensity(int anyDensity) {
        if (anyDensity == 1) {
            return this;
        }
        this.anyDensity = anyDensity < 0;
        return this;
    }

    @Override
    public PackageImpl setAppComponentFactory(@Nullable String appComponentFactory) {
        this.appComponentFactory = appComponentFactory;
        return this;
    }

    @Override
    public ParsingPackage setAttributionsAreUserVisible(boolean attributionsAreUserVisible) {
        this.setBoolean(0x800000000000L, attributionsAreUserVisible);
        return this;
    }

    @Override
    public PackageImpl setAutoRevokePermissions(int value) {
        this.autoRevokePermissions = value;
        return this;
    }

    @Override
    public PackageImpl setBackupAgentName(@Nullable String backupAgentName) {
        this.backupAgentName = backupAgentName;
        return this;
    }

    @Override
    public PackageImpl setBackupInForeground(boolean value) {
        return this.setBoolean(0x1000000L, value);
    }

    @Override
    public PackageImpl setBannerResourceId(int value) {
        this.banner = value;
        return this;
    }

    @Override
    public PackageImpl setHardwareAccelerated(boolean value) {
        return this.setBoolean(2L, value);
    }

    @Override
    public PackageImpl setBaseRevisionCode(int value) {
        this.baseRevisionCode = value;
        return this;
    }

    @Override
    public PackageImpl setSaveStateDisallowed(boolean value) {
        return this.setBoolean(0x800000000L, value);
    }

    @Override
    public PackageImpl setCategory(int value) {
        this.category = value;
        return this;
    }

    @Override
    public PackageImpl setClassLoaderName(@Nullable String classLoaderName) {
        this.classLoaderName = classLoaderName;
        return this;
    }

    @Override
    public PackageImpl setApplicationClassName(@Nullable String className) {
        this.className = className == null ? null : className.trim();
        return this;
    }

    @Override
    public PackageImpl setCompatibleWidthLimitDp(int value) {
        this.compatibleWidthLimitDp = value;
        return this;
    }

    @Override
    public PackageImpl setCompileSdkVersion(int value) {
        this.compileSdkVersion = value;
        return this;
    }

    @Override
    public ParsingPackage setCompileSdkVersionCodeName(String compileSdkVersionCodeName) {
        this.compileSdkVersionCodeName = compileSdkVersionCodeName;
        return this;
    }

    @Override
    public PackageImpl setCrossProfile(boolean value) {
        return this.setBoolean(0x80000000000L, value);
    }

    @Override
    public PackageImpl setDataExtractionRulesResourceId(int value) {
        this.dataExtractionRules = value;
        return this;
    }

    @Override
    public PackageImpl setDebuggable(boolean value) {
        return this.setBoolean(128L, value);
    }

    @Override
    public PackageImpl setDescriptionResourceId(int value) {
        this.descriptionRes = value;
        return this;
    }

    @Override
    public PackageImpl setEnabled(boolean value) {
        return this.setBoolean(0x100000000000L, value);
    }

    @Override
    public PackageImpl setExternalStorage(boolean value) {
        return this.setBoolean(1L, value);
    }

    @Override
    public PackageImpl setExtractNativeLibrariesRequested(boolean value) {
        return this.setBoolean(131072L, value);
    }

    @Override
    public PackageImpl setForceQueryable(boolean value) {
        return this.setBoolean(0x40000000000L, value);
    }

    @Override
    public PackageImpl setFullBackupContentResourceId(int value) {
        this.fullBackupContent = value;
        return this;
    }

    @Override
    public PackageImpl setFullBackupOnly(boolean value) {
        return this.setBoolean(32L, value);
    }

    @Override
    public PackageImpl setGame(boolean value) {
        return this.setBoolean(262144L, value);
    }

    @Override
    public PackageImpl setGwpAsanMode(int value) {
        this.gwpAsanMode = value;
        return this;
    }

    @Override
    public PackageImpl setDeclaredHavingCode(boolean value) {
        return this.setBoolean(512L, value);
    }

    @Override
    public PackageImpl setHasDomainUrls(boolean value) {
        return this.setBoolean(0x400000L, value);
    }

    @Override
    public PackageImpl setUserDataFragile(boolean value) {
        return this.setBoolean(0x400000000L, value);
    }

    @Override
    public PackageImpl setIconResourceId(int value) {
        this.iconRes = value;
        return this;
    }

    @Override
    public PackageImpl setInstallLocation(int value) {
        this.installLocation = value;
        return this;
    }

    @Override
    public PackageImpl setIsolatedSplitLoading(boolean value) {
        return this.setBoolean(0x200000L, value);
    }

    @Override
    public PackageImpl setKillAfterRestoreAllowed(boolean value) {
        return this.setBoolean(8L, value);
    }

    @Override
    public ParsingPackage setKnownActivityEmbeddingCerts(@NonNull Set<String> knownEmbeddingCerts) {
        this.mKnownActivityEmbeddingCerts = knownEmbeddingCerts;
        return this;
    }

    @Override
    public PackageImpl setLabelResourceId(int value) {
        this.labelRes = value;
        return this;
    }

    @Override
    public PackageImpl setLargeHeap(boolean value) {
        return this.setBoolean(4096L, value);
    }

    @Override
    public PackageImpl setLargestWidthLimitDp(int value) {
        this.largestWidthLimitDp = value;
        return this;
    }

    @Override
    public PackageImpl setLeavingSharedUser(boolean value) {
        return this.setBoolean(0x8000000000000L, value);
    }

    @Override
    public PackageImpl setLocaleConfigResourceId(int value) {
        this.mLocaleConfigRes = value;
        return this;
    }

    @Override
    public PackageImpl setLogoResourceId(int value) {
        this.logo = value;
        return this;
    }

    @Override
    public PackageImpl setManageSpaceActivityName(@Nullable String manageSpaceActivityName) {
        this.manageSpaceActivityName = manageSpaceActivityName;
        return this;
    }

    @Override
    public PackageImpl setMaxAspectRatio(float value) {
        this.maxAspectRatio = value;
        return this;
    }

    @Override
    public PackageImpl setMaxSdkVersion(int value) {
        this.maxSdkVersion = value;
        return this;
    }

    @Override
    public PackageImpl setMemtagMode(int value) {
        this.memtagMode = value;
        return this;
    }

    @Override
    public PackageImpl setMetaData(@Nullable Bundle value) {
        this.metaData = value;
        return this;
    }

    @Override
    public PackageImpl setMinAspectRatio(float value) {
        this.minAspectRatio = value;
        return this;
    }

    @Override
    public PackageImpl setMinExtensionVersions(@Nullable SparseIntArray value) {
        this.minExtensionVersions = value;
        return this;
    }

    @Override
    public PackageImpl setMinSdkVersion(int value) {
        this.minSdkVersion = value;
        return this;
    }

    @Override
    public PackageImpl setMultiArch(boolean value) {
        return this.setBoolean(65536L, value);
    }

    @Override
    public PackageImpl setNativeHeapZeroInitialized(int value) {
        this.nativeHeapZeroInitialized = value;
        return this;
    }

    @Override
    public PackageImpl setPageSizeAppCompatFlags(int flag) {
        this.mPageSizeAppCompatFlags = flag;
        return this;
    }

    @Override
    public PackageImpl setNetworkSecurityConfigResourceId(int value) {
        this.networkSecurityConfigRes = value;
        return this;
    }

    @Override
    public PackageImpl setNonLocalizedLabel(@Nullable CharSequence value) {
        this.nonLocalizedLabel = value == null ? null : value.toString().trim();
        return this;
    }

    @Override
    public ParsingPackage setOnBackInvokedCallbackEnabled(boolean value) {
        this.setBoolean(0x4000000000000L, value);
        return this;
    }

    @Override
    public ParsingPackage setAllowCrossUidActivitySwitchFromBelow(boolean value) {
        this.mAllowCrossUidActivitySwitchFromBelow = value;
        return this;
    }

    @Override
    public PackageImpl setResourceOverlay(boolean value) {
        return this.setBoolean(0x100000L, value);
    }

    @Override
    public PackageImpl setOverlayCategory(@Nullable String overlayCategory) {
        this.overlayCategory = overlayCategory;
        return this;
    }

    @Override
    public PackageImpl setOverlayIsStatic(boolean value) {
        return this.setBoolean(0x8000000000L, value);
    }

    @Override
    public PackageImpl setOverlayPriority(int value) {
        this.overlayPriority = value;
        return this;
    }

    @Override
    public PackageImpl setOverlayTarget(@Nullable String overlayTarget) {
        this.overlayTarget = TextUtils.safeIntern(overlayTarget);
        return this;
    }

    @Override
    public PackageImpl setOverlayTargetOverlayableName(@Nullable String overlayTargetOverlayableName) {
        this.overlayTargetOverlayableName = overlayTargetOverlayableName;
        return this;
    }

    @Override
    public PackageImpl setPartiallyDirectBootAware(boolean value) {
        return this.setBoolean(0x10000000L, value);
    }

    @Override
    public PackageImpl setPermission(@Nullable String permission2) {
        this.permission = permission2;
        return this;
    }

    @Override
    public PackageImpl setPreserveLegacyExternalStorage(boolean value) {
        return this.setBoolean(0x2000000000L, value);
    }

    @Override
    public PackageImpl setProcessName(String processName) {
        this.processName = processName;
        return this;
    }

    @Override
    public PackageImpl setProcesses(@NonNull Map<String, ParsedProcess> value) {
        this.processes = value;
        return this;
    }

    @Override
    public PackageImpl setProfileable(boolean value) {
        return this.setBoolean(0x200000000000L, !value);
    }

    @Override
    public PackageImpl setProfileableByShell(boolean value) {
        return this.setBoolean(0x800000L, value);
    }

    @Override
    public PackageImpl setRequestForegroundServiceExemption(boolean value) {
        return this.setBoolean(0x400000000000L, value);
    }

    @Override
    public PackageImpl setRequestLegacyExternalStorage(boolean value) {
        return this.setBoolean(0x100000000L, value);
    }

    @Override
    public PackageImpl setRequestRawExternalStorageAccess(@Nullable Boolean value) {
        this.requestRawExternalStorageAccess = value;
        return this;
    }

    @Override
    public PackageImpl setRequiredAccountType(@Nullable String requiredAccountType) {
        this.requiredAccountType = TextUtils.nullIfEmpty(requiredAccountType);
        return this;
    }

    @Override
    public PackageImpl setRequiredForAllUsers(boolean value) {
        return this.setBoolean(0x4000000000L, value);
    }

    @Override
    public PackageImpl setRequiresSmallestWidthDp(int value) {
        this.requiresSmallestWidthDp = value;
        return this;
    }

    @Override
    public ParsingPackage setResetEnabledSettingsOnAppDataCleared(boolean resetEnabledSettingsOnAppDataCleared) {
        this.setBoolean(0x1000000000000L, resetEnabledSettingsOnAppDataCleared);
        return this;
    }

    @Override
    public PackageImpl setResizeable(int resizeable) {
        if (resizeable == 1) {
            return this;
        }
        this.resizeable = resizeable < 0;
        return this;
    }

    @Override
    public PackageImpl setResizeableActivity(@Nullable Boolean value) {
        this.resizeableActivity = value;
        return this;
    }

    @Override
    public PackageImpl setResizeableActivityViaSdkVersion(boolean value) {
        return this.setBoolean(0x20000000L, value);
    }

    @Override
    public PackageImpl setRestoreAnyVersion(boolean value) {
        return this.setBoolean(16L, value);
    }

    @Override
    public PackageImpl setRestrictedAccountType(@Nullable String restrictedAccountType) {
        this.restrictedAccountType = restrictedAccountType;
        return this;
    }

    @Override
    public PackageImpl setEmergencyInstaller(@Nullable String emergencyInstaller) {
        this.mEmergencyInstaller = emergencyInstaller;
        return this;
    }

    @Override
    public PackageImpl setRoundIconResourceId(int value) {
        this.roundIconRes = value;
        return this;
    }

    @Override
    public PackageImpl setSdkLibraryName(String sdkLibraryName) {
        this.sdkLibraryName = TextUtils.safeIntern(sdkLibraryName);
        return this;
    }

    @Override
    public PackageImpl setSdkLibVersionMajor(int sdkLibVersionMajor) {
        this.sdkLibVersionMajor = sdkLibVersionMajor;
        return this;
    }

    @Override
    public PackageImpl setSdkLibrary(boolean value) {
        return this.setBoolean(0x2000000000000L, value);
    }

    @Override
    public PackageImpl setSharedUserId(String sharedUserId) {
        this.sharedUserId = TextUtils.safeIntern(sharedUserId);
        return this;
    }

    @Override
    public PackageImpl setSharedUserLabelResourceId(int value) {
        this.sharedUserLabel = value;
        return this;
    }

    @Override
    public PackageImpl setSplitClassLoaderName(int splitIndex, String classLoaderName) {
        this.splitClassLoaderNames[splitIndex] = classLoaderName;
        return this;
    }

    @Override
    public PackageImpl setSplitHasCode(int splitIndex, boolean splitHasCode) {
        this.splitFlags[splitIndex] = splitHasCode ? this.splitFlags[splitIndex] | 4 : this.splitFlags[splitIndex] & 0xFFFFFFFB;
        return this;
    }

    @Override
    public PackageImpl setStaticSharedLibraryName(String staticSharedLibraryName) {
        this.staticSharedLibraryName = TextUtils.safeIntern(staticSharedLibraryName);
        return this;
    }

    @Override
    public PackageImpl setStaticSharedLibraryVersion(long value) {
        this.staticSharedLibVersion = value;
        return this;
    }

    @Override
    public PackageImpl setStaticSharedLibrary(boolean value) {
        return this.setBoolean(524288L, value);
    }

    @Override
    public PackageImpl setExtraLargeScreensSupported(int supportsExtraLargeScreens) {
        if (supportsExtraLargeScreens == 1) {
            return this;
        }
        this.supportsExtraLargeScreens = supportsExtraLargeScreens < 0;
        return this;
    }

    @Override
    public PackageImpl setLargeScreensSupported(int supportsLargeScreens) {
        if (supportsLargeScreens == 1) {
            return this;
        }
        this.supportsLargeScreens = supportsLargeScreens < 0;
        return this;
    }

    @Override
    public PackageImpl setNormalScreensSupported(int supportsNormalScreens) {
        if (supportsNormalScreens == 1) {
            return this;
        }
        this.supportsNormalScreens = supportsNormalScreens < 0;
        return this;
    }

    @Override
    public PackageImpl setRtlSupported(boolean value) {
        return this.setBoolean(16384L, value);
    }

    @Override
    public PackageImpl setSmallScreensSupported(int supportsSmallScreens) {
        if (supportsSmallScreens == 1) {
            return this;
        }
        this.supportsSmallScreens = supportsSmallScreens < 0;
        return this;
    }

    @Override
    public PackageImpl setTargetSandboxVersion(int value) {
        this.targetSandboxVersion = value;
        return this;
    }

    @Override
    public PackageImpl setTargetSdkVersion(int value) {
        this.targetSdkVersion = value;
        return this;
    }

    @Override
    public PackageImpl setTaskAffinity(@Nullable String taskAffinity) {
        this.taskAffinity = taskAffinity;
        return this;
    }

    @Override
    public PackageImpl setTestOnly(boolean value) {
        return this.setBoolean(32768L, value);
    }

    @Override
    public PackageImpl setThemeResourceId(int value) {
        this.theme = value;
        return this;
    }

    @Override
    public PackageImpl setUiOptions(int value) {
        this.uiOptions = value;
        return this;
    }

    @Override
    public PackageImpl setUpgradeKeySets(@NonNull Set<String> value) {
        this.upgradeKeySets = value;
        return this;
    }

    @Override
    public PackageImpl set32BitAbiPreferred(boolean value) {
        return this.setBoolean(0x10000000000L, value);
    }

    @Override
    public PackageImpl setUseEmbeddedDex(boolean value) {
        return this.setBoolean(0x2000000L, value);
    }

    @Override
    public PackageImpl setCleartextTrafficAllowed(boolean value) {
        return this.setBoolean(8192L, value);
    }

    @Override
    public PackageImpl setNonSdkApiRequested(boolean value) {
        return this.setBoolean(0x200000000L, value);
    }

    @Override
    public PackageImpl setVersionName(String versionName) {
        this.versionName = versionName;
        return this;
    }

    @Override
    public PackageImpl setVisibleToInstantApps(boolean value) {
        return this.setBoolean(0x20000000000L, value);
    }

    @Override
    public PackageImpl setVmSafeMode(boolean value) {
        return this.setBoolean(256L, value);
    }

    @Override
    public PackageImpl setVolumeUuid(@Nullable String volumeUuid) {
        this.volumeUuid = TextUtils.safeIntern(volumeUuid);
        return this;
    }

    @Override
    public PackageImpl setZygotePreloadName(@Nullable String zygotePreloadName) {
        this.zygotePreloadName = zygotePreloadName;
        return this;
    }

    @Override
    public PackageImpl sortActivities() {
        Collections.sort(this.activities, ORDER_COMPARATOR);
        return this;
    }

    @Override
    public PackageImpl sortReceivers() {
        Collections.sort(this.receivers, ORDER_COMPARATOR);
        return this;
    }

    @Override
    public PackageImpl sortServices() {
        Collections.sort(this.services, ORDER_COMPARATOR);
        return this;
    }

    public ApplicationInfo toAppInfoWithoutStateWithoutFlags() {
        ApplicationInfo appInfo = new ApplicationInfo();
        appInfo.appComponentFactory = this.appComponentFactory;
        appInfo.backupAgentName = this.backupAgentName;
        appInfo.banner = this.banner;
        appInfo.category = this.category;
        appInfo.classLoaderName = this.classLoaderName;
        appInfo.className = this.className;
        appInfo.compatibleWidthLimitDp = this.compatibleWidthLimitDp;
        appInfo.compileSdkVersion = this.compileSdkVersion;
        appInfo.compileSdkVersionCodename = this.compileSdkVersionCodeName;
        appInfo.crossProfile = this.isCrossProfile();
        appInfo.descriptionRes = this.descriptionRes;
        appInfo.enabled = this.getBoolean(0x100000000000L);
        appInfo.fullBackupContent = this.fullBackupContent;
        appInfo.dataExtractionRulesRes = this.dataExtractionRules;
        appInfo.icon = ParsingPackageUtils.sUseRoundIcon && this.roundIconRes != 0 ? this.roundIconRes : this.iconRes;
        appInfo.iconRes = this.iconRes;
        appInfo.roundIconRes = this.roundIconRes;
        appInfo.installLocation = this.installLocation;
        appInfo.labelRes = this.labelRes;
        appInfo.largestWidthLimitDp = this.largestWidthLimitDp;
        appInfo.logo = this.logo;
        appInfo.manageSpaceActivityName = this.manageSpaceActivityName;
        appInfo.maxAspectRatio = this.maxAspectRatio;
        appInfo.metaData = this.metaData;
        appInfo.minAspectRatio = this.minAspectRatio;
        appInfo.minSdkVersion = this.minSdkVersion;
        appInfo.name = this.className;
        appInfo.networkSecurityConfigRes = this.networkSecurityConfigRes;
        appInfo.nonLocalizedLabel = this.nonLocalizedLabel;
        appInfo.packageName = this.packageName;
        appInfo.permission = this.permission;
        appInfo.processName = this.getProcessName();
        appInfo.requiresSmallestWidthDp = this.requiresSmallestWidthDp;
        appInfo.splitClassLoaderNames = this.splitClassLoaderNames;
        appInfo.splitDependencies = this.splitDependencies == null || this.splitDependencies.size() == 0 ? null : this.splitDependencies;
        appInfo.splitNames = this.splitNames;
        appInfo.storageUuid = this.mStorageUuid;
        appInfo.targetSandboxVersion = this.targetSandboxVersion;
        appInfo.targetSdkVersion = this.targetSdkVersion;
        appInfo.taskAffinity = this.taskAffinity;
        appInfo.theme = this.theme;
        appInfo.uiOptions = this.uiOptions;
        appInfo.volumeUuid = this.volumeUuid;
        appInfo.zygotePreloadName = this.zygotePreloadName;
        appInfo.setGwpAsanMode(this.gwpAsanMode);
        appInfo.setMemtagMode(this.memtagMode);
        appInfo.setNativeHeapZeroInitialized(this.nativeHeapZeroInitialized);
        appInfo.setRequestRawExternalStorageAccess(this.requestRawExternalStorageAccess);
        appInfo.setBaseCodePath(this.mBaseApkPath);
        appInfo.setBaseResourcePath(this.mBaseApkPath);
        appInfo.setCodePath(this.mPath);
        appInfo.setResourcePath(this.mPath);
        appInfo.setSplitCodePaths(ArrayUtils.size(this.splitCodePaths) == 0 ? null : this.splitCodePaths);
        appInfo.setSplitResourcePaths(ArrayUtils.size(this.splitCodePaths) == 0 ? null : this.splitCodePaths);
        appInfo.setVersionCode(this.mLongVersionCode);
        appInfo.setAppClassNamesByProcess(this.buildAppClassNamesByProcess());
        appInfo.setLocaleConfigRes(this.mLocaleConfigRes);
        if (!this.mKnownActivityEmbeddingCerts.isEmpty()) {
            appInfo.setKnownActivityEmbeddingCerts(this.mKnownActivityEmbeddingCerts);
        }
        appInfo.allowCrossUidActivitySwitchFromBelow = this.mAllowCrossUidActivitySwitchFromBelow;
        appInfo.setPageSizeAppCompatFlags(this.mPageSizeAppCompatFlags);
        return appInfo;
    }

    private PackageImpl setBoolean(@Booleans.Flags long flag, boolean value) {
        this.mBooleans = value ? (this.mBooleans |= flag) : (this.mBooleans &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    private boolean getBoolean(@Booleans.Flags long flag) {
        return (this.mBooleans & flag) != 0L;
    }

    private PackageImpl setBoolean2(@Booleans2.Flags long flag, boolean value) {
        this.mBooleans2 = value ? (this.mBooleans2 |= flag) : (this.mBooleans2 &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    private boolean getBoolean2(@Booleans2.Flags long flag) {
        return (this.mBooleans2 & flag) != 0L;
    }

    @VisibleForTesting
    public PackageImpl(@NonNull String packageName, @NonNull String baseApkPath, @NonNull String path, @Nullable TypedArray manifestArray, boolean isCoreApp, @Nullable ParsingPackageUtils.Callback callback) {
        this.packageName = TextUtils.safeIntern(packageName);
        this.mBaseApkPath = baseApkPath;
        this.mPath = path;
        this.mCallback = callback;
        if (manifestArray != null) {
            this.versionCode = manifestArray.getInteger(1, 0);
            this.versionCodeMajor = manifestArray.getInteger(11, 0);
            this.setBaseRevisionCode(manifestArray.getInteger(5, 0));
            this.setVersionName(manifestArray.getNonConfigurationString(2, 0));
            this.setCompileSdkVersion(manifestArray.getInteger(9, 0));
            this.setCompileSdkVersionCodeName(manifestArray.getNonConfigurationString(10, 0));
            this.setIsolatedSplitLoading(manifestArray.getBoolean(6, false));
        }
        this.manifestPackageName = this.packageName;
        this.setBoolean(0x10000000000000L, isCoreApp);
    }

    @Override
    public PackageImpl hideAsParsed() {
        this.assignDerivedFields();
        return this;
    }

    @Override
    public AndroidPackageInternal hideAsFinal() {
        if (this.mStorageUuid == null) {
            this.assignDerivedFields();
        }
        this.assignDerivedFields2();
        this.makeImmutable();
        return this;
    }

    private static String[] sortLibraries(List<String> libraryNames) {
        int size = libraryNames.size();
        if (size == 0) {
            return EmptyArray.STRING;
        }
        Object[] arr = libraryNames.toArray(EmptyArray.STRING);
        Arrays.sort(arr);
        return arr;
    }

    private void assignDerivedFields2() {
        this.mBaseAppInfoFlags = AppInfoUtils.appInfoFlags(this);
        this.mBaseAppInfoPrivateFlags = AppInfoUtils.appInfoPrivateFlags(this);
        this.mBaseAppInfoPrivateFlagsExt = AppInfoUtils.appInfoPrivateFlagsExt(this, this.mCallback == null ? false : this.mCallback.getHiddenApiWhitelistedApps().contains(this.packageName));
        String baseAppDataDir = Environment.getDataDirectoryPath(this.getVolumeUuid()) + File.separator;
        String systemUserSuffix = File.separator + 0 + File.separator;
        this.mBaseAppDataCredentialProtectedDirForSystemUser = TextUtils.safeIntern(baseAppDataDir + "user" + systemUserSuffix);
        this.mBaseAppDataDeviceProtectedDirForSystemUser = TextUtils.safeIntern(baseAppDataDir + "user_de" + systemUserSuffix);
    }

    private void makeImmutable() {
        this.usesLibraries = Collections.unmodifiableList(this.usesLibraries);
        this.usesOptionalLibraries = Collections.unmodifiableList(this.usesOptionalLibraries);
        this.usesNativeLibraries = Collections.unmodifiableList(this.usesNativeLibraries);
        this.usesOptionalNativeLibraries = Collections.unmodifiableList(this.usesOptionalNativeLibraries);
        this.originalPackages = Collections.unmodifiableList(this.originalPackages);
        this.adoptPermissions = Collections.unmodifiableList(this.adoptPermissions);
        this.requestedPermissions = Collections.unmodifiableSet(this.requestedPermissions);
        this.protectedBroadcasts = Collections.unmodifiableList(this.protectedBroadcasts);
        this.apexSystemServices = Collections.unmodifiableList(this.apexSystemServices);
        this.activities = Collections.unmodifiableList(this.activities);
        this.receivers = Collections.unmodifiableList(this.receivers);
        this.services = Collections.unmodifiableList(this.services);
        this.providers = Collections.unmodifiableList(this.providers);
        this.permissions = Collections.unmodifiableList(this.permissions);
        this.permissionGroups = Collections.unmodifiableList(this.permissionGroups);
        this.instrumentations = Collections.unmodifiableList(this.instrumentations);
        this.overlayables = Collections.unmodifiableMap(this.overlayables);
        this.libraryNames = Collections.unmodifiableList(this.libraryNames);
        this.usesStaticLibraries = Collections.unmodifiableList(this.usesStaticLibraries);
        this.usesSdkLibraries = Collections.unmodifiableList(this.usesSdkLibraries);
        this.configPreferences = Collections.unmodifiableList(this.configPreferences);
        this.reqFeatures = Collections.unmodifiableList(this.reqFeatures);
        this.featureGroups = Collections.unmodifiableList(this.featureGroups);
        this.usesPermissions = Collections.unmodifiableList(this.usesPermissions);
        this.usesSdkLibraries = Collections.unmodifiableList(this.usesSdkLibraries);
        this.implicitPermissions = Collections.unmodifiableSet(this.implicitPermissions);
        this.upgradeKeySets = Collections.unmodifiableSet(this.upgradeKeySets);
        this.keySetMapping = Collections.unmodifiableMap(this.keySetMapping);
        this.attributions = Collections.unmodifiableList(this.attributions);
        this.preferredActivityFilters = Collections.unmodifiableList(this.preferredActivityFilters);
        this.processes = Collections.unmodifiableMap(this.processes);
        this.mProperties = Collections.unmodifiableMap(this.mProperties);
        this.queriesIntents = Collections.unmodifiableList(this.queriesIntents);
        this.queriesPackages = Collections.unmodifiableList(this.queriesPackages);
        this.queriesProviders = Collections.unmodifiableSet(this.queriesProviders);
        this.mimeGroups = Collections.unmodifiableSet(this.mimeGroups);
        this.mKnownActivityEmbeddingCerts = Collections.unmodifiableSet(this.mKnownActivityEmbeddingCerts);
        this.mFeatureFlagState = Collections.unmodifiableMap(this.mFeatureFlagState);
    }

    @Override
    public long getLongVersionCode() {
        return PackageInfo.composeLongVersionCode(this.versionCodeMajor, this.versionCode);
    }

    @Override
    public PackageImpl removePermission(int index) {
        this.permissions.remove(index);
        return this;
    }

    @Override
    public PackageImpl addUsesOptionalLibrary(int index, String libraryName) {
        this.usesOptionalLibraries = CollectionUtils.add(this.usesOptionalLibraries, index, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public PackageImpl addUsesLibrary(int index, String libraryName) {
        this.usesLibraries = CollectionUtils.add(this.usesLibraries, index, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public PackageImpl removeUsesLibrary(String libraryName) {
        this.usesLibraries = CollectionUtils.remove(this.usesLibraries, libraryName);
        return this;
    }

    @Override
    public PackageImpl removeUsesOptionalLibrary(String libraryName) {
        this.usesOptionalLibraries = CollectionUtils.remove(this.usesOptionalLibraries, libraryName);
        return this;
    }

    @Override
    public PackageImpl setSigningDetails(@NonNull SigningDetails value) {
        this.signingDetails = value;
        return this;
    }

    @Override
    public PackageImpl setRestrictUpdateHash(byte ... value) {
        this.restrictUpdateHash = value;
        return this;
    }

    @Override
    public PackageImpl setPersistent(boolean value) {
        this.setBoolean(64L, value);
        return this;
    }

    @Override
    public PackageImpl setDefaultToDeviceProtectedStorage(boolean value) {
        this.setBoolean(0x4000000L, value);
        return this;
    }

    @Override
    public PackageImpl setDirectBootAware(boolean value) {
        this.setBoolean(0x8000000L, value);
        return this;
    }

    @Override
    public PackageImpl clearProtectedBroadcasts() {
        this.protectedBroadcasts.clear();
        return this;
    }

    @Override
    public PackageImpl clearOriginalPackages() {
        this.originalPackages.clear();
        return this;
    }

    @Override
    public PackageImpl clearAdoptPermissions() {
        this.adoptPermissions.clear();
        return this;
    }

    @Override
    public PackageImpl setPath(@NonNull String path) {
        this.mPath = path;
        return this;
    }

    @Override
    public PackageImpl setPackageName(@NonNull String packageName) {
        this.packageName = TextUtils.safeIntern(packageName);
        int permissionsSize = this.permissions.size();
        for (int index = 0; index < permissionsSize; ++index) {
            ComponentMutateUtils.setPackageName(this.permissions.get(index), this.packageName);
        }
        int permissionGroupsSize = this.permissionGroups.size();
        for (int index = 0; index < permissionGroupsSize; ++index) {
            ComponentMutateUtils.setPackageName(this.permissionGroups.get(index), this.packageName);
        }
        int activitiesSize = this.activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ComponentMutateUtils.setPackageName(this.activities.get(index), this.packageName);
        }
        int receiversSize = this.receivers.size();
        for (int index = 0; index < receiversSize; ++index) {
            ComponentMutateUtils.setPackageName(this.receivers.get(index), this.packageName);
        }
        int providersSize = this.providers.size();
        for (int index = 0; index < providersSize; ++index) {
            ComponentMutateUtils.setPackageName(this.providers.get(index), this.packageName);
        }
        int servicesSize = this.services.size();
        for (int index = 0; index < servicesSize; ++index) {
            ComponentMutateUtils.setPackageName(this.services.get(index), this.packageName);
        }
        int instrumentationsSize = this.instrumentations.size();
        for (int index = 0; index < instrumentationsSize; ++index) {
            ComponentMutateUtils.setPackageName(this.instrumentations.get(index), this.packageName);
        }
        return this;
    }

    @Override
    public PackageImpl setAllComponentsDirectBootAware(boolean allComponentsDirectBootAware) {
        int activitiesSize = this.activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ComponentMutateUtils.setDirectBootAware(this.activities.get(index), allComponentsDirectBootAware);
        }
        int receiversSize = this.receivers.size();
        for (int index = 0; index < receiversSize; ++index) {
            ComponentMutateUtils.setDirectBootAware(this.receivers.get(index), allComponentsDirectBootAware);
        }
        int providersSize = this.providers.size();
        for (int index = 0; index < providersSize; ++index) {
            ComponentMutateUtils.setDirectBootAware(this.providers.get(index), allComponentsDirectBootAware);
        }
        int servicesSize = this.services.size();
        for (int index = 0; index < servicesSize; ++index) {
            ComponentMutateUtils.setDirectBootAware(this.services.get(index), allComponentsDirectBootAware);
        }
        return this;
    }

    @Override
    public PackageImpl setBaseApkPath(@NonNull String baseApkPath) {
        this.mBaseApkPath = TextUtils.safeIntern(baseApkPath);
        return this;
    }

    @Override
    public PackageImpl setNativeLibraryDir(@Nullable String nativeLibraryDir) {
        this.nativeLibraryDir = TextUtils.safeIntern(nativeLibraryDir);
        return this;
    }

    @Override
    public PackageImpl setNativeLibraryRootDir(@Nullable String nativeLibraryRootDir) {
        this.nativeLibraryRootDir = TextUtils.safeIntern(nativeLibraryRootDir);
        return this;
    }

    @Override
    public PackageImpl setPrimaryCpuAbi(@Nullable String primaryCpuAbi) {
        this.primaryCpuAbi = TextUtils.safeIntern(primaryCpuAbi);
        return this;
    }

    @Override
    public PackageImpl setSecondaryCpuAbi(@Nullable String secondaryCpuAbi) {
        this.secondaryCpuAbi = TextUtils.safeIntern(secondaryCpuAbi);
        return this;
    }

    @Override
    public PackageImpl setSecondaryNativeLibraryDir(@Nullable String secondaryNativeLibraryDir) {
        this.secondaryNativeLibraryDir = TextUtils.safeIntern(secondaryNativeLibraryDir);
        return this;
    }

    @Override
    public PackageImpl setSplitCodePaths(@Nullable String[] splitCodePaths) {
        this.splitCodePaths = splitCodePaths;
        this.mSplits = null;
        if (splitCodePaths != null) {
            int size = splitCodePaths.length;
            for (int index = 0; index < size; ++index) {
                this.splitCodePaths[index] = TextUtils.safeIntern(this.splitCodePaths[index]);
            }
        }
        return this;
    }

    @Override
    public PackageImpl capPermissionPriorities() {
        int size = this.permissionGroups.size();
        for (int index = size - 1; index >= 0; --index) {
            ComponentMutateUtils.setPriority(this.permissionGroups.get(index), 0);
        }
        return this;
    }

    @Override
    public PackageImpl markNotActivitiesAsNotExportedIfSingleUser() {
        int receiversSize = this.receivers.size();
        for (int index = 0; index < receiversSize; ++index) {
            ParsedActivity receiver = this.receivers.get(index);
            if ((receiver.getFlags() & 0x40000000) == 0) continue;
            ComponentMutateUtils.setExported(receiver, false);
        }
        int servicesSize = this.services.size();
        for (int index = 0; index < servicesSize; ++index) {
            ParsedService service = this.services.get(index);
            if ((service.getFlags() & 0x40000000) == 0) continue;
            ComponentMutateUtils.setExported(service, false);
        }
        int providersSize = this.providers.size();
        for (int index = 0; index < providersSize; ++index) {
            ParsedProvider provider = this.providers.get(index);
            if ((provider.getFlags() & 0x40000000) == 0) continue;
            ComponentMutateUtils.setExported(provider, false);
        }
        return this;
    }

    @Override
    public PackageImpl setCoreApp(boolean coreApp) {
        return this.setBoolean(0x10000000000000L, coreApp);
    }

    @Override
    public PackageImpl setVersionCode(int versionCode) {
        this.versionCode = versionCode;
        return this;
    }

    @Override
    public PackageImpl setVersionCodeMajor(int versionCodeMajor) {
        this.versionCodeMajor = versionCodeMajor;
        return this;
    }

    @Override
    public ApplicationInfo toAppInfoWithoutState() {
        ApplicationInfo appInfo = this.toAppInfoWithoutStateWithoutFlags();
        appInfo.flags = this.mBaseAppInfoFlags;
        appInfo.privateFlags = this.mBaseAppInfoPrivateFlags;
        appInfo.privateFlagsExt = this.mBaseAppInfoPrivateFlagsExt;
        appInfo.nativeLibraryDir = this.nativeLibraryDir;
        appInfo.nativeLibraryRootDir = this.nativeLibraryRootDir;
        appInfo.nativeLibraryRootRequiresIsa = this.nativeLibraryRootRequiresIsa;
        appInfo.primaryCpuAbi = this.primaryCpuAbi;
        appInfo.secondaryCpuAbi = this.secondaryCpuAbi;
        appInfo.secondaryNativeLibraryDir = this.secondaryNativeLibraryDir;
        appInfo.seInfoUser = ":complete";
        appInfo.uid = this.uid;
        return appInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int index;
        this.writeFeatureFlagState(dest);
        sForBoolean.parcel(this.supportsSmallScreens, dest, flags);
        sForBoolean.parcel(this.supportsNormalScreens, dest, flags);
        sForBoolean.parcel(this.supportsLargeScreens, dest, flags);
        sForBoolean.parcel(this.supportsExtraLargeScreens, dest, flags);
        sForBoolean.parcel(this.resizeable, dest, flags);
        sForBoolean.parcel(this.anyDensity, dest, flags);
        dest.writeInt(this.versionCode);
        dest.writeInt(this.versionCodeMajor);
        dest.writeInt(this.baseRevisionCode);
        sForInternedString.parcel(this.versionName, dest, flags);
        dest.writeInt(this.compileSdkVersion);
        dest.writeString(this.compileSdkVersionCodeName);
        sForInternedString.parcel(this.packageName, dest, flags);
        dest.writeString(this.mBaseApkPath);
        dest.writeString(this.restrictedAccountType);
        dest.writeString(this.requiredAccountType);
        dest.writeString(this.mEmergencyInstaller);
        sForInternedString.parcel(this.overlayTarget, dest, flags);
        dest.writeString(this.overlayTargetOverlayableName);
        dest.writeString(this.overlayCategory);
        dest.writeInt(this.overlayPriority);
        sForInternedStringValueMap.parcel(this.overlayables, dest, flags);
        sForInternedString.parcel(this.sdkLibraryName, dest, flags);
        dest.writeInt(this.sdkLibVersionMajor);
        sForInternedString.parcel(this.staticSharedLibraryName, dest, flags);
        dest.writeLong(this.staticSharedLibVersion);
        sForInternedStringList.parcel(this.libraryNames, dest, flags);
        sForInternedStringList.parcel(this.usesLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesOptionalLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesNativeLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesOptionalNativeLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesStaticLibraries, dest, flags);
        dest.writeLongArray(this.usesStaticLibrariesVersions);
        if (this.usesStaticLibrariesCertDigests == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(this.usesStaticLibrariesCertDigests.length);
            for (index = 0; index < this.usesStaticLibrariesCertDigests.length; ++index) {
                dest.writeStringArray(this.usesStaticLibrariesCertDigests[index]);
            }
        }
        sForInternedStringList.parcel(this.usesSdkLibraries, dest, flags);
        dest.writeLongArray(this.usesSdkLibrariesVersionsMajor);
        if (this.usesSdkLibrariesCertDigests == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(this.usesSdkLibrariesCertDigests.length);
            for (index = 0; index < this.usesSdkLibrariesCertDigests.length; ++index) {
                dest.writeStringArray(this.usesSdkLibrariesCertDigests[index]);
            }
        }
        dest.writeBooleanArray(this.usesSdkLibrariesOptional);
        sForInternedString.parcel(this.sharedUserId, dest, flags);
        dest.writeInt(this.sharedUserLabel);
        dest.writeTypedList(this.configPreferences);
        dest.writeTypedList(this.reqFeatures);
        dest.writeTypedList(this.featureGroups);
        dest.writeByteArray(this.restrictUpdateHash);
        dest.writeStringList(this.originalPackages);
        sForInternedStringList.parcel(this.adoptPermissions, dest, flags);
        sForInternedStringSet.parcel(this.requestedPermissions, dest, flags);
        ParsingUtils.writeParcelableList(dest, this.usesPermissions);
        sForInternedStringSet.parcel(this.implicitPermissions, dest, flags);
        sForStringSet.parcel(this.upgradeKeySets, dest, flags);
        ParsingPackageUtils.writeKeySetMapping(dest, this.keySetMapping);
        sForInternedStringList.parcel(this.protectedBroadcasts, dest, flags);
        ParsingUtils.writeParcelableList(dest, this.activities);
        ParsingUtils.writeParcelableList(dest, this.apexSystemServices);
        ParsingUtils.writeParcelableList(dest, this.receivers);
        ParsingUtils.writeParcelableList(dest, this.services);
        ParsingUtils.writeParcelableList(dest, this.providers);
        ParsingUtils.writeParcelableList(dest, this.attributions);
        ParsingUtils.writeParcelableList(dest, this.permissions);
        ParsingUtils.writeParcelableList(dest, this.permissionGroups);
        ParsingUtils.writeParcelableList(dest, this.instrumentations);
        sForIntentInfoPairs.parcel(this.preferredActivityFilters, dest, flags);
        dest.writeMap(this.processes);
        dest.writeBundle(this.metaData);
        sForInternedString.parcel(this.volumeUuid, dest, flags);
        dest.writeParcelable(this.signingDetails, flags);
        dest.writeString(this.mPath);
        dest.writeTypedList(this.queriesIntents, flags);
        sForInternedStringList.parcel(this.queriesPackages, dest, flags);
        sForInternedStringSet.parcel(this.queriesProviders, dest, flags);
        dest.writeString(this.appComponentFactory);
        dest.writeString(this.backupAgentName);
        dest.writeInt(this.banner);
        dest.writeInt(this.category);
        dest.writeString(this.classLoaderName);
        dest.writeString(this.className);
        dest.writeInt(this.compatibleWidthLimitDp);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.fullBackupContent);
        dest.writeInt(this.dataExtractionRules);
        dest.writeInt(this.iconRes);
        dest.writeInt(this.installLocation);
        dest.writeInt(this.labelRes);
        dest.writeInt(this.largestWidthLimitDp);
        dest.writeInt(this.logo);
        dest.writeString(this.manageSpaceActivityName);
        dest.writeFloat(this.maxAspectRatio);
        dest.writeFloat(this.minAspectRatio);
        dest.writeInt(this.minSdkVersion);
        dest.writeInt(this.maxSdkVersion);
        dest.writeInt(this.networkSecurityConfigRes);
        dest.writeCharSequence(this.nonLocalizedLabel);
        dest.writeString(this.permission);
        dest.writeString(this.processName);
        dest.writeInt(this.requiresSmallestWidthDp);
        dest.writeInt(this.roundIconRes);
        dest.writeInt(this.targetSandboxVersion);
        dest.writeInt(this.targetSdkVersion);
        dest.writeString(this.taskAffinity);
        dest.writeInt(this.theme);
        dest.writeInt(this.uiOptions);
        dest.writeString(this.zygotePreloadName);
        dest.writeStringArray(this.splitClassLoaderNames);
        dest.writeStringArray(this.splitCodePaths);
        dest.writeSparseArray(this.splitDependencies);
        dest.writeIntArray(this.splitFlags);
        dest.writeStringArray(this.splitNames);
        dest.writeIntArray(this.splitRevisionCodes);
        sForBoolean.parcel(this.resizeableActivity, dest, flags);
        dest.writeInt(this.autoRevokePermissions);
        sForInternedStringSet.parcel(this.mimeGroups, dest, flags);
        dest.writeInt(this.gwpAsanMode);
        dest.writeSparseIntArray(this.minExtensionVersions);
        dest.writeMap(this.mProperties);
        dest.writeInt(this.memtagMode);
        dest.writeInt(this.nativeHeapZeroInitialized);
        sForBoolean.parcel(this.requestRawExternalStorageAccess, dest, flags);
        dest.writeInt(this.mLocaleConfigRes);
        sForStringSet.parcel(this.mKnownActivityEmbeddingCerts, dest, flags);
        sForInternedString.parcel(this.manifestPackageName, dest, flags);
        dest.writeString(this.nativeLibraryDir);
        dest.writeString(this.nativeLibraryRootDir);
        dest.writeBoolean(this.nativeLibraryRootRequiresIsa);
        sForInternedString.parcel(this.primaryCpuAbi, dest, flags);
        sForInternedString.parcel(this.secondaryCpuAbi, dest, flags);
        dest.writeString(this.secondaryNativeLibraryDir);
        dest.writeInt(this.uid);
        dest.writeLong(this.mBooleans);
        dest.writeLong(this.mBooleans2);
        dest.writeBoolean(this.mAllowCrossUidActivitySwitchFromBelow);
        dest.writeInt(this.mIntentMatchingFlags);
        dest.writeIntArray(this.mAlternateLauncherIconResIds);
        dest.writeIntArray(this.mAlternateLauncherLabelResIds);
        dest.writeInt(this.mPageSizeAppCompatFlags);
    }

    private void writeFeatureFlagState(@NonNull Parcel dest) {
        int featureFlagCount = this.mFeatureFlagState.size();
        String[] featureFlagStateAsArray = new String[featureFlagCount];
        Iterator<Map.Entry<String, Boolean>> entryIterator = this.mFeatureFlagState.entrySet().iterator();
        for (int i = 0; i < featureFlagCount; ++i) {
            Map.Entry<String, Boolean> entry = entryIterator.next();
            Boolean flagValue = entry.getValue();
            featureFlagStateAsArray[i] = flagValue == null ? entry.getKey() + "=?" : (flagValue != false ? entry.getKey() + "=1" : entry.getKey() + "=0");
        }
        dest.writeStringArray(featureFlagStateAsArray);
    }

    public PackageImpl(Parcel in) {
        this(in, null);
    }

    public PackageImpl(@NonNull Parcel in, @Nullable ParsingPackageUtils.Callback callback) {
        int index;
        this.mCallback = callback;
        ClassLoader boot = Object.class.getClassLoader();
        this.readFeatureFlagState(in);
        this.supportsSmallScreens = sForBoolean.unparcel(in);
        this.supportsNormalScreens = sForBoolean.unparcel(in);
        this.supportsLargeScreens = sForBoolean.unparcel(in);
        this.supportsExtraLargeScreens = sForBoolean.unparcel(in);
        this.resizeable = sForBoolean.unparcel(in);
        this.anyDensity = sForBoolean.unparcel(in);
        this.versionCode = in.readInt();
        this.versionCodeMajor = in.readInt();
        this.baseRevisionCode = in.readInt();
        this.versionName = sForInternedString.unparcel(in);
        this.compileSdkVersion = in.readInt();
        this.compileSdkVersionCodeName = in.readString();
        this.packageName = sForInternedString.unparcel(in);
        this.mBaseApkPath = in.readString();
        this.restrictedAccountType = in.readString();
        this.requiredAccountType = in.readString();
        this.mEmergencyInstaller = in.readString();
        this.overlayTarget = sForInternedString.unparcel(in);
        this.overlayTargetOverlayableName = in.readString();
        this.overlayCategory = in.readString();
        this.overlayPriority = in.readInt();
        this.overlayables = sForInternedStringValueMap.unparcel(in);
        this.sdkLibraryName = sForInternedString.unparcel(in);
        this.sdkLibVersionMajor = in.readInt();
        this.staticSharedLibraryName = sForInternedString.unparcel(in);
        this.staticSharedLibVersion = in.readLong();
        this.libraryNames = sForInternedStringList.unparcel(in);
        this.usesLibraries = sForInternedStringList.unparcel(in);
        this.usesOptionalLibraries = sForInternedStringList.unparcel(in);
        this.usesNativeLibraries = sForInternedStringList.unparcel(in);
        this.usesOptionalNativeLibraries = sForInternedStringList.unparcel(in);
        this.usesStaticLibraries = sForInternedStringList.unparcel(in);
        this.usesStaticLibrariesVersions = in.createLongArray();
        int digestsSize = in.readInt();
        if (digestsSize >= 0) {
            this.usesStaticLibrariesCertDigests = new String[digestsSize][];
            for (index = 0; index < digestsSize; ++index) {
                this.usesStaticLibrariesCertDigests[index] = sForInternedStringArray.unparcel(in);
            }
        }
        this.usesSdkLibraries = sForInternedStringList.unparcel(in);
        this.usesSdkLibrariesVersionsMajor = in.createLongArray();
        digestsSize = in.readInt();
        if (digestsSize >= 0) {
            this.usesSdkLibrariesCertDigests = new String[digestsSize][];
            for (index = 0; index < digestsSize; ++index) {
                this.usesSdkLibrariesCertDigests[index] = sForInternedStringArray.unparcel(in);
            }
        }
        this.usesSdkLibrariesOptional = in.createBooleanArray();
        this.sharedUserId = sForInternedString.unparcel(in);
        this.sharedUserLabel = in.readInt();
        this.configPreferences = in.createTypedArrayList(ConfigurationInfo.CREATOR);
        this.reqFeatures = in.createTypedArrayList(FeatureInfo.CREATOR);
        this.featureGroups = in.createTypedArrayList(FeatureGroupInfo.CREATOR);
        this.restrictUpdateHash = in.createByteArray();
        this.originalPackages = in.createStringArrayList();
        this.adoptPermissions = sForInternedStringList.unparcel(in);
        this.requestedPermissions = sForInternedStringSet.unparcel(in);
        this.usesPermissions = ParsingUtils.createTypedInterfaceList(in, ParsedUsesPermissionImpl.CREATOR);
        this.implicitPermissions = sForInternedStringSet.unparcel(in);
        this.upgradeKeySets = sForStringSet.unparcel(in);
        this.keySetMapping = ParsingPackageUtils.readKeySetMapping(in);
        this.protectedBroadcasts = sForInternedStringList.unparcel(in);
        this.activities = ParsingUtils.createTypedInterfaceList(in, ParsedActivityImpl.CREATOR);
        this.apexSystemServices = ParsingUtils.createTypedInterfaceList(in, ParsedApexSystemServiceImpl.CREATOR);
        this.receivers = ParsingUtils.createTypedInterfaceList(in, ParsedActivityImpl.CREATOR);
        this.services = ParsingUtils.createTypedInterfaceList(in, ParsedServiceImpl.CREATOR);
        this.providers = ParsingUtils.createTypedInterfaceList(in, ParsedProviderImpl.CREATOR);
        this.attributions = ParsingUtils.createTypedInterfaceList(in, ParsedAttributionImpl.CREATOR);
        this.permissions = ParsingUtils.createTypedInterfaceList(in, ParsedPermissionImpl.CREATOR);
        this.permissionGroups = ParsingUtils.createTypedInterfaceList(in, ParsedPermissionGroupImpl.CREATOR);
        this.instrumentations = ParsingUtils.createTypedInterfaceList(in, ParsedInstrumentationImpl.CREATOR);
        this.preferredActivityFilters = sForIntentInfoPairs.unparcel(in);
        this.processes = in.readHashMap(ParsedProcessImpl.class.getClassLoader());
        this.metaData = in.readBundle(boot);
        this.volumeUuid = sForInternedString.unparcel(in);
        this.signingDetails = in.readParcelable(boot, SigningDetails.class);
        this.mPath = in.readString();
        this.queriesIntents = in.createTypedArrayList(Intent.CREATOR);
        this.queriesPackages = sForInternedStringList.unparcel(in);
        this.queriesProviders = sForInternedStringSet.unparcel(in);
        this.appComponentFactory = in.readString();
        this.backupAgentName = in.readString();
        this.banner = in.readInt();
        this.category = in.readInt();
        this.classLoaderName = in.readString();
        this.className = in.readString();
        this.compatibleWidthLimitDp = in.readInt();
        this.descriptionRes = in.readInt();
        this.fullBackupContent = in.readInt();
        this.dataExtractionRules = in.readInt();
        this.iconRes = in.readInt();
        this.installLocation = in.readInt();
        this.labelRes = in.readInt();
        this.largestWidthLimitDp = in.readInt();
        this.logo = in.readInt();
        this.manageSpaceActivityName = in.readString();
        this.maxAspectRatio = in.readFloat();
        this.minAspectRatio = in.readFloat();
        this.minSdkVersion = in.readInt();
        this.maxSdkVersion = in.readInt();
        this.networkSecurityConfigRes = in.readInt();
        this.nonLocalizedLabel = in.readCharSequence();
        this.permission = in.readString();
        this.processName = in.readString();
        this.requiresSmallestWidthDp = in.readInt();
        this.roundIconRes = in.readInt();
        this.targetSandboxVersion = in.readInt();
        this.targetSdkVersion = in.readInt();
        this.taskAffinity = in.readString();
        this.theme = in.readInt();
        this.uiOptions = in.readInt();
        this.zygotePreloadName = in.readString();
        this.splitClassLoaderNames = in.createStringArray();
        this.splitCodePaths = in.createStringArray();
        this.splitDependencies = in.readSparseArray(boot);
        this.splitFlags = in.createIntArray();
        this.splitNames = in.createStringArray();
        this.splitRevisionCodes = in.createIntArray();
        this.resizeableActivity = sForBoolean.unparcel(in);
        this.autoRevokePermissions = in.readInt();
        this.mimeGroups = sForInternedStringSet.unparcel(in);
        this.gwpAsanMode = in.readInt();
        this.minExtensionVersions = in.readSparseIntArray();
        this.mProperties = in.readHashMap(boot);
        this.memtagMode = in.readInt();
        this.nativeHeapZeroInitialized = in.readInt();
        this.requestRawExternalStorageAccess = sForBoolean.unparcel(in);
        this.mLocaleConfigRes = in.readInt();
        this.mKnownActivityEmbeddingCerts = sForStringSet.unparcel(in);
        this.manifestPackageName = sForInternedString.unparcel(in);
        this.nativeLibraryDir = in.readString();
        this.nativeLibraryRootDir = in.readString();
        this.nativeLibraryRootRequiresIsa = in.readBoolean();
        this.primaryCpuAbi = sForInternedString.unparcel(in);
        this.secondaryCpuAbi = sForInternedString.unparcel(in);
        this.secondaryNativeLibraryDir = in.readString();
        this.uid = in.readInt();
        this.mBooleans = in.readLong();
        this.mBooleans2 = in.readLong();
        this.mAllowCrossUidActivitySwitchFromBelow = in.readBoolean();
        this.mIntentMatchingFlags = in.readInt();
        this.mAlternateLauncherIconResIds = in.createIntArray();
        this.mAlternateLauncherLabelResIds = in.createIntArray();
        this.mPageSizeAppCompatFlags = in.readInt();
        this.assignDerivedFields();
        this.assignDerivedFields2();
    }

    private void readFeatureFlagState(@NonNull Parcel in) {
        String[] featureFlagStateAsArray;
        for (String s : featureFlagStateAsArray = in.createStringArray()) {
            int sepIndex = s.lastIndexOf(61);
            if (sepIndex < 0 || sepIndex != s.length() - 2) continue;
            String flagPackageAndName = s.substring(0, sepIndex);
            char c = s.charAt(sepIndex + 1);
            Boolean flagValue = null;
            if (c == '1') {
                flagValue = Boolean.TRUE;
            } else if (c == '0') {
                flagValue = Boolean.FALSE;
            } else if (c != '?') continue;
            this.mFeatureFlagState.put(flagPackageAndName, flagValue);
        }
    }

    @Override
    @NonNull
    public String getManifestPackageName() {
        return this.manifestPackageName;
    }

    @Override
    public boolean isStub() {
        return this.getBoolean2(1L);
    }

    @Override
    @Nullable
    public String getNativeLibraryDir() {
        return this.nativeLibraryDir;
    }

    @Override
    @Nullable
    public String getNativeLibraryRootDir() {
        return this.nativeLibraryRootDir;
    }

    @Override
    public boolean isNativeLibraryRootRequiresIsa() {
        return this.nativeLibraryRootRequiresIsa;
    }

    @Override
    @Nullable
    public String getPrimaryCpuAbi() {
        return this.primaryCpuAbi;
    }

    @Override
    @Nullable
    public String getSecondaryCpuAbi() {
        return this.secondaryCpuAbi;
    }

    @Override
    @Nullable
    public String getSecondaryNativeLibraryDir() {
        return this.secondaryNativeLibraryDir;
    }

    @Override
    public boolean isCoreApp() {
        return this.getBoolean(0x10000000000000L);
    }

    @Override
    public boolean isSystem() {
        return this.getBoolean(0x20000000000000L);
    }

    @Override
    public boolean isUpdatableSystem() {
        return this.getBoolean2(4L);
    }

    @Override
    public boolean isFactoryTest() {
        return this.getBoolean(0x40000000000000L);
    }

    @Override
    public boolean isApex() {
        return this.getBoolean2(2L);
    }

    @Override
    public boolean isSystemExt() {
        return this.getBoolean(0x100000000000000L);
    }

    @Override
    public boolean isPrivileged() {
        return this.getBoolean(0x200000000000000L);
    }

    @Override
    public boolean isOem() {
        return this.getBoolean(0x400000000000000L);
    }

    @Override
    public boolean isVendor() {
        return this.getBoolean(0x800000000000000L);
    }

    @Override
    public boolean isProduct() {
        return this.getBoolean(0x1000000000000000L);
    }

    @Override
    public boolean isOdm() {
        return this.getBoolean(0x2000000000000000L);
    }

    @Override
    public boolean isSignedWithPlatformKey() {
        return this.getBoolean(0x4000000000000000L);
    }

    @Override
    public int getUid() {
        return this.uid;
    }

    @Override
    public PackageImpl setStub(boolean value) {
        this.setBoolean2(1L, value);
        return this;
    }

    @Override
    public PackageImpl setNativeLibraryRootRequiresIsa(boolean value) {
        this.nativeLibraryRootRequiresIsa = value;
        return this;
    }

    @Override
    public PackageImpl setSystem(boolean value) {
        this.setBoolean(0x20000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setUpdatableSystem(boolean value) {
        return this.setBoolean2(4L, value);
    }

    @Override
    public PackageImpl setFactoryTest(boolean value) {
        this.setBoolean(0x40000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setApex(boolean isApex) {
        this.setBoolean2(2L, isApex);
        return this;
    }

    @Override
    public PackageImpl setSystemExt(boolean value) {
        this.setBoolean(0x100000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setPrivileged(boolean value) {
        this.setBoolean(0x200000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setOem(boolean value) {
        this.setBoolean(0x400000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setVendor(boolean value) {
        this.setBoolean(0x800000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setProduct(boolean value) {
        this.setBoolean(0x1000000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setOdm(boolean value) {
        this.setBoolean(0x2000000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setSignedWithPlatformKey(boolean value) {
        this.setBoolean(0x4000000000000000L, value);
        return this;
    }

    @Override
    public PackageImpl setUid(int value) {
        this.uid = value;
        return this;
    }

    @Override
    public ParsingPackage setIntentMatchingFlags(int intentMatchingFlags) {
        this.mIntentMatchingFlags = intentMatchingFlags;
        return this;
    }

    @Override
    public int getIntentMatchingFlags() {
        return this.mIntentMatchingFlags;
    }

    public String getBaseAppDataCredentialProtectedDirForSystemUser() {
        return this.mBaseAppDataCredentialProtectedDirForSystemUser;
    }

    public String getBaseAppDataDeviceProtectedDirForSystemUser() {
        return this.mBaseAppDataDeviceProtectedDirForSystemUser;
    }

    @Override
    public PackageImpl addFeatureFlag(@NonNull String flagPackageAndName, @Nullable Boolean flagValue) {
        this.mFeatureFlagState.put(flagPackageAndName, flagValue);
        return this;
    }

    public Map<String, Boolean> getFeatureFlagState() {
        return this.mFeatureFlagState;
    }

    private static class Booleans {
        private static final long EXTERNAL_STORAGE = 1L;
        private static final long HARDWARE_ACCELERATED = 2L;
        private static final long ALLOW_BACKUP = 4L;
        private static final long KILL_AFTER_RESTORE = 8L;
        private static final long RESTORE_ANY_VERSION = 16L;
        private static final long FULL_BACKUP_ONLY = 32L;
        private static final long PERSISTENT = 64L;
        private static final long DEBUGGABLE = 128L;
        private static final long VM_SAFE_MODE = 256L;
        private static final long HAS_CODE = 512L;
        private static final long ALLOW_TASK_REPARENTING = 1024L;
        private static final long ALLOW_CLEAR_USER_DATA = 2048L;
        private static final long LARGE_HEAP = 4096L;
        private static final long USES_CLEARTEXT_TRAFFIC = 8192L;
        private static final long SUPPORTS_RTL = 16384L;
        private static final long TEST_ONLY = 32768L;
        private static final long MULTI_ARCH = 65536L;
        private static final long EXTRACT_NATIVE_LIBS = 131072L;
        private static final long GAME = 262144L;
        private static final long STATIC_SHARED_LIBRARY = 524288L;
        private static final long OVERLAY = 0x100000L;
        private static final long ISOLATED_SPLIT_LOADING = 0x200000L;
        private static final long HAS_DOMAIN_URLS = 0x400000L;
        private static final long PROFILEABLE_BY_SHELL = 0x800000L;
        private static final long BACKUP_IN_FOREGROUND = 0x1000000L;
        private static final long USE_EMBEDDED_DEX = 0x2000000L;
        private static final long DEFAULT_TO_DEVICE_PROTECTED_STORAGE = 0x4000000L;
        private static final long DIRECT_BOOT_AWARE = 0x8000000L;
        private static final long PARTIALLY_DIRECT_BOOT_AWARE = 0x10000000L;
        private static final long RESIZEABLE_ACTIVITY_VIA_SDK_VERSION = 0x20000000L;
        private static final long ALLOW_CLEAR_USER_DATA_ON_FAILED_RESTORE = 0x40000000L;
        private static final long ALLOW_AUDIO_PLAYBACK_CAPTURE = 0x80000000L;
        private static final long REQUEST_LEGACY_EXTERNAL_STORAGE = 0x100000000L;
        private static final long USES_NON_SDK_API = 0x200000000L;
        private static final long HAS_FRAGILE_USER_DATA = 0x400000000L;
        private static final long CANT_SAVE_STATE = 0x800000000L;
        private static final long ALLOW_NATIVE_HEAP_POINTER_TAGGING = 0x1000000000L;
        private static final long PRESERVE_LEGACY_EXTERNAL_STORAGE = 0x2000000000L;
        private static final long REQUIRED_FOR_ALL_USERS = 0x4000000000L;
        private static final long OVERLAY_IS_STATIC = 0x8000000000L;
        private static final long USE_32_BIT_ABI = 0x10000000000L;
        private static final long VISIBLE_TO_INSTANT_APPS = 0x20000000000L;
        private static final long FORCE_QUERYABLE = 0x40000000000L;
        private static final long CROSS_PROFILE = 0x80000000000L;
        private static final long ENABLED = 0x100000000000L;
        private static final long DISALLOW_PROFILING = 0x200000000000L;
        private static final long REQUEST_FOREGROUND_SERVICE_EXEMPTION = 0x400000000000L;
        private static final long ATTRIBUTIONS_ARE_USER_VISIBLE = 0x800000000000L;
        private static final long RESET_ENABLED_SETTINGS_ON_APP_DATA_CLEARED = 0x1000000000000L;
        private static final long SDK_LIBRARY = 0x2000000000000L;
        private static final long ENABLE_ON_BACK_INVOKED_CALLBACK = 0x4000000000000L;
        private static final long LEAVING_SHARED_UID = 0x8000000000000L;
        private static final long CORE_APP = 0x10000000000000L;
        private static final long SYSTEM = 0x20000000000000L;
        private static final long FACTORY_TEST = 0x40000000000000L;
        private static final long SYSTEM_EXT = 0x100000000000000L;
        private static final long PRIVILEGED = 0x200000000000000L;
        private static final long OEM = 0x400000000000000L;
        private static final long VENDOR = 0x800000000000000L;
        private static final long PRODUCT = 0x1000000000000000L;
        private static final long ODM = 0x2000000000000000L;
        private static final long SIGNED_WITH_PLATFORM_KEY = 0x4000000000000000L;
        private static final long NATIVE_LIBRARY_ROOT_REQUIRES_ISA = Long.MIN_VALUE;

        private Booleans() {
        }

        public static @interface Flags {
        }
    }

    private static class Booleans2 {
        private static final long STUB = 1L;
        private static final long APEX = 2L;
        private static final long UPDATABLE_SYSTEM = 4L;

        private Booleans2() {
        }

        public static @interface Flags {
        }
    }
}

