/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.aconfig.DeviceProtos;
import android.aconfig.nano.Aconfig;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Environment;
import android.os.Process;
import android.os.flagging.AconfigPackage;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.provider.flags.Flags;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.modules.utils.TypedXmlPullParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AconfigFlags {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AconfigFlags";
    private static final String OVERRIDE_PREFIX = "device_config_overrides/";
    private static final String STAGED_PREFIX = "staged/";
    private final Map<String, Boolean> mFlagValues = new ArrayMap<String, Boolean>();
    private final Map<String, AconfigPackage> mAconfigPackages = new ConcurrentHashMap<String, AconfigPackage>();

    public AconfigFlags() {
        if (!android.content.res.Flags.manifestFlagging()) {
            return;
        }
        if (AconfigFlags.useNewStorage()) {
            Slog.i(LOG_TAG, "Using new flag storage");
        } else {
            Slog.i(LOG_TAG, "Using OLD proto flag storage");
            List<String> defaultFlagProtoFiles = Process.myUid() == 1000 ? DeviceProtos.parsedFlagsProtoPaths() : Arrays.asList(DeviceProtos.PATHS);
            for (String fileName : defaultFlagProtoFiles) {
                File protoFile = new File(fileName);
                if (!protoFile.isFile() || !protoFile.canRead()) continue;
                try (FileInputStream inputStream = new FileInputStream(protoFile);){
                    this.loadAconfigDefaultValues(inputStream.readAllBytes());
                }
                catch (IOException e) {
                    Slog.w(LOG_TAG, "Failed to read Aconfig values from " + fileName, e);
                }
            }
            if (Process.myUid() == 1000) {
                this.loadServerOverrides();
            }
        }
    }

    private static boolean useNewStorage() {
        return Flags.newStoragePublicApi() && android.content.res.Flags.useNewAconfigStorage();
    }

    private void loadServerOverrides() {
        File settingsFile = new File(Environment.getUserSystemDirectory(0), "settings_config.xml");
        if (!settingsFile.isFile() || !settingsFile.canRead()) {
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(settingsFile);){
            TypedXmlPullParser parser = Xml.resolvePullParser(inputStream);
            if (parser.next() != 3 && "settings".equals(parser.getName())) {
                int type;
                ArrayMap<String, Integer> flagPriority = new ArrayMap<String, Integer>();
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    Integer currentPriority;
                    String flagPackageAndName;
                    if (type == 3 || type == 4 || !"setting".equals(parser.getName())) continue;
                    String name = parser.getAttributeValue(null, "name");
                    String value = parser.getAttributeValue(null, "value");
                    if (name == null || value == null || !"false".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value)) continue;
                    String separator = "/";
                    String prefix = "default";
                    int priority = 0;
                    if (name.startsWith(OVERRIDE_PREFIX)) {
                        prefix = OVERRIDE_PREFIX;
                        name = name.substring(OVERRIDE_PREFIX.length());
                        separator = ":";
                        priority = 20;
                    } else if (name.startsWith(STAGED_PREFIX)) {
                        prefix = STAGED_PREFIX;
                        name = name.substring(STAGED_PREFIX.length());
                        separator = "*";
                        priority = 10;
                    }
                    if ((flagPackageAndName = AconfigFlags.parseFlagPackageAndName(name, separator)) == null || !this.mFlagValues.containsKey(flagPackageAndName) || (currentPriority = (Integer)flagPriority.get(flagPackageAndName)) != null && currentPriority >= priority) continue;
                    flagPriority.put(flagPackageAndName, priority);
                    this.mFlagValues.put(flagPackageAndName, Boolean.parseBoolean(value));
                }
            }
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(LOG_TAG, "Failed to read Aconfig values from settings_config.xml", e);
        }
    }

    private static String parseFlagPackageAndName(String fullName, String separator) {
        int index = fullName.indexOf(separator);
        if (index < 0) {
            return null;
        }
        return fullName.substring(index + 1);
    }

    private void loadAconfigDefaultValues(byte[] fileContents) throws IOException {
        Aconfig.parsed_flags parsedFlags = Aconfig.parsed_flags.parseFrom(fileContents);
        for (Aconfig.parsed_flag flag : parsedFlags.parsedFlag) {
            String flagPackageAndName = flag.package_ + "." + flag.name;
            boolean flagValue = flag.state == 1;
            this.mFlagValues.put(flagPackageAndName, flagValue);
        }
    }

    @Nullable
    public Boolean getFlagValue(@NonNull String flagPackageAndName) {
        if (AconfigFlags.useNewStorage()) {
            return this.getFlagValueFromNewStorage(flagPackageAndName);
        }
        Boolean value = this.mFlagValues.get(flagPackageAndName);
        return value;
    }

    private Boolean getFlagValueFromNewStorage(String flagPackageAndName) {
        if (!this.mFlagValues.isEmpty() && this.mFlagValues.containsKey(flagPackageAndName)) {
            Boolean value = this.mFlagValues.get(flagPackageAndName);
            return value;
        }
        int index = flagPackageAndName.lastIndexOf(46);
        if (index < 0) {
            Slog.e(LOG_TAG, "Unable to parse package name from " + flagPackageAndName);
            return null;
        }
        String flagPackage = flagPackageAndName.substring(0, index);
        String flagName = flagPackageAndName.substring(index + 1);
        Boolean value = null;
        AconfigPackage aconfigPackage = this.mAconfigPackages.computeIfAbsent(flagPackage, p -> {
            try {
                return AconfigPackage.load(p);
            }
            catch (Exception e) {
                Slog.e(LOG_TAG, "Failed to load aconfig package " + p, e);
                return null;
            }
        });
        if (aconfigPackage != null) {
            try {
                value = aconfigPackage.getBooleanFlagValue(flagName, false);
            }
            catch (Exception e) {
                Slog.e(LOG_TAG, "Failed to read Aconfig flag value for " + flagPackageAndName, e);
                return null;
            }
        }
        return value;
    }

    public boolean skipCurrentElement(@Nullable ParsingPackage pkg, @NonNull XmlPullParser parser) {
        return this.skipCurrentElement(pkg, parser, false);
    }

    public boolean skipCurrentElement(@Nullable ParsingPackage pkg, @NonNull XmlPullParser parser, boolean allowNoNamespace) {
        if (!android.content.res.Flags.manifestFlagging()) {
            return false;
        }
        String featureFlag = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "featureFlag");
        if (featureFlag == null && allowNoNamespace) {
            featureFlag = parser.getAttributeValue(null, "featureFlag");
        }
        if (featureFlag == null) {
            return false;
        }
        featureFlag = featureFlag.strip();
        boolean negated = false;
        if (featureFlag.startsWith("!")) {
            negated = true;
            featureFlag = featureFlag.substring(1).strip();
        }
        Boolean flagValue = this.getFlagValue(featureFlag);
        boolean isUndefined = false;
        if (flagValue == null) {
            isUndefined = true;
            flagValue = false;
        }
        boolean shouldSkip = false;
        if (flagValue == negated) {
            shouldSkip = true;
        }
        if (pkg != null && com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags.includeFeatureFlagsInPackageCacher()) {
            if (isUndefined) {
                pkg.addFeatureFlag(featureFlag, null);
            } else {
                pkg.addFeatureFlag(featureFlag, flagValue);
            }
        }
        return shouldSkip;
    }

    @VisibleForTesting
    public void addFlagValuesForTesting(@NonNull Map<String, Boolean> flagValues) {
        this.mFlagValues.putAll(flagValues);
    }
}

