/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityTaskManager;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.parsing.FrameworkParsingPackageUtils;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.ParsedActivity;
import com.android.internal.pm.pkg.component.ParsedActivityImpl;
import com.android.internal.pm.pkg.component.ParsedComponentUtils;
import com.android.internal.pm.pkg.component.ParsedIntentInfoImpl;
import com.android.internal.pm.pkg.component.ParsedMainComponentUtils;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedActivityUtils {
    private static final String TAG = "PackageParsing";
    public static final boolean LOG_UNSAFE_BROADCASTS = false;
    public static final Set<String> SAFE_BROADCASTS = new ArraySet<String>();
    private static final int RECREATE_ON_CONFIG_CHANGES_MASK = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static ParseResult<ParsedActivity> parseActivityOrReceiver(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, boolean useRoundIcon, @Nullable String defaultSplitName, ParseInput input) throws XmlPullParserException, IOException {
        String packageName = pkg.getPackageName();
        ParsedActivityImpl activity = new ParsedActivityImpl();
        boolean receiver = "receiver".equals(parser.getName());
        String tag = "<" + parser.getName() + ">";
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivity);
        try {
            String requiredDisplayCategory;
            ParseResult<ParsedActivityImpl> result = ParsedMainComponentUtils.parseMainComponent(activity, tag, separateProcesses, pkg, sa, flags, useRoundIcon, defaultSplitName, input, 30, 17, 42, 5, 2, 1, 23, 3, 7, 44, 48, 57, 66);
            if (result.isError()) {
                ParseResult<ParsedActivity> parseResult = input.error(result);
                return parseResult;
            }
            if (receiver && pkg.isSaveStateDisallowed() && Objects.equals(activity.getProcessName(), packageName)) {
                ParseResult<ParsedActivity> parseResult = input.error("Heavy-weight applications can not have receivers in main process");
                return parseResult;
            }
            activity.setTheme(sa.getResourceId(0, 0)).setUiOptions(sa.getInt(26, pkg.getUiOptions()));
            activity.setFlags(activity.getFlags() | (ComponentParseUtils.flag(64, 19, pkg.isTaskReparentingAllowed(), sa) | ComponentParseUtils.flag(8, 18, sa) | ComponentParseUtils.flag(4, 11, sa) | ComponentParseUtils.flag(32, 13, sa) | ComponentParseUtils.flag(256, 22, sa) | ComponentParseUtils.flag(2, 10, sa) | ComponentParseUtils.flag(2048, 24, sa) | ComponentParseUtils.flag(1, 9, sa) | ComponentParseUtils.flag(128, 21, sa) | ComponentParseUtils.flag(1024, 39, sa) | ComponentParseUtils.flag(1024, 29, sa) | ComponentParseUtils.flag(16, 12, sa) | ComponentParseUtils.flag(0x20000000, 64, sa)));
            if (!receiver) {
                activity.setFlags(activity.getFlags() | (ComponentParseUtils.flag(512, 25, pkg.isHardwareAccelerated(), sa) | ComponentParseUtils.flag(Integer.MIN_VALUE, 31, sa) | ComponentParseUtils.flag(262144, 67, sa) | ComponentParseUtils.flag(8192, 35, sa) | ComponentParseUtils.flag(4096, 36, sa) | ComponentParseUtils.flag(16384, 37, sa) | ComponentParseUtils.flag(0x800000, 51, sa) | ComponentParseUtils.flag(0x400000, 41, sa) | ComponentParseUtils.flag(0x1000000, 52, sa) | ComponentParseUtils.flag(0x2000000, 56, sa)) | ComponentParseUtils.flag(0x10000000, 60, sa));
                activity.setPrivateFlags(activity.getPrivateFlags() | (ComponentParseUtils.flag(1, 54, sa) | ComponentParseUtils.flag(2, 58, true, sa)));
                activity.setColorMode(sa.getInt(49, 0)).setDocumentLaunchMode(sa.getInt(33, 0)).setLaunchMode(sa.getInt(14, 0)).setLockTaskLaunchMode(sa.getInt(38, 0)).setMaxRecents(sa.getInt(34, ActivityTaskManager.getDefaultAppRecentsLimitStatic())).setPersistableMode(sa.getInteger(32, 0)).setRequestedVrComponent(sa.getString(43)).setRotationAnimation(sa.getInt(46, -1)).setSoftInputMode(sa.getInt(20, 0)).setConfigChanges(ParsedActivityUtils.getActivityConfigChanges(sa.getInt(16, 0), sa.getInt(47, 0)));
                int screenOrientation = sa.getInt(15, -1);
                int resizeMode = ParsedActivityUtils.getActivityResizeMode(pkg, sa, screenOrientation);
                activity.setScreenOrientation(screenOrientation).setResizeMode(resizeMode);
                if (sa.hasValue(50) && sa.getType(50) == 4) {
                    activity.setMaxAspectRatio(resizeMode, sa.getFloat(50, 0.0f));
                }
                if (sa.hasValue(53) && sa.getType(53) == 4) {
                    activity.setMinAspectRatio(resizeMode, sa.getFloat(53, 0.0f));
                }
                if (sa.hasValue(62)) {
                    boolean enable = sa.getBoolean(62, false);
                    activity.setPrivateFlags(activity.getPrivateFlags() | (enable ? 4 : 8));
                }
            } else {
                activity.setLaunchMode(0).setConfigChanges(0).setFlags(activity.getFlags() | ComponentParseUtils.flag(0x40000000, 28, sa));
            }
            String taskAffinity = sa.getNonConfigurationString(8, 1024);
            ParseResult<String> affinityNameResult = ComponentParseUtils.buildTaskAffinityName(packageName, pkg.getTaskAffinity(), taskAffinity, input);
            if (affinityNameResult.isError()) {
                ParseResult<ParsedActivity> enable = input.error(affinityNameResult);
                return enable;
            }
            activity.setTaskAffinity(affinityNameResult.getResult());
            boolean visibleToEphemeral = sa.getBoolean(45, false);
            if (visibleToEphemeral) {
                activity.setFlags(activity.getFlags() | 0x100000);
                pkg.setVisibleToInstantApps(true);
            }
            if ((requiredDisplayCategory = sa.getNonConfigurationString(63, 0)) != null && FrameworkParsingPackageUtils.validateName(requiredDisplayCategory, false, false) != null) {
                ParseResult<ParsedActivity> parseResult = input.error("requiredDisplayCategory attribute can only consist of alphanumeric characters, '_', and '.'");
                return parseResult;
            }
            activity.setRequiredDisplayCategory(requiredDisplayCategory);
            activity.setRequireContentUriPermissionFromCaller(sa.getInt(65, 0));
            ParseResult<ParsedActivity> parseResult = ParsedActivityUtils.parseActivityOrAlias(activity, pkg, tag, parser, res, sa, receiver, false, visibleToEphemeral, input, 27, 4, 6);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ParseResult<ParsedActivity> parseActivityAlias(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, @Nullable String defaultSplitName, @NonNull ParseInput input) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivityAlias);
        try {
            String tag;
            String targetActivity = sa.getNonConfigurationString(7, 1024);
            if (targetActivity == null) {
                ParseResult<ParsedActivity> parseResult = input.error("<activity-alias> does not specify android:targetActivity");
                return parseResult;
            }
            String packageName = pkg.getPackageName();
            targetActivity = ParsingUtils.buildClassName(packageName, targetActivity);
            if (targetActivity == null) {
                ParseResult<ParsedActivity> parseResult = input.error("Empty class name in package " + packageName);
                return parseResult;
            }
            ParsedActivity target = null;
            List<ParsedActivity> activities = pkg.getActivities();
            int activitiesSize = ArrayUtils.size(activities);
            for (int i = 0; i < activitiesSize; ++i) {
                ParsedActivity t = activities.get(i);
                if (!targetActivity.equals(t.getName())) continue;
                target = t;
                break;
            }
            if (target == null) {
                ParseResult<ParsedActivity> i = input.error("<activity-alias> target activity " + targetActivity + " not found in manifest with activities = " + pkg.getActivities() + ", parsedActivities = " + activities);
                return i;
            }
            ParsedActivityImpl activity = ParsedActivityImpl.makeAlias(targetActivity, target);
            ParseResult<ParsedActivityImpl> result = ParsedMainComponentUtils.parseMainComponent(activity, tag = "<" + parser.getName() + ">", null, pkg, sa, 0, useRoundIcon, defaultSplitName, input, 10, 6, -1, 4, 1, 0, 8, 2, -1, 11, -1, 12, 15);
            if (result.isError()) {
                ParseResult<ParsedActivity> parseResult = input.error(result);
                return parseResult;
            }
            boolean visibleToEphemeral = (activity.getFlags() & 0x100000) != 0;
            ParseResult<ParsedActivity> parseResult = ParsedActivityUtils.parseActivityOrAlias(activity, pkg, tag, parser, res, sa, false, true, visibleToEphemeral, input, 9, 3, 5);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    @NonNull
    private static ParseResult<ParsedActivity> parseActivityOrAlias(ParsedActivityImpl activity, ParsingPackage pkg, String tag, XmlResourceParser parser, Resources resources, TypedArray array2, boolean isReceiver, boolean isAlias, boolean visibleToEphemeral, ParseInput input, int parentActivityNameAttr, int permissionAttr, int exportedAttr) throws IOException, XmlPullParserException {
        ParseResult<ActivityInfo.WindowLayout> layoutResult;
        String launchMode;
        int type;
        boolean setExported;
        String parentActivityName = array2.getNonConfigurationString(parentActivityNameAttr, 1024);
        if (parentActivityName != null) {
            String packageName = pkg.getPackageName();
            String parentClassName = ParsingUtils.buildClassName(packageName, parentActivityName);
            if (parentClassName == null) {
                Log.e(TAG, "Activity " + activity.getName() + " specified invalid parentActivityName " + parentActivityName);
            } else {
                activity.setParentActivityName(parentClassName);
            }
        }
        String permission2 = array2.getNonConfigurationString(permissionAttr, 0);
        if (isAlias) {
            activity.setPermission(permission2);
        } else {
            activity.setPermission(permission2 != null ? permission2 : pkg.getPermission());
        }
        ParseResult<Set<String>> knownActivityEmbeddingCertsResult = ParsingUtils.parseKnownActivityEmbeddingCerts(array2, resources, isAlias ? 14 : 61, input);
        if (knownActivityEmbeddingCertsResult.isError()) {
            return input.error(knownActivityEmbeddingCertsResult);
        }
        Set<String> knownActivityEmbeddingCerts = knownActivityEmbeddingCertsResult.getResult();
        if (knownActivityEmbeddingCerts != null) {
            activity.setKnownActivityEmbeddingCerts(knownActivityEmbeddingCerts);
        }
        if (setExported = array2.hasValue(exportedAttr)) {
            activity.setExported(array2.getBoolean(exportedAttr, false));
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Object> result;
            ParseResult<ParsedIntentInfoImpl> intentResult;
            if (type != 2 || ParsingPackageUtils.getAconfigFlags().skipCurrentElement(pkg, parser)) continue;
            if (parser.getName().equals("intent-filter")) {
                ParsedIntentInfoImpl intentInfo;
                intentResult = ParsedActivityUtils.parseIntentFilter(pkg, activity, !isReceiver, visibleToEphemeral, resources, parser, input);
                if (intentResult.isSuccess() && (intentInfo = intentResult.getResult()) != null) {
                    IntentFilter intentFilter = intentInfo.getIntentFilter();
                    activity.setOrder(Math.max(intentFilter.getOrder(), activity.getOrder()));
                    activity.addIntent(intentInfo);
                }
                result = intentResult;
            } else if (parser.getName().equals("meta-data")) {
                result = ParsedComponentUtils.addMetaData(activity, pkg, resources, parser, input);
            } else if (parser.getName().equals("property")) {
                result = ParsedComponentUtils.addProperty(activity, pkg, resources, parser, input);
            } else if (!isReceiver && !isAlias && parser.getName().equals("preferred")) {
                ParsedIntentInfoImpl intent;
                intentResult = ParsedActivityUtils.parseIntentFilter(pkg, activity, true, visibleToEphemeral, resources, parser, input);
                if (intentResult.isSuccess() && (intent = intentResult.getResult()) != null) {
                    pkg.addPreferredActivityFilter(activity.getClassName(), intent);
                }
                result = intentResult;
            } else if (!isReceiver && !isAlias && parser.getName().equals("layout")) {
                ParseResult<ActivityInfo.WindowLayout> layoutResult2 = ParsedActivityUtils.parseActivityWindowLayout(resources, parser, input);
                if (layoutResult2.isSuccess()) {
                    activity.setWindowLayout(layoutResult2.getResult());
                }
                result = layoutResult2;
            } else {
                result = ParsingUtils.unknownTag(tag, pkg, parser, input);
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (!isAlias && activity.getLaunchMode() != 4 && activity.getMetaData().containsKey("android.activity.launch_mode") && (launchMode = activity.getMetaData().getString("android.activity.launch_mode")) != null && launchMode.equals("singleInstancePerTask")) {
            activity.setLaunchMode(4);
        }
        if (!isAlias) {
            boolean canDisplayOnRemoteDevices = array2.getBoolean(59, true);
            if (!activity.getMetaData().getBoolean("android.can_display_on_remote_devices", true)) {
                canDisplayOnRemoteDevices = false;
            }
            if (canDisplayOnRemoteDevices) {
                activity.setFlags(activity.getFlags() | 0x10000);
            }
        }
        if ((layoutResult = ParsedActivityUtils.resolveActivityWindowLayout(activity, input)).isError()) {
            return input.error(layoutResult);
        }
        activity.setWindowLayout(layoutResult.getResult());
        if (!setExported) {
            ParseResult<?> exportedCheckResult;
            boolean hasIntentFilters;
            boolean bl = hasIntentFilters = activity.getIntents().size() > 0;
            if (hasIntentFilters && (exportedCheckResult = input.deferError(activity.getName() + ": Targeting S+ (version " + 31 + " and above) requires that an explicit value for android:exported be defined when intent filters are present", 150232615L)).isError()) {
                return input.error(exportedCheckResult);
            }
            activity.setExported(hasIntentFilters);
        }
        return input.success(activity);
    }

    @NonNull
    private static ParseResult<ParsedIntentInfoImpl> parseIntentFilter(ParsingPackage pkg, ParsedActivityImpl activity, boolean allowImplicitEphemeralVisibility, boolean visibleToEphemeral, Resources resources, XmlResourceParser parser, ParseInput input) throws IOException, XmlPullParserException {
        ParseResult<ParsedIntentInfoImpl> result = ParsedMainComponentUtils.parseIntentFilter(activity, pkg, resources, parser, visibleToEphemeral, true, true, allowImplicitEphemeralVisibility, true, input);
        if (result.isError()) {
            return input.error(result);
        }
        ParsedIntentInfoImpl intent = result.getResult();
        if (intent != null) {
            IntentFilter intentFilter = intent.getIntentFilter();
            if (intentFilter.isVisibleToInstantApp()) {
                activity.setFlags(activity.getFlags() | 0x100000);
            }
            if (intentFilter.isImplicitlyVisibleToInstantApp()) {
                activity.setFlags(activity.getFlags() | 0x200000);
            }
        }
        return input.success(intent);
    }

    private static int getActivityResizeMode(ParsingPackage pkg, TypedArray sa, int screenOrientation) {
        Boolean resizeableActivity = pkg.getResizeableActivity();
        if (sa.hasValue(40) || resizeableActivity != null) {
            if (sa.getBoolean(40, resizeableActivity != null && resizeableActivity != false)) {
                return 2;
            }
            return 0;
        }
        if (pkg.isResizeableActivityViaSdkVersion()) {
            return 1;
        }
        if (ActivityInfo.isFixedOrientationPortrait(screenOrientation)) {
            return 6;
        }
        if (ActivityInfo.isFixedOrientationLandscape(screenOrientation)) {
            return 5;
        }
        if (screenOrientation == 14) {
            return 7;
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ActivityInfo.WindowLayout> parseActivityWindowLayout(Resources res, AttributeSet attrs, ParseInput input) {
        TypedArray sw = res.obtainAttributes(attrs, R.styleable.AndroidManifestLayout);
        try {
            int width = -1;
            float widthFraction = -1.0f;
            int height = -1;
            float heightFraction = -1.0f;
            int widthType = sw.getType(3);
            if (widthType == 6) {
                widthFraction = sw.getFraction(3, 1, 1, -1.0f);
            } else if (widthType == 5) {
                width = sw.getDimensionPixelSize(3, -1);
            }
            int heightType = sw.getType(4);
            if (heightType == 6) {
                heightFraction = sw.getFraction(4, 1, 1, -1.0f);
            } else if (heightType == 5) {
                height = sw.getDimensionPixelSize(4, -1);
            }
            int gravity = sw.getInt(0, 17);
            int minWidth = sw.getDimensionPixelSize(1, -1);
            int minHeight = sw.getDimensionPixelSize(2, -1);
            String windowLayoutAffinity = sw.getNonConfigurationString(5, 0);
            ActivityInfo.WindowLayout windowLayout = new ActivityInfo.WindowLayout(width, widthFraction, height, heightFraction, gravity, minWidth, minHeight, windowLayoutAffinity);
            ParseResult<ActivityInfo.WindowLayout> parseResult = input.success(windowLayout);
            return parseResult;
        }
        finally {
            sw.recycle();
        }
    }

    private static ParseResult<ActivityInfo.WindowLayout> resolveActivityWindowLayout(ParsedActivity activity, ParseInput input) {
        if (!activity.getMetaData().containsKey("android.activity_window_layout_affinity")) {
            return input.success(activity.getWindowLayout());
        }
        if (activity.getWindowLayout() != null && activity.getWindowLayout().windowLayoutAffinity != null) {
            return input.success(activity.getWindowLayout());
        }
        String windowLayoutAffinity = activity.getMetaData().getString("android.activity_window_layout_affinity");
        ActivityInfo.WindowLayout layout2 = activity.getWindowLayout();
        if (layout2 == null) {
            layout2 = new ActivityInfo.WindowLayout(-1, -1.0f, -1, -1.0f, 0, -1, -1, windowLayoutAffinity);
        } else {
            layout2.windowLayoutAffinity = windowLayoutAffinity;
        }
        return input.success(layout2);
    }

    public static int getActivityConfigChanges(int configChanges, int recreateOnConfigChanges) {
        return configChanges | ~recreateOnConfigChanges & 3;
    }

    static {
        SAFE_BROADCASTS.add("android.intent.action.BOOT_COMPLETED");
    }
}

