/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.pm.pkg.component.ParsedComponentImpl;
import com.android.internal.pm.pkg.component.ParsedPermission;
import com.android.internal.pm.pkg.component.ParsedPermissionGroup;
import com.android.internal.pm.pkg.component.ParsedPermissionGroupImpl;
import com.android.internal.util.Parcelling;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class ParsedPermissionImpl
extends ParsedComponentImpl
implements ParsedPermission,
Parcelable {
    private static final Parcelling.BuiltIn.ForStringSet sForStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForStringSet.class);
    @Nullable
    private String backgroundPermission;
    @Nullable
    private String group;
    private int requestRes;
    private int protectionLevel;
    private boolean tree;
    @Nullable
    private ParsedPermissionGroup parsedPermissionGroup;
    @Nullable
    private Set<String> knownCerts;
    @NonNull
    public static final Parcelable.Creator<ParsedPermissionImpl> CREATOR = new Parcelable.Creator<ParsedPermissionImpl>(){

        @Override
        public ParsedPermissionImpl createFromParcel(Parcel source) {
            return new ParsedPermissionImpl(source);
        }

        public ParsedPermissionImpl[] newArray(int size) {
            return new ParsedPermissionImpl[size];
        }
    };

    @VisibleForTesting
    public ParsedPermissionImpl() {
    }

    @Override
    public ParsedPermissionGroup getParsedPermissionGroup() {
        return this.parsedPermissionGroup;
    }

    public ParsedPermissionImpl setGroup(String group) {
        this.group = TextUtils.safeIntern(group);
        return this;
    }

    protected void setKnownCert(String knownCert) {
        this.knownCerts = Set.of(knownCert.toUpperCase(Locale.US));
    }

    protected void setKnownCerts(String[] knownCerts) {
        this.knownCerts = new ArraySet<String>();
        for (String knownCert : knownCerts) {
            this.knownCerts.add(knownCert.toUpperCase(Locale.US));
        }
    }

    @Override
    @NonNull
    public Set<String> getKnownCerts() {
        return this.knownCerts == null ? Collections.emptySet() : this.knownCerts;
    }

    public String toString() {
        return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.getName() + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.backgroundPermission);
        dest.writeString(this.group);
        dest.writeInt(this.requestRes);
        dest.writeInt(this.protectionLevel);
        dest.writeBoolean(this.tree);
        dest.writeParcelable((ParsedPermissionGroupImpl)this.parsedPermissionGroup, flags);
        sForStringSet.parcel(this.knownCerts, dest, flags);
    }

    protected ParsedPermissionImpl(Parcel in) {
        super(in);
        this.backgroundPermission = in.readString();
        this.group = TextUtils.safeIntern(in.readString());
        this.requestRes = in.readInt();
        this.protectionLevel = in.readInt();
        this.tree = in.readBoolean();
        this.parsedPermissionGroup = in.readParcelable(ParsedPermissionGroupImpl.class.getClassLoader(), ParsedPermissionGroupImpl.class);
        this.knownCerts = sForStringSet.unparcel(in);
    }

    public ParsedPermissionImpl(@Nullable String backgroundPermission, @Nullable String group, int requestRes, int protectionLevel, boolean tree, @Nullable ParsedPermissionGroup parsedPermissionGroup, @Nullable Set<String> knownCerts) {
        this.backgroundPermission = backgroundPermission;
        this.group = group;
        this.requestRes = requestRes;
        this.protectionLevel = protectionLevel;
        this.tree = tree;
        this.parsedPermissionGroup = parsedPermissionGroup;
        this.knownCerts = knownCerts;
    }

    @Override
    @Nullable
    public String getBackgroundPermission() {
        return this.backgroundPermission;
    }

    @Override
    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Override
    public int getRequestRes() {
        return this.requestRes;
    }

    @Override
    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    @Override
    public boolean isTree() {
        return this.tree;
    }

    @NonNull
    public ParsedPermissionImpl setBackgroundPermission(@NonNull String value) {
        this.backgroundPermission = value;
        return this;
    }

    @NonNull
    public ParsedPermissionImpl setRequestRes(int value) {
        this.requestRes = value;
        return this;
    }

    @NonNull
    public ParsedPermissionImpl setProtectionLevel(int value) {
        this.protectionLevel = value;
        return this;
    }

    @NonNull
    public ParsedPermissionImpl setTree(boolean value) {
        this.tree = value;
        return this;
    }

    @NonNull
    public ParsedPermissionImpl setParsedPermissionGroup(@NonNull ParsedPermissionGroup value) {
        this.parsedPermissionGroup = value;
        return this;
    }

    @NonNull
    public ParsedPermissionImpl setKnownCerts(@NonNull Set<String> value) {
        this.knownCerts = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

