/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.R;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.ParsedProcess;
import com.android.internal.pm.pkg.component.ParsedProcessImpl;
import com.android.internal.pm.pkg.component.flags.Flags;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedProcessUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<Set<String>> parseDenyPermission(Set<String> perms, Resources res, XmlResourceParser parser, ParseInput input) throws IOException, XmlPullParserException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestDenyPermission);
        try {
            String perm = sa.getNonConfigurationString(0, 0);
            if (perm != null && perm.equals("android.permission.INTERNET")) {
                perms = CollectionUtils.add(perms, perm);
            }
        }
        finally {
            sa.recycle();
        }
        XmlUtils.skipCurrentTag(parser);
        return input.success(perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<Set<String>> parseAllowPermission(Set<String> perms, Resources res, XmlResourceParser parser, ParseInput input) throws IOException, XmlPullParserException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestAllowPermission);
        try {
            String perm = sa.getNonConfigurationString(0, 0);
            if (perm != null && perm.equals("android.permission.INTERNET")) {
                perms = CollectionUtils.remove(perms, perm);
            }
        }
        finally {
            sa.recycle();
        }
        XmlUtils.skipCurrentTag(parser);
        return input.success(perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsedProcess> parseProcess(Set<String> perms, String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, ParseInput input) throws IOException, XmlPullParserException {
        int type;
        ParsedProcessImpl proc = new ParsedProcessImpl();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProcess);
        try {
            if (perms != null) {
                proc.setDeniedPermissions(new ArraySet<String>(perms));
            }
            String processName = sa.getNonConfigurationString(1, 0);
            ParseResult<String> processNameResult = ComponentParseUtils.buildProcessName(pkg.getPackageName(), pkg.getPackageName(), processName, flags, separateProcesses, input);
            if (processNameResult.isError()) {
                ParseResult<ParsedProcess> parseResult = input.error(processNameResult);
                return parseResult;
            }
            String packageName = pkg.getPackageName();
            String className = ParsingUtils.buildClassName(packageName, sa.getNonConfigurationString(0, 0));
            proc.setName(processNameResult.getResult());
            proc.putAppClassNameForPackage(packageName, className);
            proc.setGwpAsanMode(sa.getInt(3, -1));
            proc.setMemtagMode(sa.getInt(4, -1));
            if (sa.hasValue(5)) {
                boolean v = sa.getBoolean(5, false);
                proc.setNativeHeapZeroInitialized(v ? 1 : 0);
            }
            if (Flags.enablePerProcessUseEmbeddedDexAttr()) {
                proc.setUseEmbeddedDex(sa.getBoolean(2, false));
            } else {
                proc.setUseEmbeddedDex(false);
            }
        }
        finally {
            sa.recycle();
        }
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            ParseResult<Set<String>> result;
            String tagName;
            if (type == 3 || type == 4) continue;
            switch (tagName = parser.getName()) {
                case "deny-permission": {
                    ParseResult<Set<String>> denyResult;
                    result = denyResult = ParsedProcessUtils.parseDenyPermission(proc.getDeniedPermissions(), res, parser, input);
                    if (!denyResult.isSuccess()) break;
                    proc.setDeniedPermissions(denyResult.getResult());
                    break;
                }
                case "allow-permission": {
                    ParseResult<Set<String>> allowResult = ParsedProcessUtils.parseAllowPermission(proc.getDeniedPermissions(), res, parser, input);
                    result = allowResult;
                    if (!allowResult.isSuccess()) break;
                    proc.setDeniedPermissions(allowResult.getResult());
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag("<process>", pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        return input.success(proc);
    }

    @NonNull
    public static ParseResult<ArrayMap<String, ParsedProcess>> parseProcesses(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, ParseInput input) throws IOException, XmlPullParserException {
        int type;
        Set<String> deniedPerms = null;
        ArrayMap<String, ParsedProcess> processes = new ArrayMap<String, ParsedProcess>();
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            ParseResult<Object> result;
            String tagName;
            if (type == 3 || type == 4) continue;
            switch (tagName = parser.getName()) {
                case "deny-permission": {
                    ParseResult<Set<String>> denyResult;
                    result = denyResult = ParsedProcessUtils.parseDenyPermission(deniedPerms, res, parser, input);
                    if (!denyResult.isSuccess()) break;
                    deniedPerms = denyResult.getResult();
                    break;
                }
                case "allow-permission": {
                    ParseResult<Set<String>> allowResult = ParsedProcessUtils.parseAllowPermission(deniedPerms, res, parser, input);
                    result = allowResult;
                    if (!allowResult.isSuccess()) break;
                    deniedPerms = allowResult.getResult();
                    break;
                }
                case "process": {
                    ParsedProcess process;
                    ParseResult<ParsedProcess> processResult = ParsedProcessUtils.parseProcess(deniedPerms, separateProcesses, pkg, res, parser, flags, input);
                    result = processResult;
                    if (!processResult.isSuccess() || processes.put((process = processResult.getResult()).getName(), process) == null) break;
                    result = input.error("<process> specified existing name '" + process.getName() + "'");
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag("<processes>", pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        return input.success(processes);
    }
}

