/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDeviceLockedStateListener
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.policy.IDeviceLockedStateListener";

    public void onDeviceLockedStateChanged(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDeviceLockedStateListener {
        static final int TRANSACTION_onDeviceLockedStateChanged = 1;

        public Stub() {
            this.attachInterface(this, IDeviceLockedStateListener.DESCRIPTOR);
        }

        public static IDeviceLockedStateListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDeviceLockedStateListener.DESCRIPTOR);
            if (iin != null && iin instanceof IDeviceLockedStateListener) {
                return (IDeviceLockedStateListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDeviceLockedStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDeviceLockedStateListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onDeviceLockedStateChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IDeviceLockedStateListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDeviceLockedStateListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeviceLockedStateChanged(boolean isDeviceLocked) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockedStateListener.DESCRIPTOR);
                    _data.writeBoolean(isDeviceLocked);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDeviceLockedStateListener {
        @Override
        public void onDeviceLockedStateChanged(boolean isDeviceLocked) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

