/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.android.internal.policy.DecorView;

public class WearGestureInterceptionDetector {
    private static final boolean DEBUG = false;
    private static final String TAG = "WearGestureInterceptionDetector";
    private final DecorView mInstalledDecorView;
    private final float mTouchSlop;
    private final float mSwipingStartThreshold;
    private boolean mSwiping;
    private float mDownX;
    private float mDownY;
    private int mActivePointerId;
    private boolean mDiscardIntercept;

    WearGestureInterceptionDetector(Context context, DecorView installedDecorView) {
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.mInstalledDecorView = installedDecorView;
        this.mSwipingStartThreshold = this.mTouchSlop * 2.0f;
    }

    public static boolean isEnabled(Context context) {
        PackageManager pm = context.getPackageManager();
        if (!pm.hasSystemFeature("android.hardware.type.watch")) {
            return false;
        }
        TypedArray windowAttr = context.obtainStyledAttributes(new int[]{16843763});
        boolean windowSwipeToDismiss = true;
        if (windowAttr.getIndexCount() > 0) {
            windowSwipeToDismiss = windowAttr.getBoolean(0, true);
        }
        windowAttr.recycle();
        return windowSwipeToDismiss;
    }

    private int getIndexForValidPointer(MotionEvent ev) {
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex == -1) {
            this.mDiscardIntercept = true;
        }
        return pointerIndex;
    }

    private void updateSwiping(MotionEvent ev) {
        float deltaY;
        if (this.mSwiping) {
            return;
        }
        float deltaX = ev.getRawX() - this.mDownX;
        if (deltaX * deltaX + (deltaY = ev.getRawY() - this.mDownY) * deltaY > this.mTouchSlop * this.mTouchSlop) {
            this.mSwiping = deltaX > this.mSwipingStartThreshold && Math.abs(deltaY) < Math.abs(deltaX);
        }
    }

    private void updateDiscardIntercept(MotionEvent ev, int pointerIndex) {
        float y;
        float x;
        if (!this.mSwiping) {
            return;
        }
        if (this.mDiscardIntercept) {
            return;
        }
        boolean checkLeft = this.mDownX < ev.getRawX();
        if (this.canScroll(this.mInstalledDecorView, false, checkLeft, x = ev.getX(pointerIndex), y = ev.getY(pointerIndex))) {
            this.mDiscardIntercept = true;
        }
    }

    private void resetMembers() {
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDiscardIntercept = false;
    }

    public boolean isIntercepting() {
        return !this.mDiscardIntercept && this.mSwiping;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 5: {
                this.mActivePointerId = ev.getPointerId(ev.getActionIndex());
                break;
            }
            case 6: {
                int associatedPointerIndex = ev.getActionIndex();
                if (ev.getPointerId(associatedPointerIndex) != this.mActivePointerId) break;
                int newActionIndex = associatedPointerIndex == 0 ? 1 : 0;
                this.mActivePointerId = ev.getPointerId(newActionIndex);
                break;
            }
            case 2: {
                int pointerIndex;
                if (this.mDiscardIntercept || (pointerIndex = this.getIndexForValidPointer(ev)) == -1) break;
                this.updateSwiping(ev);
                this.updateDiscardIntercept(ev, pointerIndex);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
            }
        }
        return this.isIntercepting();
    }

    private boolean canScroll(View v, boolean checkSelf, boolean checkLeft, float x, float y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + (float)scrollX < (float)child.getLeft() || x + (float)scrollX >= (float)child.getRight() || y + (float)scrollY < (float)child.getTop() || y + (float)scrollY >= (float)child.getBottom() || !this.canScroll(child, true, checkLeft, x + (float)scrollX - (float)child.getLeft(), y + (float)scrollY - (float)child.getTop())) continue;
                return true;
            }
        }
        return checkSelf && v.canScrollHorizontally(checkLeft ? -1 : 1);
    }
}

