/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.text.TextUtils;
import android.tracing.Flags;
import android.tracing.perfetto.InitArguments;
import android.tracing.perfetto.Producer;
import android.tracing.perfetto.TracingContext;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongArray;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.protolog.IProtoLogClient;
import com.android.internal.protolog.IProtoLogConfigurationService;
import com.android.internal.protolog.ProtoLog;
import com.android.internal.protolog.ProtoLogCacheUpdater;
import com.android.internal.protolog.ProtoLogDataSource;
import com.android.internal.protolog.ProtoLogViewerConfigReader;
import com.android.internal.protolog.common.ILogger;
import com.android.internal.protolog.common.IProtoLog;
import com.android.internal.protolog.common.IProtoLogGroup;
import com.android.internal.protolog.common.InvalidFormatStringException;
import com.android.internal.protolog.common.LogDataType;
import com.android.internal.protolog.common.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class PerfettoProtoLogImpl
extends IProtoLogClient.Stub
implements IProtoLog {
    private static final String LOG_TAG = "ProtoLog";
    public static final String NULL_STRING = "null";
    private final AtomicInteger mTracingInstances = new AtomicInteger();
    @NonNull
    protected final ProtoLogDataSource mDataSource;
    @Nullable
    protected final IProtoLogConfigurationService mConfigurationService;
    @NonNull
    protected final TreeMap<String, IProtoLogGroup> mLogGroups = new TreeMap();
    @NonNull
    private final ProtoLogCacheUpdater mCacheUpdater;
    @NonNull
    private final int[] mDefaultLogLevelCounts = new int[LogLevel.values().length];
    @NonNull
    private final Map<String, int[]> mLogLevelCounts = new ArrayMap<String, int[]>();
    @NonNull
    private final Map<String, Integer> mCollectStackTraceGroupCounts = new ArrayMap<String, Integer>();
    private final Lock mBackgroundServiceLock = new ReentrantLock();
    protected ExecutorService mBackgroundLoggingService = Executors.newSingleThreadExecutor();
    private boolean mLogcatReady = false;
    private static final int STACK_SIZE_TO_PROTO_LOG_ENTRY_CALL = 6;

    protected PerfettoProtoLogImpl(@NonNull ProtoLogDataSource dataSource, @NonNull ProtoLogCacheUpdater cacheUpdater, @NonNull IProtoLogGroup[] groups) throws ServiceManager.ServiceNotFoundException {
        this(dataSource, cacheUpdater, groups, Flags.clientSideProtoLogging() ? IProtoLogConfigurationService.Stub.asInterface(ServiceManager.getServiceOrThrow("protolog_configuration")) : null);
    }

    protected PerfettoProtoLogImpl(@NonNull ProtoLogDataSource dataSource, @NonNull ProtoLogCacheUpdater cacheUpdater, @NonNull IProtoLogGroup[] groups, @Nullable IProtoLogConfigurationService configurationService) {
        this.mDataSource = dataSource;
        this.mCacheUpdater = cacheUpdater;
        this.mConfigurationService = configurationService;
        this.registerGroupsLocally(groups);
    }

    public void enable() {
        Producer.init(InitArguments.DEFAULTS);
        if (Flags.clientSideProtoLogging()) {
            this.connectToConfigurationService();
        }
        this.mDataSource.registerOnStartCallback(this::onTracingInstanceStart);
        this.mDataSource.registerOnFlushCallback(this::onTracingFlush);
        this.mDataSource.registerOnStopCallback(this::onTracingInstanceStop);
    }

    private void connectToConfigurationService() {
        Objects.requireNonNull(this.mConfigurationService, "A null ProtoLog Configuration Service was provided!");
        this.mBackgroundLoggingService.execute(() -> {
            try {
                IProtoLogConfigurationService.RegisterClientArgs args = this.createConfigurationServiceRegisterClientArgs();
                args.groups = new String[this.mLogGroups.size()];
                args.groupsDefaultLogcatStatus = new boolean[this.mLogGroups.size()];
                List<IProtoLogGroup> groups = this.mLogGroups.values().stream().toList();
                for (int i = 0; i < groups.size(); ++i) {
                    IProtoLogGroup group = groups.get(i);
                    args.groups[i] = group.name();
                    args.groupsDefaultLogcatStatus[i] = group.isLogToLogcat();
                }
                this.mConfigurationService.registerClient(this, args);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Failed to register ProtoLog client");
            }
        });
    }

    public void disable() {
        this.mDataSource.unregisterOnStartCallback(this::onTracingInstanceStart);
        this.mDataSource.unregisterOnFlushCallback(this::onTracingFlush);
        this.mDataSource.unregisterOnStopCallback(this::onTracingInstanceStop);
    }

    @NonNull
    protected abstract IProtoLogConfigurationService.RegisterClientArgs createConfigurationServiceRegisterClientArgs();

    @Override
    @VisibleForTesting
    public void log(LogLevel logLevel, IProtoLogGroup group, long messageHash, int paramsMask, @Nullable Object[] args) {
        this.log(logLevel, group, new Message(messageHash, paramsMask), args);
    }

    @Override
    public void log(LogLevel logLevel, IProtoLogGroup group, String messageString, Object ... args) {
        try {
            this.log(logLevel, group, new Message(messageString), args);
        }
        catch (InvalidFormatStringException e) {
            Slog.e(LOG_TAG, "Invalid protolog string format", e);
            this.log(logLevel, group, new Message("INVALID MESSAGE"), new Object[0]);
        }
    }

    @VisibleForTesting
    public void passToLogcat(String tag, LogLevel level, String message) {
        switch (level) {
            case DEBUG: {
                Slog.d(tag, message);
                break;
            }
            case VERBOSE: {
                Slog.v(tag, message);
                break;
            }
            case INFO: {
                Slog.i(tag, message);
                break;
            }
            case WARN: {
                Slog.w(tag, message);
                break;
            }
            case ERROR: {
                Slog.e(tag, message);
                break;
            }
            case WTF: {
                Slog.wtf(tag, message);
            }
        }
    }

    @Override
    public boolean isProtoEnabled() {
        return this.mTracingInstances.get() > 0;
    }

    @Override
    public void toggleLogcat(boolean enabled, String[] groups) {
        ILogger logger = message -> Log.d(LOG_TAG, message);
        if (enabled) {
            this.startLoggingToLogcat(groups, logger);
        } else {
            this.stopLoggingToLogcat(groups, logger);
        }
    }

    @Override
    public int startLoggingToLogcat(String[] groups, @NonNull ILogger logger) {
        return this.setTextLogging(true, logger, groups);
    }

    @Override
    public int stopLoggingToLogcat(String[] groups, @NonNull ILogger logger) {
        return this.setTextLogging(false, logger, groups);
    }

    @Override
    public boolean isEnabled(IProtoLogGroup group, LogLevel level) {
        int[] groupLevelCount = this.mLogLevelCounts.get(group.name());
        return groupLevelCount == null && this.mDefaultLogLevelCounts[level.ordinal()] > 0 || groupLevelCount != null && groupLevelCount[level.ordinal()] > 0 || group.isLogToLogcat();
    }

    @Override
    @NonNull
    public List<IProtoLogGroup> getRegisteredGroups() {
        return this.mLogGroups.values().stream().toList();
    }

    private void registerGroupsLocally(@NonNull IProtoLogGroup[] protoLogGroups) {
        this.verifyNoCollisionsOrDuplicates(protoLogGroups);
        for (IProtoLogGroup protoLogGroup : protoLogGroups) {
            this.mLogGroups.put(protoLogGroup.name(), protoLogGroup);
        }
    }

    private void verifyNoCollisionsOrDuplicates(@NonNull IProtoLogGroup[] protoLogGroups) {
        ArraySet<Integer> groupId = new ArraySet<Integer>();
        for (IProtoLogGroup protoLogGroup : protoLogGroups) {
            if (groupId.contains(protoLogGroup.getId())) {
                throw new RuntimeException("Group with same id (" + protoLogGroup.getId() + ") registered twice. Potential duplicate or hash id collision.");
            }
            groupId.add(protoLogGroup.getId());
        }
    }

    protected void readyToLogToLogcat() {
        this.mLogcatReady = true;
    }

    @Deprecated
    public int onShellCommand(ShellCommand shell) {
        String arg;
        PrintWriter pw = shell.getOutPrintWriter();
        if (Flags.clientSideProtoLogging()) {
            pw.println("Command deprecated. Please use 'cmd protolog_configuration' instead.");
            return -1;
        }
        String cmd = shell.getNextArg();
        if (cmd == null) {
            return this.unknownCommand(pw);
        }
        ArrayList<String> args = new ArrayList<String>();
        while ((arg = shell.getNextArg()) != null) {
            args.add(arg);
        }
        ILogger logger = msg -> PerfettoProtoLogImpl.logAndPrintln(pw, msg);
        String[] groups = args.toArray(new String[0]);
        switch (cmd) {
            case "start": 
            case "stop": {
                pw.println("Command not supported. Please start and stop ProtoLog tracing with Perfetto.");
                return -1;
            }
            case "enable-text": {
                return this.startLoggingToLogcat(groups, logger);
            }
            case "disable-text": {
                return this.stopLoggingToLogcat(groups, logger);
            }
        }
        return this.unknownCommand(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(LogLevel logLevel, IProtoLogGroup group, Message message, @Nullable Object[] args) {
        if (this.isProtoEnabled()) {
            long tsNanos = SystemClock.elapsedRealtimeNanos();
            String stacktrace = this.mCollectStackTraceGroupCounts.getOrDefault(group.name(), 0) > 0 ? this.collectStackTrace() : null;
            try {
                this.mBackgroundServiceLock.lock();
                this.mBackgroundLoggingService.execute(() -> this.logToProto(logLevel, group, message, args, tsNanos, stacktrace));
            }
            finally {
                this.mBackgroundServiceLock.unlock();
            }
        }
        if (group.isLogToLogcat()) {
            this.logToLogcat(group.getTag(), logLevel, message, args);
        }
    }

    private void onTracingFlush() {
        ExecutorService loggingService;
        Log.d(LOG_TAG, "Executing onTracingFlush");
        try {
            this.mBackgroundServiceLock.lock();
            loggingService = this.mBackgroundLoggingService;
            this.mBackgroundLoggingService = Executors.newSingleThreadExecutor();
        }
        finally {
            this.mBackgroundServiceLock.unlock();
        }
        try {
            loggingService.shutdown();
            boolean finished = loggingService.awaitTermination(10L, TimeUnit.SECONDS);
            if (!finished) {
                Log.e(LOG_TAG, "ProtoLog background tracing service didn't finish gracefully.");
            }
        }
        catch (InterruptedException e) {
            Log.e(LOG_TAG, "Failed to wait for tracing to finish", e);
        }
        if (!Flags.clientSideProtoLogging()) {
            this.dumpViewerConfig();
        }
        Log.d(LOG_TAG, "Finished onTracingFlush");
    }

    @Deprecated
    abstract void dumpViewerConfig();

    @NonNull
    abstract String getLogcatMessageString(@NonNull Message var1);

    private void logToLogcat(@NonNull String tag, @NonNull LogLevel level, @NonNull Message message, @Nullable Object[] args) {
        if (!this.mLogcatReady) {
            Log.w(LOG_TAG, "Trying to log a protolog message with hash " + message.getMessageHash() + " to logcat before the service is ready to accept such requests.");
            return;
        }
        String messageString = this.getLogcatMessageString(message);
        this.logToLogcat(tag, level, messageString, args);
    }

    private void logToLogcat(String tag, LogLevel level, String messageString, @Nullable Object[] args) {
        String message;
        if (args != null) {
            try {
                message = TextUtils.formatSimple(messageString, args);
            }
            catch (IllegalArgumentException e) {
                message = "FORMAT_ERROR \"" + messageString + "\", args=(" + String.join((CharSequence)", ", Arrays.stream(args).map(Object::toString).toList()) + ")";
            }
        } else {
            message = messageString;
        }
        this.passToLogcat(tag, level, message);
    }

    private void logToProto(LogLevel level, IProtoLogGroup logGroup, Message message, Object[] args, long tsNanos, @Nullable String stacktrace) {
        this.mDataSource.trace(ctx -> {
            ProtoLogDataSource.TlsState tlsState = (ProtoLogDataSource.TlsState)ctx.getCustomTlsState();
            LogLevel logFrom = tlsState.getLogFromLevel(logGroup.name());
            if (level.ordinal() < logFrom.ordinal()) {
                return;
            }
            if (args != null) {
                int argIndex = 0;
                for (Object o : args) {
                    int type = LogDataType.bitmaskToLogDataType(message.getMessageMask(), argIndex);
                    if (type == 0) {
                        if (o == null) {
                            this.internStringArg(ctx, NULL_STRING);
                        } else {
                            this.internStringArg(ctx, o.toString());
                        }
                    }
                    ++argIndex;
                }
            }
            int internedStacktrace = 0;
            if (tlsState.getShouldCollectStacktrace(logGroup.name())) {
                internedStacktrace = this.internStacktraceString(ctx, stacktrace);
            }
            boolean needsIncrementalState = false;
            long messageHash = 0L;
            if (message.mMessageHash != null) {
                messageHash = message.mMessageHash;
            }
            if (message.mMessageString != null) {
                needsIncrementalState = true;
                messageHash = this.internProtoMessage(ctx, level, logGroup, message.mMessageString);
            }
            ProtoOutputStream os = ctx.newTracePacket();
            os.write(1116691496968L, tsNanos);
            long token = os.start(1146756268136L);
            os.write(0x10600000001L, messageHash);
            if (args != null) {
                int argIndex = 0;
                LongArray longParams = new LongArray();
                ArrayList<Double> doubleParams = new ArrayList<Double>();
                ArrayList<Boolean> booleanParams = new ArrayList<Boolean>();
                for (Object o : args) {
                    int type = LogDataType.bitmaskToLogDataType(message.getMessageMask(), argIndex);
                    try {
                        switch (type) {
                            case 0: {
                                int internedStringId = o == null ? this.internStringArg(ctx, NULL_STRING) : this.internStringArg(ctx, o.toString());
                                os.write(0x20D00000002L, internedStringId);
                                needsIncrementalState = true;
                                break;
                            }
                            case 1: {
                                if (o == null) {
                                    longParams.add(0L);
                                    break;
                                }
                                longParams.add(((Number)o).longValue());
                                break;
                            }
                            case 2: {
                                if (o == null) {
                                    doubleParams.add(0.0);
                                    break;
                                }
                                doubleParams.add(((Number)o).doubleValue());
                                break;
                            }
                            case 3: {
                                if (o == null) {
                                    booleanParams.add(false);
                                    break;
                                }
                                booleanParams.add((Boolean)o);
                            }
                        }
                    }
                    catch (ClassCastException ex) {
                        Slog.e(LOG_TAG, "Invalid ProtoLog paramsMask", ex);
                    }
                    ++argIndex;
                }
                for (int i = 0; i < longParams.size(); ++i) {
                    os.write(2276332666883L, longParams.get(i));
                }
                doubleParams.forEach(it -> os.write(2203318222852L, (double)it));
                booleanParams.forEach(it -> os.write(0x20500000005L, it != false ? 1 : 0));
            }
            if (tlsState.getShouldCollectStacktrace(logGroup.name())) {
                os.write(1155346202630L, internedStacktrace);
            }
            os.end(token);
            if (needsIncrementalState) {
                os.write(0x10D0000000DL, 2);
            }
        });
    }

    private long internProtoMessage(TracingContext<ProtoLogDataSource.Instance, ProtoLogDataSource.TlsState, ProtoLogDataSource.IncrementalState> ctx, LogLevel level, IProtoLogGroup logGroup, String message) {
        Long messageHash;
        ProtoOutputStream os;
        ProtoLogDataSource.IncrementalState incrementalState = ctx.getIncrementalState();
        if (!incrementalState.clearReported) {
            os = ctx.newTracePacket();
            os.write(0x10D0000000DL, 1);
            incrementalState.clearReported = true;
        }
        if (!incrementalState.protologGroupInterningSet.contains(logGroup.getId())) {
            incrementalState.protologGroupInterningSet.add(logGroup.getId());
            os = ctx.newTracePacket();
            long protologViewerConfigToken = os.start(1146756268137L);
            long groupConfigToken = os.start(0x20B00000002L);
            os.write(0x10D00000001L, logGroup.getId());
            os.write(1138166333442L, logGroup.name());
            os.write(1138166333443L, logGroup.getTag());
            os.end(groupConfigToken);
            os.end(protologViewerConfigToken);
        }
        if (!incrementalState.protologMessageInterningSet.contains(messageHash = this.hash(level, logGroup.name(), message))) {
            incrementalState.protologMessageInterningSet.add(messageHash);
            ProtoOutputStream os2 = ctx.newTracePacket();
            os2.write(0x10D0000000DL, 2);
            long protologViewerConfigToken = os2.start(1146756268137L);
            long messageConfigToken = os2.start(2246267895809L);
            os2.write(0x10600000001L, messageHash);
            os2.write(1138166333442L, message);
            os2.write(1159641169923L, level.id);
            os2.write(1155346202628L, logGroup.getId());
            os2.end(messageConfigToken);
            os2.end(protologViewerConfigToken);
        }
        return messageHash;
    }

    private Long hash(LogLevel logLevel, String logGroup, String messageString) {
        String fullStringIdentifier = messageString + (Object)((Object)logLevel) + logGroup;
        return UUID.nameUUIDFromBytes(fullStringIdentifier.getBytes()).getMostSignificantBits();
    }

    private String collectStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            for (int i = 6; i < stackTrace.length; ++i) {
                pw.println("\tat " + stackTrace[i]);
            }
        }
        return ((Object)sw).toString();
    }

    private int internStacktraceString(TracingContext<ProtoLogDataSource.Instance, ProtoLogDataSource.TlsState, ProtoLogDataSource.IncrementalState> ctx, String stacktrace) {
        ProtoLogDataSource.IncrementalState incrementalState = ctx.getIncrementalState();
        return this.internString(ctx, incrementalState.stacktraceInterningMap, 2246267895845L, stacktrace);
    }

    private int internStringArg(TracingContext<ProtoLogDataSource.Instance, ProtoLogDataSource.TlsState, ProtoLogDataSource.IncrementalState> ctx, String string2) {
        ProtoLogDataSource.IncrementalState incrementalState = ctx.getIncrementalState();
        return this.internString(ctx, incrementalState.argumentInterningMap, 2246267895844L, string2);
    }

    private int internString(TracingContext<ProtoLogDataSource.Instance, ProtoLogDataSource.TlsState, ProtoLogDataSource.IncrementalState> ctx, Map<String, Integer> internMap, long fieldId, @NonNull String string2) {
        ProtoLogDataSource.IncrementalState incrementalState = ctx.getIncrementalState();
        if (!incrementalState.clearReported) {
            ProtoOutputStream os = ctx.newTracePacket();
            os.write(0x10D0000000DL, 1);
            incrementalState.clearReported = true;
        }
        if (!internMap.containsKey(string2)) {
            int internedIndex = internMap.size() + 1;
            internMap.put(string2, internedIndex);
            ProtoOutputStream os = ctx.newTracePacket();
            long token = os.start(1146756268044L);
            long innerToken = os.start(fieldId);
            os.write(0x10400000001L, internedIndex);
            os.write(1151051235330L, string2.getBytes());
            os.end(innerToken);
            os.end(token);
        }
        return internMap.get(string2);
    }

    protected boolean validateGroups(ILogger logger, String[] groups) {
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            IProtoLogGroup g = this.mLogGroups.get(group);
            if (g != null) continue;
            logger.log("No IProtoLogGroup named " + group);
            return false;
        }
        return true;
    }

    private int setTextLogging(boolean value, ILogger logger, String ... groups) {
        if (!this.validateGroups(logger, groups)) {
            return -1;
        }
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            IProtoLogGroup g = this.mLogGroups.get(group);
            if (g == null) {
                throw new RuntimeException("No IProtoLogGroup named " + group);
            }
            g.setLogToLogcat(value);
        }
        this.mCacheUpdater.update(this);
        return 0;
    }

    private int unknownCommand(PrintWriter pw) {
        pw.println("Unknown command");
        pw.println("Window manager logging options:");
        pw.println("  enable-text [group...]: Enable logcat logging for given groups");
        pw.println("  disable-text [group...]: Disable logcat logging for given groups");
        return -1;
    }

    private synchronized void onTracingInstanceStart(int instanceIdx, ProtoLogDataSource.ProtoLogConfig config) {
        Log.d(LOG_TAG, "Executing onTracingInstanceStart");
        LogLevel defaultLogFrom = config.getDefaultGroupConfig().logFrom;
        int i = defaultLogFrom.ordinal();
        while (i < LogLevel.values().length) {
            int n = i++;
            this.mDefaultLogLevelCounts[n] = this.mDefaultLogLevelCounts[n] + 1;
        }
        Set<String> overriddenGroupTags = config.getGroupTagsWithOverriddenConfigs();
        for (String overriddenGroupTag : overriddenGroupTags) {
            this.mLogLevelCounts.putIfAbsent(overriddenGroupTag, new int[LogLevel.values().length]);
            int[] logLevelsCountsForGroup = this.mLogLevelCounts.get(overriddenGroupTag);
            LogLevel logFromLevel = config.getConfigFor((String)overriddenGroupTag).logFrom;
            int i2 = logFromLevel.ordinal();
            while (i2 < LogLevel.values().length) {
                int n = i2++;
                logLevelsCountsForGroup[n] = logLevelsCountsForGroup[n] + 1;
            }
            if (config.getConfigFor((String)overriddenGroupTag).collectStackTrace) {
                this.mCollectStackTraceGroupCounts.put(overriddenGroupTag, this.mCollectStackTraceGroupCounts.getOrDefault(overriddenGroupTag, 0) + 1);
            }
            if (!config.getConfigFor((String)overriddenGroupTag).collectStackTrace) continue;
            this.mCollectStackTraceGroupCounts.put(overriddenGroupTag, this.mCollectStackTraceGroupCounts.getOrDefault(overriddenGroupTag, 0) + 1);
        }
        this.mCacheUpdater.update(this);
        this.mTracingInstances.incrementAndGet();
        Log.d(LOG_TAG, "Finished onTracingInstanceStart");
    }

    private synchronized void onTracingInstanceStop(int instanceIdx, ProtoLogDataSource.ProtoLogConfig config) {
        Log.d(LOG_TAG, "Executing onTracingInstanceStop");
        this.mTracingInstances.decrementAndGet();
        LogLevel defaultLogFrom = config.getDefaultGroupConfig().logFrom;
        int i = defaultLogFrom.ordinal();
        while (i < LogLevel.values().length) {
            int n = i++;
            this.mDefaultLogLevelCounts[n] = this.mDefaultLogLevelCounts[n] - 1;
        }
        Set<String> overriddenGroupTags = config.getGroupTagsWithOverriddenConfigs();
        for (String overriddenGroupTag : overriddenGroupTags) {
            int[] logLevelsCountsForGroup = this.mLogLevelCounts.get(overriddenGroupTag);
            LogLevel logFromLevel = config.getConfigFor((String)overriddenGroupTag).logFrom;
            int i2 = logFromLevel.ordinal();
            while (i2 < LogLevel.values().length) {
                int n = i2++;
                logLevelsCountsForGroup[n] = logLevelsCountsForGroup[n] - 1;
            }
            if (Arrays.stream(logLevelsCountsForGroup).allMatch(it -> it == 0)) {
                this.mLogLevelCounts.remove(overriddenGroupTag);
            }
            if (!config.getConfigFor((String)overriddenGroupTag).collectStackTrace) continue;
            this.mCollectStackTraceGroupCounts.put(overriddenGroupTag, this.mCollectStackTraceGroupCounts.get(overriddenGroupTag) - 1);
            if (this.mCollectStackTraceGroupCounts.get(overriddenGroupTag) != 0) continue;
            this.mCollectStackTraceGroupCounts.remove(overriddenGroupTag);
        }
        this.mCacheUpdater.update(this);
        Log.d(LOG_TAG, "Finished onTracingInstanceStop");
    }

    private static void logAndPrintln(@Nullable PrintWriter pw, String msg) {
        Slog.i(LOG_TAG, msg);
        if (pw != null) {
            pw.println(msg);
            pw.flush();
        }
    }

    @VisibleForTesting
    public static void waitForInitialization() {
        IProtoLog currentInstance = ProtoLog.getSingleInstance();
        if (!(currentInstance instanceof PerfettoProtoLogImpl)) {
            return;
        }
        PerfettoProtoLogImpl protoLog = (PerfettoProtoLogImpl)currentInstance;
        try {
            protoLog.mBackgroundLoggingService.submit(() -> Log.i(LOG_TAG, "Complete initialization")).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Log.e(LOG_TAG, "Failed to wait for tracing service", e);
        }
    }

    protected static class Message {
        @Nullable
        private final Long mMessageHash;
        private final int mMessageMask;
        @Nullable
        private final String mMessageString;

        private Message(long messageHash, int messageMask) {
            this.mMessageHash = messageHash;
            this.mMessageMask = messageMask;
            this.mMessageString = null;
        }

        private Message(@NonNull String messageString) throws InvalidFormatStringException {
            this.mMessageHash = null;
            List<Integer> argTypes = LogDataType.parseFormatString(messageString);
            this.mMessageMask = LogDataType.logDataTypesToBitMask(argTypes);
            this.mMessageString = messageString;
        }

        private int getMessageMask() {
            return this.mMessageMask;
        }

        @Nullable
        protected Long getMessageHash() {
            return this.mMessageHash;
        }

        @Nullable
        protected String getMessage() {
            return this.mMessageString;
        }

        @Nullable
        protected String getMessage(@NonNull ProtoLogViewerConfigReader viewerConfigReader) {
            if (this.mMessageString != null) {
                return this.mMessageString;
            }
            if (this.mMessageHash != null) {
                return viewerConfigReader.getViewerString(this.mMessageHash);
            }
            throw new RuntimeException("Both mMessageString and mMessageHash should never be null");
        }
    }
}

