/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.telecom.CallEndpoint;
import android.telecom.DisconnectCause;

public interface ICallControl
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.telecom.ICallControl";

    public void setActive(String var1, ResultReceiver var2) throws RemoteException;

    public void answer(int var1, String var2, ResultReceiver var3) throws RemoteException;

    public void setInactive(String var1, ResultReceiver var2) throws RemoteException;

    public void disconnect(String var1, DisconnectCause var2, ResultReceiver var3) throws RemoteException;

    public void startCallStreaming(String var1, ResultReceiver var2) throws RemoteException;

    public void requestCallEndpointChange(CallEndpoint var1, ResultReceiver var2) throws RemoteException;

    public void setMuteState(boolean var1, ResultReceiver var2) throws RemoteException;

    public void sendEvent(String var1, String var2, Bundle var3) throws RemoteException;

    public void requestVideoState(int var1, String var2, ResultReceiver var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICallControl {
        static final int TRANSACTION_setActive = 1;
        static final int TRANSACTION_answer = 2;
        static final int TRANSACTION_setInactive = 3;
        static final int TRANSACTION_disconnect = 4;
        static final int TRANSACTION_startCallStreaming = 5;
        static final int TRANSACTION_requestCallEndpointChange = 6;
        static final int TRANSACTION_setMuteState = 7;
        static final int TRANSACTION_sendEvent = 8;
        static final int TRANSACTION_requestVideoState = 9;

        public Stub() {
            this.attachInterface(this, ICallControl.DESCRIPTOR);
        }

        public static ICallControl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICallControl.DESCRIPTOR);
            if (iin != null && iin instanceof ICallControl) {
                return (ICallControl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setActive";
                }
                case 2: {
                    return "answer";
                }
                case 3: {
                    return "setInactive";
                }
                case 4: {
                    return "disconnect";
                }
                case 5: {
                    return "startCallStreaming";
                }
                case 6: {
                    return "requestCallEndpointChange";
                }
                case 7: {
                    return "setMuteState";
                }
                case 8: {
                    return "sendEvent";
                }
                case 9: {
                    return "requestVideoState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICallControl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setActive(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.answer(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setInactive(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    DisconnectCause _arg1 = data.readTypedObject(DisconnectCause.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.disconnect(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.startCallStreaming(_arg0, _arg1);
                    break;
                }
                case 6: {
                    CallEndpoint _arg0 = data.readTypedObject(CallEndpoint.CREATOR);
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestCallEndpointChange(_arg0, _arg1);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setMuteState(_arg0, _arg1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestVideoState(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements ICallControl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICallControl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActive(String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void answer(int videoState, String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeInt(videoState);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInactive(String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(String callId, DisconnectCause disconnectCause, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(disconnectCause, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startCallStreaming(String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCallEndpointChange(CallEndpoint callEndpoint, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeTypedObject(callEndpoint, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMuteState(boolean isMuted, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeBoolean(isMuted);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendEvent(String callId, String event, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeString(event);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestVideoState(int videoState, String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallControl.DESCRIPTOR);
                    _data.writeInt(videoState);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICallControl {
        @Override
        public void setActive(String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void answer(int videoState, String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void setInactive(String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void disconnect(String callId, DisconnectCause disconnectCause, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void startCallStreaming(String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void requestCallEndpointChange(CallEndpoint callEndpoint, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void setMuteState(boolean isMuted, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void sendEvent(String callId, String event, Bundle extras) throws RemoteException {
        }

        @Override
        public void requestVideoState(int videoState, String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

