/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.ContentValues;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMms
extends IInterface {
    public void sendMessage(int var1, int var2, String var3, Uri var4, String var5, Bundle var6, PendingIntent var7, long var8, String var10) throws RemoteException;

    public void downloadMessage(int var1, int var2, String var3, String var4, Uri var5, Bundle var6, PendingIntent var7, long var8, String var10) throws RemoteException;

    public Uri importTextMessage(String var1, String var2, int var3, String var4, long var5, boolean var7, boolean var8) throws RemoteException;

    public Uri importMultimediaMessage(int var1, String var2, Uri var3, String var4, long var5, boolean var7, boolean var8) throws RemoteException;

    public boolean deleteStoredMessage(String var1, Uri var2) throws RemoteException;

    public boolean deleteStoredConversation(String var1, long var2) throws RemoteException;

    public boolean updateStoredMessageStatus(String var1, Uri var2, ContentValues var3) throws RemoteException;

    public boolean archiveStoredConversation(String var1, long var2, boolean var4) throws RemoteException;

    public Uri addTextMessageDraft(String var1, String var2, String var3) throws RemoteException;

    public Uri addMultimediaMessageDraft(int var1, String var2, Uri var3) throws RemoteException;

    public void sendStoredMessage(int var1, String var2, Uri var3, Bundle var4, PendingIntent var5) throws RemoteException;

    public void setAutoPersisting(String var1, boolean var2) throws RemoteException;

    public boolean getAutoPersisting() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMms {
        public static final String DESCRIPTOR = "com.android.internal.telephony.IMms";
        static final int TRANSACTION_sendMessage = 1;
        static final int TRANSACTION_downloadMessage = 2;
        static final int TRANSACTION_importTextMessage = 3;
        static final int TRANSACTION_importMultimediaMessage = 4;
        static final int TRANSACTION_deleteStoredMessage = 5;
        static final int TRANSACTION_deleteStoredConversation = 6;
        static final int TRANSACTION_updateStoredMessageStatus = 7;
        static final int TRANSACTION_archiveStoredConversation = 8;
        static final int TRANSACTION_addTextMessageDraft = 9;
        static final int TRANSACTION_addMultimediaMessageDraft = 10;
        static final int TRANSACTION_sendStoredMessage = 11;
        static final int TRANSACTION_setAutoPersisting = 12;
        static final int TRANSACTION_getAutoPersisting = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMms asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMms) {
                return (IMms)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendMessage";
                }
                case 2: {
                    return "downloadMessage";
                }
                case 3: {
                    return "importTextMessage";
                }
                case 4: {
                    return "importMultimediaMessage";
                }
                case 5: {
                    return "deleteStoredMessage";
                }
                case 6: {
                    return "deleteStoredConversation";
                }
                case 7: {
                    return "updateStoredMessageStatus";
                }
                case 8: {
                    return "archiveStoredConversation";
                }
                case 9: {
                    return "addTextMessageDraft";
                }
                case 10: {
                    return "addMultimediaMessageDraft";
                }
                case 11: {
                    return "sendStoredMessage";
                }
                case 12: {
                    return "setAutoPersisting";
                }
                case 13: {
                    return "getAutoPersisting";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    Uri _arg3 = data.readTypedObject(Uri.CREATOR);
                    String _arg4 = data.readString();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    PendingIntent _arg6 = data.readTypedObject(PendingIntent.CREATOR);
                    long _arg7 = data.readLong();
                    String _arg8 = data.readString();
                    data.enforceNoDataAvail();
                    this.sendMessage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    Uri _arg4 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    PendingIntent _arg6 = data.readTypedObject(PendingIntent.CREATOR);
                    long _arg7 = data.readLong();
                    String _arg8 = data.readString();
                    data.enforceNoDataAvail();
                    this.downloadMessage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    long _arg4 = data.readLong();
                    boolean _arg5 = data.readBoolean();
                    boolean _arg6 = data.readBoolean();
                    data.enforceNoDataAvail();
                    Uri _result = this.importTextMessage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    Uri _arg2 = data.readTypedObject(Uri.CREATOR);
                    String _arg3 = data.readString();
                    long _arg4 = data.readLong();
                    boolean _arg5 = data.readBoolean();
                    boolean _arg6 = data.readBoolean();
                    data.enforceNoDataAvail();
                    Uri _result = this.importMultimediaMessage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.deleteStoredMessage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.deleteStoredConversation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    ContentValues _arg2 = data.readTypedObject(ContentValues.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.updateStoredMessageStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.archiveStoredConversation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    Uri _result = this.addTextMessageDraft(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    Uri _arg2 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    Uri _result = this.addMultimediaMessageDraft(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    Uri _arg2 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    PendingIntent _arg4 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendStoredMessage(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAutoPersisting(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    boolean _result = this.getAutoPersisting();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 12;
        }

        private static class Proxy
        implements IMms {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(int subId, int callingUser, String callingPkg, Uri contentUri, String locationUrl, Bundle configOverrides, PendingIntent sentIntent, long messageId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(callingUser);
                    _data.writeString(callingPkg);
                    _data.writeTypedObject(contentUri, 0);
                    _data.writeString(locationUrl);
                    _data.writeTypedObject(configOverrides, 0);
                    _data.writeTypedObject(sentIntent, 0);
                    _data.writeLong(messageId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloadMessage(int subId, int callingUser, String callingPkg, String locationUrl, Uri contentUri, Bundle configOverrides, PendingIntent downloadedIntent, long messageId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(callingUser);
                    _data.writeString(callingPkg);
                    _data.writeString(locationUrl);
                    _data.writeTypedObject(contentUri, 0);
                    _data.writeTypedObject(configOverrides, 0);
                    _data.writeTypedObject(downloadedIntent, 0);
                    _data.writeLong(messageId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Uri importTextMessage(String callingPkg, String address, int type, String text, long timestampMillis, boolean seen, boolean read) throws RemoteException {
                Uri _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(address);
                    _data.writeInt(type);
                    _data.writeString(text);
                    _data.writeLong(timestampMillis);
                    _data.writeBoolean(seen);
                    _data.writeBoolean(read);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Uri.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Uri importMultimediaMessage(int callingUser, String callingPkg, Uri contentUri, String messageId, long timestampSecs, boolean seen, boolean read) throws RemoteException {
                Uri _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callingUser);
                    _data.writeString(callingPkg);
                    _data.writeTypedObject(contentUri, 0);
                    _data.writeString(messageId);
                    _data.writeLong(timestampSecs);
                    _data.writeBoolean(seen);
                    _data.writeBoolean(read);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Uri.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deleteStoredMessage(String callingPkg, Uri messageUri) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeTypedObject(messageUri, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deleteStoredConversation(String callingPkg, long conversationId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeLong(conversationId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateStoredMessageStatus(String callingPkg, Uri messageUri, ContentValues statusValues) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeTypedObject(messageUri, 0);
                    _data.writeTypedObject(statusValues, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean archiveStoredConversation(String callingPkg, long conversationId, boolean archived) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeLong(conversationId);
                    _data.writeBoolean(archived);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Uri addTextMessageDraft(String callingPkg, String address, String text) throws RemoteException {
                Uri _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(address);
                    _data.writeString(text);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Uri.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Uri addMultimediaMessageDraft(int callingUser, String callingPkg, Uri contentUri) throws RemoteException {
                Uri _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callingUser);
                    _data.writeString(callingPkg);
                    _data.writeTypedObject(contentUri, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Uri.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendStoredMessage(int subId, String callingPkg, Uri messageUri, Bundle configOverrides, PendingIntent sentIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPkg);
                    _data.writeTypedObject(messageUri, 0);
                    _data.writeTypedObject(configOverrides, 0);
                    _data.writeTypedObject(sentIntent, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoPersisting(String callingPkg, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getAutoPersisting() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IMms {
        @Override
        public void sendMessage(int subId, int callingUser, String callingPkg, Uri contentUri, String locationUrl, Bundle configOverrides, PendingIntent sentIntent, long messageId, String attributionTag) throws RemoteException {
        }

        @Override
        public void downloadMessage(int subId, int callingUser, String callingPkg, String locationUrl, Uri contentUri, Bundle configOverrides, PendingIntent downloadedIntent, long messageId, String attributionTag) throws RemoteException {
        }

        @Override
        public Uri importTextMessage(String callingPkg, String address, int type, String text, long timestampMillis, boolean seen, boolean read) throws RemoteException {
            return null;
        }

        @Override
        public Uri importMultimediaMessage(int callingUser, String callingPkg, Uri contentUri, String messageId, long timestampSecs, boolean seen, boolean read) throws RemoteException {
            return null;
        }

        @Override
        public boolean deleteStoredMessage(String callingPkg, Uri messageUri) throws RemoteException {
            return false;
        }

        @Override
        public boolean deleteStoredConversation(String callingPkg, long conversationId) throws RemoteException {
            return false;
        }

        @Override
        public boolean updateStoredMessageStatus(String callingPkg, Uri messageUri, ContentValues statusValues) throws RemoteException {
            return false;
        }

        @Override
        public boolean archiveStoredConversation(String callingPkg, long conversationId, boolean archived) throws RemoteException {
            return false;
        }

        @Override
        public Uri addTextMessageDraft(String callingPkg, String address, String text) throws RemoteException {
            return null;
        }

        @Override
        public Uri addMultimediaMessageDraft(int callingUser, String callingPkg, Uri contentUri) throws RemoteException {
            return null;
        }

        @Override
        public void sendStoredMessage(int subId, String callingPkg, Uri messageUri, Bundle configOverrides, PendingIntent sentIntent) throws RemoteException {
        }

        @Override
        public void setAutoPersisting(String callingPkg, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean getAutoPersisting() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

