/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.ExceptionUtils;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FunctionalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

@RavenwoodKeepWholeClass
public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> boolean contains(@Nullable Collection<T> collection, T element) {
        return collection != null && collection.contains(element);
    }

    @NonNull
    public static <T> List<T> filter(@Nullable List<T> list, Predicate<? super T> predicate) {
        ArrayList<T> result = null;
        for (int i = 0; i < CollectionUtils.size(list); ++i) {
            T item = list.get(i);
            if (!predicate.test(item)) continue;
            result = ArrayUtils.add(result, item);
        }
        return CollectionUtils.emptyIfNull(result);
    }

    @NonNull
    public static <T> Set<T> filter(@Nullable Set<T> set, Predicate<? super T> predicate) {
        if (set == null || set.size() == 0) {
            return Collections.emptySet();
        }
        ArraySet<T> result = null;
        if (set instanceof ArraySet) {
            ArraySet arraySet = (ArraySet)set;
            int size = arraySet.size();
            for (int i = 0; i < size; ++i) {
                Object item = arraySet.valueAt(i);
                if (!predicate.test(item)) continue;
                result = ArrayUtils.add(result, item);
            }
        } else {
            for (T item : set) {
                if (!predicate.test(item)) continue;
                result = ArrayUtils.add(result, item);
            }
        }
        return CollectionUtils.emptyIfNull(result);
    }

    public static <T> void addIf(@Nullable List<T> source, @NonNull Collection<? super T> dest, @Nullable Predicate<? super T> predicate) {
        for (int i = 0; i < CollectionUtils.size(source); ++i) {
            T item = source.get(i);
            if (!predicate.test(item)) continue;
            dest.add(item);
        }
    }

    @NonNull
    public static <I, O> List<O> map(@Nullable List<I> cur, Function<? super I, ? extends O> f) {
        if (CollectionUtils.isEmpty(cur)) {
            return Collections.emptyList();
        }
        int size = cur.size();
        ArrayList<O> result = new ArrayList<O>(size);
        for (int i = 0; i < size; ++i) {
            result.add(f.apply(cur.get(i)));
        }
        return result;
    }

    @NonNull
    public static <I, O> Set<O> map(@Nullable Set<I> cur, Function<? super I, ? extends O> f) {
        if (CollectionUtils.isEmpty(cur)) {
            return Collections.emptySet();
        }
        ArraySet<O> result = new ArraySet<O>(cur.size());
        if (cur instanceof ArraySet) {
            ArraySet arraySet = (ArraySet)cur;
            int size = arraySet.size();
            for (int i = 0; i < size; ++i) {
                result.add(f.apply(arraySet.valueAt(i)));
            }
        } else {
            for (I item : cur) {
                result.add(f.apply(item));
            }
        }
        return result;
    }

    @NonNull
    public static <I, O> List<O> mapNotNull(@Nullable List<I> cur, Function<? super I, ? extends O> f) {
        if (CollectionUtils.isEmpty(cur)) {
            return Collections.emptyList();
        }
        List<O> result = null;
        int size = cur.size();
        for (int i = 0; i < size; ++i) {
            O transformed = f.apply(cur.get(i));
            if (transformed == null) continue;
            result = CollectionUtils.add(result, transformed);
        }
        return CollectionUtils.emptyIfNull(result);
    }

    @NonNull
    public static <T> List<T> emptyIfNull(@Nullable List<T> cur) {
        return cur == null ? Collections.emptyList() : cur;
    }

    @NonNull
    public static <T> Set<T> emptyIfNull(@Nullable Set<T> cur) {
        return cur == null ? Collections.emptySet() : cur;
    }

    @NonNull
    public static <K, V> Map<K, V> emptyIfNull(@Nullable Map<K, V> cur) {
        return cur == null ? Collections.emptyMap() : cur;
    }

    public static int size(@Nullable Collection<?> cur) {
        return cur != null ? cur.size() : 0;
    }

    public static int size(@Nullable Map<?, ?> cur) {
        return cur != null ? cur.size() : 0;
    }

    public static boolean isEmpty(@Nullable Collection<?> cur) {
        return CollectionUtils.size(cur) == 0;
    }

    public static boolean isEmpty(@Nullable Map<?, ?> cur) {
        return CollectionUtils.size(cur) == 0;
    }

    @NonNull
    public static <T> List<T> filter(@Nullable List<?> list, Class<T> c) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<?> result = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object item = list.get(i);
            if (!c.isInstance(item)) continue;
            result = ArrayUtils.add(result, item);
        }
        return CollectionUtils.emptyIfNull(result);
    }

    public static <T> boolean any(@Nullable List<T> items, Predicate<T> predicate) {
        return CollectionUtils.find(items, predicate) != null;
    }

    public static <T> boolean any(@Nullable Set<T> items, Predicate<T> predicate) {
        return CollectionUtils.find(items, predicate) != null;
    }

    @Nullable
    public static <T> T find(@Nullable List<T> items, Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(items)) {
            return null;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            T item = items.get(i);
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Nullable
    public static <T> T find(@Nullable Set<T> cur, Predicate<T> predicate) {
        if (cur == null || predicate == null) {
            return null;
        }
        int size = cur.size();
        if (size == 0) {
            return null;
        }
        try {
            if (cur instanceof ArraySet) {
                ArraySet arraySet = (ArraySet)cur;
                for (int i = 0; i < size; ++i) {
                    Object item = arraySet.valueAt(i);
                    if (!predicate.test(item)) continue;
                    return (T)item;
                }
            } else {
                for (T t : cur) {
                    if (!predicate.test(t)) continue;
                    return t;
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.propagate(e);
        }
        return null;
    }

    @NonNull
    public static <T> List<T> add(@Nullable List<T> cur, T val) {
        if (cur == null || cur == Collections.emptyList()) {
            cur = new ArrayList<T>();
        }
        cur.add(val);
        return cur;
    }

    @NonNull
    public static <T> List<T> add(@Nullable List<T> cur, int index, T val) {
        if (cur == null || cur == Collections.emptyList()) {
            cur = new ArrayList<T>();
        }
        cur.add(index, val);
        return cur;
    }

    @NonNull
    public static <T> Set<T> addAll(@Nullable Set<T> cur, @Nullable Collection<T> val) {
        if (CollectionUtils.isEmpty(val)) {
            return cur != null ? cur : Collections.emptySet();
        }
        if (cur == null || cur == Collections.emptySet()) {
            cur = new ArraySet<T>();
        }
        cur.addAll(val);
        return cur;
    }

    @NonNull
    public static <T> Set<T> add(@Nullable Set<T> cur, T val) {
        if (cur == null || cur == Collections.emptySet()) {
            cur = new ArraySet<T>();
        }
        cur.add(val);
        return cur;
    }

    @NonNull
    public static <K, V> Map<K, V> add(@Nullable Map<K, V> map, K key, V value) {
        if (map == null || map == Collections.emptyMap()) {
            map = new ArrayMap();
        }
        map.put(key, value);
        return map;
    }

    @NonNull
    public static <T> List<T> remove(@Nullable List<T> cur, T val) {
        if (CollectionUtils.isEmpty(cur)) {
            return CollectionUtils.emptyIfNull(cur);
        }
        cur.remove(val);
        return cur;
    }

    @NonNull
    public static <T> Set<T> remove(@Nullable Set<T> cur, T val) {
        if (CollectionUtils.isEmpty(cur)) {
            return CollectionUtils.emptyIfNull(cur);
        }
        cur.remove(val);
        return cur;
    }

    @NonNull
    public static <T> List<T> copyOf(@Nullable List<T> cur) {
        return CollectionUtils.isEmpty(cur) ? Collections.emptyList() : new ArrayList<T>(cur);
    }

    @NonNull
    public static <T> Set<T> copyOf(@Nullable Set<T> cur) {
        return CollectionUtils.isEmpty(cur) ? Collections.emptySet() : new ArraySet<T>(cur);
    }

    @NonNull
    public static <T> Set<T> toSet(@Nullable Collection<T> cur) {
        return CollectionUtils.isEmpty(cur) ? Collections.emptySet() : new ArraySet<T>(cur);
    }

    public static <T> void forEach(@Nullable Set<T> cur, @Nullable FunctionalUtils.ThrowingConsumer<T> action) {
        if (cur == null || action == null) {
            return;
        }
        int size = cur.size();
        if (size == 0) {
            return;
        }
        try {
            if (cur instanceof ArraySet) {
                ArraySet arraySet = (ArraySet)cur;
                for (int i = 0; i < size; ++i) {
                    action.acceptOrThrow(arraySet.valueAt(i));
                }
            } else {
                for (T t : cur) {
                    action.acceptOrThrow(t);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.propagate(e);
        }
    }

    public static <K, V> void forEach(@Nullable Map<K, V> cur, @Nullable BiConsumer<K, V> action) {
        if (cur == null || action == null) {
            return;
        }
        int size = cur.size();
        if (size == 0) {
            return;
        }
        if (cur instanceof ArrayMap) {
            ArrayMap arrayMap = (ArrayMap)cur;
            for (int i = 0; i < size; ++i) {
                action.accept(arrayMap.keyAt(i), arrayMap.valueAt(i));
            }
        } else {
            for (K key : cur.keySet()) {
                action.accept(key, cur.get(key));
            }
        }
    }

    @Nullable
    public static <T> T firstOrNull(@Nullable List<T> cur) {
        return CollectionUtils.isEmpty(cur) ? null : (T)cur.get(0);
    }

    @Nullable
    public static <T> T firstOrNull(@Nullable Collection<T> cur) {
        return CollectionUtils.isEmpty(cur) ? null : (T)cur.iterator().next();
    }

    @NonNull
    public static <T> List<T> singletonOrEmpty(@Nullable T item) {
        return item == null ? Collections.emptyList() : Collections.singletonList(item);
    }
}

