/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Debug;
import android.os.StrictMode;

public class MemInfoReader {
    final long[] mInfos = new long[26];

    @UnsupportedAppUsage
    public MemInfoReader() {
    }

    @UnsupportedAppUsage
    public void readMemInfo() {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        try {
            Debug.getMemInfo(this.mInfos);
        }
        finally {
            StrictMode.setThreadPolicy(savedPolicy);
        }
    }

    @UnsupportedAppUsage
    public long getTotalSize() {
        return this.mInfos[0] * 1024L;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getFreeSize() {
        return this.mInfos[1] * 1024L;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getCachedSize() {
        return this.getCachedSizeKb() * 1024L;
    }

    public long getKernelUsedSize() {
        return this.getKernelUsedSizeKb() * 1024L;
    }

    public long getTotalSizeKb() {
        return this.mInfos[0];
    }

    public long getFreeSizeKb() {
        return this.mInfos[1];
    }

    public long getShmemSizeKb() {
        return this.mInfos[4];
    }

    public long getCachedSizeKb() {
        long kReclaimable = this.mInfos[15];
        if (kReclaimable == 0L) {
            kReclaimable = this.mInfos[6];
        }
        return this.mInfos[2] + kReclaimable + this.mInfos[3] - this.mInfos[11];
    }

    public long getKernelUsedSizeKb() {
        long size = this.mInfos[4] + this.mInfos[7] + this.mInfos[12] + this.mInfos[13];
        if (!Debug.isVmapStack()) {
            size += this.mInfos[14];
        }
        return size;
    }

    public long getSwapTotalSizeKb() {
        return this.mInfos[8];
    }

    public long getSwapFreeSizeKb() {
        return this.mInfos[9];
    }

    public long getZramTotalSizeKb() {
        return this.mInfos[10];
    }

    @UnsupportedAppUsage
    public long[] getRawInfo() {
        return this.mInfos;
    }
}

