/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util.dump;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import android.util.Dumpable;
import android.util.DumpableContainer;
import android.util.IndentingPrintWriter;
import android.util.Log;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class DumpableContainerImpl
implements DumpableContainer {
    private static final String TAG = DumpableContainerImpl.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final ArrayMap<String, Dumpable> mDumpables = new ArrayMap();

    @Override
    public boolean addDumpable(Dumpable dumpable) {
        Objects.requireNonNull(dumpable, "dumpable");
        String name = dumpable.getDumpableName();
        Objects.requireNonNull(name, () -> "name of" + dumpable);
        if (this.mDumpables.containsKey(name)) {
            return false;
        }
        this.mDumpables.put(name, dumpable);
        return true;
    }

    @Override
    public boolean removeDumpable(Dumpable dumpable) {
        Objects.requireNonNull(dumpable, "dumpable");
        String name = dumpable.getDumpableName();
        if (name == null) {
            return false;
        }
        Dumpable candidate = this.mDumpables.get(name);
        if (candidate == null) {
            return false;
        }
        if (candidate != dumpable) {
            Log.w(TAG, "removeDumpable(): passed dumpable (" + dumpable + ") named " + name + ", but internal dumpable with that name is " + candidate);
            return false;
        }
        this.mDumpables.remove(name);
        return true;
    }

    private int dumpNumberDumpables(IndentingPrintWriter writer) {
        int size = this.mDumpables.size();
        if (size == 0) {
            writer.print("No dumpables");
        } else {
            writer.print(size);
            writer.print(" dumpables");
        }
        return size;
    }

    public void listDumpables(String prefix, PrintWriter writer) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)writer, prefix, prefix);
        int size = this.dumpNumberDumpables(ipw);
        if (size == 0) {
            ipw.println();
            return;
        }
        ipw.print(": ");
        for (int i = 0; i < size; ++i) {
            ipw.print(this.mDumpables.keyAt(i));
            if (i >= size - 1) continue;
            ipw.print(' ');
        }
        ipw.println();
    }

    public void dumpAllDumpables(String prefix, PrintWriter writer, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)writer, prefix, prefix);
        int size = this.dumpNumberDumpables(ipw);
        if (size == 0) {
            ipw.println();
            return;
        }
        ipw.println(":");
        for (int i = 0; i < size; ++i) {
            String dumpableName = this.mDumpables.keyAt(i);
            ipw.print('#');
            ipw.print(i);
            ipw.print(": ");
            ipw.println(dumpableName);
            Dumpable dumpable = this.mDumpables.valueAt(i);
            this.indentAndDump(ipw, dumpable, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indentAndDump(IndentingPrintWriter writer, Dumpable dumpable, String[] args) {
        writer.increaseIndent();
        try {
            dumpable.dump(writer, args);
        }
        finally {
            writer.decreaseIndent();
        }
    }

    public void dumpOneDumpable(String prefix, PrintWriter writer, String dumpableName, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)writer, prefix, prefix);
        Dumpable dumpable = this.mDumpables.get(dumpableName);
        if (dumpable == null) {
            ipw.print("No ");
            ipw.println(dumpableName);
            return;
        }
        ipw.print(dumpableName);
        ipw.println(':');
        this.indentAndDump(ipw, dumpable, args);
    }
}

