/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.VibrationEffect;
import android.os.vibrator.BasicPwleSegment;
import android.os.vibrator.Flags;
import android.os.vibrator.PrebakedSegment;
import android.os.vibrator.PrimitiveSegment;
import android.os.vibrator.PwleSegment;
import android.os.vibrator.StepSegment;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.vibrator.persistence.SerializedAmplitudeStepWaveform;
import com.android.internal.vibrator.persistence.SerializedBasicEnvelopeEffect;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.SerializedCompositionPrimitive;
import com.android.internal.vibrator.persistence.SerializedPredefinedEffect;
import com.android.internal.vibrator.persistence.SerializedRepeatingEffect;
import com.android.internal.vibrator.persistence.SerializedVendorEffect;
import com.android.internal.vibrator.persistence.SerializedWaveformEffectEntries;
import com.android.internal.vibrator.persistence.SerializedWaveformEnvelopeEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlSerializedVibration;
import com.android.internal.vibrator.persistence.XmlSerializerException;
import com.android.internal.vibrator.persistence.XmlValidator;
import java.util.List;
import java.util.function.BiConsumer;

public class VibrationEffectSerializer {
    private static final String TAG = "VibrationEffectSerializer";

    @NonNull
    public static XmlSerializedVibration<? extends VibrationEffect> serialize(@NonNull VibrationEffect vibration, int flags) throws XmlSerializerException {
        SerializedComposedEffect serializedEffect;
        if (Flags.vendorVibrationEffects() && vibration instanceof VibrationEffect.VendorEffect) {
            VibrationEffect.VendorEffect vendorEffect = (VibrationEffect.VendorEffect)vibration;
            return VibrationEffectSerializer.serializeVendorEffect(vendorEffect);
        }
        XmlValidator.checkSerializerCondition(vibration instanceof VibrationEffect.Composed, "Unsupported VibrationEffect type %s", vibration);
        VibrationEffect.Composed composed = (VibrationEffect.Composed)vibration;
        XmlValidator.checkSerializerCondition(!composed.getSegments().isEmpty(), "Unsupported empty VibrationEffect %s", vibration);
        List<VibrationEffectSegment> segments = composed.getSegments();
        int repeatIndex = composed.getRepeatIndex();
        if (repeatIndex >= 0) {
            serializedEffect = VibrationEffectSerializer.trySerializeRepeatingAmplitudeWaveformEffect(segments, repeatIndex);
            if (serializedEffect == null) {
                serializedEffect = VibrationEffectSerializer.serializeRepeatingEffect(segments, repeatIndex, flags);
            }
        } else {
            serializedEffect = VibrationEffectSerializer.serializeNonRepeatingEffect(segments, flags);
        }
        return serializedEffect;
    }

    private static SerializedComposedEffect serializeRepeatingEffect(List<VibrationEffectSegment> segments, int repeatIndex, int flags) throws XmlSerializerException {
        SerializedRepeatingEffect.Builder builder = new SerializedRepeatingEffect.Builder();
        if (repeatIndex > 0) {
            List<VibrationEffectSegment> preambleSegments = segments.subList(0, repeatIndex);
            builder.setPreamble(VibrationEffectSerializer.serializeEffectEntries(preambleSegments, flags));
            segments = segments.subList(repeatIndex, segments.size());
        }
        builder.setRepeating(VibrationEffectSerializer.serializeEffectEntries(segments, flags));
        return new SerializedComposedEffect(builder.build());
    }

    @NonNull
    private static SerializedComposedEffect serializeNonRepeatingEffect(List<VibrationEffectSegment> segments, int flags) throws XmlSerializerException {
        SerializedComposedEffect effect = VibrationEffectSerializer.trySerializeNonWaveformEffect(segments, flags);
        if (effect == null) {
            effect = VibrationEffectSerializer.serializeWaveformEffect(segments);
        }
        return effect;
    }

    @NonNull
    private static SerializedComposedEffect serializeEffectEntries(List<VibrationEffectSegment> segments, int flags) throws XmlSerializerException {
        SerializedComposedEffect effect = VibrationEffectSerializer.trySerializeNonWaveformEffect(segments, flags);
        if (effect == null) {
            effect = VibrationEffectSerializer.serializeWaveformEffectEntries(segments);
        }
        return effect;
    }

    @Nullable
    private static SerializedComposedEffect trySerializeNonWaveformEffect(List<VibrationEffectSegment> segments, int flags) throws XmlSerializerException {
        VibrationEffectSegment firstSegment = segments.getFirst();
        if (firstSegment instanceof PrebakedSegment) {
            return VibrationEffectSerializer.serializePredefinedEffect(segments, flags);
        }
        if (firstSegment instanceof PrimitiveSegment) {
            return VibrationEffectSerializer.serializePrimitiveEffect(segments);
        }
        if (firstSegment instanceof PwleSegment) {
            return VibrationEffectSerializer.serializeWaveformEnvelopeEffect(segments);
        }
        if (firstSegment instanceof BasicPwleSegment) {
            return VibrationEffectSerializer.serializeBasicEnvelopeEffect(segments);
        }
        return null;
    }

    private static SerializedComposedEffect serializePredefinedEffect(List<VibrationEffectSegment> segments, int flags) throws XmlSerializerException {
        XmlValidator.checkSerializerCondition(segments.size() == 1, "Unsupported multiple segments in predefined effect: %s", segments);
        return new SerializedComposedEffect(VibrationEffectSerializer.serializePrebakedSegment(segments.getFirst(), flags));
    }

    private static SerializedVendorEffect serializeVendorEffect(VibrationEffect.VendorEffect effect) {
        return new SerializedVendorEffect(effect.getVendorData());
    }

    private static SerializedComposedEffect serializePrimitiveEffect(List<VibrationEffectSegment> segments) throws XmlSerializerException {
        SerializedComposedEffect.SerializedSegment[] primitives = new SerializedComposedEffect.SerializedSegment[segments.size()];
        for (int i = 0; i < segments.size(); ++i) {
            primitives[i] = VibrationEffectSerializer.serializePrimitiveSegment(segments.get(i));
        }
        return new SerializedComposedEffect(primitives);
    }

    private static SerializedComposedEffect serializeWaveformEnvelopeEffect(List<VibrationEffectSegment> segments) throws XmlSerializerException {
        SerializedWaveformEnvelopeEffect.Builder builder = new SerializedWaveformEnvelopeEffect.Builder();
        for (int i = 0; i < segments.size(); ++i) {
            XmlValidator.checkSerializerCondition(segments.get(i) instanceof PwleSegment, "Unsupported segment for waveform envelope effect %s", segments.get(i));
            PwleSegment segment = (PwleSegment)segments.get(i);
            if (i == 0 && segment.getStartFrequencyHz() != segment.getEndFrequencyHz()) {
                builder.setInitialFrequencyHz(segment.getStartFrequencyHz());
            }
            builder.addControlPoint(segment.getEndAmplitude(), segment.getEndFrequencyHz(), segment.getDuration());
        }
        return new SerializedComposedEffect(builder.build());
    }

    private static SerializedComposedEffect serializeBasicEnvelopeEffect(List<VibrationEffectSegment> segments) throws XmlSerializerException {
        SerializedBasicEnvelopeEffect.Builder builder = new SerializedBasicEnvelopeEffect.Builder();
        for (int i = 0; i < segments.size(); ++i) {
            XmlValidator.checkSerializerCondition(segments.get(i) instanceof BasicPwleSegment, "Unsupported segment for basic envelope effect %s", segments.get(i));
            BasicPwleSegment segment = (BasicPwleSegment)segments.get(i);
            if (i == 0 && segment.getStartSharpness() != segment.getEndSharpness()) {
                builder.setInitialSharpness(segment.getStartSharpness());
            }
            builder.addControlPoint(segment.getEndIntensity(), segment.getEndSharpness(), segment.getDuration());
        }
        return new SerializedComposedEffect(builder.build());
    }

    private static SerializedComposedEffect trySerializeRepeatingAmplitudeWaveformEffect(List<VibrationEffectSegment> segments, int repeatingIndex) {
        SerializedAmplitudeStepWaveform.Builder builder = new SerializedAmplitudeStepWaveform.Builder();
        for (int i = 0; i < segments.size(); ++i) {
            if (repeatingIndex == i) {
                builder.setRepeatIndexToCurrentEntry();
            }
            try {
                VibrationEffectSerializer.serializeStepSegment(segments.get(i), builder::addDurationAndAmplitude);
                continue;
            }
            catch (XmlSerializerException e) {
                return null;
            }
        }
        return new SerializedComposedEffect(builder.build());
    }

    private static SerializedComposedEffect serializeWaveformEffect(List<VibrationEffectSegment> segments) throws XmlSerializerException {
        SerializedAmplitudeStepWaveform.Builder builder = new SerializedAmplitudeStepWaveform.Builder();
        for (int i = 0; i < segments.size(); ++i) {
            VibrationEffectSerializer.serializeStepSegment(segments.get(i), builder::addDurationAndAmplitude);
        }
        return new SerializedComposedEffect(builder.build());
    }

    private static SerializedComposedEffect serializeWaveformEffectEntries(List<VibrationEffectSegment> segments) throws XmlSerializerException {
        SerializedWaveformEffectEntries.Builder builder = new SerializedWaveformEffectEntries.Builder();
        for (int i = 0; i < segments.size(); ++i) {
            VibrationEffectSerializer.serializeStepSegment(segments.get(i), builder::addDurationAndAmplitude);
        }
        return new SerializedComposedEffect(builder.build());
    }

    private static void serializeStepSegment(VibrationEffectSegment segment, BiConsumer<Long, Integer> builder) throws XmlSerializerException {
        XmlValidator.checkSerializerCondition(segment instanceof StepSegment, "Unsupported segment for waveform effect %s", segment);
        XmlValidator.checkSerializerCondition(Float.compare(((StepSegment)segment).getFrequencyHz(), 0.0f) == 0, "Unsupported segment with non-default frequency %f", Float.valueOf(((StepSegment)segment).getFrequencyHz()));
        builder.accept(segment.getDuration(), VibrationEffectSerializer.toAmplitudeInt(((StepSegment)segment).getAmplitude()));
    }

    private static SerializedPredefinedEffect serializePrebakedSegment(VibrationEffectSegment segment, int flags) throws XmlSerializerException {
        XmlValidator.checkSerializerCondition(segment instanceof PrebakedSegment, "Unsupported segment for predefined effect %s", segment);
        PrebakedSegment prebaked = (PrebakedSegment)segment;
        XmlConstants.PredefinedEffectName effectName = XmlConstants.PredefinedEffectName.findById(prebaked.getEffectId(), flags);
        XmlValidator.checkSerializerCondition(effectName != null, "Unsupported predefined effect id %s", prebaked.getEffectId());
        if ((flags & 1) == 0) {
            XmlValidator.checkSerializerCondition(prebaked.shouldFallback(), "Unsupported predefined effect with should fallback %s", prebaked.shouldFallback());
        }
        return new SerializedPredefinedEffect(effectName, prebaked.shouldFallback());
    }

    private static SerializedCompositionPrimitive serializePrimitiveSegment(VibrationEffectSegment segment) throws XmlSerializerException {
        XmlValidator.checkSerializerCondition(segment instanceof PrimitiveSegment, "Unsupported segment for primitive composition %s", segment);
        PrimitiveSegment primitive = (PrimitiveSegment)segment;
        XmlConstants.PrimitiveEffectName primitiveName = XmlConstants.PrimitiveEffectName.findById(primitive.getPrimitiveId());
        XmlValidator.checkSerializerCondition(primitiveName != null, "Unsupported primitive effect id %s", primitive.getPrimitiveId());
        XmlConstants.PrimitiveDelayType delayType = null;
        if (Flags.primitiveCompositionAbsoluteDelay()) {
            delayType = XmlConstants.PrimitiveDelayType.findByType(primitive.getDelayType());
            XmlValidator.checkSerializerCondition(delayType != null, "Unsupported primitive delay type %s", primitive.getDelayType());
        } else {
            XmlValidator.checkSerializerCondition(primitive.getDelayType() == 0, "Unsupported primitive delay type %s", primitive.getDelayType());
        }
        return new SerializedCompositionPrimitive(primitiveName, primitive.getScale(), primitive.getDelay(), delayType);
    }

    private static int toAmplitudeInt(float amplitude) {
        return Float.compare(amplitude, -1.0f) == 0 ? -1 : Math.round(amplitude * 255.0f);
    }
}

