/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import android.os.vibrator.Flags;
import com.android.internal.vibrator.persistence.SerializedAmplitudeStepWaveform;
import com.android.internal.vibrator.persistence.SerializedBasicEnvelopeEffect;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.SerializedCompositionPrimitive;
import com.android.internal.vibrator.persistence.SerializedPredefinedEffect;
import com.android.internal.vibrator.persistence.SerializedRepeatingEffect;
import com.android.internal.vibrator.persistence.SerializedVendorEffect;
import com.android.internal.vibrator.persistence.SerializedWaveformEnvelopeEffect;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlSerializedVibration;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class VibrationEffectXmlParser {
    @NonNull
    public static XmlSerializedVibration<? extends VibrationEffect> parseTag(@NonNull TypedXmlPullParser parser, int flags) throws XmlParserException, IOException {
        XmlValidator.checkStartTag(parser, "vibration-effect");
        XmlValidator.checkTagHasNoUnexpectedAttributes(parser, new String[0]);
        return VibrationEffectXmlParser.parseVibrationContent(parser, flags);
    }

    private static XmlSerializedVibration<? extends VibrationEffect> parseVibrationContent(TypedXmlPullParser parser, int flags) throws XmlParserException, IOException {
        XmlSerializedVibration<VibrationEffect.VendorEffect> serializedVibration;
        String vibrationTagName = parser.getName();
        int vibrationTagDepth = parser.getDepth();
        XmlValidator.checkParserCondition(XmlReader.readNextTagWithin(parser, vibrationTagDepth), "Unsupported empty vibration tag", new Object[0]);
        switch (parser.getName()) {
            case "vendor-effect": {
                if (Flags.vendorVibrationEffects()) {
                    serializedVibration = SerializedVendorEffect.Parser.parseNext(parser, flags);
                    break;
                }
            }
            case "predefined-effect": {
                serializedVibration = new SerializedComposedEffect(SerializedPredefinedEffect.Parser.parseNext(parser, flags));
                break;
            }
            case "primitive-effect": {
                ArrayList<SerializedCompositionPrimitive> primitives = new ArrayList<SerializedCompositionPrimitive>();
                do {
                    primitives.add(SerializedCompositionPrimitive.Parser.parseNext(parser));
                } while (XmlReader.readNextTagWithin(parser, vibrationTagDepth));
                serializedVibration = new SerializedComposedEffect(primitives.toArray(new SerializedComposedEffect.SerializedSegment[primitives.size()]));
                break;
            }
            case "waveform-effect": {
                serializedVibration = new SerializedComposedEffect(SerializedAmplitudeStepWaveform.Parser.parseNext(parser));
                break;
            }
            case "waveform-envelope-effect": {
                if (Flags.normalizedPwleEffects()) {
                    serializedVibration = new SerializedComposedEffect(SerializedWaveformEnvelopeEffect.Parser.parseNext(parser, flags));
                    break;
                }
            }
            case "basic-envelope-effect": {
                if (Flags.normalizedPwleEffects()) {
                    serializedVibration = new SerializedComposedEffect(SerializedBasicEnvelopeEffect.Parser.parseNext(parser, flags));
                    break;
                }
            }
            case "repeating-effect": {
                if (Flags.normalizedPwleEffects()) {
                    serializedVibration = new SerializedComposedEffect(SerializedRepeatingEffect.Parser.parseNext(parser, flags));
                    break;
                }
            }
            default: {
                throw new XmlParserException("Unexpected tag " + parser.getName() + " in vibration tag " + vibrationTagName);
            }
        }
        XmlReader.readEndTag(parser, vibrationTagName, vibrationTagDepth);
        return serializedVibration;
    }
}

