/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.annotation.NonNull;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.ScrollCaptureViewHelper;
import java.util.function.Consumer;

public class ScrollViewCaptureHelper
implements ScrollCaptureViewHelper<ViewGroup> {
    private int mStartScrollY;
    private boolean mScrollBarEnabled;
    private int mOverScrollMode;

    @Override
    public boolean onAcceptSession(@NonNull ViewGroup view) {
        return view.isVisibleToUser() && (view.canScrollVertically(-1) || view.canScrollVertically(1));
    }

    @Override
    public void onPrepareForStart(@NonNull ViewGroup view, Rect scrollBounds) {
        this.mStartScrollY = view.getScrollY();
        this.mOverScrollMode = view.getOverScrollMode();
        if (this.mOverScrollMode != 2) {
            view.setOverScrollMode(2);
        }
        this.mScrollBarEnabled = view.isVerticalScrollBarEnabled();
        if (this.mScrollBarEnabled) {
            view.setVerticalScrollBarEnabled(false);
        }
    }

    @Override
    public void onScrollRequested(@NonNull ViewGroup view, Rect scrollBounds, Rect requestRect, CancellationSignal signal, Consumer<ScrollCaptureViewHelper.ScrollResult> resultConsumer) {
        int scrollDelta = view.getScrollY() - this.mStartScrollY;
        ScrollCaptureViewHelper.ScrollResult result = new ScrollCaptureViewHelper.ScrollResult();
        result.requestedArea = new Rect(requestRect);
        result.scrollDelta = scrollDelta;
        result.availableArea = new Rect();
        View contentView = view.getChildAt(0);
        if (contentView == null) {
            resultConsumer.accept(result);
            return;
        }
        Rect requestedContainerBounds = new Rect(requestRect);
        requestedContainerBounds.offset(0, -scrollDelta);
        requestedContainerBounds.offset(scrollBounds.left, scrollBounds.top);
        Rect requestedContentBounds = new Rect(requestedContainerBounds);
        requestedContentBounds.offset(view.getScrollX() - contentView.getLeft(), view.getScrollY() - contentView.getTop());
        Rect input = new Rect(requestedContentBounds);
        int remainingHeight = view.getHeight() - view.getPaddingTop() - view.getPaddingBottom() - input.height();
        if (remainingHeight > 0) {
            input.inset(0, -remainingHeight / 2);
        }
        contentView.requestRectangleOnScreen(input, true);
        result.scrollDelta = scrollDelta = view.getScrollY() - this.mStartScrollY;
        Point offset = new Point();
        Rect available = new Rect(requestedContentBounds);
        if (!view.getChildVisibleRect(contentView, available, offset)) {
            available.setEmpty();
            result.availableArea = available;
            resultConsumer.accept(result);
            return;
        }
        available.offset(-offset.x, -offset.y);
        available.offset(contentView.getLeft() - view.getScrollX(), contentView.getTop() - view.getScrollY());
        available.offset(-scrollBounds.left, -scrollBounds.top);
        available.offset(0, scrollDelta);
        result.availableArea = new Rect(available);
        resultConsumer.accept(result);
    }

    @Override
    public void onPrepareForEnd(@NonNull ViewGroup view) {
        view.scrollTo(0, this.mStartScrollY);
        if (this.mOverScrollMode != 2) {
            view.setOverScrollMode(this.mOverScrollMode);
        }
        if (this.mScrollBarEnabled) {
            view.setVerticalScrollBarEnabled(true);
        }
    }
}

