/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.PendingIntent;
import android.app.RemoteLockscreenValidationResult;
import android.app.RemoteLockscreenValidationSession;
import android.app.trust.IStrongAuthTracker;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.RecoveryCertPath;
import android.security.keystore.recovery.WrappedApplicationKey;
import com.android.internal.widget.ICheckCredentialProgressCallback;
import com.android.internal.widget.IWeakEscrowTokenActivatedListener;
import com.android.internal.widget.IWeakEscrowTokenRemovedListener;
import com.android.internal.widget.LockscreenCredential;
import com.android.internal.widget.VerifyCredentialResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ILockSettings
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/widget/ILockSettings.aidl:38:1:38:25")
    public void setBoolean(String var1, boolean var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/widget/ILockSettings.aidl:40:1:40:25")
    public void setLong(String var1, long var2, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/widget/ILockSettings.aidl:42:1:42:25")
    public void setString(String var1, String var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/widget/ILockSettings.aidl:44:1:44:25")
    public boolean getBoolean(String var1, boolean var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/widget/ILockSettings.aidl:46:1:46:25")
    public long getLong(String var1, long var2, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/widget/ILockSettings.aidl:48:1:48:25")
    public String getString(String var1, String var2, int var3) throws RemoteException;

    public boolean setLockCredential(LockscreenCredential var1, LockscreenCredential var2, int var3) throws RemoteException;

    public void resetKeyStore(int var1) throws RemoteException;

    public VerifyCredentialResponse checkCredential(LockscreenCredential var1, int var2, ICheckCredentialProgressCallback var3) throws RemoteException;

    public VerifyCredentialResponse verifyCredential(LockscreenCredential var1, int var2, int var3) throws RemoteException;

    public VerifyCredentialResponse verifyTiedProfileChallenge(LockscreenCredential var1, int var2, int var3) throws RemoteException;

    public VerifyCredentialResponse verifyGatekeeperPasswordHandle(long var1, long var3, int var5) throws RemoteException;

    public void removeGatekeeperPasswordHandle(long var1) throws RemoteException;

    public int getCredentialType(int var1) throws RemoteException;

    public int getPinLength(int var1) throws RemoteException;

    public boolean refreshStoredPinLength(int var1) throws RemoteException;

    public byte[] getHashFactor(LockscreenCredential var1, int var2) throws RemoteException;

    public void setSeparateProfileChallengeEnabled(int var1, boolean var2, LockscreenCredential var3) throws RemoteException;

    public boolean getSeparateProfileChallengeEnabled(int var1) throws RemoteException;

    public void registerStrongAuthTracker(IStrongAuthTracker var1) throws RemoteException;

    public void unregisterStrongAuthTracker(IStrongAuthTracker var1) throws RemoteException;

    public void requireStrongAuth(int var1, int var2) throws RemoteException;

    public void reportSuccessfulBiometricUnlock(boolean var1, int var2) throws RemoteException;

    public void scheduleNonStrongBiometricIdleTimeout(int var1) throws RemoteException;

    public void systemReady() throws RemoteException;

    public void userPresent(int var1) throws RemoteException;

    public int getStrongAuthForUser(int var1) throws RemoteException;

    public boolean hasPendingEscrowToken(int var1) throws RemoteException;

    public void initRecoveryServiceWithSigFile(String var1, byte[] var2, byte[] var3) throws RemoteException;

    public KeyChainSnapshot getKeyChainSnapshot() throws RemoteException;

    public String generateKey(String var1) throws RemoteException;

    public String generateKeyWithMetadata(String var1, byte[] var2) throws RemoteException;

    public String importKey(String var1, byte[] var2) throws RemoteException;

    public String importKeyWithMetadata(String var1, byte[] var2, byte[] var3) throws RemoteException;

    public String getKey(String var1) throws RemoteException;

    public void removeKey(String var1) throws RemoteException;

    public void setSnapshotCreatedPendingIntent(PendingIntent var1) throws RemoteException;

    public void setServerParams(byte[] var1) throws RemoteException;

    public void setRecoveryStatus(String var1, int var2) throws RemoteException;

    public Map getRecoveryStatus() throws RemoteException;

    public void setRecoverySecretTypes(int[] var1) throws RemoteException;

    public int[] getRecoverySecretTypes() throws RemoteException;

    public byte[] startRecoverySessionWithCertPath(String var1, String var2, RecoveryCertPath var3, byte[] var4, byte[] var5, List<KeyChainProtectionParams> var6) throws RemoteException;

    public Map recoverKeyChainSnapshot(String var1, byte[] var2, List<WrappedApplicationKey> var3) throws RemoteException;

    public void closeSession(String var1) throws RemoteException;

    public RemoteLockscreenValidationSession startRemoteLockscreenValidation() throws RemoteException;

    public RemoteLockscreenValidationResult validateRemoteLockscreen(byte[] var1) throws RemoteException;

    public boolean hasSecureLockScreen() throws RemoteException;

    public boolean tryUnlockWithCachedUnifiedChallenge(int var1) throws RemoteException;

    public void removeCachedUnifiedChallenge(int var1) throws RemoteException;

    public boolean registerWeakEscrowTokenRemovedListener(IWeakEscrowTokenRemovedListener var1) throws RemoteException;

    public boolean unregisterWeakEscrowTokenRemovedListener(IWeakEscrowTokenRemovedListener var1) throws RemoteException;

    public long addWeakEscrowToken(byte[] var1, int var2, IWeakEscrowTokenActivatedListener var3) throws RemoteException;

    public boolean removeWeakEscrowToken(long var1, int var3) throws RemoteException;

    public boolean isWeakEscrowTokenActive(long var1, int var3) throws RemoteException;

    public boolean isWeakEscrowTokenValid(long var1, byte[] var3, int var4) throws RemoteException;

    public void unlockUserKeyIfUnsecured(int var1) throws RemoteException;

    public boolean writeRepairModeCredential(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILockSettings {
        public static final String DESCRIPTOR = "com.android.internal.widget.ILockSettings";
        static final int TRANSACTION_setBoolean = 1;
        static final int TRANSACTION_setLong = 2;
        static final int TRANSACTION_setString = 3;
        static final int TRANSACTION_getBoolean = 4;
        static final int TRANSACTION_getLong = 5;
        static final int TRANSACTION_getString = 6;
        static final int TRANSACTION_setLockCredential = 7;
        static final int TRANSACTION_resetKeyStore = 8;
        static final int TRANSACTION_checkCredential = 9;
        static final int TRANSACTION_verifyCredential = 10;
        static final int TRANSACTION_verifyTiedProfileChallenge = 11;
        static final int TRANSACTION_verifyGatekeeperPasswordHandle = 12;
        static final int TRANSACTION_removeGatekeeperPasswordHandle = 13;
        static final int TRANSACTION_getCredentialType = 14;
        static final int TRANSACTION_getPinLength = 15;
        static final int TRANSACTION_refreshStoredPinLength = 16;
        static final int TRANSACTION_getHashFactor = 17;
        static final int TRANSACTION_setSeparateProfileChallengeEnabled = 18;
        static final int TRANSACTION_getSeparateProfileChallengeEnabled = 19;
        static final int TRANSACTION_registerStrongAuthTracker = 20;
        static final int TRANSACTION_unregisterStrongAuthTracker = 21;
        static final int TRANSACTION_requireStrongAuth = 22;
        static final int TRANSACTION_reportSuccessfulBiometricUnlock = 23;
        static final int TRANSACTION_scheduleNonStrongBiometricIdleTimeout = 24;
        static final int TRANSACTION_systemReady = 25;
        static final int TRANSACTION_userPresent = 26;
        static final int TRANSACTION_getStrongAuthForUser = 27;
        static final int TRANSACTION_hasPendingEscrowToken = 28;
        static final int TRANSACTION_initRecoveryServiceWithSigFile = 29;
        static final int TRANSACTION_getKeyChainSnapshot = 30;
        static final int TRANSACTION_generateKey = 31;
        static final int TRANSACTION_generateKeyWithMetadata = 32;
        static final int TRANSACTION_importKey = 33;
        static final int TRANSACTION_importKeyWithMetadata = 34;
        static final int TRANSACTION_getKey = 35;
        static final int TRANSACTION_removeKey = 36;
        static final int TRANSACTION_setSnapshotCreatedPendingIntent = 37;
        static final int TRANSACTION_setServerParams = 38;
        static final int TRANSACTION_setRecoveryStatus = 39;
        static final int TRANSACTION_getRecoveryStatus = 40;
        static final int TRANSACTION_setRecoverySecretTypes = 41;
        static final int TRANSACTION_getRecoverySecretTypes = 42;
        static final int TRANSACTION_startRecoverySessionWithCertPath = 43;
        static final int TRANSACTION_recoverKeyChainSnapshot = 44;
        static final int TRANSACTION_closeSession = 45;
        static final int TRANSACTION_startRemoteLockscreenValidation = 46;
        static final int TRANSACTION_validateRemoteLockscreen = 47;
        static final int TRANSACTION_hasSecureLockScreen = 48;
        static final int TRANSACTION_tryUnlockWithCachedUnifiedChallenge = 49;
        static final int TRANSACTION_removeCachedUnifiedChallenge = 50;
        static final int TRANSACTION_registerWeakEscrowTokenRemovedListener = 51;
        static final int TRANSACTION_unregisterWeakEscrowTokenRemovedListener = 52;
        static final int TRANSACTION_addWeakEscrowToken = 53;
        static final int TRANSACTION_removeWeakEscrowToken = 54;
        static final int TRANSACTION_isWeakEscrowTokenActive = 55;
        static final int TRANSACTION_isWeakEscrowTokenValid = 56;
        static final int TRANSACTION_unlockUserKeyIfUnsecured = 57;
        static final int TRANSACTION_writeRepairModeCredential = 58;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILockSettings asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ILockSettings) {
                return (ILockSettings)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setBoolean";
                }
                case 2: {
                    return "setLong";
                }
                case 3: {
                    return "setString";
                }
                case 4: {
                    return "getBoolean";
                }
                case 5: {
                    return "getLong";
                }
                case 6: {
                    return "getString";
                }
                case 7: {
                    return "setLockCredential";
                }
                case 8: {
                    return "resetKeyStore";
                }
                case 9: {
                    return "checkCredential";
                }
                case 10: {
                    return "verifyCredential";
                }
                case 11: {
                    return "verifyTiedProfileChallenge";
                }
                case 12: {
                    return "verifyGatekeeperPasswordHandle";
                }
                case 13: {
                    return "removeGatekeeperPasswordHandle";
                }
                case 14: {
                    return "getCredentialType";
                }
                case 15: {
                    return "getPinLength";
                }
                case 16: {
                    return "refreshStoredPinLength";
                }
                case 17: {
                    return "getHashFactor";
                }
                case 18: {
                    return "setSeparateProfileChallengeEnabled";
                }
                case 19: {
                    return "getSeparateProfileChallengeEnabled";
                }
                case 20: {
                    return "registerStrongAuthTracker";
                }
                case 21: {
                    return "unregisterStrongAuthTracker";
                }
                case 22: {
                    return "requireStrongAuth";
                }
                case 23: {
                    return "reportSuccessfulBiometricUnlock";
                }
                case 24: {
                    return "scheduleNonStrongBiometricIdleTimeout";
                }
                case 25: {
                    return "systemReady";
                }
                case 26: {
                    return "userPresent";
                }
                case 27: {
                    return "getStrongAuthForUser";
                }
                case 28: {
                    return "hasPendingEscrowToken";
                }
                case 29: {
                    return "initRecoveryServiceWithSigFile";
                }
                case 30: {
                    return "getKeyChainSnapshot";
                }
                case 31: {
                    return "generateKey";
                }
                case 32: {
                    return "generateKeyWithMetadata";
                }
                case 33: {
                    return "importKey";
                }
                case 34: {
                    return "importKeyWithMetadata";
                }
                case 35: {
                    return "getKey";
                }
                case 36: {
                    return "removeKey";
                }
                case 37: {
                    return "setSnapshotCreatedPendingIntent";
                }
                case 38: {
                    return "setServerParams";
                }
                case 39: {
                    return "setRecoveryStatus";
                }
                case 40: {
                    return "getRecoveryStatus";
                }
                case 41: {
                    return "setRecoverySecretTypes";
                }
                case 42: {
                    return "getRecoverySecretTypes";
                }
                case 43: {
                    return "startRecoverySessionWithCertPath";
                }
                case 44: {
                    return "recoverKeyChainSnapshot";
                }
                case 45: {
                    return "closeSession";
                }
                case 46: {
                    return "startRemoteLockscreenValidation";
                }
                case 47: {
                    return "validateRemoteLockscreen";
                }
                case 48: {
                    return "hasSecureLockScreen";
                }
                case 49: {
                    return "tryUnlockWithCachedUnifiedChallenge";
                }
                case 50: {
                    return "removeCachedUnifiedChallenge";
                }
                case 51: {
                    return "registerWeakEscrowTokenRemovedListener";
                }
                case 52: {
                    return "unregisterWeakEscrowTokenRemovedListener";
                }
                case 53: {
                    return "addWeakEscrowToken";
                }
                case 54: {
                    return "removeWeakEscrowToken";
                }
                case 55: {
                    return "isWeakEscrowTokenActive";
                }
                case 56: {
                    return "isWeakEscrowTokenValid";
                }
                case 57: {
                    return "unlockUserKeyIfUnsecured";
                }
                case 58: {
                    return "writeRepairModeCredential";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setBoolean(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setLong(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setString(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.getBoolean(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getLong(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getString(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 7: {
                    LockscreenCredential _arg0 = data.readTypedObject(LockscreenCredential.CREATOR);
                    LockscreenCredential _arg1 = data.readTypedObject(LockscreenCredential.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setLockCredential(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resetKeyStore(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    LockscreenCredential _arg0 = data.readTypedObject(LockscreenCredential.CREATOR);
                    int _arg1 = data.readInt();
                    ICheckCredentialProgressCallback _arg2 = ICheckCredentialProgressCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    VerifyCredentialResponse _result = this.checkCredential(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    LockscreenCredential _arg0 = data.readTypedObject(LockscreenCredential.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    VerifyCredentialResponse _result = this.verifyCredential(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    LockscreenCredential _arg0 = data.readTypedObject(LockscreenCredential.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    VerifyCredentialResponse _result = this.verifyTiedProfileChallenge(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    VerifyCredentialResponse _result = this.verifyGatekeeperPasswordHandle(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.removeGatekeeperPasswordHandle(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getCredentialType(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getPinLength(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.refreshStoredPinLength(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    LockscreenCredential _arg0 = data.readTypedObject(LockscreenCredential.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    byte[] _result = this.getHashFactor(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    LockscreenCredential _arg2 = data.readTypedObject(LockscreenCredential.CREATOR);
                    data.enforceNoDataAvail();
                    this.setSeparateProfileChallengeEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.getSeparateProfileChallengeEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    IStrongAuthTracker _arg0 = IStrongAuthTracker.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStrongAuthTracker(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IStrongAuthTracker _arg0 = IStrongAuthTracker.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStrongAuthTracker(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requireStrongAuth(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportSuccessfulBiometricUnlock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.scheduleNonStrongBiometricIdleTimeout(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    this.systemReady();
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.userPresent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStrongAuthForUser(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasPendingEscrowToken(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.initRecoveryServiceWithSigFile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    KeyChainSnapshot _result = this.getKeyChainSnapshot();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.generateKey(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 32: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    String _result = this.generateKeyWithMetadata(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    String _result = this.importKey(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    String _result = this.importKeyWithMetadata(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getKey(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.setSnapshotCreatedPendingIntent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setServerParams(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRecoveryStatus(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    Map _result = this.getRecoveryStatus();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 41: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setRecoverySecretTypes(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int[] _result = this.getRecoverySecretTypes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 43: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    RecoveryCertPath _arg2 = data.readTypedObject(RecoveryCertPath.CREATOR);
                    byte[] _arg3 = data.createByteArray();
                    byte[] _arg4 = data.createByteArray();
                    ArrayList<KeyChainProtectionParams> _arg5 = data.createTypedArrayList(KeyChainProtectionParams.CREATOR);
                    data.enforceNoDataAvail();
                    byte[] _result = this.startRecoverySessionWithCertPath(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 44: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    ArrayList<WrappedApplicationKey> _arg2 = data.createTypedArrayList(WrappedApplicationKey.CREATOR);
                    data.enforceNoDataAvail();
                    Map _result = this.recoverKeyChainSnapshot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 45: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.closeSession(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    RemoteLockscreenValidationSession _result = this.startRemoteLockscreenValidation();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 47: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    RemoteLockscreenValidationResult _result = this.validateRemoteLockscreen(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 48: {
                    boolean _result = this.hasSecureLockScreen();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.tryUnlockWithCachedUnifiedChallenge(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeCachedUnifiedChallenge(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    IWeakEscrowTokenRemovedListener _arg0 = IWeakEscrowTokenRemovedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerWeakEscrowTokenRemovedListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 52: {
                    IWeakEscrowTokenRemovedListener _arg0 = IWeakEscrowTokenRemovedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.unregisterWeakEscrowTokenRemovedListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 53: {
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    IWeakEscrowTokenActivatedListener _arg2 = IWeakEscrowTokenActivatedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    long _result = this.addWeakEscrowToken(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 54: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeWeakEscrowToken(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 55: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWeakEscrowTokenActive(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 56: {
                    long _arg0 = data.readLong();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWeakEscrowTokenValid(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unlockUserKeyIfUnsecured(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.writeRepairModeCredential(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 57;
        }

        private static class Proxy
        implements ILockSettings {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBoolean(String key, boolean value, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeBoolean(value);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLong(String key, long value, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeLong(value);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setString(String key, String value, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeString(value);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getBoolean(String key, boolean defaultValue, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeBoolean(defaultValue);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getLong(String key, long defaultValue, int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeLong(defaultValue);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getString(String key, String defaultValue, int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeString(defaultValue);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setLockCredential(LockscreenCredential credential, LockscreenCredential savedCredential, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(credential, 0);
                    _data.writeTypedObject(savedCredential, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetKeyStore(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifyCredentialResponse checkCredential(LockscreenCredential credential, int userId, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
                VerifyCredentialResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(credential, 0);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(progressCallback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifyCredentialResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifyCredentialResponse verifyCredential(LockscreenCredential credential, int userId, int flags) throws RemoteException {
                VerifyCredentialResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(credential, 0);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifyCredentialResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifyCredentialResponse verifyTiedProfileChallenge(LockscreenCredential credential, int userId, int flags) throws RemoteException {
                VerifyCredentialResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(credential, 0);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifyCredentialResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifyCredentialResponse verifyGatekeeperPasswordHandle(long gatekeeperPasswordHandle, long challenge, int userId) throws RemoteException {
                VerifyCredentialResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(gatekeeperPasswordHandle);
                    _data.writeLong(challenge);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifyCredentialResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGatekeeperPasswordHandle(long gatekeeperPasswordHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(gatekeeperPasswordHandle);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCredentialType(int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPinLength(int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean refreshStoredPinLength(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getHashFactor(LockscreenCredential currentCredential, int userId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(currentCredential, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSeparateProfileChallengeEnabled(int userId, boolean enabled, LockscreenCredential managedUserPassword) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(enabled);
                    _data.writeTypedObject(managedUserPassword, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSeparateProfileChallengeEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStrongAuthTracker(IStrongAuthTracker tracker) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(tracker);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStrongAuthTracker(IStrongAuthTracker tracker) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(tracker);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requireStrongAuth(int strongAuthReason, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strongAuthReason);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportSuccessfulBiometricUnlock(boolean isStrongBiometric, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isStrongBiometric);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void scheduleNonStrongBiometricIdleTimeout(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void systemReady() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void userPresent(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStrongAuthForUser(int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasPendingEscrowToken(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initRecoveryServiceWithSigFile(String rootCertificateAlias, byte[] recoveryServiceCertFile, byte[] recoveryServiceSigFile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rootCertificateAlias);
                    _data.writeByteArray(recoveryServiceCertFile);
                    _data.writeByteArray(recoveryServiceSigFile);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyChainSnapshot getKeyChainSnapshot() throws RemoteException {
                KeyChainSnapshot _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyChainSnapshot.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String generateKey(String alias) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String generateKeyWithMetadata(String alias, byte[] metadata) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    _data.writeByteArray(metadata);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String importKey(String alias, byte[] keyBytes) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    _data.writeByteArray(keyBytes);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String importKeyWithMetadata(String alias, byte[] keyBytes, byte[] metadata) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    _data.writeByteArray(keyBytes);
                    _data.writeByteArray(metadata);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getKey(String alias) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeKey(String alias) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSnapshotCreatedPendingIntent(PendingIntent intent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setServerParams(byte[] serverParams) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(serverParams);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecoveryStatus(String alias, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    _data.writeInt(status);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getRecoveryStatus() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecoverySecretTypes(int[] secretTypes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(secretTypes);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getRecoverySecretTypes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] startRecoverySessionWithCertPath(String sessionId, String rootCertificateAlias, RecoveryCertPath verifierCertPath, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeString(rootCertificateAlias);
                    _data.writeTypedObject(verifierCertPath, 0);
                    _data.writeByteArray(vaultParams);
                    _data.writeByteArray(vaultChallenge);
                    _data.writeTypedList(secrets, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map recoverKeyChainSnapshot(String sessionId, byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeByteArray(recoveryKeyBlob);
                    _data.writeTypedList(applicationKeys, 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSession(String sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sessionId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RemoteLockscreenValidationSession startRemoteLockscreenValidation() throws RemoteException {
                RemoteLockscreenValidationSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RemoteLockscreenValidationSession.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RemoteLockscreenValidationResult validateRemoteLockscreen(byte[] encryptedCredential) throws RemoteException {
                RemoteLockscreenValidationResult _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(encryptedCredential);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RemoteLockscreenValidationResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasSecureLockScreen() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean tryUnlockWithCachedUnifiedChallenge(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCachedUnifiedChallenge(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerWeakEscrowTokenRemovedListener(IWeakEscrowTokenRemovedListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterWeakEscrowTokenRemovedListener(IWeakEscrowTokenRemovedListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long addWeakEscrowToken(byte[] token, int userId, IWeakEscrowTokenActivatedListener callback) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(token);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeWeakEscrowToken(long handle, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(handle);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWeakEscrowTokenActive(long handle, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(handle);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWeakEscrowTokenValid(long handle, byte[] token, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(handle);
                    _data.writeByteArray(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockUserKeyIfUnsecured(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean writeRepairModeCredential(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ILockSettings {
        @Override
        public void setBoolean(String key, boolean value, int userId) throws RemoteException {
        }

        @Override
        public void setLong(String key, long value, int userId) throws RemoteException {
        }

        @Override
        public void setString(String key, String value, int userId) throws RemoteException {
        }

        @Override
        public boolean getBoolean(String key, boolean defaultValue, int userId) throws RemoteException {
            return false;
        }

        @Override
        public long getLong(String key, long defaultValue, int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public String getString(String key, String defaultValue, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setLockCredential(LockscreenCredential credential, LockscreenCredential savedCredential, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void resetKeyStore(int userId) throws RemoteException {
        }

        @Override
        public VerifyCredentialResponse checkCredential(LockscreenCredential credential, int userId, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
            return null;
        }

        @Override
        public VerifyCredentialResponse verifyCredential(LockscreenCredential credential, int userId, int flags) throws RemoteException {
            return null;
        }

        @Override
        public VerifyCredentialResponse verifyTiedProfileChallenge(LockscreenCredential credential, int userId, int flags) throws RemoteException {
            return null;
        }

        @Override
        public VerifyCredentialResponse verifyGatekeeperPasswordHandle(long gatekeeperPasswordHandle, long challenge, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void removeGatekeeperPasswordHandle(long gatekeeperPasswordHandle) throws RemoteException {
        }

        @Override
        public int getCredentialType(int userId) throws RemoteException {
            return 0;
        }

        @Override
        public int getPinLength(int userId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean refreshStoredPinLength(int userId) throws RemoteException {
            return false;
        }

        @Override
        public byte[] getHashFactor(LockscreenCredential currentCredential, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setSeparateProfileChallengeEnabled(int userId, boolean enabled, LockscreenCredential managedUserPassword) throws RemoteException {
        }

        @Override
        public boolean getSeparateProfileChallengeEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void registerStrongAuthTracker(IStrongAuthTracker tracker) throws RemoteException {
        }

        @Override
        public void unregisterStrongAuthTracker(IStrongAuthTracker tracker) throws RemoteException {
        }

        @Override
        public void requireStrongAuth(int strongAuthReason, int userId) throws RemoteException {
        }

        @Override
        public void reportSuccessfulBiometricUnlock(boolean isStrongBiometric, int userId) throws RemoteException {
        }

        @Override
        public void scheduleNonStrongBiometricIdleTimeout(int userId) throws RemoteException {
        }

        @Override
        public void systemReady() throws RemoteException {
        }

        @Override
        public void userPresent(int userId) throws RemoteException {
        }

        @Override
        public int getStrongAuthForUser(int userId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean hasPendingEscrowToken(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void initRecoveryServiceWithSigFile(String rootCertificateAlias, byte[] recoveryServiceCertFile, byte[] recoveryServiceSigFile) throws RemoteException {
        }

        @Override
        public KeyChainSnapshot getKeyChainSnapshot() throws RemoteException {
            return null;
        }

        @Override
        public String generateKey(String alias) throws RemoteException {
            return null;
        }

        @Override
        public String generateKeyWithMetadata(String alias, byte[] metadata) throws RemoteException {
            return null;
        }

        @Override
        public String importKey(String alias, byte[] keyBytes) throws RemoteException {
            return null;
        }

        @Override
        public String importKeyWithMetadata(String alias, byte[] keyBytes, byte[] metadata) throws RemoteException {
            return null;
        }

        @Override
        public String getKey(String alias) throws RemoteException {
            return null;
        }

        @Override
        public void removeKey(String alias) throws RemoteException {
        }

        @Override
        public void setSnapshotCreatedPendingIntent(PendingIntent intent) throws RemoteException {
        }

        @Override
        public void setServerParams(byte[] serverParams) throws RemoteException {
        }

        @Override
        public void setRecoveryStatus(String alias, int status) throws RemoteException {
        }

        @Override
        public Map getRecoveryStatus() throws RemoteException {
            return null;
        }

        @Override
        public void setRecoverySecretTypes(int[] secretTypes) throws RemoteException {
        }

        @Override
        public int[] getRecoverySecretTypes() throws RemoteException {
            return null;
        }

        @Override
        public byte[] startRecoverySessionWithCertPath(String sessionId, String rootCertificateAlias, RecoveryCertPath verifierCertPath, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws RemoteException {
            return null;
        }

        @Override
        public Map recoverKeyChainSnapshot(String sessionId, byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws RemoteException {
            return null;
        }

        @Override
        public void closeSession(String sessionId) throws RemoteException {
        }

        @Override
        public RemoteLockscreenValidationSession startRemoteLockscreenValidation() throws RemoteException {
            return null;
        }

        @Override
        public RemoteLockscreenValidationResult validateRemoteLockscreen(byte[] encryptedCredential) throws RemoteException {
            return null;
        }

        @Override
        public boolean hasSecureLockScreen() throws RemoteException {
            return false;
        }

        @Override
        public boolean tryUnlockWithCachedUnifiedChallenge(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void removeCachedUnifiedChallenge(int userId) throws RemoteException {
        }

        @Override
        public boolean registerWeakEscrowTokenRemovedListener(IWeakEscrowTokenRemovedListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterWeakEscrowTokenRemovedListener(IWeakEscrowTokenRemovedListener listener) throws RemoteException {
            return false;
        }

        @Override
        public long addWeakEscrowToken(byte[] token, int userId, IWeakEscrowTokenActivatedListener callback) throws RemoteException {
            return 0L;
        }

        @Override
        public boolean removeWeakEscrowToken(long handle, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isWeakEscrowTokenActive(long handle, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isWeakEscrowTokenValid(long handle, byte[] token, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void unlockUserKeyIfUnsecured(int userId) throws RemoteException {
        }

        @Override
        public boolean writeRepairModeCredential(int userId) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

