/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.input.InputManager;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.ISystemGestureExclusionListener;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.RoundedCorner;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowInsets;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerPolicyConstants;

public class PointerLocationView
extends View
implements InputManager.InputDeviceListener,
WindowManagerPolicyConstants.PointerEventListener {
    private static final String TAG = "Pointer";
    private static final String ALT_STRATEGY_PROPERY_KEY = "debug.velocitytracker.alt";
    private static final String GESTURE_EXCLUSION_PROP = "debug.pointerlocation.showexclusion";
    private static final PointerState EMPTY_POINTER_STATE = new PointerState();
    private final InputManager mIm;
    private final ViewConfiguration mVC;
    private final Paint mTextPaint;
    private final Paint mTextBackgroundPaint;
    private final Paint mTextLevelPaint;
    private final Paint mPaint;
    private final Paint mCurrentPointPaint;
    private final Paint mTargetPaint;
    private final Paint mPathPaint;
    private final Paint.FontMetricsInt mTextMetrics = new Paint.FontMetricsInt();
    private int mHeaderBottom;
    private int mHeaderPaddingTop = 0;
    private Insets mWaterfallInsets = Insets.NONE;
    @UnsupportedAppUsage
    private boolean mCurDown;
    @UnsupportedAppUsage
    private int mCurNumPointers;
    @UnsupportedAppUsage
    private int mMaxNumPointers;
    private int mActivePointerId;
    @UnsupportedAppUsage
    private final SparseArray<PointerState> mPointers = new SparseArray();
    private final MotionEvent.PointerCoords mTempCoords = new MotionEvent.PointerCoords();
    private Bitmap mTraceBitmap;
    private final Canvas mTraceCanvas;
    private final Region mSystemGestureExclusion = new Region();
    private final Region mSystemGestureExclusionRejected = new Region();
    private final Path mSystemGestureExclusionPath = new Path();
    private final Paint mSystemGestureExclusionPaint;
    private final Paint mSystemGestureExclusionRejectedPaint;
    private final VelocityTracker mVelocity;
    private final VelocityTracker mAltVelocity;
    private final FasterStringBuilder mText = new FasterStringBuilder();
    @UnsupportedAppUsage
    private boolean mPrintCoords = true;
    private float mDensity;
    private final RectF mReusableOvalRect = new RectF();
    private final ISystemGestureExclusionListener mSystemGestureExclusionListener = new ISystemGestureExclusionListener.Stub(){

        @Override
        public void onSystemGestureExclusionChanged(int displayId, Region systemGestureExclusion, Region systemGestureExclusionUnrestricted) {
            Handler handler;
            Region exclusion = Region.obtain(systemGestureExclusion);
            Region rejected = Region.obtain();
            if (systemGestureExclusionUnrestricted != null) {
                rejected.set(systemGestureExclusionUnrestricted);
                rejected.op(exclusion, Region.Op.DIFFERENCE);
            }
            if ((handler = PointerLocationView.this.getHandler()) != null) {
                handler.post(() -> {
                    PointerLocationView.this.mSystemGestureExclusion.set(exclusion);
                    PointerLocationView.this.mSystemGestureExclusionRejected.set(rejected);
                    exclusion.recycle();
                    PointerLocationView.this.invalidate();
                });
            }
        }
    };

    public PointerLocationView(Context c) {
        super(c);
        this.setFocusableInTouchMode(true);
        this.mIm = c.getSystemService(InputManager.class);
        this.mVC = ViewConfiguration.get(c);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mCurrentPointPaint = new Paint();
        this.mCurrentPointPaint.setAntiAlias(true);
        this.mCurrentPointPaint.setARGB(255, 255, 0, 0);
        this.mCurrentPointPaint.setStyle(Paint.Style.STROKE);
        this.mTargetPaint = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mTraceCanvas = new Canvas();
        this.configureTraceBitmap();
        this.configureDensityDependentFactors();
        this.mSystemGestureExclusionPaint = new Paint();
        this.mSystemGestureExclusionPaint.setARGB(25, 255, 0, 0);
        this.mSystemGestureExclusionPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mSystemGestureExclusionRejectedPaint = new Paint();
        this.mSystemGestureExclusionRejectedPaint.setARGB(25, 0, 0, 255);
        this.mSystemGestureExclusionRejectedPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mActivePointerId = 0;
        this.mVelocity = VelocityTracker.obtain();
        String altStrategy = SystemProperties.get(ALT_STRATEGY_PROPERY_KEY);
        if (altStrategy.length() != 0) {
            Log.d(TAG, "Comparing default velocity tracker strategy with " + altStrategy);
            this.mAltVelocity = VelocityTracker.obtain(altStrategy);
        } else {
            this.mAltVelocity = null;
        }
    }

    public void setPrintCoords(boolean state) {
        this.mPrintCoords = state;
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        RoundedCorner topRightRounded;
        int headerPaddingTop = 0;
        Insets waterfallInsets = Insets.NONE;
        RoundedCorner topLeftRounded = insets.getRoundedCorner(0);
        if (topLeftRounded != null) {
            headerPaddingTop = topLeftRounded.getRadius();
        }
        if ((topRightRounded = insets.getRoundedCorner(1)) != null) {
            headerPaddingTop = Math.max(headerPaddingTop, topRightRounded.getRadius());
        }
        if (insets.getDisplayCutout() != null) {
            headerPaddingTop = Math.max(headerPaddingTop, insets.getDisplayCutout().getSafeInsetTop());
            waterfallInsets = insets.getDisplayCutout().getWaterfallInsets();
        }
        this.mHeaderPaddingTop = headerPaddingTop;
        this.mWaterfallInsets = waterfallInsets;
        return super.onApplyWindowInsets(insets);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mTextPaint.getFontMetricsInt(this.mTextMetrics);
        this.mHeaderBottom = this.mHeaderPaddingTop - this.mTextMetrics.ascent + this.mTextMetrics.descent + 2;
    }

    private void drawOval(Canvas canvas, float x, float y, float major, float minor, float angle, Paint paint) {
        canvas.save(1);
        canvas.rotate((float)((double)(angle * 180.0f) / Math.PI), x, y);
        this.mReusableOvalRect.left = x - minor / 2.0f;
        this.mReusableOvalRect.right = x + minor / 2.0f;
        this.mReusableOvalRect.top = y - major / 2.0f;
        this.mReusableOvalRect.bottom = y + major / 2.0f;
        canvas.drawOval(this.mReusableOvalRect, paint);
        canvas.restore();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        int NP = this.mPointers.size();
        canvas.save();
        this.rotateCanvasToUnrotatedDisplay(canvas);
        canvas.drawBitmap(this.mTraceBitmap, 0.0f, 0.0f, null);
        canvas.restore();
        if (!this.mSystemGestureExclusion.isEmpty()) {
            this.mSystemGestureExclusionPath.reset();
            this.mSystemGestureExclusion.getBoundaryPath(this.mSystemGestureExclusionPath);
            canvas.drawPath(this.mSystemGestureExclusionPath, this.mSystemGestureExclusionPaint);
        }
        if (!this.mSystemGestureExclusionRejected.isEmpty()) {
            this.mSystemGestureExclusionPath.reset();
            this.mSystemGestureExclusionRejected.getBoundaryPath(this.mSystemGestureExclusionPath);
            canvas.drawPath(this.mSystemGestureExclusionPath, this.mSystemGestureExclusionRejectedPaint);
        }
        this.drawLabels(canvas);
        canvas.save();
        this.rotateCanvasToUnrotatedDisplay(canvas);
        for (int p = 0; p < NP; ++p) {
            PointerState ps = this.mPointers.valueAt(p);
            float lastX = ps.mCurrentX;
            float lastY = ps.mCurrentY;
            if (!Float.isNaN(lastX) && !Float.isNaN(lastY)) {
                this.mPaint.setARGB(255, 255, 64, 128);
                float xVel = ps.mXVelocity * 16.0f;
                float yVel = ps.mYVelocity * 16.0f;
                canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                if (this.mAltVelocity != null) {
                    this.mPaint.setARGB(255, 64, 255, 128);
                    xVel = ps.mAltXVelocity * 16.0f;
                    yVel = ps.mAltYVelocity * 16.0f;
                    canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                }
            }
            if (!this.mCurDown || !ps.mCurDown) continue;
            canvas.drawLine(0.0f, ps.mCoords.y, this.getWidth(), ps.mCoords.y, this.mTargetPaint);
            canvas.drawLine(ps.mCoords.x, -this.getHeight(), ps.mCoords.x, Math.max(this.getHeight(), this.getWidth()), this.mTargetPaint);
            int pressureLevel = (int)(ps.mCoords.pressure * 255.0f);
            this.mPaint.setARGB(255, pressureLevel, 255, 255 - pressureLevel);
            canvas.drawPoint(ps.mCoords.x, ps.mCoords.y, this.mPaint);
            this.mPaint.setARGB(255, pressureLevel, 255 - pressureLevel, 128);
            this.drawOval(canvas, ps.mCoords.x, ps.mCoords.y, ps.mCoords.touchMajor, ps.mCoords.touchMinor, ps.mCoords.orientation, this.mPaint);
            this.mPaint.setARGB(255, pressureLevel, 128, 255 - pressureLevel);
            this.drawOval(canvas, ps.mCoords.x, ps.mCoords.y, ps.mCoords.toolMajor, ps.mCoords.toolMinor, ps.mCoords.orientation, this.mPaint);
            float arrowSize = Math.max(ps.mCoords.toolMajor * 0.7f, 24.0f * this.mDensity);
            this.mPaint.setARGB(255, pressureLevel, 255, 0);
            float orientationVectorX = (float)(Math.sin(ps.mCoords.orientation) * (double)arrowSize);
            float orientationVectorY = (float)(-Math.cos(ps.mCoords.orientation) * (double)arrowSize);
            if (ps.mToolType == 2 || ps.mToolType == 4) {
                canvas.drawLine(ps.mCoords.x, ps.mCoords.y, ps.mCoords.x + orientationVectorX, ps.mCoords.y + orientationVectorY, this.mPaint);
            } else {
                canvas.drawLine(ps.mCoords.x - orientationVectorX, ps.mCoords.y - orientationVectorY, ps.mCoords.x + orientationVectorX, ps.mCoords.y + orientationVectorY, this.mPaint);
            }
            float tiltScale = (float)Math.sin(ps.mCoords.getAxisValue(25));
            canvas.drawCircle(ps.mCoords.x + orientationVectorX * tiltScale, ps.mCoords.y + orientationVectorY * tiltScale, 3.0f * this.mDensity, this.mPaint);
            if (!ps.mHasBoundingBox) continue;
            canvas.drawRect(ps.mBoundingLeft, ps.mBoundingTop, ps.mBoundingRight, ps.mBoundingBottom, this.mPaint);
        }
        canvas.restore();
    }

    private void drawLabels(Canvas canvas) {
        int w = this.getWidth() - this.mWaterfallInsets.left - this.mWaterfallInsets.right;
        int itemW = w / 7;
        int base = this.mHeaderPaddingTop - this.mTextMetrics.ascent + 1;
        int bottom = this.mHeaderBottom;
        canvas.save();
        canvas.translate(this.mWaterfallInsets.left, 0.0f);
        PointerState ps = this.mPointers.get(this.mActivePointerId, EMPTY_POINTER_STATE);
        canvas.drawRect(0.0f, this.mHeaderPaddingTop, itemW - 1, bottom, this.mTextBackgroundPaint);
        canvas.drawText(this.mText.clear().append("P: ").append(this.mCurNumPointers).append(" / ").append(this.mMaxNumPointers).toString(), 1.0f, base, this.mTextPaint);
        if (this.mCurDown && ps.mCurDown || Float.isNaN(ps.mCurrentX)) {
            canvas.drawRect(itemW, this.mHeaderPaddingTop, itemW * 2 - 1, bottom, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("X: ").append(ps.mCoords.x, 1).toString(), 1 + itemW, base, this.mTextPaint);
            canvas.drawRect(itemW * 2, this.mHeaderPaddingTop, itemW * 3 - 1, bottom, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("Y: ").append(ps.mCoords.y, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
        } else {
            float dx = ps.mCurrentX - ps.mFirstX;
            float dy = ps.mCurrentY - ps.mFirstY;
            canvas.drawRect(itemW, this.mHeaderPaddingTop, itemW * 2 - 1, bottom, Math.abs(dx) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("dX: ").append(dx, 1).toString(), 1 + itemW, base, this.mTextPaint);
            canvas.drawRect(itemW * 2, this.mHeaderPaddingTop, itemW * 3 - 1, bottom, Math.abs(dy) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("dY: ").append(dy, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
        }
        canvas.drawRect(itemW * 3, this.mHeaderPaddingTop, itemW * 4 - 1, bottom, this.mTextBackgroundPaint);
        canvas.drawText(this.mText.clear().append("Xv: ").append(ps.mXVelocity, 3).toString(), 1 + itemW * 3, base, this.mTextPaint);
        canvas.drawRect(itemW * 4, this.mHeaderPaddingTop, itemW * 5 - 1, bottom, this.mTextBackgroundPaint);
        canvas.drawText(this.mText.clear().append("Yv: ").append(ps.mYVelocity, 3).toString(), 1 + itemW * 4, base, this.mTextPaint);
        canvas.drawRect(itemW * 5, this.mHeaderPaddingTop, itemW * 6 - 1, bottom, this.mTextBackgroundPaint);
        canvas.drawRect(itemW * 5, this.mHeaderPaddingTop, (float)(itemW * 5) + ps.mCoords.pressure * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
        canvas.drawText(this.mText.clear().append("Prs: ").append(ps.mCoords.pressure, 2).toString(), 1 + itemW * 5, base, this.mTextPaint);
        canvas.drawRect(itemW * 6, this.mHeaderPaddingTop, w, bottom, this.mTextBackgroundPaint);
        canvas.drawRect(itemW * 6, this.mHeaderPaddingTop, (float)(itemW * 6) + ps.mCoords.size * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
        canvas.drawText(this.mText.clear().append("Size: ").append(ps.mCoords.size, 2).toString(), 1 + itemW * 6, base, this.mTextPaint);
        canvas.restore();
    }

    private void logMotionEvent(String type, MotionEvent event) {
        int action = event.getAction();
        int N2 = event.getHistorySize();
        int NI = event.getPointerCount();
        for (int historyPos = 0; historyPos < N2; ++historyPos) {
            for (int i = 0; i < NI; ++i) {
                int id2 = event.getPointerId(i);
                event.getHistoricalPointerCoords(i, historyPos, this.mTempCoords);
                this.logCoords(type, action, i, this.mTempCoords, id2, event);
            }
        }
        for (int i = 0; i < NI; ++i) {
            int id3 = event.getPointerId(i);
            event.getPointerCoords(i, this.mTempCoords);
            this.logCoords(type, action, i, this.mTempCoords, id3, event);
        }
    }

    private void logCoords(String type, int action, int index, MotionEvent.PointerCoords coords, int id2, MotionEvent event) {
        String prefix;
        int toolType = event.getToolType(index);
        int buttonState = event.getButtonState();
        switch (action & 0xFF) {
            case 0: {
                prefix = "DOWN";
                break;
            }
            case 1: {
                prefix = "UP";
                break;
            }
            case 2: {
                prefix = "MOVE";
                break;
            }
            case 3: {
                prefix = "CANCEL";
                break;
            }
            case 4: {
                prefix = "OUTSIDE";
                break;
            }
            case 5: {
                if (index == (action & 0xFF00) >> 8) {
                    prefix = "DOWN";
                    break;
                }
                prefix = "MOVE";
                break;
            }
            case 6: {
                if (index == (action & 0xFF00) >> 8) {
                    prefix = "UP";
                    break;
                }
                prefix = "MOVE";
                break;
            }
            case 7: {
                prefix = "HOVER MOVE";
                break;
            }
            case 9: {
                prefix = "HOVER ENTER";
                break;
            }
            case 10: {
                prefix = "HOVER EXIT";
                break;
            }
            case 8: {
                prefix = "SCROLL";
                break;
            }
            default: {
                prefix = Integer.toString(action);
            }
        }
        Log.i(TAG, this.mText.clear().append(type).append(" id ").append(id2 + 1).append(": ").append(prefix).append(" (").append(coords.x, 3).append(", ").append(coords.y, 3).append(") Pressure=").append(coords.pressure, 3).append(" Size=").append(coords.size, 3).append(" TouchMajor=").append(coords.touchMajor, 3).append(" TouchMinor=").append(coords.touchMinor, 3).append(" ToolMajor=").append(coords.toolMajor, 3).append(" ToolMinor=").append(coords.toolMinor, 3).append(" Orientation=").append((float)((double)(coords.orientation * 180.0f) / Math.PI), 1).append("deg").append(" Tilt=").append((float)((double)(coords.getAxisValue(25) * 180.0f) / Math.PI), 1).append("deg").append(" Distance=").append(coords.getAxisValue(24), 1).append(" VScroll=").append(coords.getAxisValue(9), 1).append(" HScroll=").append(coords.getAxisValue(10), 1).append(" BoundingBox=[(").append(event.getAxisValue(32), 3).append(", ").append(event.getAxisValue(33), 3).append(")").append(", (").append(event.getAxisValue(34), 3).append(", ").append(event.getAxisValue(35), 3).append(")]").append(" ToolType=").append(MotionEvent.toolTypeToString(toolType)).append(" ButtonState=").append(MotionEvent.buttonStateToString(buttonState)).toString());
    }

    @Override
    public void onPointerEvent(MotionEvent event) {
        event.transform(MotionEvent.createRotateMatrix(PointerLocationView.inverseRotation(event.getSurfaceRotation()), this.mTraceBitmap.getWidth(), this.mTraceBitmap.getHeight()));
        int action = event.getAction();
        if (action == 0 || (action & 0xFF) == 5) {
            int id2;
            PointerState ps;
            int index = (action & 0xFF00) >> 8;
            if (action == 0) {
                this.mPointers.clear();
                this.mCurDown = true;
                this.mCurNumPointers = 0;
                this.mMaxNumPointers = 0;
                this.mVelocity.clear();
                this.mTraceCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                if (this.mAltVelocity != null) {
                    this.mAltVelocity.clear();
                }
            }
            ++this.mCurNumPointers;
            if (this.mMaxNumPointers < this.mCurNumPointers) {
                this.mMaxNumPointers = this.mCurNumPointers;
            }
            if ((ps = this.mPointers.get(id2 = event.getPointerId(index))) == null) {
                ps = new PointerState();
                this.mPointers.put(id2, ps);
            }
            if (!this.mPointers.contains(this.mActivePointerId) || !this.mPointers.get((int)this.mActivePointerId).mCurDown) {
                this.mActivePointerId = id2;
            }
            ps.mCurDown = true;
            InputDevice device = InputDevice.getDevice(event.getDeviceId());
            ps.mHasBoundingBox = device != null && device.getMotionRange(32) != null;
        }
        int NI = event.getPointerCount();
        this.mVelocity.addMovement(event);
        this.mVelocity.computeCurrentVelocity(1);
        if (this.mAltVelocity != null) {
            this.mAltVelocity.addMovement(event);
            this.mAltVelocity.computeCurrentVelocity(1);
        }
        int N2 = event.getHistorySize();
        for (int historyPos = 0; historyPos < N2; ++historyPos) {
            for (int i = 0; i < NI; ++i) {
                int id3 = event.getPointerId(i);
                PointerState ps = this.mCurDown ? this.mPointers.get(id3) : null;
                MotionEvent.PointerCoords coords = ps != null ? ps.mCoords : this.mTempCoords;
                event.getHistoricalPointerCoords(i, historyPos, coords);
                if (this.mPrintCoords) {
                    this.logCoords(TAG, action, i, coords, id3, event);
                }
                if (ps == null) continue;
                ps.addTrace(coords.x, coords.y, true);
                this.updateDrawTrace(ps);
            }
        }
        for (int i = 0; i < NI; ++i) {
            int id4 = event.getPointerId(i);
            PointerState ps = this.mCurDown ? this.mPointers.get(id4) : null;
            MotionEvent.PointerCoords coords = ps != null ? ps.mCoords : this.mTempCoords;
            event.getPointerCoords(i, coords);
            if (this.mPrintCoords) {
                this.logCoords(TAG, action, i, coords, id4, event);
            }
            if (ps == null) continue;
            ps.addTrace(coords.x, coords.y, false);
            this.updateDrawTrace(ps);
            ps.mXVelocity = this.mVelocity.getXVelocity(id4);
            ps.mYVelocity = this.mVelocity.getYVelocity(id4);
            if (this.mAltVelocity != null) {
                ps.mAltXVelocity = this.mAltVelocity.getXVelocity(id4);
                ps.mAltYVelocity = this.mAltVelocity.getYVelocity(id4);
            }
            ps.mToolType = event.getToolType(i);
            if (!ps.mHasBoundingBox) continue;
            ps.mBoundingLeft = event.getAxisValue(32, i);
            ps.mBoundingTop = event.getAxisValue(33, i);
            ps.mBoundingRight = event.getAxisValue(34, i);
            ps.mBoundingBottom = event.getAxisValue(35, i);
        }
        if (action == 1 || action == 3 || (action & 0xFF) == 6) {
            int index = (action & 0xFF00) >> 8;
            int id5 = event.getPointerId(index);
            PointerState ps = this.mPointers.get(id5);
            if (ps == null) {
                Slog.wtf(TAG, "Could not find pointer id=" + id5 + " in mPointers map, size=" + this.mPointers.size() + " pointerindex=" + index + " action=0x" + Integer.toHexString(action));
                return;
            }
            ps.mCurDown = false;
            if (action == 1 || action == 3) {
                this.mCurDown = false;
                this.mCurNumPointers = 0;
            } else {
                --this.mCurNumPointers;
                if (this.mActivePointerId == id5) {
                    this.mActivePointerId = event.getPointerId(index == 0 ? 1 : 0);
                }
                ps.addTrace(Float.NaN, Float.NaN, true);
            }
        }
        this.invalidate();
    }

    private void updateDrawTrace(PointerState ps) {
        this.mPaint.setARGB(255, 128, 255, 255);
        float x = ps.mCurrentX;
        float y = ps.mCurrentY;
        float lastX = ps.mPreviousX;
        float lastY = ps.mPreviousY;
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(lastX) || Float.isNaN(lastY)) {
            return;
        }
        this.mTraceCanvas.drawLine(lastX, lastY, x, y, this.mPathPaint);
        Paint paint = ps.mPreviousPointIsHistorical ? this.mPaint : this.mCurrentPointPaint;
        this.mTraceCanvas.drawPoint(lastX, lastY, paint);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        this.onPointerEvent(event);
        if (event.getAction() == 0 && !this.isFocused()) {
            this.requestFocus();
        }
        return true;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        int source = event.getSource();
        if ((source & 2) != 0) {
            this.onPointerEvent(event);
        } else if ((source & 0x10) != 0) {
            this.logMotionEvent("Joystick", event);
        } else if ((source & 8) != 0) {
            this.logMotionEvent("Position", event);
        } else {
            this.logMotionEvent("Generic", event);
        }
        return true;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (PointerLocationView.shouldLogKey(keyCode)) {
            int repeatCount = event.getRepeatCount();
            if (repeatCount == 0) {
                Log.i(TAG, "Key Down: " + event);
            } else {
                Log.i(TAG, "Key Repeat #" + repeatCount + ": " + event);
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (PointerLocationView.shouldLogKey(keyCode)) {
            Log.i(TAG, "Key Up: " + event);
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private static boolean shouldLogKey(int keyCode) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return KeyEvent.isGamepadButton(keyCode) || KeyEvent.isModifierKey(keyCode);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        this.logMotionEvent("Trackball", event);
        return true;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIm.registerInputDeviceListener(this, this.getHandler());
        if (PointerLocationView.shouldShowSystemGestureExclusion()) {
            try {
                WindowManagerGlobal.getWindowManagerService().registerSystemGestureExclusionListener(this.mSystemGestureExclusionListener, this.mContext.getDisplayId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            int alpha = PointerLocationView.systemGestureExclusionOpacity();
            this.mSystemGestureExclusionPaint.setAlpha(alpha);
            this.mSystemGestureExclusionRejectedPaint.setAlpha(alpha);
        } else {
            this.mSystemGestureExclusion.setEmpty();
        }
        this.logInputDevices();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIm.unregisterInputDeviceListener(this);
        try {
            WindowManagerGlobal.getWindowManagerService().unregisterSystemGestureExclusionListener(this.mSystemGestureExclusionListener, this.mContext.getDisplayId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Failed to unregister window manager callbacks", e);
        }
    }

    @Override
    public void onInputDeviceAdded(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Added");
    }

    @Override
    public void onInputDeviceChanged(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Changed");
    }

    @Override
    public void onInputDeviceRemoved(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Removed");
    }

    private void logInputDevices() {
        int[] deviceIds = InputDevice.getDeviceIds();
        for (int i = 0; i < deviceIds.length; ++i) {
            this.logInputDeviceState(deviceIds[i], "Device Enumerated");
        }
    }

    private void logInputDeviceState(int deviceId, String state) {
        InputDevice device = this.mIm.getInputDevice(deviceId);
        if (device != null) {
            Log.i(TAG, state + ": " + device);
        } else {
            Log.i(TAG, state + ": " + deviceId);
        }
    }

    private static boolean shouldShowSystemGestureExclusion() {
        return PointerLocationView.systemGestureExclusionOpacity() > 0;
    }

    private static int systemGestureExclusionOpacity() {
        int x = SystemProperties.getInt(GESTURE_EXCLUSION_PROP, 0);
        return x >= 0 && x <= 255 ? x : 0;
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.configureTraceBitmap();
        this.configureDensityDependentFactors();
    }

    private void configureDensityDependentFactors() {
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mTextPaint.setTextSize(10.0f * this.mDensity);
        this.mPaint.setStrokeWidth(1.0f * this.mDensity);
        this.mCurrentPointPaint.setStrokeWidth(1.0f * this.mDensity);
        this.mPathPaint.setStrokeWidth(1.0f * this.mDensity);
    }

    private void configureTraceBitmap() {
        int unrotatedHeight;
        Display display = this.mContext.getDisplay();
        boolean rotated = display.getRotation() == 1 || display.getRotation() == 3;
        int unrotatedWidth = rotated ? display.getHeight() : display.getWidth();
        int n = unrotatedHeight = rotated ? display.getWidth() : display.getHeight();
        if (this.mTraceBitmap != null && this.mTraceBitmap.getWidth() == unrotatedWidth && this.mTraceBitmap.getHeight() == unrotatedHeight) {
            return;
        }
        if (unrotatedWidth <= 0 || unrotatedHeight <= 0) {
            Slog.w(TAG, "Ignoring configuration: invalid display size: " + unrotatedWidth + "x" + unrotatedHeight);
            unrotatedWidth = 100;
            unrotatedHeight = 100;
        }
        this.mTraceBitmap = Bitmap.createBitmap(unrotatedWidth, unrotatedHeight, Bitmap.Config.ARGB_8888);
        this.mTraceCanvas.setBitmap(this.mTraceBitmap);
    }

    private static int inverseRotation(int rotation) {
        int n;
        switch (rotation) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            default: {
                Slog.e(TAG, "Received unexpected surface rotation: " + rotation);
                n = 0;
            }
        }
        return n;
    }

    private void rotateCanvasToUnrotatedDisplay(Canvas c) {
        switch (PointerLocationView.inverseRotation(this.mContext.getDisplay().getRotation())) {
            case 1: {
                c.rotate(90.0f);
                c.translate(0.0f, -this.mTraceBitmap.getHeight());
                break;
            }
            case 2: {
                c.rotate(180.0f);
                c.translate(-this.mTraceBitmap.getWidth(), -this.mTraceBitmap.getHeight());
                break;
            }
            case 3: {
                c.rotate(270.0f);
                c.translate(-this.mTraceBitmap.getWidth(), 0.0f);
            }
        }
    }

    private static class FasterStringBuilder {
        private char[] mChars = new char[64];
        private int mLength;

        public FasterStringBuilder clear() {
            this.mLength = 0;
            return this;
        }

        public FasterStringBuilder append(String value) {
            int valueLength = value.length();
            int index = this.reserve(valueLength);
            value.getChars(0, valueLength, this.mChars, index);
            this.mLength += valueLength;
            return this;
        }

        public FasterStringBuilder append(int value) {
            return this.append(value, 0);
        }

        public FasterStringBuilder append(int value, int zeroPadWidth) {
            int divisor;
            boolean negative;
            boolean bl = negative = value < 0;
            if (negative && (value = -value) < 0) {
                this.append("-2147483648");
                return this;
            }
            int index = this.reserve(11);
            char[] chars = this.mChars;
            if (value == 0) {
                chars[index++] = 48;
                ++this.mLength;
                return this;
            }
            if (negative) {
                chars[index++] = 45;
            }
            int numberWidth = 10;
            for (divisor = 1000000000; value < divisor; divisor /= 10) {
                if (--numberWidth >= zeroPadWidth) continue;
                chars[index++] = 48;
            }
            do {
                int digit = value / divisor;
                value -= digit * divisor;
                chars[index++] = (char)(digit + 48);
            } while ((divisor /= 10) != 0);
            this.mLength = index;
            return this;
        }

        public FasterStringBuilder append(float value, int precision) {
            int scale = 1;
            for (int i = 0; i < precision; ++i) {
                scale *= 10;
            }
            if ((int)(value = (float)(Math.rint(value * (float)scale) / (double)scale)) == 0 && value < 0.0f) {
                this.append("-");
            }
            this.append((int)value);
            if (precision != 0) {
                this.append(".");
                value = Math.abs(value);
                value = (float)((double)value - Math.floor(value));
                this.append((int)(value * (float)scale), precision);
            }
            return this;
        }

        public String toString() {
            return new String(this.mChars, 0, this.mLength);
        }

        private int reserve(int length) {
            int oldLength = this.mLength;
            int newLength = this.mLength + length;
            char[] oldChars = this.mChars;
            int oldCapacity = oldChars.length;
            if (newLength > oldCapacity) {
                int newCapacity = oldCapacity * 2;
                char[] newChars = new char[newCapacity];
                System.arraycopy(oldChars, 0, newChars, 0, oldLength);
                this.mChars = newChars;
            }
            return oldLength;
        }
    }

    public static class PointerState {
        private float mCurrentX = Float.NaN;
        private float mCurrentY = Float.NaN;
        private float mPreviousX = Float.NaN;
        private float mPreviousY = Float.NaN;
        private float mFirstX = Float.NaN;
        private float mFirstY = Float.NaN;
        private boolean mPreviousPointIsHistorical;
        private boolean mCurrentPointIsHistorical;
        @UnsupportedAppUsage
        private boolean mCurDown;
        private final MotionEvent.PointerCoords mCoords = new MotionEvent.PointerCoords();
        private int mToolType;
        private float mXVelocity;
        private float mYVelocity;
        private float mAltXVelocity;
        private float mAltYVelocity;
        private boolean mHasBoundingBox;
        private float mBoundingLeft;
        private float mBoundingTop;
        private float mBoundingRight;
        private float mBoundingBottom;

        @UnsupportedAppUsage
        public PointerState() {
        }

        void addTrace(float x, float y, boolean isHistorical) {
            if (Float.isNaN(this.mFirstX)) {
                this.mFirstX = x;
            }
            if (Float.isNaN(this.mFirstY)) {
                this.mFirstY = y;
            }
            this.mPreviousX = this.mCurrentX;
            this.mPreviousY = this.mCurrentY;
            this.mCurrentX = x;
            this.mCurrentY = y;
            this.mPreviousPointIsHistorical = this.mCurrentPointIsHistorical;
            this.mCurrentPointIsHistorical = isHistorical;
        }
    }
}

